--
-- PostgreSQL database dump
--

-- Dumped from database version 13.18
-- Dumped by pg_dump version 13.18

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: rand(); Type: FUNCTION; Schema: public; Owner: orientlimraerp_karim
--

CREATE FUNCTION public.rand() RETURNS double precision
    LANGUAGE sql
    AS $$SELECT random();$$;


ALTER FUNCTION public.rand() OWNER TO orientlimraerp_karim;

--
-- Name: soundex(text); Type: FUNCTION; Schema: public; Owner: orientlimraerp_karim
--

CREATE FUNCTION public.soundex(input text) RETURNS text
    LANGUAGE plpgsql IMMUTABLE STRICT COST 500
    AS $$
DECLARE
  soundex text = '';
  char text;
  symbol text;
  last_symbol text = '';
  pos int = 1;
BEGIN
  WHILE length(soundex) < 4 LOOP
    char = upper(substr(input, pos, 1));
    pos = pos + 1;
    CASE char
    WHEN '' THEN
      -- End of input string
      IF soundex = '' THEN
        RETURN '';
      ELSE
        RETURN rpad(soundex, 4, '0');
      END IF;
    WHEN 'B', 'F', 'P', 'V' THEN
      symbol = '1';
    WHEN 'C', 'G', 'J', 'K', 'Q', 'S', 'X', 'Z' THEN
      symbol = '2';
    WHEN 'D', 'T' THEN
      symbol = '3';
    WHEN 'L' THEN
      symbol = '4';
    WHEN 'M', 'N' THEN
      symbol = '5';
    WHEN 'R' THEN
      symbol = '6';
    ELSE
      -- Not a consonant; no output, but next similar consonant will be re-recorded
      symbol = '';
    END CASE;

    IF soundex = '' THEN
      -- First character; only accept strictly English ASCII characters
      IF char ~>=~ 'A' AND char ~<=~ 'Z' THEN
        soundex = char;
        last_symbol = symbol;
      END IF;
    ELSIF last_symbol != symbol THEN
      soundex = soundex || symbol;
      last_symbol = symbol;
    END IF;
  END LOOP;

  RETURN soundex;
END;
$$;


ALTER FUNCTION public.soundex(input text) OWNER TO orientlimraerp_karim;

--
-- Name: substring_index(text, text, integer); Type: FUNCTION; Schema: public; Owner: orientlimraerp_karim
--

CREATE FUNCTION public.substring_index(text, text, integer) RETURNS text
    LANGUAGE sql
    AS $_$SELECT array_to_string((string_to_array($1, $2)) [1:$3], $2);$_$;


ALTER FUNCTION public.substring_index(text, text, integer) OWNER TO orientlimraerp_karim;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: a_v_pro_check_qties; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.a_v_pro_check_qties (
    id bigint NOT NULL,
    "Product" text,
    "AvQty" text,
    "Qty" text,
    "RequestQty" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "OriginalProduct" text,
    "NewRequestQty" text
);


ALTER TABLE public.a_v_pro_check_qties OWNER TO orientlimraerp_karim;

--
-- Name: a_v_pro_check_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.a_v_pro_check_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.a_v_pro_check_qties_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: a_v_pro_check_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.a_v_pro_check_qties_id_seq OWNED BY public.a_v_pro_check_qties.id;


--
-- Name: abouts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.abouts (
    id bigint NOT NULL,
    "Image" text,
    "Image_2" text,
    "Image_3" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.abouts OWNER TO orientlimraerp_karim;

--
-- Name: abouts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.abouts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.abouts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: abouts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.abouts_id_seq OWNED BY public.abouts.id;


--
-- Name: acccounting_manuals; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.acccounting_manuals (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Parent" text NOT NULL,
    "Note" text,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account_Code" text,
    "Pro_Group" text,
    "NameEn" text,
    "SearchCode" text
);


ALTER TABLE public.acccounting_manuals OWNER TO orientlimraerp_karim;

--
-- Name: acccounting_manuals_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.acccounting_manuals_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.acccounting_manuals_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: acccounting_manuals_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.acccounting_manuals_id_seq OWNED BY public.acccounting_manuals.id;


--
-- Name: accounts_default_data; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.accounts_default_data (
    id bigint NOT NULL,
    "Draw" text,
    "Coin" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sure_Recipts" text,
    "Show_Group" text,
    "Account_Balance" text,
    "Salary" text,
    "Commission" text,
    "Coin_Show" text,
    "Cost_Show" text,
    "Draw_Show" text,
    "Collect_Show" text,
    "Sales_Bill_Show" text,
    "Hide_Edit_Delete" text,
    "Order_Number" text
);


ALTER TABLE public.accounts_default_data OWNER TO orientlimraerp_karim;

--
-- Name: accounts_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.accounts_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.accounts_default_data_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: accounts_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.accounts_default_data_id_seq OWNED BY public.accounts_default_data.id;


--
-- Name: activites; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.activites (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.activites OWNER TO orientlimraerp_karim;

--
-- Name: activites_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.activites_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.activites_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: activites_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.activites_id_seq OWNED BY public.activites.id;


--
-- Name: add_translates; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.add_translates (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Client" text,
    "Client_Type" text,
    "From_Lang" text,
    "To_Lang" text,
    "Company" text,
    "Num_Translted_Word" text,
    "ID_Name" text,
    "ID_Profession" text,
    "ID_Martial_Status" text,
    "Passport_Name" text,
    "Passport_Profession" text,
    "Passport_Martial_Status" text,
    "Extracted" text,
    "Extracted_Birthplace" text,
    "Extracted_Issuer" text,
    "CommercialRegistration" text,
    "Commercial_Name" text,
    "Commercial_Type" text,
    "Commercial_Start_Date" text,
    "Commercial_Number" text,
    "Commercial_Capital" text,
    "Commercial_Issuer" text,
    "Commercial_Address" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.add_translates OWNER TO orientlimraerp_karim;

--
-- Name: add_translates_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.add_translates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.add_translates_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: add_translates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.add_translates_id_seq OWNED BY public.add_translates.id;


--
-- Name: additional_products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.additional_products (
    id bigint NOT NULL,
    "Additional_Product" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.additional_products OWNER TO orientlimraerp_karim;

--
-- Name: additional_products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.additional_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.additional_products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: additional_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.additional_products_id_seq OWNED BY public.additional_products.id;


--
-- Name: addressses; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.addressses (
    id bigint NOT NULL,
    "Address_Name" text,
    "Street" text,
    "Special_Mark" text,
    "Buliding" text,
    "Floor" text,
    "Flat" text,
    "Details" text,
    "Location" text,
    "Governrate" bigint,
    "City" bigint,
    "Place" bigint,
    "Customer" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Lat" text,
    "Lng" text
);


ALTER TABLE public.addressses OWNER TO orientlimraerp_karim;

--
-- Name: addressses_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.addressses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.addressses_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: addressses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.addressses_id_seq OWNED BY public.addressses.id;


--
-- Name: admins; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.admins (
    id bigint NOT NULL,
    email character varying(191) NOT NULL,
    name text NOT NULL,
    password text NOT NULL,
    image text,
    phone text,
    hidden text DEFAULT '0'::text NOT NULL,
    emp text DEFAULT '0'::text NOT NULL,
    ship text DEFAULT '0'::text NOT NULL,
    vend text DEFAULT '0'::text NOT NULL,
    status text DEFAULT '0'::text NOT NULL,
    remember_token character varying(100),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    cli bigint DEFAULT 0,
    lat text,
    long text,
    account bigint,
    safe bigint,
    store bigint,
    type text,
    roles_name text,
    code text,
    token text,
    price_sale text,
    discount text,
    price_1 text,
    price_2 text,
    price_3 text,
    pos_pay text,
    executor text,
    cost_price text,
    price_level text,
    guest text,
    pos_stores text,
    pos_hold text,
    cost_price_purch text,
    cost_price_sales text,
    manu_order_precent text,
    pos_product text DEFAULT 0,
    "Cash" text,
    "Later" text,
    "Check" text,
    "Installment" text,
    "Cash_Visa" text,
    "Cash_Collection" text,
    "Delivery" text,
    "InstallmentCompanies" text,
    "Date" text,
    ticket_price text,
    ticket_discount text,
    "nameEn" text,
    package text,
    job_order_price text,
    "Visa_Network" text,
    bill_discount text,
    pos_safes text,
    expire text,
    expire_type text DEFAULT 0
);


ALTER TABLE public.admins OWNER TO orientlimraerp_karim;

--
-- Name: admins_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.admins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.admins_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: admins_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.admins_id_seq OWNED BY public.admins.id;


--
-- Name: all_groups; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.all_groups (
    id bigint NOT NULL,
    "Group" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Name" text
);


ALTER TABLE public.all_groups OWNER TO orientlimraerp_karim;

--
-- Name: all_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.all_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.all_groups_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: all_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.all_groups_id_seq OWNED BY public.all_groups.id;


--
-- Name: allowences_emps; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.allowences_emps (
    id bigint NOT NULL,
    "AmountAllow" text,
    "Allow" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.allowences_emps OWNER TO orientlimraerp_karim;

--
-- Name: allowences_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.allowences_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.allowences_emps_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: allowences_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.allowences_emps_id_seq OWNED BY public.allowences_emps.id;


--
-- Name: area_pincode_a_p_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.area_pincode_a_p_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.area_pincode_a_p_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: articles; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.articles (
    id bigint NOT NULL,
    "Image" text,
    "Sub_Image" text,
    "Date" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.articles OWNER TO orientlimraerp_karim;

--
-- Name: articles_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.articles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.articles_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: articles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.articles_id_seq OWNED BY public.articles.id;


--
-- Name: assembly_products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.assembly_products (
    id bigint NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Total" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" bigint,
    "Product" bigint,
    p_id bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.assembly_products OWNER TO orientlimraerp_karim;

--
-- Name: assembly_products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.assembly_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assembly_products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: assembly_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.assembly_products_id_seq OWNED BY public.assembly_products.id;


--
-- Name: assets; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.assets (
    id bigint NOT NULL,
    "Code" text,
    "Name" text,
    "Asset_Type" text,
    "Depreciation_Method" text,
    "Purchases_Date" text,
    "Operation_Date" text,
    "Cost" text,
    "Previous_Depreciation" text,
    "Asset_Net" text,
    "Annual_Depreciation_Ratio" text,
    "Annual_Depreciation" text,
    "Life_Span" text,
    "Image" text,
    "Note" text,
    "Depreciation_Expenses" bigint,
    "Depreciation_Complex" bigint,
    "Main_Account" bigint,
    "Account" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Draw" text,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Branch" bigint,
    "Sort_Asset" text,
    "Vendor" bigint,
    "Safe" bigint,
    "Ehlak" text,
    "Payment_Method" text,
    "M1" text,
    "M2" text,
    "M3" text,
    "M4" text,
    "M5" text,
    "M6" text,
    "M7" text,
    "M8" text,
    "M9" text,
    "M10" text,
    "M11" text,
    "M12" text,
    "NameEn" text,
    "Asset_Type_En" text,
    "Depreciation_Method_En" text,
    arr bigint,
    "Delete" text,
    "Sale" text,
    "Amount" text,
    "Client" text,
    "CurrentAssetPrice" text
);


ALTER TABLE public.assets OWNER TO orientlimraerp_karim;

--
-- Name: assets_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.assets_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assets_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: assets_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.assets_arr_seq OWNED BY public.assets."Code";


--
-- Name: assets_expenses; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.assets_expenses (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Name" text NOT NULL,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Asset" bigint,
    "Safe" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.assets_expenses OWNER TO orientlimraerp_karim;

--
-- Name: assets_expenses_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.assets_expenses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assets_expenses_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: assets_expenses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.assets_expenses_id_seq OWNED BY public.assets_expenses.id;


--
-- Name: assets_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.assets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.assets_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: assets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.assets_id_seq OWNED BY public.assets.id;


--
-- Name: attend_departure_import; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.attend_departure_import (
    id bigint NOT NULL,
    "In_Time" text,
    "Out_Time" text,
    "Date" text,
    "Month" text,
    "Note" text,
    "Attend" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.attend_departure_import OWNER TO orientlimraerp_karim;

--
-- Name: attend_departure_import_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.attend_departure_import_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attend_departure_import_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: attend_departure_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.attend_departure_import_id_seq OWNED BY public.attend_departure_import.id;


--
-- Name: attendance_emps; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.attendance_emps (
    id bigint NOT NULL,
    "In_Time" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "Attend" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.attendance_emps OWNER TO orientlimraerp_karim;

--
-- Name: attendance_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.attendance_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendance_emps_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: attendance_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.attendance_emps_id_seq OWNED BY public.attendance_emps.id;


--
-- Name: attendances; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.attendances (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text,
    arr bigint
);


ALTER TABLE public.attendances OWNER TO orientlimraerp_karim;

--
-- Name: attendances_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.attendances_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendances_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: attendances_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.attendances_arr_seq OWNED BY public.attendances."Code";


--
-- Name: attendances_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.attendances_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendances_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: attendances_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.attendances_id_seq OWNED BY public.attendances.id;


--
-- Name: attendence_policy_emps; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.attendence_policy_emps (
    id bigint NOT NULL,
    "From" text,
    "To" text,
    "Discount" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.attendence_policy_emps OWNER TO orientlimraerp_karim;

--
-- Name: attendence_policy_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.attendence_policy_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attendence_policy_emps_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: attendence_policy_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.attendence_policy_emps_id_seq OWNED BY public.attendence_policy_emps.id;


--
-- Name: barcode_products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.barcode_products (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Code" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Group" text
);


ALTER TABLE public.barcode_products OWNER TO orientlimraerp_karim;

--
-- Name: barcode_products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.barcode_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: barcode_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.barcode_products_id_seq OWNED BY public.barcode_products.id;


--
-- Name: barcode_settings; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.barcode_settings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Direction" text NOT NULL,
    "Width" text NOT NULL,
    "Height" text NOT NULL,
    "Padding_L" text NOT NULL,
    "Padding_R" text NOT NULL,
    "Padding_T" text NOT NULL,
    "Padding_B" text NOT NULL,
    "Margin_L" text NOT NULL,
    "Margin_R" text NOT NULL,
    "Margin_T" text NOT NULL,
    "Margin_B" text NOT NULL,
    "Barcode_Width" text NOT NULL,
    "Barcode_Height" text NOT NULL,
    "Font_Size" text NOT NULL,
    "Line_Height" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Height_Logo" character varying,
    "Width_Logo" character varying,
    "NameEn" text,
    arr bigint
);


ALTER TABLE public.barcode_settings OWNER TO orientlimraerp_karim;

--
-- Name: barcode_settings_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.barcode_settings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_settings_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: barcode_settings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.barcode_settings_arr_seq OWNED BY public.barcode_settings.arr;


--
-- Name: barcode_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.barcode_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_settings_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: barcode_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.barcode_settings_id_seq OWNED BY public.barcode_settings.id;


--
-- Name: barcode_shows; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.barcode_shows (
    id bigint NOT NULL,
    "Company_Name" text,
    "Product_Name" text,
    "Product_Price" text,
    "Unit" text,
    "Coin" text,
    "Group" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "Logo" text
);


ALTER TABLE public.barcode_shows OWNER TO orientlimraerp_karim;

--
-- Name: barcode_shows_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.barcode_shows_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_shows_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: barcode_shows_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.barcode_shows_id_seq OWNED BY public.barcode_shows.id;


--
-- Name: befroe_footers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.befroe_footers (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    "Arabic_Title" text NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Title" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.befroe_footers OWNER TO orientlimraerp_karim;

--
-- Name: befroe_footers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.befroe_footers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.befroe_footers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: befroe_footers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.befroe_footers_id_seq OWNED BY public.befroe_footers.id;


--
-- Name: beneftis_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.beneftis_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.beneftis_types OWNER TO orientlimraerp_karim;

--
-- Name: beneftis_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.beneftis_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.beneftis_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: beneftis_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.beneftis_types_id_seq OWNED BY public.beneftis_types.id;


--
-- Name: bones_sales_petrols; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.bones_sales_petrols (
    id bigint NOT NULL,
    "Bone_Amount" text NOT NULL,
    "Bone" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.bones_sales_petrols OWNER TO orientlimraerp_karim;

--
-- Name: bones_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.bones_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bones_sales_petrols_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: bones_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.bones_sales_petrols_id_seq OWNED BY public.bones_sales_petrols.id;


--
-- Name: bones_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.bones_types (
    id bigint NOT NULL,
    "Name" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.bones_types OWNER TO orientlimraerp_karim;

--
-- Name: bones_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.bones_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bones_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: bones_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.bones_types_id_seq OWNED BY public.bones_types.id;


--
-- Name: borrowas; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.borrowas (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Safe" bigint NOT NULL,
    "Emp" bigint,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.borrowas OWNER TO orientlimraerp_karim;

--
-- Name: borrowas_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.borrowas_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.borrowas_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: borrowas_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.borrowas_arr_seq OWNED BY public.borrowas."Code";


--
-- Name: borrowas_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.borrowas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.borrowas_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: borrowas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.borrowas_id_seq OWNED BY public.borrowas.id;


--
-- Name: branches; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.branches (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Letter" text,
    "Code" text,
    "Location" text,
    "Budget" text
);


ALTER TABLE public.branches OWNER TO orientlimraerp_karim;

--
-- Name: branches_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.branches_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.branches_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: branches_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.branches_id_seq OWNED BY public.branches.id;


--
-- Name: brands; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.brands (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Note" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Image" text,
    "Sales_Show" text,
    "Store_Show" text,
    "NameEn" text,
    "Sales_Precet" text DEFAULT 0
);


ALTER TABLE public.brands OWNER TO orientlimraerp_karim;

--
-- Name: brands_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.brands_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.brands_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: brands_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.brands_id_seq OWNED BY public.brands.id;


--
-- Name: campaigns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.campaigns (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Platform" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.campaigns OWNER TO orientlimraerp_karim;

--
-- Name: campaigns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.campaigns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.campaigns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: campaigns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.campaigns_id_seq OWNED BY public.campaigns.id;


--
-- Name: capital_increases; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.capital_increases (
    id bigint NOT NULL,
    "Date" text,
    "Month" text,
    "Value" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.capital_increases OWNER TO orientlimraerp_karim;

--
-- Name: capital_increases_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.capital_increases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.capital_increases_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: capital_increases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.capital_increases_id_seq OWNED BY public.capital_increases.id;


--
-- Name: capitals; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.capitals (
    id bigint NOT NULL,
    "Authorized_Capital" text,
    "Source_Capital" text,
    "Shares_Number" text,
    "Nominal_Value_of_Shares" text,
    "Actual_Share_Value" text,
    "Actual_Capital" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Working_Capital" text,
    "New_Shares_Number" text,
    "Capital_Increase" text,
    "New_Source_Capital" text,
    "Total_Investment" text
);


ALTER TABLE public.capitals OWNER TO orientlimraerp_karim;

--
-- Name: capitals_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.capitals_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.capitals_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: capitals_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.capitals_id_seq OWNED BY public.capitals.id;


--
-- Name: cars_sales_petrols; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.cars_sales_petrols (
    id bigint NOT NULL,
    "Car_Amount" text NOT NULL,
    "Car" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.cars_sales_petrols OWNER TO orientlimraerp_karim;

--
-- Name: cars_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.cars_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cars_sales_petrols_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: cars_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.cars_sales_petrols_id_seq OWNED BY public.cars_sales_petrols.id;


--
-- Name: cart_stores; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.cart_stores (
    id bigint NOT NULL,
    "Name" text,
    "NameEn" text,
    "V_Name" text,
    "VV_Name" text,
    "P_Code" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Image" text,
    "Total" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Product" text
);


ALTER TABLE public.cart_stores OWNER TO orientlimraerp_karim;

--
-- Name: cart_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.cart_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cart_stores_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: cart_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.cart_stores_id_seq OWNED BY public.cart_stores.id;


--
-- Name: chat_issues; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.chat_issues (
    id bigint NOT NULL,
    "Name" text,
    "Date" text,
    "Time" text,
    "Desc" text,
    "Image" text,
    "Issue" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "Appear" text
);


ALTER TABLE public.chat_issues OWNER TO orientlimraerp_karim;

--
-- Name: chat_issues_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.chat_issues_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.chat_issues_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: chat_issues_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.chat_issues_id_seq OWNED BY public.chat_issues.id;


--
-- Name: checks_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.checks_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.checks_types OWNER TO orientlimraerp_karim;

--
-- Name: checks_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.checks_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.checks_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: checks_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.checks_types_id_seq OWNED BY public.checks_types.id;


--
-- Name: cities; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.cities (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Gov" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ship_Price" text,
    "Shipping_Company" text,
    "SearchCode" text
);


ALTER TABLE public.cities OWNER TO orientlimraerp_karim;

--
-- Name: cities_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.cities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cities_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: cities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.cities_id_seq OWNED BY public.cities.id;


--
-- Name: client_account_statement_column_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.client_account_statement_column_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.client_account_statement_column_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: client_account_statement_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.client_account_statement_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_account_statement_column_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: client_account_statement_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.client_account_statement_column_sechdules_id_seq OWNED BY public.client_account_statement_column_sechdules.id;


--
-- Name: client_account_statement_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.client_account_statement_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.client_account_statement_columns OWNER TO orientlimraerp_karim;

--
-- Name: client_account_statement_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.client_account_statement_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_account_statement_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: client_account_statement_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.client_account_statement_columns_id_seq OWNED BY public.client_account_statement_columns.id;


--
-- Name: client_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.client_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client" text
);


ALTER TABLE public.client_filters OWNER TO orientlimraerp_karim;

--
-- Name: client_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.client_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: client_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.client_filters_id_seq OWNED BY public.client_filters.id;


--
-- Name: client_sales_petrols; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.client_sales_petrols (
    id bigint NOT NULL,
    "Customer_Amount" text NOT NULL,
    "Customer" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.client_sales_petrols OWNER TO orientlimraerp_karim;

--
-- Name: client_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.client_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_sales_petrols_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: client_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.client_sales_petrols_id_seq OWNED BY public.client_sales_petrols.id;


--
-- Name: client_statuses; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.client_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.client_statuses OWNER TO orientlimraerp_karim;

--
-- Name: client_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.client_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.client_statuses_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: client_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.client_statuses_id_seq OWNED BY public.client_statuses.id;


--
-- Name: clients_statements_column_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.clients_statements_column_sechdules (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.clients_statements_column_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: clients_statements_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.clients_statements_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.clients_statements_column_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: clients_statements_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.clients_statements_column_sechdules_id_seq OWNED BY public.clients_statements_column_sechdules.id;


--
-- Name: clients_statements_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.clients_statements_columns (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.clients_statements_columns OWNER TO orientlimraerp_karim;

--
-- Name: clients_statements_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.clients_statements_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.clients_statements_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: clients_statements_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.clients_statements_columns_id_seq OWNED BY public.clients_statements_columns.id;


--
-- Name: coins; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.coins (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Draw" text,
    "Symbol" text,
    "Code" text
);


ALTER TABLE public.coins OWNER TO orientlimraerp_karim;

--
-- Name: coins_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.coins_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.coins_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: coins_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.coins_id_seq OWNED BY public.coins.id;


--
-- Name: comments; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.comments (
    id bigint NOT NULL,
    "Comment" text NOT NULL,
    "Date" text NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.comments OWNER TO orientlimraerp_karim;

--
-- Name: comments_clients; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.comments_clients (
    id bigint NOT NULL,
    "Comment" text,
    "Responsible" text,
    "Customer" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CommentEn" text,
    "Code" text,
    "Date" text,
    "Rate" text,
    "Visit_Cost" text,
    "Note" text,
    "Time" text,
    "Type" text,
    lat text,
    lng text
);


ALTER TABLE public.comments_clients OWNER TO orientlimraerp_karim;

--
-- Name: comments_clients_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.comments_clients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.comments_clients_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: comments_clients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.comments_clients_id_seq OWNED BY public.comments_clients.id;


--
-- Name: comments_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.comments_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.comments_id_seq OWNED BY public.comments.id;


--
-- Name: company_cars; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.company_cars (
    id bigint NOT NULL,
    "Name" text,
    "Number" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.company_cars OWNER TO orientlimraerp_karim;

--
-- Name: company_cars_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.company_cars_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.company_cars_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: company_cars_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.company_cars_id_seq OWNED BY public.company_cars.id;


--
-- Name: company_data; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.company_data (
    id bigint NOT NULL,
    "Name" text,
    "Phone1" text,
    "Phone2" text,
    "Address" text,
    "Commercial_Record" text,
    "Tax_File_Number" text,
    "Logo" text,
    "Icon" text,
    "Print_Text" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Print_Text_Footer" text,
    "Seal" text,
    "Print_Text_Footer_Sales" text,
    "Name_Sales_Bill" text,
    "Name_Sales_Order_Bill" text,
    "Print_Text_Footer_Quote" text,
    "Name_Quote_Bill" text,
    "Print_Text_Footer_Secretariat" text,
    "Logo_Store" text,
    "Phone3" text,
    "Phone4" text,
    "Icon_Store" text,
    "View" text,
    "Tax_Registration_Number" text,
    "Tax_activity_code" text,
    work_nature text,
    "Governrate" text,
    "City" text,
    "Place" text,
    "Nationality" text,
    "Buliding_Num" text,
    "Street" text,
    "Postal_Code" text,
    tax_magistrate text,
    "Client_ID" text,
    "Serial_Client_ID" text,
    "Version_Type" text,
    "Computer_SN" text,
    "Invoice_Type" text,
    "Floor" text,
    "Room" text,
    "Landmark" text,
    "Add_Info" text,
    "Print_Text_Footer_Manufacturing" text,
    "POS_Version" text,
    "Path" text,
    "DB_Backup" text,
    "NameEn" text,
    "Print_Text_En" text,
    "Print_Text_Footer_En" text,
    "Print_Text_Footer_Manufacturing_En" text,
    "Print_Text_Footer_Sales_En" text,
    "Print_Text_Footer_Quote_En" text,
    "Print_Text_Footer_Secretariat_En" text,
    "Name_Sales_Bill_En" text,
    "Name_Sales_Order_Bill_En" text,
    "Name_Quote_Bill_En" text,
    "AddressEn" text,
    "HomeMainScreen" text,
    "PDF" text,
    "Email" text,
    "Location" text,
    "Bill_View" text,
    "Font_Type" text,
    "Welcome_Arabic_Word_App" text,
    "Welcome_English_Word_App" text
);


ALTER TABLE public.company_data OWNER TO orientlimraerp_karim;

--
-- Name: company_data_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.company_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.company_data_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: company_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.company_data_id_seq OWNED BY public.company_data.id;


--
-- Name: compare_prices_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.compare_prices_columns (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_columns OWNER TO orientlimraerp_karim;

--
-- Name: compare_prices_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.compare_prices_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: compare_prices_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.compare_prices_columns_id_seq OWNED BY public.compare_prices_columns.id;


--
-- Name: compare_prices_columns_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.compare_prices_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_columns_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: compare_prices_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.compare_prices_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_columns_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: compare_prices_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.compare_prices_columns_sechdules_id_seq OWNED BY public.compare_prices_columns_sechdules.id;


--
-- Name: compare_prices_filter_twos; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.compare_prices_filter_twos (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_filter_twos OWNER TO orientlimraerp_karim;

--
-- Name: compare_prices_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.compare_prices_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_filter_twos_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: compare_prices_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.compare_prices_filter_twos_id_seq OWNED BY public.compare_prices_filter_twos.id;


--
-- Name: compare_prices_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.compare_prices_filters (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compare_prices_filters OWNER TO orientlimraerp_karim;

--
-- Name: compare_prices_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.compare_prices_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compare_prices_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: compare_prices_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.compare_prices_filters_id_seq OWNED BY public.compare_prices_filters.id;


--
-- Name: compares; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.compares (
    id bigint NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.compares OWNER TO orientlimraerp_karim;

--
-- Name: compares_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.compares_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.compares_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: compares_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.compares_id_seq OWNED BY public.compares.id;


--
-- Name: competitors; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.competitors (
    id bigint NOT NULL,
    "Facebook" character varying(191),
    "Twitter" character varying(191),
    "Instagram" character varying(191),
    "Name" character varying(191),
    "Country" text,
    "Whatsapp" character varying(191),
    "Addtional_Link" character varying(191),
    "Phone" character varying(191),
    "Pinterest" character varying(191),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text,
    "Website" text
);


ALTER TABLE public.competitors OWNER TO orientlimraerp_karim;

--
-- Name: competitors_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.competitors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.competitors_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: competitors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.competitors_id_seq OWNED BY public.competitors.id;


--
-- Name: consist_maintainces; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.consist_maintainces (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Exp_Date" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Maintaince" text,
    "TDiscount" text,
    "Group" text,
    "Brand" text,
    "Code" text,
    "Date" text,
    "Note" text,
    "Serial_Num" text,
    "Total_Price" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_Cost" text,
    "Total_Bf_Taxes" text,
    "Total_Taxes" text,
    "Draw" text,
    "Company" text,
    "Device_Type" text,
    "Device_Case" text,
    "Coin" text,
    "Cost_Center" text,
    "Account" text,
    "User" text,
    "Status" text,
    "Pattern_Image" text,
    "Time" text,
    "Payment_Method" text,
    "Password" text,
    "Pay" text,
    "Eng_Note" text,
    "Reason" text,
    "Report_Client" text,
    "Work" text,
    "StoreMain" text,
    "Eng" text,
    "Recipient" text,
    "Branch" text,
    "RefuseReason" text,
    "NoteRecived" text,
    "Returned" text,
    "CustomerGroup" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.consist_maintainces OWNER TO orientlimraerp_karim;

--
-- Name: consist_maintainces_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.consist_maintainces_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.consist_maintainces_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: consist_maintainces_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.consist_maintainces_id_seq OWNED BY public.consist_maintainces.id;


--
-- Name: consists; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.consists (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Darw" text NOT NULL,
    "Products_Number" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint,
    "Coin" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Time" text,
    "Branch" text,
    arr bigint,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.consists OWNER TO orientlimraerp_karim;

--
-- Name: consists_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.consists_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.consists_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: consists_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.consists_arr_seq OWNED BY public.consists.arr;


--
-- Name: consists_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.consists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.consists_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: consists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.consists_id_seq OWNED BY public.consists.id;


--
-- Name: contact_u_s; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.contact_u_s (
    id bigint NOT NULL,
    "Map" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    "Opening_Hours" text,
    "Phone1" text,
    "Phone2" text,
    "Phone_Header" text,
    "Email" text,
    "Arabic_Address" text,
    "English_Address" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.contact_u_s OWNER TO orientlimraerp_karim;

--
-- Name: contact_u_s_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.contact_u_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contact_u_s_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: contact_u_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.contact_u_s_id_seq OWNED BY public.contact_u_s.id;


--
-- Name: cost_centers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.cost_centers (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.cost_centers OWNER TO orientlimraerp_karim;

--
-- Name: cost_centers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.cost_centers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cost_centers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: cost_centers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.cost_centers_id_seq OWNED BY public.cost_centers.id;


--
-- Name: counters_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.counters_types (
    id bigint NOT NULL,
    "Name" text,
    "Current_Read" text,
    "Store" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.counters_types OWNER TO orientlimraerp_karim;

--
-- Name: counters_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.counters_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.counters_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: counters_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.counters_types_id_seq OWNED BY public.counters_types.id;


--
-- Name: countris; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.countris (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text NOT NULL,
    "Flag" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Safe" text,
    "Coin" text,
    "Store" text,
    "Code" text,
    "SearchCode" text
);


ALTER TABLE public.countris OWNER TO orientlimraerp_karim;

--
-- Name: countris_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.countris_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.countris_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: countris_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.countris_id_seq OWNED BY public.countris.id;


--
-- Name: coupon_codes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.coupon_codes (
    id bigint NOT NULL,
    "Code" text,
    "Amount" text,
    "Status" text,
    "Num" text,
    "Used" text,
    "Expire" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.coupon_codes OWNER TO orientlimraerp_karim;

--
-- Name: coupon_codes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.coupon_codes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.coupon_codes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: coupon_codes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.coupon_codes_id_seq OWNED BY public.coupon_codes.id;


--
-- Name: courses; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.courses (
    id bigint NOT NULL,
    "Code" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    "Category" text,
    "Lec_Num" text,
    "Hours" text,
    "Subject" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text
);


ALTER TABLE public.courses OWNER TO orientlimraerp_karim;

--
-- Name: courses_categories; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.courses_categories (
    id bigint NOT NULL,
    "Image" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.courses_categories OWNER TO orientlimraerp_karim;

--
-- Name: courses_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.courses_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_categories_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: courses_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.courses_categories_id_seq OWNED BY public.courses_categories.id;


--
-- Name: courses_halls; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.courses_halls (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Chairs_Num" text,
    "Wiifii" text,
    "Air_Condition" text,
    "Place" text,
    "Number" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.courses_halls OWNER TO orientlimraerp_karim;

--
-- Name: courses_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.courses_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_halls_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: courses_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.courses_halls_id_seq OWNED BY public.courses_halls.id;


--
-- Name: courses_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.courses_id_seq OWNED BY public.courses.id;


--
-- Name: courses_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.courses_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.courses_types OWNER TO orientlimraerp_karim;

--
-- Name: courses_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.courses_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.courses_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: courses_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.courses_types_id_seq OWNED BY public.courses_types.id;


--
-- Name: crm_default_data; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.crm_default_data (
    id bigint NOT NULL,
    "Price_Level" text,
    "Governrate" bigint,
    "City" bigint,
    "Responsible" bigint,
    "Activity" bigint,
    "Campagin" bigint,
    "ClientStatus" bigint,
    "Platforms" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client_Delegate" text DEFAULT 0,
    "Nationality" text,
    "ClientGroup" text
);


ALTER TABLE public.crm_default_data OWNER TO orientlimraerp_karim;

--
-- Name: crm_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.crm_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.crm_default_data_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: crm_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.crm_default_data_id_seq OWNED BY public.crm_default_data.id;


--
-- Name: custom_prints; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.custom_prints (
    id bigint NOT NULL,
    "Sales_Print_Type" text,
    "Sales_Bill_Code" text,
    "Sales_Date" text,
    "Sales_Coin" text,
    "Sales_Draw" text,
    "Sales_Payment_Method" text,
    "Sales_Status" text,
    "Sales_Executor" text,
    "Sales_Refernce_Number" text,
    "Sales_Safe" text,
    "Sales_Client" text,
    "Sales_Delegate" text,
    "Sales_Store" text,
    "Sales_User" text,
    "Sales_Cost_Center" text,
    "Sales_Notes" text,
    "Sales_Pro_Code" text,
    "Sales_Pro_Name" text,
    "Sales_Pro_Unit" text,
    "Sales_Pro_Qty" text,
    "Sales_Pro_Price" text,
    "Sales_Pro_Discount" text,
    "Sales_Pro_Total_Bf_Tax" text,
    "Sales_Pro_Total_Tax" text,
    "Sales_Pro_Total" text,
    "Sales_Pro_Store" text,
    "Sales_Pro_Desc" text,
    "Sales_Pro_Exp_Date" text,
    "Sales_Pro_Weight" text,
    "Sales_Pro_Patch_Number" text,
    "Sales_Product_Numbers" text,
    "Sales_Total_Qty" text,
    "Sales_Total_Discount" text,
    "Sales_Total_Bf_Taxes" text,
    "Sales_Total_Taxes" text,
    "Sales_Total_Price" text,
    "Sales_Paid" text,
    "Sales_Residual" text,
    "Sales_Taknet" text,
    "Sales_Credit" text,
    "Sales_Barcode" text,
    "Sales_Text" text,
    "Sales_Seal" text,
    "Purch_Print_Type" text,
    "Purch_Bill_Code" text,
    "Purch_Date" text,
    "Purch_Vendor_Bill_Date" text,
    "Purch_Coin" text,
    "Purch_Draw" text,
    "Purch_Payment_Method" text,
    "Purch_Status" text,
    "Purch_Refernce_Number" text,
    "Purch_Safe" text,
    "Purch_Vendor" text,
    "Purch_Delegate" text,
    "Purch_Store" text,
    "Purch_User" text,
    "Purch_Cost_Center" text,
    "Purch_Notes" text,
    "Purch_Pro_Code" text,
    "Purch_Pro_Name" text,
    "Purch_Pro_Unit" text,
    "Purch_Pro_Qty" text,
    "Purch_Pro_Price" text,
    "Purch_Pro_Discount" text,
    "Purch_Pro_Total_Bf_Tax" text,
    "Purch_Pro_Total_Tax" text,
    "Purch_Pro_Total" text,
    "Purch_Pro_Store" text,
    "Purch_Pro_Exp_Date" text,
    "Purch_Product_Numbers" text,
    "Purch_Total_Qty" text,
    "Purch_Total_Discount" text,
    "Purch_Total_Bf_Taxes" text,
    "Purch_Total_Taxes" text,
    "Purch_Total_Price" text,
    "Purch_Paid" text,
    "Purch_Residual" text,
    "Purch_Taknet" text,
    "Purch_Credit" text,
    "Purch_Barcode" text,
    "Purch_Text" text,
    "Purch_Seal" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sales_Client_Phone" text,
    "Sales_Resdiual" text,
    "Sales_Total_Return" text,
    "Sales_Client_Address" text,
    "Sales_Pro_Total_Net" text,
    "Purch_Pro_Total_Net" text
);


ALTER TABLE public.custom_prints OWNER TO orientlimraerp_karim;

--
-- Name: custom_prints_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.custom_prints_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.custom_prints_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: custom_prints_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.custom_prints_id_seq OWNED BY public.custom_prints.id;


--
-- Name: customer_follow_ups; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.customer_follow_ups (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Client" text,
    "Subject" text,
    "Rate" text,
    "Emp" text,
    "Visit_Cost" text,
    "Note" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customer_follow_ups OWNER TO orientlimraerp_karim;

--
-- Name: customer_follow_ups_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.customer_follow_ups_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customer_follow_ups_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: customer_follow_ups_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.customer_follow_ups_arr_seq OWNED BY public.customer_follow_ups.arr;


--
-- Name: customer_follow_ups_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.customer_follow_ups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customer_follow_ups_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: customer_follow_ups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.customer_follow_ups_id_seq OWNED BY public.customer_follow_ups.id;


--
-- Name: customers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.customers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text,
    "Name" text NOT NULL,
    "Price_Level" text,
    "Phone" text,
    email text,
    password text,
    "ID_Number" text,
    "Address" text,
    "Qualifications" text,
    "Birthdate" text,
    "Social_Status" text,
    "Passport_Number" text,
    "Company_Name" text,
    "Commercial_Registration_No" text,
    "Tax_Card_No" text,
    "Bank_Account" text,
    "Image" text,
    "Next_Time" text,
    "Executions_Status" text,
    "Governrate" bigint,
    "City" bigint,
    "Responsible" bigint,
    "Activity" bigint,
    "Campagin" bigint,
    "ClientStatus" bigint,
    "Account" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Platform" bigint,
    "Contract_Start" text,
    "Contract_End" text,
    code text,
    country text,
    "Tax_Registration_Number" text,
    "Tax_activity_code" text,
    work_nature text,
    "Buliding_Num" text,
    "Street" text,
    "Postal_Code" text,
    tax_magistrate text,
    "Floor" text,
    "Room" text,
    "Landmark" text,
    "Add_Info" text,
    "Phone2" text,
    "Phone3" text,
    "Phone4" text,
    "Warranty" text,
    "Group" bigint,
    "Place" bigint,
    "Nationality" bigint,
    "Product" bigint,
    token text,
    "NameEn" text,
    arr bigint,
    "SearchCode" text,
    "Credit_Limit" text,
    "Respon_Person" text,
    "Respon_Person_Phone" text,
    "Operating_Date" text,
    "Activation_Serial" text,
    "Activation_Code" text,
    "Repayment_Period" text
);


ALTER TABLE public.customers OWNER TO orientlimraerp_karim;

--
-- Name: customers_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.customers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: customers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.customers_arr_seq OWNED BY public.customers.arr;


--
-- Name: customers_files; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.customers_files (
    id bigint NOT NULL,
    "File" text NOT NULL,
    "Customer" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customers_files OWNER TO orientlimraerp_karim;

--
-- Name: customers_files_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.customers_files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_files_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: customers_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.customers_files_id_seq OWNED BY public.customers_files.id;


--
-- Name: customers_groups; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.customers_groups (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Discount" text
);


ALTER TABLE public.customers_groups OWNER TO orientlimraerp_karim;

--
-- Name: customers_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.customers_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_groups_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: customers_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.customers_groups_id_seq OWNED BY public.customers_groups.id;


--
-- Name: customers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.customers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: customers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.customers_id_seq OWNED BY public.customers.id;


--
-- Name: customers_rate_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.customers_rate_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.customers_rate_types OWNER TO orientlimraerp_karim;

--
-- Name: customers_rate_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.customers_rate_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_rate_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: customers_rate_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.customers_rate_types_id_seq OWNED BY public.customers_rate_types.id;


--
-- Name: customers_tickets; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.customers_tickets (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Problem" text NOT NULL,
    "Status" text NOT NULL,
    "Bill_Number" text,
    "Responsible" bigint,
    "Customer" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ProblemEn" text,
    arr bigint
);


ALTER TABLE public.customers_tickets OWNER TO orientlimraerp_karim;

--
-- Name: customers_tickets_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.customers_tickets_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_tickets_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: customers_tickets_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.customers_tickets_arr_seq OWNED BY public.customers_tickets.arr;


--
-- Name: customers_tickets_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.customers_tickets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.customers_tickets_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: customers_tickets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.customers_tickets_id_seq OWNED BY public.customers_tickets.id;


--
-- Name: deducations_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.deducations_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.deducations_types OWNER TO orientlimraerp_karim;

--
-- Name: deducations_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.deducations_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deducations_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: deducations_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.deducations_types_id_seq OWNED BY public.deducations_types.id;


--
-- Name: deductions; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.deductions (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Coin" bigint NOT NULL,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.deductions OWNER TO orientlimraerp_karim;

--
-- Name: deductions_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.deductions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deductions_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: deductions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.deductions_arr_seq OWNED BY public.deductions.arr;


--
-- Name: deductions_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.deductions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deductions_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: deductions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.deductions_id_seq OWNED BY public.deductions.id;


--
-- Name: default_data_show_hides; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.default_data_show_hides (
    id bigint NOT NULL,
    "Status" text,
    "Shipping_Company" text,
    "Vendor_Date" text,
    "Expire_Date" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Coin" text,
    "Draw" text,
    "Delegate_Sale" text,
    "Delegate_Purchase" text,
    "Note" text,
    "Refrence_Number" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Cost_Center" text,
    "Branch" text,
    "Serial_Num" text,
    "Pass" text,
    "Pattern_Image" text,
    "Barcode_Print" text,
    "Unit_Print" text,
    "Total_BF_Print" text,
    "Discount_Print" text,
    "Tax_Print" text,
    "A5" text,
    "A4" text,
    "CM8" text,
    "Group_Brand" text,
    "Patch_Number" text,
    "Manufacturing_Model_Shortcomings" text,
    "Search_Typical" text,
    "Validity_Product" text,
    "Executor_Sale" text,
    "Totuch_Screen" text,
    "Tax_POS" text,
    "TotalDiscountPrint" text,
    "TotalTaxPrint" text,
    "ProductsNumber" text,
    "TotalQtyPrint" text,
    "Credit" text,
    "Barcode" text,
    "Taknet" text,
    "Address" text,
    "Phone1" text,
    "Phone2" text,
    "Phone3" text,
    "Phone4" text,
    "Text" text,
    "Seal" text,
    "Code_Report" text,
    "Unit" text,
    "Refrence_Number_Print" text,
    "Icon_Payment_Recipt" text,
    "SearchCode" text,
    "TaxOnTotal" text,
    "TotalBfTax" text,
    "AvQty" text,
    "Disc" text,
    "Tax" text,
    "Store" text,
    "TaxBill" text,
    "Change_Way_Stores_Transfer" text,
    "Note_POS" text,
    "Open_Drawer" text,
    client_delivery text,
    "POS_RecivedDate" text,
    "POS_Barcode" text,
    "POS_Qty" text,
    "Show_File_InsurancePaper" text,
    "Show_File_Checks" text,
    "Show_File_Purchases" text,
    "Show_File_Sales" text,
    "Show_File_PaymentVoucher" text,
    "Show_File_ReciptVoucher" text,
    "Show_File_TransferStores" text,
    "Thickness_Print" text,
    "Height_Print" text,
    "Thickness" text,
    "Height" text,
    "Items_Guide_Store_Show" text,
    "Sales_Pro_Desc" text,
    "Show_Barcode" text,
    "Show_Net" text,
    "Show_Unit" text,
    "Show_Total" text
);


ALTER TABLE public.default_data_show_hides OWNER TO orientlimraerp_karim;

--
-- Name: default_data_show_hides_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.default_data_show_hides_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.default_data_show_hides_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: default_data_show_hides_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.default_data_show_hides_id_seq OWNED BY public.default_data_show_hides.id;


--
-- Name: depaarture_policy_emps; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.depaarture_policy_emps (
    id bigint NOT NULL,
    "From" text,
    "To" text,
    "Discount" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.depaarture_policy_emps OWNER TO orientlimraerp_karim;

--
-- Name: depaarture_policy_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.depaarture_policy_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.depaarture_policy_emps_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: depaarture_policy_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.depaarture_policy_emps_id_seq OWNED BY public.depaarture_policy_emps.id;


--
-- Name: departure_emps; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.departure_emps (
    id bigint NOT NULL,
    "In_Time" text NOT NULL,
    "Out_Time" text NOT NULL,
    "Hours_Number" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "Departure" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Disc_Late" text,
    "Disc_Early" text
);


ALTER TABLE public.departure_emps OWNER TO orientlimraerp_karim;

--
-- Name: departure_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.departure_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departure_emps_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: departure_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.departure_emps_id_seq OWNED BY public.departure_emps.id;


--
-- Name: departures; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.departures (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Note" text,
    "Attend" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.departures OWNER TO orientlimraerp_karim;

--
-- Name: departures_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.departures_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departures_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: departures_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.departures_arr_seq OWNED BY public.departures.arr;


--
-- Name: departures_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.departures_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departures_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: departures_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.departures_id_seq OWNED BY public.departures.id;


--
-- Name: desvice_cases; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.desvice_cases (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.desvice_cases OWNER TO orientlimraerp_karim;

--
-- Name: desvice_cases_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.desvice_cases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.desvice_cases_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: desvice_cases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.desvice_cases_id_seq OWNED BY public.desvice_cases.id;


--
-- Name: device_descrips; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.device_descrips (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Sort" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.device_descrips OWNER TO orientlimraerp_karim;

--
-- Name: device_descrips_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.device_descrips_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.device_descrips_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: device_descrips_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.device_descrips_id_seq OWNED BY public.device_descrips.id;


--
-- Name: devices_typesies; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.devices_typesies (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Company" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.devices_typesies OWNER TO orientlimraerp_karim;

--
-- Name: devices_typesies_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.devices_typesies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.devices_typesies_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: devices_typesies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.devices_typesies_id_seq OWNED BY public.devices_typesies.id;


--
-- Name: disclaimers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.disclaimers (
    id bigint NOT NULL,
    "Date" text,
    "File" text,
    "Emp" text,
    "Note" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.disclaimers OWNER TO orientlimraerp_karim;

--
-- Name: disclaimers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.disclaimers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.disclaimers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: disclaimers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.disclaimers_id_seq OWNED BY public.disclaimers.id;


--
-- Name: discounts_emps; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.discounts_emps (
    id bigint NOT NULL,
    "AmountDiscount" text,
    "Discount" bigint,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.discounts_emps OWNER TO orientlimraerp_karim;

--
-- Name: discounts_emps_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.discounts_emps_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discounts_emps_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: discounts_emps_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.discounts_emps_id_seq OWNED BY public.discounts_emps.id;


--
-- Name: domains; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.domains (
    id integer NOT NULL,
    domain character varying(255) NOT NULL,
    tenant_id character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.domains OWNER TO orientlimraerp_karim;

--
-- Name: emp_covenants; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emp_covenants (
    id bigint NOT NULL,
    "Emp" text,
    "Date" text,
    "Name" text,
    "Price" text,
    "Reason" text,
    "Life_Expectancy" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_covenants OWNER TO orientlimraerp_karim;

--
-- Name: emp_covenants_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emp_covenants_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_covenants_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emp_covenants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emp_covenants_id_seq OWNED BY public.emp_covenants.id;


--
-- Name: emp_excs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emp_excs (
    id bigint NOT NULL,
    "Name" text,
    "Account" text,
    "Emp_Type" text,
    "Salary" text,
    "Phone" text,
    "Job" text,
    "Department" text,
    "Store1" text,
    "Store2" text,
    "Store3" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_excs OWNER TO orientlimraerp_karim;

--
-- Name: emp_excs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emp_excs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_excs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emp_excs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emp_excs_id_seq OWNED BY public.emp_excs.id;


--
-- Name: emp_installment_details; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emp_installment_details (
    id bigint NOT NULL,
    "Date" text,
    "Value" text,
    "Status" text,
    "Emp" bigint,
    "Install" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_installment_details OWNER TO orientlimraerp_karim;

--
-- Name: emp_installment_details_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emp_installment_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_installment_details_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emp_installment_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emp_installment_details_id_seq OWNED BY public.emp_installment_details.id;


--
-- Name: emp_installments; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emp_installments (
    id bigint NOT NULL,
    "Amount" text NOT NULL,
    "Years_Number" text NOT NULL,
    "First_Date" text NOT NULL,
    "Install" text NOT NULL,
    "Install_Numbers" text NOT NULL,
    "Status" text NOT NULL,
    "Emp" bigint,
    "Loan" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_installments OWNER TO orientlimraerp_karim;

--
-- Name: emp_installments_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emp_installments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_installments_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emp_installments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emp_installments_id_seq OWNED BY public.emp_installments.id;


--
-- Name: emp_mails; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emp_mails (
    id bigint NOT NULL,
    "Message" text,
    "Emp" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_mails OWNER TO orientlimraerp_karim;

--
-- Name: emp_mails_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emp_mails_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_mails_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emp_mails_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emp_mails_id_seq OWNED BY public.emp_mails.id;


--
-- Name: emp_p_o_s_stores; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emp_p_o_s_stores (
    id bigint NOT NULL,
    "Emp" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" text
);


ALTER TABLE public.emp_p_o_s_stores OWNER TO orientlimraerp_karim;

--
-- Name: emp_p_o_s_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emp_p_o_s_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_p_o_s_stores_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emp_p_o_s_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emp_p_o_s_stores_id_seq OWNED BY public.emp_p_o_s_stores.id;


--
-- Name: emp_ratios; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emp_ratios (
    id bigint NOT NULL,
    "From" text NOT NULL,
    "To" text NOT NULL,
    "Salary" text NOT NULL,
    "Rate" text NOT NULL,
    "Type" text NOT NULL,
    "Emp" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Typee" text
);


ALTER TABLE public.emp_ratios OWNER TO orientlimraerp_karim;

--
-- Name: emp_ratios_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emp_ratios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_ratios_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emp_ratios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emp_ratios_id_seq OWNED BY public.emp_ratios.id;


--
-- Name: emp_safes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emp_safes (
    id bigint NOT NULL,
    "Safe" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emp_safes OWNER TO orientlimraerp_karim;

--
-- Name: emp_safes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emp_safes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emp_safes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emp_safes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emp_safes_id_seq OWNED BY public.emp_safes.id;


--
-- Name: empassies; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.empassies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Address" text,
    "English_Address" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.empassies OWNER TO orientlimraerp_karim;

--
-- Name: empassies_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.empassies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.empassies_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: empassies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.empassies_id_seq OWNED BY public.empassies.id;


--
-- Name: empassy_reserve_dates; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.empassy_reserve_dates (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Client" text,
    "Purpose" text,
    "Empassy" text,
    "Booking_Date" text,
    "Cost" text,
    "Pay" text,
    "Residual" text,
    "Safe" text,
    "Draw" text,
    "Coin" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.empassy_reserve_dates OWNER TO orientlimraerp_karim;

--
-- Name: empassy_reserve_dates_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.empassy_reserve_dates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.empassy_reserve_dates_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: empassy_reserve_dates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.empassy_reserve_dates_id_seq OWNED BY public.empassy_reserve_dates.id;


--
-- Name: employesses; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.employesses (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Emp_Type" text,
    "Salary" text,
    "Attendence" text,
    "Departure" text,
    "Hours_Numbers" text,
    "Days_Numbers" text,
    "Day_Price" text,
    "Precentage_of_Sales" text,
    "Precentage_of_Profits" text,
    "Image" text,
    "Bank_Account" text,
    "Qualifications" text,
    "Address" text,
    "Social_Status" text,
    "ID_Number" text,
    "Contract_Start" text,
    "Contract_End" text,
    "Phone" text,
    "Phone2" text,
    "Email" text,
    "Password" text,
    "Job" bigint,
    "Department" bigint,
    "Account" bigint,
    "Account_Emp" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "Precentage_of_Execution" text,
    "Covenant" bigint,
    "Commission" bigint,
    "Price_Level" text,
    "Bill_Num" text,
    "NumbersOfBill" text,
    "EmpSort" text DEFAULT 1,
    "CV" text,
    "ID_Image" text,
    "Criminal_status" text,
    "Contract" text,
    health_certificate text,
    "Search_Card" text,
    "Recruitment_certificate" text,
    employee_profile text,
    duration_criminal_investigation text,
    "Birthdate" text,
    "Attitude_recruiting" text,
    "Job_Number" text,
    date_resignation text,
    "Living" text,
    "Branch" text,
    "Level" text,
    "Religion" text,
    "Insurance_salary" text,
    "Insurance_companies" text,
    "Previous_experience" text,
    "Nationality" text,
    "MonthlyTarget" text,
    "QuarterTarget" text,
    "SemiTarget" text,
    "YearlyTarget" text,
    "IDExpireDate" text,
    "LicensExpireDate" text,
    "PassportExpireDate" text,
    "Merit" text,
    "Pro_Group" text,
    "NameEn" text,
    arr bigint,
    "SearchCode" text,
    "Active" text DEFAULT 1,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.employesses OWNER TO orientlimraerp_karim;

--
-- Name: employesses_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.employesses_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.employesses_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: employesses_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.employesses_arr_seq OWNED BY public.employesses.arr;


--
-- Name: employesses_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.employesses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.employesses_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: employesses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.employesses_id_seq OWNED BY public.employesses.id;


--
-- Name: employment_levels; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.employment_levels (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.employment_levels OWNER TO orientlimraerp_karim;

--
-- Name: employment_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.employment_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.employment_levels_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: employment_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.employment_levels_id_seq OWNED BY public.employment_levels.id;


--
-- Name: emps_producation_points; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emps_producation_points (
    id bigint NOT NULL,
    "Month" text,
    "Point" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text
);


ALTER TABLE public.emps_producation_points OWNER TO orientlimraerp_karim;

--
-- Name: emps_producation_points_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emps_producation_points_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emps_producation_points_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emps_producation_points_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emps_producation_points_id_seq OWNED BY public.emps_producation_points.id;


--
-- Name: emps_producation_quantities; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.emps_producation_quantities (
    id bigint NOT NULL,
    "FromQ" text,
    "ToQ" text,
    "ValueQ" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.emps_producation_quantities OWNER TO orientlimraerp_karim;

--
-- Name: emps_producation_quantities_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.emps_producation_quantities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.emps_producation_quantities_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: emps_producation_quantities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.emps_producation_quantities_id_seq OWNED BY public.emps_producation_quantities.id;


--
-- Name: entitlements; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.entitlements (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Coin" bigint NOT NULL,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.entitlements OWNER TO orientlimraerp_karim;

--
-- Name: entitlements_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.entitlements_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entitlements_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: entitlements_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.entitlements_arr_seq OWNED BY public.entitlements.arr;


--
-- Name: entitlements_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.entitlements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entitlements_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: entitlements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.entitlements_id_seq OWNED BY public.entitlements.id;


--
-- Name: events; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.events (
    id bigint NOT NULL,
    "Start_Date" text,
    "End_Date" text,
    "Event_Ar_Name" text,
    "Event_En_Name" text,
    "Type" text,
    "Type_ID" text,
    "Type_Code" text,
    "Emp" text,
    "Client" text,
    "Product" text,
    "Customer" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.events OWNER TO orientlimraerp_karim;

--
-- Name: events_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.events_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.events_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: events_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.events_id_seq OWNED BY public.events.id;


--
-- Name: examinations_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.examinations_types (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Allow_From" text NOT NULL,
    "Allow_To" text NOT NULL,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.examinations_types OWNER TO orientlimraerp_karim;

--
-- Name: examinations_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.examinations_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.examinations_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: examinations_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.examinations_types_id_seq OWNED BY public.examinations_types.id;


--
-- Name: exchange_commissions; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.exchange_commissions (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text,
    "Note" text,
    "Return_Maintaince" text,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Commision" text NOT NULL,
    "Pre_Sales" text NOT NULL,
    "Pre_Execu" text NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Emp" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Exchange_Commision" text,
    "Collection" text,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.exchange_commissions OWNER TO orientlimraerp_karim;

--
-- Name: exchange_commissions_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.exchange_commissions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.exchange_commissions_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: exchange_commissions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.exchange_commissions_arr_seq OWNED BY public.exchange_commissions."Code";


--
-- Name: exchange_commissions_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.exchange_commissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.exchange_commissions_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: exchange_commissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.exchange_commissions_id_seq OWNED BY public.exchange_commissions.id;


--
-- Name: execute_job_order_models; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.execute_job_order_models (
    id bigint NOT NULL,
    "Model" text,
    "Qty" text,
    "Total_Cost" text,
    "Outcome" text,
    "Execute" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.execute_job_order_models OWNER TO orientlimraerp_karim;

--
-- Name: execute_job_order_models_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.execute_job_order_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_order_models_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: execute_job_order_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.execute_job_order_models_id_seq OWNED BY public.execute_job_order_models.id;


--
-- Name: execute_job_order_workmanships; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.execute_job_order_workmanships (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Execute" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Net" text
);


ALTER TABLE public.execute_job_order_workmanships OWNER TO orientlimraerp_karim;

--
-- Name: execute_job_order_workmanships_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.execute_job_order_workmanships_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_order_workmanships_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: execute_job_order_workmanships_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.execute_job_order_workmanships_id_seq OWNED BY public.execute_job_order_workmanships.id;


--
-- Name: execute_job_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.execute_job_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Note" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "RecivedDate" text,
    "Recipient" text,
    "Order" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Transfer" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "Current_Credit" text,
    "Model" text,
    "Status" text DEFAULT 0
);


ALTER TABLE public.execute_job_orders OWNER TO orientlimraerp_karim;

--
-- Name: execute_job_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.execute_job_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_orders_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: execute_job_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.execute_job_orders_arr_seq OWNED BY public.execute_job_orders."Code";


--
-- Name: execute_job_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.execute_job_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.execute_job_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: execute_job_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.execute_job_orders_id_seq OWNED BY public.execute_job_orders.id;


--
-- Name: executing_receiving_secretariats; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.executing_receiving_secretariats (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Qty" text,
    "Total" text,
    "Model" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "StoreIn" text,
    "StoreOut" text,
    "Client" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Workmanship_Price" text
);


ALTER TABLE public.executing_receiving_secretariats OWNER TO orientlimraerp_karim;

--
-- Name: executing_receiving_secretariats_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.executing_receiving_secretariats_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receiving_secretariats_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: executing_receiving_secretariats_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.executing_receiving_secretariats_arr_seq OWNED BY public.executing_receiving_secretariats.arr;


--
-- Name: executing_receiving_secretariats_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.executing_receiving_secretariats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receiving_secretariats_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: executing_receiving_secretariats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.executing_receiving_secretariats_id_seq OWNED BY public.executing_receiving_secretariats.id;


--
-- Name: executing_receivings; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.executing_receivings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Qty" text NOT NULL,
    "Total" text NOT NULL,
    "Model" bigint NOT NULL,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text,
    "Time" text,
    "StoreIn" text,
    "StoreOut" text,
    "Sort" text,
    "Vendor" text,
    "Cost_Workmentship" text,
    "Total_Workmentship" text,
    arr bigint
);


ALTER TABLE public.executing_receivings OWNER TO orientlimraerp_karim;

--
-- Name: executing_receivings_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.executing_receivings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receivings_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: executing_receivings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.executing_receivings_arr_seq OWNED BY public.executing_receivings.arr;


--
-- Name: executing_receivings_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.executing_receivings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executing_receivings_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: executing_receivings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.executing_receivings_id_seq OWNED BY public.executing_receivings.id;


--
-- Name: executor_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.executor_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.executor_filters OWNER TO orientlimraerp_karim;

--
-- Name: executor_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.executor_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.executor_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: executor_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.executor_filters_id_seq OWNED BY public.executor_filters.id;


--
-- Name: expenses_list_column_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.expenses_list_column_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code_Type" text,
    "Statement" text,
    "Debitor" text,
    "Cost_Center" text,
    "Coin" text,
    "User" text,
    "Account" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.expenses_list_column_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: expenses_list_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.expenses_list_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expenses_list_column_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: expenses_list_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.expenses_list_column_sechdules_id_seq OWNED BY public.expenses_list_column_sechdules.id;


--
-- Name: expenses_list_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.expenses_list_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code_Type" text,
    "Statement" text,
    "Debitor" text,
    "Cost_Center" text,
    "Coin" text,
    "User" text,
    "Account" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.expenses_list_columns OWNER TO orientlimraerp_karim;

--
-- Name: expenses_list_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.expenses_list_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expenses_list_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: expenses_list_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.expenses_list_columns_id_seq OWNED BY public.expenses_list_columns.id;


--
-- Name: expire_date_qties; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.expire_date_qties (
    id bigint NOT NULL,
    "Qty" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Store" text,
    "Unit" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Low_Unit" text,
    "Exp_Date" text,
    "Group" text,
    "Brand" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Hold_Qty" text DEFAULT 0
);


ALTER TABLE public.expire_date_qties OWNER TO orientlimraerp_karim;

--
-- Name: expire_date_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.expire_date_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.expire_date_qties_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: expire_date_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.expire_date_qties_id_seq OWNED BY public.expire_date_qties.id;


--
-- Name: export_checks; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.export_checks (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Check_Num" text,
    "Due_Date" text NOT NULL,
    "Amount" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Reason" text,
    "Check_Type" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Account" bigint NOT NULL,
    "Bank" bigint NOT NULL,
    "Pay_Account" bigint NOT NULL,
    "Bene_Account" bigint,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "File" text,
    arr bigint,
    "Image" text,
    "Signture_Name" text,
    "Bank_Branch" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "BankSafe_Account" text,
    "Transfer" text
);


ALTER TABLE public.export_checks OWNER TO orientlimraerp_karim;

--
-- Name: export_checks_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.export_checks_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.export_checks_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: export_checks_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.export_checks_arr_seq OWNED BY public.export_checks.arr;


--
-- Name: export_checks_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.export_checks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.export_checks_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: export_checks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.export_checks_id_seq OWNED BY public.export_checks.id;


--
-- Name: f_a_q_s; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.f_a_q_s (
    id bigint NOT NULL,
    "Arabic_Question" text NOT NULL,
    "English_Question" text NOT NULL,
    "Arabic_Answer" text NOT NULL,
    "English_Answer" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.f_a_q_s OWNER TO orientlimraerp_karim;

--
-- Name: f_a_q_s_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.f_a_q_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.f_a_q_s_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: f_a_q_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.f_a_q_s_id_seq OWNED BY public.f_a_q_s.id;


--
-- Name: failed_jobs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.failed_jobs (
    id bigint NOT NULL,
    uuid character varying(191) NOT NULL,
    connection text NOT NULL,
    queue text NOT NULL,
    payload text NOT NULL,
    exception text NOT NULL,
    failed_at timestamp(0) without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.failed_jobs OWNER TO orientlimraerp_karim;

--
-- Name: failed_jobs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.failed_jobs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.failed_jobs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: failed_jobs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.failed_jobs_id_seq OWNED BY public.failed_jobs.id;


--
-- Name: faults_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.faults_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Note" text,
    "Amount" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.faults_types OWNER TO orientlimraerp_karim;

--
-- Name: faults_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.faults_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.faults_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: faults_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.faults_types_id_seq OWNED BY public.faults_types.id;


--
-- Name: fifo_qties; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.fifo_qties (
    id bigint NOT NULL,
    "Qty" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Cost_Price" text,
    "Store" text,
    "Unit" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Low_Unit" text,
    "Exp_Date" text,
    "SearchCode1" text,
    "SearchCode2" text,
    "Group" text,
    "Brand" text,
    "Branch" text,
    "Purchases_Date" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Original_Qty" text,
    "Hold_Qty" text DEFAULT 0
);


ALTER TABLE public.fifo_qties OWNER TO orientlimraerp_karim;

--
-- Name: fifo_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.fifo_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fifo_qties_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: fifo_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.fifo_qties_id_seq OWNED BY public.fifo_qties.id;


--
-- Name: firewall_ips; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.firewall_ips (
    id integer NOT NULL,
    ip character varying(191) NOT NULL,
    log_id integer,
    blocked boolean DEFAULT true NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone
);


ALTER TABLE public.firewall_ips OWNER TO orientlimraerp_karim;

--
-- Name: firewall_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.firewall_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.firewall_logs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: firewall_logs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.firewall_logs (
    id integer DEFAULT nextval('public.firewall_logs_id_seq'::regclass) NOT NULL,
    ip character varying(191) NOT NULL,
    level character varying(191) DEFAULT 'medium'::character varying NOT NULL,
    middleware character varying(191) NOT NULL,
    user_id integer,
    url text,
    referrer character varying(191),
    request text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    deleted_at timestamp(0) without time zone
);


ALTER TABLE public.firewall_logs OWNER TO orientlimraerp_karim;

--
-- Name: follow_lists; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.follow_lists (
    id bigint NOT NULL,
    "Emp" text,
    "Day" text,
    "Time" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.follow_lists OWNER TO orientlimraerp_karim;

--
-- Name: follow_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.follow_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.follow_lists_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: follow_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.follow_lists_id_seq OWNED BY public.follow_lists.id;


--
-- Name: general_dailies; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.general_dailies (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Type" text NOT NULL,
    "Debitor" text NOT NULL,
    "Creditor" text NOT NULL,
    "Statement" text,
    "Draw" text NOT NULL,
    "Debitor_Coin" text NOT NULL,
    "Creditor_Coin" text NOT NULL,
    "Account" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    userr bigint,
    "Code_Type" text,
    "Branch" text,
    "TypeEn" text,
    arr bigint
);


ALTER TABLE public.general_dailies OWNER TO orientlimraerp_karim;

--
-- Name: general_dailies_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.general_dailies_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.general_dailies_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: general_dailies_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.general_dailies_arr_seq OWNED BY public.general_dailies.arr;


--
-- Name: general_dailies_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.general_dailies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.general_dailies_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: general_dailies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.general_dailies_id_seq OWNED BY public.general_dailies.id;


--
-- Name: governrates; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.governrates (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Country" text,
    "SearchCode" text
);


ALTER TABLE public.governrates OWNER TO orientlimraerp_karim;

--
-- Name: governrates_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.governrates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.governrates_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: governrates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.governrates_id_seq OWNED BY public.governrates.id;


--
-- Name: group_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.group_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.group_filters OWNER TO orientlimraerp_karim;

--
-- Name: group_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.group_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.group_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: group_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.group_filters_id_seq OWNED BY public.group_filters.id;


--
-- Name: holidays; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.holidays (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Num_of_Days" text NOT NULL,
    "Start_Date" text NOT NULL,
    "Discount" text NOT NULL,
    "Status" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.holidays OWNER TO orientlimraerp_karim;

--
-- Name: holidays_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.holidays_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: holidays_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.holidays_arr_seq OWNED BY public.holidays.arr;


--
-- Name: holidays_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.holidays_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: holidays_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.holidays_id_seq OWNED BY public.holidays.id;


--
-- Name: holidays_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.holidays_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Days" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From_Date" text,
    "To_Date" text
);


ALTER TABLE public.holidays_types OWNER TO orientlimraerp_karim;

--
-- Name: holidays_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.holidays_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: holidays_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.holidays_types_id_seq OWNED BY public.holidays_types.id;


--
-- Name: home_e_com_designs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.home_e_com_designs (
    id bigint NOT NULL,
    "Slider_BG_Type" text,
    "Slider_BG_Image" text,
    "Slider_BG_Color" text,
    "Slider_Button_BG_Color" text,
    "Slider_Button_Txt_Color" text,
    "Slider_Button_Hover_BG_Color" text,
    "Slider_Button_Hover_Txt_Color" text,
    "Slider_Title_Txt_Color" text,
    "Slider_Desc_Txt_Color" text,
    "Ads_Top_Img_First_BG_Color" text,
    "Ads_Top_Img_First_Before_BG_Color" text,
    "Ads_Top_Img_Second_BG_Color" text,
    "Ads_Top_Img_Second_Before_BG_Color" text,
    "Ads_Top_Img_Button_BG_Color" text,
    "Ads_Top_Img_Button_Txt_Color" text,
    "Ads_Top_Img_Button_Hover_BG_Color" text,
    "Ads_Top_Img_Button_Hover_Txt_Color" text,
    "Support_Icons_BG_Color" text,
    "Support_Icons_Txt_Color" text,
    "Support_Icons_Color" text,
    "Ads_Bootom_Imgs_BG_Color" text,
    "Ads_Bootom_Imgs_Middle_BG_Color" text,
    "Ads_Bootom_Imgs_Button_BG_Color" text,
    "Ads_Bootom_Imgs_Button_Txt_Color" text,
    "Ads_Bootom_Imgs_Button_Hover_BG_Color" text,
    "Ads_Bootom_Imgs_Button_Hover_Txt_Color" text,
    "Partners_BG_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.home_e_com_designs OWNER TO orientlimraerp_karim;

--
-- Name: home_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.home_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.home_e_com_designs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: home_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.home_e_com_designs_id_seq OWNED BY public.home_e_com_designs.id;


--
-- Name: home_product_e_com_designs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.home_product_e_com_designs (
    id bigint NOT NULL,
    "Special_Offer_Title_BG_Color" text,
    "Special_Offer_Title_Txt_Color" text,
    "Special_Offer_Product_BG_Color" text,
    "Special_Offer_Product_Border_Color" text,
    "Special_Offer_Product_Txt_Color" text,
    "Special_Offer_Product_Price_Color" text,
    "Special_Offer_Product_Rate_Color" text,
    "Best_Sellers_Title_BG_Color" text,
    "Best_Sellers_Title_Txt_Color" text,
    "Best_Sellers_Category_Txt_Color" text,
    "Best_Sellers_Category_Active_Txt_Color" text,
    "Best_Sellers_Product_BG_Color" text,
    "Best_Sellers_Product_Group_BG_Color" text,
    "Best_Sellers_Product_Group_Txt_Color" text,
    "Best_Sellers_Product_Group_Hover_BG_Color" text,
    "Best_Sellers_Product_Group_Hover_Txt_Color" text,
    "Best_Sellers_Product_Icon_BG_Color" text,
    "Best_Sellers_Product_Icon_Txt_Color" text,
    "Best_Sellers_Product_Icon_Hover_BG_Color" text,
    "Best_Sellers_Product_Icon_Hover_Txt_Color" text,
    "Best_Sellers_Product_Txt_Color" text,
    "Best_Sellers_Product_Price_Color" text,
    "Best_Sellers_Product_Rate_Color" text,
    "New_Arrivals_Title_BG_Color" text,
    "New_Arrivals_Title_Txt_Color" text,
    "New_Arrivals_Product_BG_Color" text,
    "New_Arrivals_Product_Group_BG_Color" text,
    "New_Arrivals_Product_Group_Txt_Color" text,
    "New_Arrivals_Product_Group_Hover_BG_Color" text,
    "New_Arrivals_Product_Group_Hover_Txt_Color" text,
    "New_Arrivals_Product_Icon_BG_Color" text,
    "New_Arrivals_Product_Icon_Txt_Color" text,
    "New_Arrivals_Product_Icon_Hover_BG_Color" text,
    "New_Arrivals_Product_Icon_Hover_Txt_Color" text,
    "New_Arrivals_Product_Txt_Color" text,
    "New_Arrivals_Product_Price_Color" text,
    "New_Arrivals_Product_Hover_Price_Color" text,
    "New_Arrivals_Product_Rate_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Special_Offer_Product_Txt_Hover_Color" text
);


ALTER TABLE public.home_product_e_com_designs OWNER TO orientlimraerp_karim;

--
-- Name: home_product_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.home_product_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.home_product_e_com_designs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: home_product_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.home_product_e_com_designs_id_seq OWNED BY public.home_product_e_com_designs.id;


--
-- Name: import_new_prods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.import_new_prods (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Group" text NOT NULL,
    "Brand" text,
    "Unit" text NOT NULL,
    "Rate" text NOT NULL,
    "Barcode" text NOT NULL,
    "Price_1" text NOT NULL,
    "Price_2" text,
    "Price_3" text,
    "Def" text NOT NULL,
    "Num" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code_Type" text,
    "World_Code" text,
    "Weight" text
);


ALTER TABLE public.import_new_prods OWNER TO orientlimraerp_karim;

--
-- Name: import_new_prods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.import_new_prods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_new_prods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: import_new_prods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.import_new_prods_id_seq OWNED BY public.import_new_prods.id;


--
-- Name: import_new_prods_starts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.import_new_prods_starts (
    id bigint NOT NULL,
    "Name" text,
    "Type" text,
    "Group" text,
    "Brand" text,
    "Unit" text,
    "Rate" text,
    "Barcode" text,
    "Price_1" text,
    "Price_2" text,
    "Price_3" text,
    "Def" text,
    "Num" text,
    "Store" text,
    "Qty" text,
    "CostPrice" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code_Type" text,
    "World_Code" text,
    "Weight" text
);


ALTER TABLE public.import_new_prods_starts OWNER TO orientlimraerp_karim;

--
-- Name: import_new_prods_starts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.import_new_prods_starts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.import_new_prods_starts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: import_new_prods_starts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.import_new_prods_starts_id_seq OWNED BY public.import_new_prods_starts.id;


--
-- Name: incom_checks; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.incom_checks (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Check_Num" text NOT NULL,
    "Due_Date" text NOT NULL,
    "Amount" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Reason" text,
    "Check_Type" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Account" bigint NOT NULL,
    "Bank" bigint NOT NULL,
    "Arrest_Account" bigint NOT NULL,
    "Bene_Account" bigint,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "File" text,
    arr bigint,
    "Image" text,
    "Signture_Name" text,
    "Bank_Branch" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "BankSafe_Account" text,
    "Transfer" text
);


ALTER TABLE public.incom_checks OWNER TO orientlimraerp_karim;

--
-- Name: incom_checks_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.incom_checks_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_checks_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: incom_checks_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.incom_checks_arr_seq OWNED BY public.incom_checks.arr;


--
-- Name: incom_checks_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.incom_checks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_checks_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: incom_checks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.incom_checks_id_seq OWNED BY public.incom_checks.id;


--
-- Name: incom_manufacturing_models; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.incom_manufacturing_models (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Cost" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Depreciation" text NOT NULL,
    "Depreciation_Qty" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "Model" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Precent" text
);


ALTER TABLE public.incom_manufacturing_models OWNER TO orientlimraerp_karim;

--
-- Name: incom_manufacturing_models_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.incom_manufacturing_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_manufacturing_models_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: incom_manufacturing_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.incom_manufacturing_models_id_seq OWNED BY public.incom_manufacturing_models.id;


--
-- Name: incom_manufacturing_secretariat_models; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.incom_manufacturing_secretariat_models (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Precent" text,
    "Qty" text,
    "Cost" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Depreciation" text,
    "Depreciation_Qty" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Model" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.incom_manufacturing_secretariat_models OWNER TO orientlimraerp_karim;

--
-- Name: incom_manufacturing_secretariat_models_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.incom_manufacturing_secretariat_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.incom_manufacturing_secretariat_models_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: incom_manufacturing_secretariat_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.incom_manufacturing_secretariat_models_id_seq OWNED BY public.incom_manufacturing_secretariat_models.id;


--
-- Name: install_companies_sales_bills_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.install_companies_sales_bills_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.install_companies_sales_bills_columns OWNER TO orientlimraerp_karim;

--
-- Name: install_companies_sales_bills_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.install_companies_sales_bills_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.install_companies_sales_bills_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: install_companies_sales_bills_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.install_companies_sales_bills_columns_id_seq OWNED BY public.install_companies_sales_bills_columns.id;


--
-- Name: install_companies_sales_bills_columns_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.install_companies_sales_bills_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Client" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.install_companies_sales_bills_columns_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: install_companies_sales_bills_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.install_companies_sales_bills_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.install_companies_sales_bills_columns_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: install_companies_sales_bills_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.install_companies_sales_bills_columns_sechdules_id_seq OWNED BY public.install_companies_sales_bills_columns_sechdules.id;


--
-- Name: installment_companies; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.installment_companies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Logo" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account" text,
    "NakdyaAccount" text
);


ALTER TABLE public.installment_companies OWNER TO orientlimraerp_karim;

--
-- Name: installment_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.installment_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installment_companies_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: installment_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.installment_companies_id_seq OWNED BY public.installment_companies.id;


--
-- Name: installment_companies_ratios; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.installment_companies_ratios (
    id bigint NOT NULL,
    "From" text,
    "To" text,
    "Service_Fee" text,
    "Company_Precent" text,
    "Company" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.installment_companies_ratios OWNER TO orientlimraerp_karim;

--
-- Name: installment_companies_ratios_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.installment_companies_ratios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installment_companies_ratios_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: installment_companies_ratios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.installment_companies_ratios_id_seq OWNED BY public.installment_companies_ratios.id;


--
-- Name: installment_dates; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.installment_dates (
    id bigint NOT NULL,
    "Date" text,
    "Value" text,
    "Status" text,
    "Client" bigint NOT NULL,
    "Install" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.installment_dates OWNER TO orientlimraerp_karim;

--
-- Name: installment_dates_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.installment_dates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installment_dates_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: installment_dates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.installment_dates_id_seq OWNED BY public.installment_dates.id;


--
-- Name: installments; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.installments (
    id bigint NOT NULL,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Residual" text,
    "Status" text,
    "Client" bigint NOT NULL,
    "Sales" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.installments OWNER TO orientlimraerp_karim;

--
-- Name: installments_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.installments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.installments_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: installments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.installments_id_seq OWNED BY public.installments.id;


--
-- Name: insurance_companies; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.insurance_companies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.insurance_companies OWNER TO orientlimraerp_karim;

--
-- Name: insurance_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.insurance_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.insurance_companies_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: insurance_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.insurance_companies_id_seq OWNED BY public.insurance_companies.id;


--
-- Name: insurance_papers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.insurance_papers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Due_Date" text NOT NULL,
    "Amount" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Account" bigint NOT NULL,
    "Bank" bigint,
    arr bigint,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From" text,
    "To" text,
    "File" text,
    "FromEn" text,
    "ToEn" text,
    "Delete" text
);


ALTER TABLE public.insurance_papers OWNER TO orientlimraerp_karim;

--
-- Name: insurance_papers_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.insurance_papers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.insurance_papers_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: insurance_papers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.insurance_papers_arr_seq OWNED BY public.insurance_papers."Code";


--
-- Name: insurance_papers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.insurance_papers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.insurance_papers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: insurance_papers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.insurance_papers_id_seq OWNED BY public.insurance_papers.id;


--
-- Name: interviews; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.interviews (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Time" text NOT NULL,
    "Status" text DEFAULT '0'::text NOT NULL,
    "Rate" text DEFAULT '0'::text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Client" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "StatusNote" text
);


ALTER TABLE public.interviews OWNER TO orientlimraerp_karim;

--
-- Name: interviews_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.interviews_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interviews_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: interviews_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.interviews_arr_seq OWNED BY public.interviews.arr;


--
-- Name: interviews_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.interviews_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interviews_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: interviews_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.interviews_id_seq OWNED BY public.interviews.id;


--
-- Name: interviews_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.interviews_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.interviews_types OWNER TO orientlimraerp_karim;

--
-- Name: interviews_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.interviews_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interviews_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: interviews_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.interviews_types_id_seq OWNED BY public.interviews_types.id;


--
-- Name: intros; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.intros (
    id bigint NOT NULL,
    "Arabic_About" text,
    "English_About" text,
    "Phone_1" text,
    "Phone_2" text,
    "Phone_3" text,
    "Phone_4" text,
    "Arabic_Terms" text,
    "English_Terms" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Arabic_Privacy" text,
    "English_Privacy" text
);


ALTER TABLE public.intros OWNER TO orientlimraerp_karim;

--
-- Name: intros_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.intros_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.intros_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: intros_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.intros_id_seq OWNED BY public.intros.id;


--
-- Name: inventories; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.inventories (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Dificit" text NOT NULL,
    "Total_Excess" text NOT NULL,
    "Total_Dificit_Price" text NOT NULL,
    "Total_Excess_Price" text NOT NULL,
    "Account_Excess" bigint NOT NULL,
    "Account_Dificit" bigint NOT NULL,
    "Store" bigint,
    "Coin" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "Settle" character varying DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.inventories OWNER TO orientlimraerp_karim;

--
-- Name: inventories_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.inventories_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.inventories_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: inventories_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.inventories_arr_seq OWNED BY public.inventories.arr;


--
-- Name: inventories_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.inventories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.inventories_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: inventories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.inventories_id_seq OWNED BY public.inventories.id;


--
-- Name: investors; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.investors (
    id bigint NOT NULL,
    "Date" text,
    "Name" text,
    "Investment_Value" text,
    "Safe" text,
    "Draw" text,
    "Coin" text,
    "Profit_Precent" text,
    "Investment_Period" text,
    "Liquidation_Time" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "End_Date" text,
    "Account" text,
    "Due_Account" text,
    "Expenses_Account" text
);


ALTER TABLE public.investors OWNER TO orientlimraerp_karim;

--
-- Name: investors_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.investors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.investors_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: investors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.investors_id_seq OWNED BY public.investors.id;


--
-- Name: issues; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.issues (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Time" text,
    "Client" text,
    "Link" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.issues OWNER TO orientlimraerp_karim;

--
-- Name: issues_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.issues_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.issues_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: issues_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.issues_id_seq OWNED BY public.issues.id;


--
-- Name: items_groups; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.items_groups (
    id bigint NOT NULL,
    "Code" text,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Parent" text NOT NULL,
    "Note" text,
    "Image" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Discount" text,
    "Store_Show" text,
    "Sales_Show" text,
    "NameEn" text,
    "Printer" text,
    "Arrange" bigint,
    "Sales_Precet" text DEFAULT 0
);


ALTER TABLE public.items_groups OWNER TO orientlimraerp_karim;

--
-- Name: items_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.items_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.items_groups_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: items_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.items_groups_id_seq OWNED BY public.items_groups.id;


--
-- Name: itineraries; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.itineraries (
    id bigint NOT NULL,
    "Emp" text,
    "Day" text,
    "Time" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.itineraries OWNER TO orientlimraerp_karim;

--
-- Name: itineraries_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.itineraries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itineraries_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: itineraries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.itineraries_id_seq OWNED BY public.itineraries.id;


--
-- Name: itinerary_visits; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.itinerary_visits (
    id bigint NOT NULL,
    "Emp" text,
    "Date" text,
    "Day" text,
    "Time" text,
    "Status" text,
    "Note" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.itinerary_visits OWNER TO orientlimraerp_karim;

--
-- Name: itinerary_visits_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.itinerary_visits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_visits_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: itinerary_visits_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.itinerary_visits_id_seq OWNED BY public.itinerary_visits.id;


--
-- Name: job_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.job_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "ShipStatus" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Later_Due" text,
    "Later_Collection" text,
    "TaxBill" text,
    "TaxCode" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "DiscountTax" text,
    "RecivedDate" text,
    "Recipient" text,
    "RecivedVoucherCode" text,
    "TransferOrder" text,
    "ExecuteOrder" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "Current_Credit" text,
    "Execute" text
);


ALTER TABLE public.job_orders OWNER TO orientlimraerp_karim;

--
-- Name: job_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.job_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_orders_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: job_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.job_orders_arr_seq OWNED BY public.job_orders."Code";


--
-- Name: job_orders_executors; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.job_orders_executors (
    id bigint NOT NULL,
    "Product" text,
    "Executor" text,
    "Order" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.job_orders_executors OWNER TO orientlimraerp_karim;

--
-- Name: job_orders_executors_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.job_orders_executors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_orders_executors_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: job_orders_executors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.job_orders_executors_id_seq OWNED BY public.job_orders_executors.id;


--
-- Name: job_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.job_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.job_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: job_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.job_orders_id_seq OWNED BY public.job_orders.id;


--
-- Name: jobs_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.jobs_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.jobs_types OWNER TO orientlimraerp_karim;

--
-- Name: jobs_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.jobs_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.jobs_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: jobs_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.jobs_types_id_seq OWNED BY public.jobs_types.id;


--
-- Name: journalizing_details; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.journalizing_details (
    id bigint NOT NULL,
    "Debitor" text NOT NULL,
    "Creditor" text NOT NULL,
    "Account" bigint NOT NULL,
    "Joun_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Statement" text
);


ALTER TABLE public.journalizing_details OWNER TO orientlimraerp_karim;

--
-- Name: journalizing_details_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.journalizing_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journalizing_details_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: journalizing_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.journalizing_details_id_seq OWNED BY public.journalizing_details.id;


--
-- Name: journalizings; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.journalizings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Debaitor" character varying,
    "Total_Creditor" character varying,
    "Note" character varying,
    "Type" character varying,
    "Code_Type" text,
    "Branch" bigint,
    "Status" text,
    "TypeEn" text,
    arr bigint,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "Transfer" text
);


ALTER TABLE public.journalizings OWNER TO orientlimraerp_karim;

--
-- Name: journalizings_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.journalizings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journalizings_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: journalizings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.journalizings_arr_seq OWNED BY public.journalizings.arr;


--
-- Name: journalizings_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.journalizings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journalizings_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: journalizings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.journalizings_id_seq OWNED BY public.journalizings.id;


--
-- Name: languages; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.languages (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.languages OWNER TO orientlimraerp_karim;

--
-- Name: languages_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.languages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.languages_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: languages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.languages_id_seq OWNED BY public.languages.id;


--
-- Name: loan_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.loan_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.loan_types OWNER TO orientlimraerp_karim;

--
-- Name: loan_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.loan_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loan_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: loan_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.loan_types_id_seq OWNED BY public.loan_types.id;


--
-- Name: loans; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.loans (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Years_Number" text NOT NULL,
    "First_Date" text NOT NULL,
    "Install" text NOT NULL,
    "Install_Numbers" text NOT NULL,
    "Note" text,
    "Draw" text NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Emp" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.loans OWNER TO orientlimraerp_karim;

--
-- Name: loans_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.loans_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loans_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: loans_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.loans_arr_seq OWNED BY public.loans.arr;


--
-- Name: loans_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.loans_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loans_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: loans_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.loans_id_seq OWNED BY public.loans.id;


--
-- Name: login_sliders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.login_sliders (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.login_sliders OWNER TO orientlimraerp_karim;

--
-- Name: login_sliders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.login_sliders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.login_sliders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: login_sliders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.login_sliders_id_seq OWNED BY public.login_sliders.id;


--
-- Name: main_e_com_designs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.main_e_com_designs (
    id bigint NOT NULL,
    "Font_Type" text,
    "Pagination_BG_Color" text,
    "Pagination_Txt_Color" text,
    "Pagination_Active_BG_Color" text,
    "Pagination_Active_Txt_Color" text,
    "Body_BG_Type" text,
    "Body_BG_Image" text,
    "Body_BG_Color" text,
    "Sub_Page_BG_Color" text,
    "Breadcumb_BG_Color" text,
    "Breadcumb_Txt_Color" text,
    "Modal_BG_Color" text,
    "Modal_Txt_Color" text,
    "Modal_Button_BG_Color" text,
    "Modal_Button_Txt_Color" text,
    "Table_Header_BG_Color" text,
    "Table_Header_Txt_Color" text,
    "Table_Body_BG_Color" text,
    "Table_Body_Txt_Color" text,
    "Table_Button_BG_Color" text,
    "Table_Button_Txt_Color" text,
    "CopyRights_Txt_Color" text,
    "CopyRights_Klar_Txt_Color" text,
    "CopyRights_Klar_Hover_Txt_Color" text,
    "Preloader_BG_Color" text,
    "Preloader_Small_Circle_Color" text,
    "Preloader_Large_Circle_Color" text,
    "Footer_Title_Color" text,
    "Footer_Txt_Color" text,
    "Footer_Social_Color" text,
    "Footer_Social_Hover_BG_Color" text,
    "Footer_Social_Hover_Txt_Color" text,
    "Header_Top_BG_Color" text,
    "Header_Top_Txt_Color" text,
    "Header_Top_Txt_Hover_Color" text,
    "Header_Middle_BG_Color" text,
    "Header_Middle_Icon_Color" text,
    "Header_Middle_Icon_Hover_Color" text,
    "Header_SearchBar_BG_Color" text,
    "Header_SearchBar_Txt_Color" text,
    "Header_SearchBar_Icon_BG_Color" text,
    "Header_SearchBar_Icon_Txt_Color" text,
    "Header_SearchBar_Icon_Hover_BG_Color" text,
    "Header_SearchBar_Icon_Hover_Txt_Color" text,
    "Navbar_BG_Color" text,
    "Navbar_Txt_Color" text,
    "Navbar_Hover_BG_Color" text,
    "Navbar_Hover_Txt_Color" text,
    "Navbar_Category_BG_Color" text,
    "Navbar_Category_Txt_Color" text,
    "Navbar_Category_Box_BG_Color" text,
    "Navbar_Category_Box_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Footer_Social_BG_Color" text,
    "Footer_Txt_Hover_Color" text
);


ALTER TABLE public.main_e_com_designs OWNER TO orientlimraerp_karim;

--
-- Name: main_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.main_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.main_e_com_designs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: main_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.main_e_com_designs_id_seq OWNED BY public.main_e_com_designs.id;


--
-- Name: maintainc_bills; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.maintainc_bills (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Note" text,
    "Serial_Num" text,
    "Draw" text NOT NULL,
    "Company" bigint,
    "Device_Type" bigint,
    "Device_Case" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    "Recipt" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" bigint,
    "Total_Price_Errors" text,
    "Totaal" text,
    "Safe" bigint
);


ALTER TABLE public.maintainc_bills OWNER TO orientlimraerp_karim;

--
-- Name: maintainc_bills_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.maintainc_bills_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintainc_bills_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: maintainc_bills_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.maintainc_bills_arr_seq OWNED BY public.maintainc_bills.arr;


--
-- Name: maintainc_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.maintainc_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintainc_bills_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: maintainc_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.maintainc_bills_id_seq OWNED BY public.maintainc_bills.id;


--
-- Name: maintaince_colors; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.maintaince_colors (
    id bigint NOT NULL,
    "Refuse" text,
    "Reported_Client" text,
    "Refused_Client" text,
    "Edited" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.maintaince_colors OWNER TO orientlimraerp_karim;

--
-- Name: maintaince_colors_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.maintaince_colors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintaince_colors_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: maintaince_colors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.maintaince_colors_id_seq OWNED BY public.maintaince_colors.id;


--
-- Name: maintaince_default_data; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.maintaince_default_data (
    id bigint NOT NULL,
    "Company" text,
    "Device_Type" text,
    "Device_Case" text,
    "Coin" text,
    "Cost_Center" text,
    "Draw" text,
    "Client" text,
    "Sure" text,
    "Eng" text,
    "Recipient" text,
    "Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.maintaince_default_data OWNER TO orientlimraerp_karim;

--
-- Name: maintaince_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.maintaince_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.maintaince_default_data_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: maintaince_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.maintaince_default_data_id_seq OWNED BY public.maintaince_default_data.id;


--
-- Name: manu_store_counts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.manu_store_counts (
    id bigint NOT NULL,
    "Store" text NOT NULL,
    "Total" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manu_store_counts OWNER TO orientlimraerp_karim;

--
-- Name: manu_store_counts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manu_store_counts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manu_store_counts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: manu_store_counts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manu_store_counts_id_seq OWNED BY public.manu_store_counts.id;


--
-- Name: manufacture_companies; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.manufacture_companies (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manufacture_companies OWNER TO orientlimraerp_karim;

--
-- Name: manufacture_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacture_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacture_companies_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacture_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacture_companies_id_seq OWNED BY public.manufacture_companies.id;


--
-- Name: manufacturing_default_data; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.manufacturing_default_data (
    id bigint NOT NULL,
    "Coin" text,
    "Draw" text,
    "Hall" text,
    "Manu_Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Executing_Qty" text
);


ALTER TABLE public.manufacturing_default_data OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_default_data_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_default_data_id_seq OWNED BY public.manufacturing_default_data.id;


--
-- Name: manufacturing_executions; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.manufacturing_executions (
    id bigint NOT NULL,
    "Code" text,
    "NewCode" text,
    "Date" text,
    "Manu_Order_Code" text,
    "Manu_Order_Date" text,
    "Recived_Date" text,
    "Manu_Request_Code" text,
    "Outcome_Name" text,
    "Outcome_Code" text,
    "Outcome_Qty" text,
    "Except_Qty" text,
    "Outcome_Unit" text,
    "Outcome_Store" text,
    "Patch_Number" text,
    "Manu_Order_ID" bigint,
    "Production_Manager" bigint,
    "Quality_Manager" bigint,
    "Model" bigint,
    "Note" text,
    "Status" text,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manufacturing_executions OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_executions_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_executions_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_executions_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_executions_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_executions_arr_seq OWNED BY public.manufacturing_executions.arr;


--
-- Name: manufacturing_executions_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_executions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_executions_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_executions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_executions_id_seq OWNED BY public.manufacturing_executions.id;


--
-- Name: manufacturing_halls; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.manufacturing_halls (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.manufacturing_halls OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_halls_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_halls_id_seq OWNED BY public.manufacturing_halls.id;


--
-- Name: manufacturing_models; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.manufacturing_models (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Name" text NOT NULL,
    "Time" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Hall" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text DEFAULT 1,
    "NameEn" text,
    "Incom_Store" text,
    "Outcom_Store" text,
    "Workmanship_Price" text
);


ALTER TABLE public.manufacturing_models OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_models_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_models_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_models_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_models_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_models_arr_seq OWNED BY public.manufacturing_models."Code";


--
-- Name: manufacturing_models_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_models_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_models_id_seq OWNED BY public.manufacturing_models.id;


--
-- Name: manufacturing_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.manufacturing_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Model" text,
    "Name_Outcome" text,
    "Except_Qty" text,
    "Total_Required_Qty" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text,
    "For_Client" text,
    "Client" bigint,
    "Client_Phone" text,
    "Client_Address" text,
    "Delegate" bigint,
    arr bigint,
    "Delegate_Phone" text,
    "Recived_Date" text,
    "Manufacture_Request_Code" bigint,
    "NewCode" text,
    "Recipient" text
);


ALTER TABLE public.manufacturing_orders OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_orders_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_orders_arr_seq OWNED BY public.manufacturing_orders.arr;


--
-- Name: manufacturing_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_orders_id_seq OWNED BY public.manufacturing_orders.id;


--
-- Name: manufacturing_requests; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.manufacturing_requests (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Recived_Date" text,
    "Client_Phone" text,
    "Client_Address" text,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Delegate_Phone" text,
    "Payment_Method" text,
    "Later_Due" text,
    "Note" text,
    "Status" text,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Store" bigint
);


ALTER TABLE public.manufacturing_requests OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_requests_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_requests_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_requests_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_requests_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_requests_arr_seq OWNED BY public.manufacturing_requests.arr;


--
-- Name: manufacturing_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_requests_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_requests_id_seq OWNED BY public.manufacturing_requests.id;


--
-- Name: manufacturing_secretariat_models; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.manufacturing_secretariat_models (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Name" text,
    "Time" text,
    "Draw" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Hall" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text,
    arr bigint,
    "Incom_Store" text DEFAULT 0,
    "Outcom_Store" text DEFAULT 0
);


ALTER TABLE public.manufacturing_secretariat_models OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_secretariat_models_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_secretariat_models_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_secretariat_models_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_secretariat_models_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_secretariat_models_arr_seq OWNED BY public.manufacturing_secretariat_models.arr;


--
-- Name: manufacturing_secretariat_models_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.manufacturing_secretariat_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.manufacturing_secretariat_models_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: manufacturing_secretariat_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.manufacturing_secretariat_models_id_seq OWNED BY public.manufacturing_secretariat_models.id;


--
-- Name: measuerments; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.measuerments (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Note" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "NameEn" text
);


ALTER TABLE public.measuerments OWNER TO orientlimraerp_karim;

--
-- Name: measuerments_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.measuerments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.measuerments_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: measuerments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.measuerments_id_seq OWNED BY public.measuerments.id;


--
-- Name: migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 2147483647
    CACHE 1;


ALTER TABLE public.migrations_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: migrations; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.migrations (
    id integer DEFAULT nextval('public.migrations_id_seq'::regclass) NOT NULL,
    migration character varying(191),
    batch integer
);


ALTER TABLE public.migrations OWNER TO orientlimraerp_karim;

--
-- Name: missions; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.missions (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Start_Date" text NOT NULL,
    "End_Date" text NOT NULL,
    "Duration" text NOT NULL,
    "Value" text NOT NULL,
    "Status" text NOT NULL,
    "File" text,
    "Desc" text,
    "Task_Owner" bigint,
    "Observer" bigint,
    "Project" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.missions OWNER TO orientlimraerp_karim;

--
-- Name: missions_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.missions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.missions_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: missions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.missions_id_seq OWNED BY public.missions.id;


--
-- Name: model_has_permissions; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.model_has_permissions (
    permission_id bigint NOT NULL,
    model_type character varying(191) NOT NULL,
    model_id bigint NOT NULL
);


ALTER TABLE public.model_has_permissions OWNER TO orientlimraerp_karim;

--
-- Name: model_has_roles; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.model_has_roles (
    role_id bigint NOT NULL,
    model_type character varying(191) NOT NULL,
    model_id bigint NOT NULL
);


ALTER TABLE public.model_has_roles OWNER TO orientlimraerp_karim;

--
-- Name: module_settings_nums; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.module_settings_nums (
    id bigint NOT NULL,
    "Branch_Select" text,
    "Branch_Num" text,
    "Store_Select" text,
    "Store_Num" text,
    "Users_Select" text,
    "Users_Num" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "System" text,
    "Expire_Date" text,
    "Type" text,
    "Price" text
);


ALTER TABLE public.module_settings_nums OWNER TO orientlimraerp_karim;

--
-- Name: module_settings_nums_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.module_settings_nums_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.module_settings_nums_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: module_settings_nums_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.module_settings_nums_id_seq OWNED BY public.module_settings_nums.id;


--
-- Name: modules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.modules (
    id bigint NOT NULL,
    "Capital" text,
    "Accounts" text,
    "Stores" text,
    "CRM" text,
    "HR" text,
    "Manufacturing" text,
    "Maintenance" text,
    "Secretariat" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Petrol" text,
    "ECommerce" text,
    "Shipping" text DEFAULT 0,
    "Bill_Electronic" text,
    "Hotels" text,
    "Resturant" text,
    "Traning_Center" text,
    "Translate" text
);


ALTER TABLE public.modules OWNER TO orientlimraerp_karim;

--
-- Name: modules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.modules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.modules_id_seq OWNED BY public.modules.id;


--
-- Name: more_products_halls; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.more_products_halls (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "SalesOrder" text,
    "Pro_Note" text,
    "KitchenEnd" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.more_products_halls OWNER TO orientlimraerp_karim;

--
-- Name: more_products_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.more_products_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.more_products_halls_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: more_products_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.more_products_halls_id_seq OWNED BY public.more_products_halls.id;


--
-- Name: most_sales_products_column_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.most_sales_products_column_sechdules (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total" text,
    "Store" text,
    "Date" text,
    "Unit" text,
    "Safe" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.most_sales_products_column_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: most_sales_products_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.most_sales_products_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.most_sales_products_column_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: most_sales_products_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.most_sales_products_column_sechdules_id_seq OWNED BY public.most_sales_products_column_sechdules.id;


--
-- Name: most_sales_products_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.most_sales_products_columns (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total" text,
    "Store" text,
    "Date" text,
    "Unit" text,
    "Safe" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.most_sales_products_columns OWNER TO orientlimraerp_karim;

--
-- Name: most_sales_products_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.most_sales_products_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.most_sales_products_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: most_sales_products_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.most_sales_products_columns_id_seq OWNED BY public.most_sales_products_columns.id;


--
-- Name: msg_rqsts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.msg_rqsts (
    id bigint NOT NULL,
    "Name" text,
    "Email" text,
    "Phone" text,
    "Subject" text,
    "Msg" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.msg_rqsts OWNER TO orientlimraerp_karim;

--
-- Name: msg_rqsts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.msg_rqsts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.msg_rqsts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: msg_rqsts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.msg_rqsts_id_seq OWNED BY public.msg_rqsts.id;


--
-- Name: my_follow_lists; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.my_follow_lists (
    id bigint NOT NULL,
    "Date" text,
    "Emp" text,
    "Day" text,
    "Status" text,
    "Client" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.my_follow_lists OWNER TO orientlimraerp_karim;

--
-- Name: my_follow_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.my_follow_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.my_follow_lists_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: my_follow_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.my_follow_lists_id_seq OWNED BY public.my_follow_lists.id;


--
-- Name: notifications; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.notifications (
    id bigint NOT NULL,
    "Date" text,
    "Status" text,
    "Noti_Ar_Name" text,
    "Noti_En_Name" text,
    "Type" text,
    "Type_Code" text,
    "Emp" text,
    "Client" text,
    "Product" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" text,
    "Safe" text,
    "TypeEn" text
);


ALTER TABLE public.notifications OWNER TO orientlimraerp_karim;

--
-- Name: notifications_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.notifications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.notifications_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: notifications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.notifications_id_seq OWNED BY public.notifications.id;


--
-- Name: opening_entries; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.opening_entries (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Debaitor" text NOT NULL,
    "Total_Creditor" text NOT NULL,
    "Note" text,
    "Capital" text NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "SecAccount" bigint,
    "Status" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text
);


ALTER TABLE public.opening_entries OWNER TO orientlimraerp_karim;

--
-- Name: opening_entries_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.opening_entries_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opening_entries_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: opening_entries_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.opening_entries_arr_seq OWNED BY public.opening_entries.arr;


--
-- Name: opening_entries_details; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.opening_entries_details (
    id bigint NOT NULL,
    "Debitor" text NOT NULL,
    "Creditor" text NOT NULL,
    "Statement" text,
    "Account" bigint NOT NULL,
    "OP_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.opening_entries_details OWNER TO orientlimraerp_karim;

--
-- Name: opening_entries_details_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.opening_entries_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opening_entries_details_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: opening_entries_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.opening_entries_details_id_seq OWNED BY public.opening_entries_details.id;


--
-- Name: opening_entries_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.opening_entries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opening_entries_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: opening_entries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.opening_entries_id_seq OWNED BY public.opening_entries.id;


--
-- Name: order_pays; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.order_pays (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Responsible" text,
    "Account" text,
    "Amount" text,
    "Note" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.order_pays OWNER TO orientlimraerp_karim;

--
-- Name: order_pays_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.order_pays_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.order_pays_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: order_pays_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.order_pays_id_seq OWNED BY public.order_pays.id;


--
-- Name: outcom_manufacturing_models; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.outcom_manufacturing_models (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "Model" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Cost" text,
    "SmallQty" text,
    "SmallCode" text
);


ALTER TABLE public.outcom_manufacturing_models OWNER TO orientlimraerp_karim;

--
-- Name: outcom_manufacturing_models_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.outcom_manufacturing_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.outcom_manufacturing_models_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: outcom_manufacturing_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.outcom_manufacturing_models_id_seq OWNED BY public.outcom_manufacturing_models.id;


--
-- Name: outcome_manufacturing_secretariat_models; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.outcome_manufacturing_secretariat_models (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "SmallQty" text,
    "SmallCode" text,
    "Store" text,
    "Product" text,
    "Unit" text,
    "Model" text,
    "Cost" text,
    "Workmanship_Price" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.outcome_manufacturing_secretariat_models OWNER TO orientlimraerp_karim;

--
-- Name: outcome_manufacturing_secretariat_models_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.outcome_manufacturing_secretariat_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.outcome_manufacturing_secretariat_models_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: outcome_manufacturing_secretariat_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.outcome_manufacturing_secretariat_models_id_seq OWNED BY public.outcome_manufacturing_secretariat_models.id;


--
-- Name: over_times; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.over_times (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Hour" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.over_times OWNER TO orientlimraerp_karim;

--
-- Name: over_times_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.over_times_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.over_times_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: over_times_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.over_times_id_seq OWNED BY public.over_times.id;


--
-- Name: pack_prems; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.pack_prems (
    id bigint NOT NULL,
    package text,
    premission text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pack_prems OWNER TO orientlimraerp_karim;

--
-- Name: pack_prems_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.pack_prems_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pack_prems_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: pack_prems_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.pack_prems_id_seq OWNED BY public.pack_prems.id;


--
-- Name: packages; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.packages (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.packages OWNER TO orientlimraerp_karim;

--
-- Name: packages_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.packages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.packages_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: packages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.packages_id_seq OWNED BY public.packages.id;


--
-- Name: partners; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.partners (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Shares_Number" text NOT NULL,
    "Nominal_Value_of_Shares" text,
    "Actual_Share_Value" text,
    "Profits_Precentage" text,
    "Profits" text,
    "Withdraw_Profits" text,
    "Remaining_Profits" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Gary_Account" text,
    "Recent_Profit_Account" text,
    "Stage_Profit_Account" text,
    "First_Partner_Share" text,
    "Now_Partner_Share" text,
    "Capital_Increase_Rate" text,
    "Capital_Increase_Value" text,
    "Partnership_Ratio" text
);


ALTER TABLE public.partners OWNER TO orientlimraerp_karim;

--
-- Name: partners_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.partners_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.partners_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: partners_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.partners_id_seq OWNED BY public.partners.id;


--
-- Name: password_resets; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.password_resets (
    email character varying(191) NOT NULL,
    token character varying(191) NOT NULL,
    created_at timestamp(0) without time zone
);


ALTER TABLE public.password_resets OWNER TO orientlimraerp_karim;

--
-- Name: pay_profit_investors; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.pay_profit_investors (
    id bigint NOT NULL,
    "Date" text,
    "Profit" text,
    "Investor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pay_profit_investors OWNER TO orientlimraerp_karim;

--
-- Name: pay_profit_investors_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.pay_profit_investors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pay_profit_investors_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: pay_profit_investors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.pay_profit_investors_id_seq OWNED BY public.pay_profit_investors.id;


--
-- Name: pay_salaries; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.pay_salaries (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Salary" text NOT NULL,
    "Pre_Sales" text,
    "Pre_Execu" text,
    "Deduction" text NOT NULL,
    "Entitlement" text NOT NULL,
    "Borrow" text NOT NULL,
    "Overtime" text,
    "Attendence_Hours" text,
    "Attendence" text,
    "Loan" text,
    "Holidays" text,
    "Resduial_Salary" text,
    "Note" text,
    "Draw" text NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Emp" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Attendence_Discount" text,
    "Holiday_Discount" text,
    "Settlements" text,
    "Later_Sales_Bill" text,
    "Allowances" text,
    "Discounts" text,
    "ProducationPoints" text,
    "DiscountLate" text,
    "DiscountDeparture" text,
    "Shipping_Precent" text,
    "Delete" text DEFAULT 0
);


ALTER TABLE public.pay_salaries OWNER TO orientlimraerp_karim;

--
-- Name: pay_salaries_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.pay_salaries_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pay_salaries_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: pay_salaries_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.pay_salaries_arr_seq OWNED BY public.pay_salaries."Code";


--
-- Name: pay_salaries_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.pay_salaries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pay_salaries_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: pay_salaries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.pay_salaries_id_seq OWNED BY public.pay_salaries.id;


--
-- Name: payment_voucher_details; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.payment_voucher_details (
    id bigint NOT NULL,
    "Debitor" text NOT NULL,
    "Statement" text,
    "Account" bigint NOT NULL,
    "PV_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Time" text,
    "Cost_Center" text,
    "Coin" text,
    "User" text,
    "Branch" text,
    "Safe" text,
    "Bill_Num" text,
    "Order_Number" text
);


ALTER TABLE public.payment_voucher_details OWNER TO orientlimraerp_karim;

--
-- Name: payment_voucher_details_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.payment_voucher_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_voucher_details_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: payment_voucher_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.payment_voucher_details_id_seq OWNED BY public.payment_voucher_details.id;


--
-- Name: payment_vouchers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.payment_vouchers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Debaitor" text NOT NULL,
    "Note" text,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Safe" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Shift" text,
    "Store" text,
    "User" text,
    "Branch" text,
    "Status" text,
    "File" text,
    "Edit" text,
    "Edit_New_Code" text,
    "Delete" text,
    "Responsiple" text
);


ALTER TABLE public.payment_vouchers OWNER TO orientlimraerp_karim;

--
-- Name: payment_vouchers_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.payment_vouchers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_vouchers_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: payment_vouchers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.payment_vouchers_arr_seq OWNED BY public.payment_vouchers.arr;


--
-- Name: payment_vouchers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.payment_vouchers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payment_vouchers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: payment_vouchers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.payment_vouchers_id_seq OWNED BY public.payment_vouchers.id;


--
-- Name: permission_to_exchange_goods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.permission_to_exchange_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "To_Store" bigint,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.permission_to_exchange_goods OWNER TO orientlimraerp_karim;

--
-- Name: permission_to_exchange_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.permission_to_exchange_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_exchange_goods_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: permission_to_exchange_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.permission_to_exchange_goods_arr_seq OWNED BY public.permission_to_exchange_goods.arr;


--
-- Name: permission_to_exchange_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.permission_to_exchange_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_exchange_goods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: permission_to_exchange_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.permission_to_exchange_goods_id_seq OWNED BY public.permission_to_exchange_goods.id;


--
-- Name: permission_to_recived_goods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.permission_to_recived_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "To_Store" bigint,
    "Status" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.permission_to_recived_goods OWNER TO orientlimraerp_karim;

--
-- Name: permission_to_recived_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.permission_to_recived_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_recived_goods_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: permission_to_recived_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.permission_to_recived_goods_arr_seq OWNED BY public.permission_to_recived_goods.arr;


--
-- Name: permission_to_recived_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.permission_to_recived_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permission_to_recived_goods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: permission_to_recived_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.permission_to_recived_goods_id_seq OWNED BY public.permission_to_recived_goods.id;


--
-- Name: permissions; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.permissions (
    id bigint NOT NULL,
    name character varying(191) NOT NULL,
    guard_name character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Parent" text,
    "Main" text,
    "nameEn" text,
    "Package" text
);


ALTER TABLE public.permissions OWNER TO orientlimraerp_karim;

--
-- Name: permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permissions_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.permissions_id_seq OWNED BY public.permissions.id;


--
-- Name: places; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.places (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Ship_Price" text,
    "City" bigint,
    "Delivery" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "SearchCode" text
);


ALTER TABLE public.places OWNER TO orientlimraerp_karim;

--
-- Name: places_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.places_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.places_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: places_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.places_id_seq OWNED BY public.places.id;


--
-- Name: platforms; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.platforms (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.platforms OWNER TO orientlimraerp_karim;

--
-- Name: platforms_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.platforms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.platforms_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: platforms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.platforms_id_seq OWNED BY public.platforms.id;


--
-- Name: polices; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.polices (
    id bigint NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.polices OWNER TO orientlimraerp_karim;

--
-- Name: polices_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.polices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.polices_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: polices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.polices_id_seq OWNED BY public.polices.id;


--
-- Name: pro_details_imgs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.pro_details_imgs (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    "Arabic_Title" text NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Title" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pro_details_imgs OWNER TO orientlimraerp_karim;

--
-- Name: pro_details_imgs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.pro_details_imgs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pro_details_imgs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: pro_details_imgs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.pro_details_imgs_id_seq OWNED BY public.pro_details_imgs.id;


--
-- Name: pro_notes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.pro_notes (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.pro_notes OWNER TO orientlimraerp_karim;

--
-- Name: pro_notes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.pro_notes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pro_notes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: pro_notes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.pro_notes_id_seq OWNED BY public.pro_notes.id;


--
-- Name: product_details_e_com_designs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_details_e_com_designs (
    id bigint NOT NULL,
    "Title_Color" text,
    "Txt_Color" text,
    "Price_Color" text,
    "Rate_Color" text,
    "Select_BG_Color" text,
    "Select_Txt_Color" text,
    "Qty_BG_Color" text,
    "Qty_Txt_Color" text,
    "Qty_Input_BG_Color" text,
    "Qty_Input_Txt_Color" text,
    "Comment_Input_BG_Color" text,
    "Comment_Button_BG_Color" text,
    "Comment_Button_Txt_Color" text,
    "Comment_Button_BG_Hover_Color" text,
    "Comment_Button_Txt_Hover_Color" text,
    "Related_Title_BG_Color" text,
    "Related_Title_Txt_Color" text,
    "Related_Product_BG_Color" text,
    "Related_Product_Group_BG_Color" text,
    "Related_Product_Group_Txt_Color" text,
    "Related_Product_Group_Hover_BG_Color" text,
    "Related_Product_Group_Hover_Txt_Color" text,
    "Related_Product_Icon_BG_Color" text,
    "Related_Product_Icon_Txt_Color" text,
    "Related_Product_Icon_Hover_BG_Color" text,
    "Related_Product_Icon_Hover_Txt_Color" text,
    "Related_Product_Txt_Color" text,
    "Related_Product_Price_Color" text,
    "Related_Product_Hover_Price_Color" text,
    "Related_Product_Rate_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_details_e_com_designs OWNER TO orientlimraerp_karim;

--
-- Name: product_details_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_details_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_details_e_com_designs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_details_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_details_e_com_designs_id_seq OWNED BY public.product_details_e_com_designs.id;


--
-- Name: product_executing_receiving_secretariats; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_executing_receiving_secretariats (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Dep" text,
    "Price" text,
    "Workmanship_Price" text,
    "Total" text,
    "StoreIn" text,
    "StoreOut" text,
    "Product" text,
    "Unit" text,
    "Executing" text,
    type text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_executing_receiving_secretariats OWNER TO orientlimraerp_karim;

--
-- Name: product_executing_receiving_secretariats_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_executing_receiving_secretariats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_executing_receiving_secretariats_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_executing_receiving_secretariats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_executing_receiving_secretariats_id_seq OWNED BY public.product_executing_receiving_secretariats.id;


--
-- Name: product_inventories; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_inventories (
    id bigint NOT NULL,
    "Av_Qty" text NOT NULL,
    "Inventory" text NOT NULL,
    "Deficit" text NOT NULL,
    "Excess" text NOT NULL,
    "Inv_ID" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "P_Code" text,
    "Price" text,
    "TotalExcessP" text,
    "TotalDificitP" text,
    "Exp_Date" text
);


ALTER TABLE public.product_inventories OWNER TO orientlimraerp_karim;

--
-- Name: product_inventories_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_inventories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_inventories_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_inventories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_inventories_id_seq OWNED BY public.product_inventories.id;


--
-- Name: product_job_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_job_orders (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Thickness" text,
    "Size" text,
    "Product" text,
    "Unit" text,
    "Order" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Executor" text
);


ALTER TABLE public.product_job_orders OWNER TO orientlimraerp_karim;

--
-- Name: product_job_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_job_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_job_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_job_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_job_orders_id_seq OWNED BY public.product_job_orders.id;


--
-- Name: product_maintainc_bills; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_maintainc_bills (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Maintaince" bigint NOT NULL,
    "TDiscount" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Date" text
);


ALTER TABLE public.product_maintainc_bills OWNER TO orientlimraerp_karim;

--
-- Name: product_maintainc_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_maintainc_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_maintainc_bills_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_maintainc_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_maintainc_bills_id_seq OWNED BY public.product_maintainc_bills.id;


--
-- Name: product_manufacturing_executions; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_manufacturing_executions (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Precent" text,
    "RequiredQty" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "ManuExecution" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Patch_Number" text
);


ALTER TABLE public.product_manufacturing_executions OWNER TO orientlimraerp_karim;

--
-- Name: product_manufacturing_executions_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_manufacturing_executions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_manufacturing_executions_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_manufacturing_executions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_manufacturing_executions_id_seq OWNED BY public.product_manufacturing_executions.id;


--
-- Name: product_moves; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_moves (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" bigint,
    "Group" bigint,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "QTY" text,
    "Brand" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    "Delegate" text,
    "Payment_Method" text,
    "Safe" bigint,
    "TypeEn" text,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text
);


ALTER TABLE public.product_moves OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_moves_columns (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_columns OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_moves_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_moves_columns_id_seq OWNED BY public.product_moves_columns.id;


--
-- Name: product_moves_columns_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_moves_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Credit" text,
    "Group" text,
    "Brand" text,
    "Store" text,
    "User" text,
    "Safe" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_columns_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_moves_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_columns_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_moves_columns_sechdules_id_seq OWNED BY public.product_moves_columns_sechdules.id;


--
-- Name: product_moves_filter_twos; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_moves_filter_twos (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_filter_twos OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_moves_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_filter_twos_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_moves_filter_twos_id_seq OWNED BY public.product_moves_filter_twos.id;


--
-- Name: product_moves_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_moves_filters (
    id bigint NOT NULL,
    "Date" text,
    "Type" text,
    "Bill_Num" text,
    "Incom" text,
    "Outcom" text,
    "Current" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "Unit" text,
    "Group" text,
    "Store" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "User" text,
    "CostIn" text,
    "CostOut" text,
    "CostCurrent" text,
    "CostOneIn" text,
    "CostOneOut" text,
    "CostOneCurrent" text,
    "QTY" text,
    "Brand" text,
    "Safe" text,
    "Branch" text,
    "SalePrice" text,
    "ProductPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_moves_filters OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_moves_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_moves_filters_id_seq OWNED BY public.product_moves_filters.id;


--
-- Name: product_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_moves_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_moves_id_seq OWNED BY public.product_moves.id;


--
-- Name: product_quote_images; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_quote_images (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "QuoteImage" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "TDiscount" text,
    "Original_Qty" text,
    "AvQty" text,
    "Store" text,
    "Exp_Date" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "CostPrice" text,
    "Date" text,
    "Patch_Number" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Net" text
);


ALTER TABLE public.product_quote_images OWNER TO orientlimraerp_karim;

--
-- Name: product_quote_images_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_quote_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_quote_images_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_quote_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_quote_images_id_seq OWNED BY public.product_quote_images.id;


--
-- Name: product_return_without_bills; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_return_without_bills (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "SmallCode" text,
    "Qty" text,
    "SmallQty" text,
    "Price" text,
    "Cost" text,
    "Discount" text,
    "TDiscount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Total_Cost" text,
    "Store" text,
    "Product" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Bill" text,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Coin" text,
    "User" text,
    "Cost_Center" text,
    "Type" text,
    "Payment_Method" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_return_without_bills OWNER TO orientlimraerp_karim;

--
-- Name: product_return_without_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_return_without_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_return_without_bills_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_return_without_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_return_without_bills_id_seq OWNED BY public.product_return_without_bills.id;


--
-- Name: product_sales; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_sales (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Sales" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Code" text,
    "Delegate" bigint,
    "Client" bigint,
    "Executor" bigint,
    "Refernce_Number" text,
    "Type" text,
    "Cost_Center" bigint,
    "User" bigint,
    "Coin" bigint,
    "Safe" bigint,
    "Ship" bigint,
    "Patch_Number" text,
    "Later_Collection" text DEFAULT 1,
    "SmallQty" text,
    "SmallCode" text,
    "TDiscount" text,
    "CostPrice" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Status" text,
    "CustomerGroup" text,
    "Payment_Method" text,
    "CoinCode" text,
    "CoinRate" text,
    "CoinPrice" text,
    "AmountEGP" text,
    "SalesTotal" text,
    "DiscountAmount" text,
    "NetTotal" text,
    "TaxType" text,
    "TaxAmount" text,
    "TaxSubType" text,
    "TaxRate" text,
    "TotalBill" text,
    "TypeEn" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "Total_Net" text
);


ALTER TABLE public.product_sales OWNER TO orientlimraerp_karim;

--
-- Name: product_sales_gifts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_sales_gifts (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Total" text,
    "TotCost" text,
    "Store" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "Gift" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Product" text
);


ALTER TABLE public.product_sales_gifts OWNER TO orientlimraerp_karim;

--
-- Name: product_sales_gifts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_sales_gifts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_gifts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_sales_gifts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_sales_gifts_id_seq OWNED BY public.product_sales_gifts.id;


--
-- Name: product_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_sales_id_seq OWNED BY public.product_sales.id;


--
-- Name: product_sales_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_sales_orders (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "SalesOrder" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Patch_Number" text,
    "TDiscount" text,
    "CostPrice" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "Date" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Total_Net" text
);


ALTER TABLE public.product_sales_orders OWNER TO orientlimraerp_karim;

--
-- Name: product_sales_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_sales_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_sales_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_sales_orders_id_seq OWNED BY public.product_sales_orders.id;


--
-- Name: product_sales_subscribes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_sales_subscribes (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Product_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Price" text,
    "Total" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Subscribe" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sub_Date" text,
    "Sub_Type" text
);


ALTER TABLE public.product_sales_subscribes OWNER TO orientlimraerp_karim;

--
-- Name: product_sales_subscribes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_sales_subscribes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_sales_subscribes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_sales_subscribes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_sales_subscribes_id_seq OWNED BY public.product_sales_subscribes.id;


--
-- Name: product_settlements; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_settlements (
    id bigint NOT NULL,
    "Av_Qty" text NOT NULL,
    "Inventory" text NOT NULL,
    "Deficit" text NOT NULL,
    "Excess" text NOT NULL,
    "Set_ID" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "P_Code" text,
    "Price" text,
    "TotalDificitP" text,
    "TotalExcessP" text,
    "Store" bigint,
    "User" bigint,
    "Coin" bigint,
    "Date" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Exp_Date" text
);


ALTER TABLE public.product_settlements OWNER TO orientlimraerp_karim;

--
-- Name: product_settlements_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_settlements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_settlements_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_settlements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_settlements_id_seq OWNED BY public.product_settlements.id;


--
-- Name: product_type_defaults; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_type_defaults (
    id bigint NOT NULL,
    "Type" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.product_type_defaults OWNER TO orientlimraerp_karim;

--
-- Name: product_type_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_type_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_type_defaults_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_type_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_type_defaults_id_seq OWNED BY public.product_type_defaults.id;


--
-- Name: product_units; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.product_units (
    id bigint NOT NULL,
    "Rate" text NOT NULL,
    "Barcode" text NOT NULL,
    "Price" text NOT NULL,
    "Price_Two" text,
    "Price_Three" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Type" text,
    "Unit" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Def" character varying DEFAULT 0,
    "Brand" text,
    "Group" text
);


ALTER TABLE public.product_units OWNER TO orientlimraerp_karim;

--
-- Name: product_units_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.product_units_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.product_units_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: product_units_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.product_units_id_seq OWNED BY public.product_units.id;


--
-- Name: products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products (
    id bigint NOT NULL,
    "P_Type" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text,
    "Brand" bigint,
    "Group" bigint NOT NULL,
    "Image" text,
    "Minimum" text,
    "Maximum" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Weight" text,
    "Saller_Point" text,
    "Customer_Point" text,
    "Tax" bigint NOT NULL,
    "Validity" text,
    "Days_Notify" text,
    "Ar_Desc" text,
    "En_Desc" text,
    "Ar_Spec" text,
    "En_Spec" text,
    "Store_Show" text,
    "Store_Type" text,
    "Status" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Sub_Cost" character varying,
    subscribe_type bigint,
    "Cas_No" text,
    "HSN" text,
    "Uni_Code" text,
    "Image2" text,
    "Offer" text,
    "OfferPrice" text,
    rate text,
    "Code_Type" text,
    "World_Code" text,
    "Origin_Number" text,
    "Origin_Country" text,
    "SearchCode1" text,
    "SearchCode2" text,
    "Space" text,
    "Storage" text,
    "Processor" text,
    "Camera" text,
    "Screen" text,
    "OS" text,
    "Battery" text,
    "Warranty" text,
    "Color" text,
    "Category" text,
    "Model" text,
    "Guess_Price" text,
    "Arrange" bigint,
    "Added" text,
    "Offer_Start_Date" text,
    "Offer_End_Date" text,
    "English_Brief_Desc" text,
    "Arabic_Brief_Desc" text,
    "Show_Other_Store" text,
    "Calories" text,
    "Thickness" text,
    "Maximum_Sales_Qty" text,
    "Delete" text DEFAULT 0,
    "Cost_Price" text DEFAULT 0
);


ALTER TABLE public.products OWNER TO orientlimraerp_karim;

--
-- Name: products_consists; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_consists (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Consist" text,
    "Price" text,
    "Total" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Consist_ID" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Exp_Date" text
);


ALTER TABLE public.products_consists OWNER TO orientlimraerp_karim;

--
-- Name: products_consists_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_consists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_consists_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_consists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_consists_id_seq OWNED BY public.products_consists.id;


--
-- Name: products_executing_receivings; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_executing_receivings (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text NOT NULL,
    "P_En_Name" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Total" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "Unit" bigint,
    "Executing" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    type text,
    "Dep" text
);


ALTER TABLE public.products_executing_receivings OWNER TO orientlimraerp_karim;

--
-- Name: products_executing_receivings_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_executing_receivings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_executing_receivings_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_executing_receivings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_executing_receivings_id_seq OWNED BY public.products_executing_receivings.id;


--
-- Name: products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_id_seq OWNED BY public.products.id;


--
-- Name: products_manufacturing_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_manufacturing_orders (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Store_Qty" text,
    "Required_Qty" text,
    "Qty" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "ManuOrder" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Precent" text
);


ALTER TABLE public.products_manufacturing_orders OWNER TO orientlimraerp_karim;

--
-- Name: products_manufacturing_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_manufacturing_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_manufacturing_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_manufacturing_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_manufacturing_orders_id_seq OWNED BY public.products_manufacturing_orders.id;


--
-- Name: products_manufacturing_requests; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_manufacturing_requests (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Request" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_manufacturing_requests OWNER TO orientlimraerp_karim;

--
-- Name: products_manufacturing_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_manufacturing_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_manufacturing_requests_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_manufacturing_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_manufacturing_requests_id_seq OWNED BY public.products_manufacturing_requests.id;


--
-- Name: products_permission_to_exchange_goods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_permission_to_exchange_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Date" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "To_Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Exchange" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CostPrice" text,
    "TDiscount" text,
    "Patch_Number" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "Total_Net" text
);


ALTER TABLE public.products_permission_to_exchange_goods OWNER TO orientlimraerp_karim;

--
-- Name: products_permission_to_exchange_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_permission_to_exchange_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_permission_to_exchange_goods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_permission_to_exchange_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_permission_to_exchange_goods_id_seq OWNED BY public.products_permission_to_exchange_goods.id;


--
-- Name: products_permission_to_recived_goods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_permission_to_recived_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Date" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Recived" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "To_Store" bigint,
    "TDiscount" text,
    "SmallCode" text,
    "SmallQty" text,
    "Total_Net" text
);


ALTER TABLE public.products_permission_to_recived_goods OWNER TO orientlimraerp_karim;

--
-- Name: products_permission_to_recived_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_permission_to_recived_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_permission_to_recived_goods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_permission_to_recived_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_permission_to_recived_goods_id_seq OWNED BY public.products_permission_to_recived_goods.id;


--
-- Name: products_purchase_petrols; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_purchase_petrols (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Store" bigint,
    "Product" bigint,
    "Unit" bigint,
    "Petrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "SmallCode" text,
    "SmallQty" text
);


ALTER TABLE public.products_purchase_petrols OWNER TO orientlimraerp_karim;

--
-- Name: products_purchase_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_purchase_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_purchase_petrols_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_purchase_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_purchase_petrols_id_seq OWNED BY public.products_purchase_petrols.id;


--
-- Name: products_purchases; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_purchases (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Purchase" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Coin" bigint,
    "User" bigint,
    "Cost_Center" bigint,
    "Type" text,
    "Ship" bigint,
    "SmallQty" text,
    "SmallCode" text,
    "TDiscount" text,
    "Payment_Method" text,
    "TypeEn" text,
    "Total_Net" text
);


ALTER TABLE public.products_purchases OWNER TO orientlimraerp_karim;

--
-- Name: products_purchases_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_purchases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_purchases_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_purchases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_purchases_id_seq OWNED BY public.products_purchases.id;


--
-- Name: products_purchases_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_purchases_orders (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "P_Order" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Tax" text,
    "Exp_Date" text,
    "Date" text,
    "Vendor" bigint,
    "TDiscount" text,
    "SmallCode" text,
    "SmallQty" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" text,
    "Delegate" text,
    "Coin" text,
    "User" text,
    "Cost_Center" text,
    "Type" text,
    "Ship" text,
    "Payment_Method" text,
    "Total_Net" text
);


ALTER TABLE public.products_purchases_orders OWNER TO orientlimraerp_karim;

--
-- Name: products_purchases_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_purchases_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_purchases_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_purchases_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_purchases_orders_id_seq OWNED BY public.products_purchases_orders.id;


--
-- Name: products_qties; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_qties (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Price" text,
    "Pro_Stores" bigint,
    "Store" bigint,
    "Unit" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Low_Unit" bigint,
    "Original" text,
    "Patch_Number" text,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text,
    "Exp_Date" text,
    "Price_Sale" text,
    "SearchCode1" text,
    "SearchCode2" text,
    "Group" text,
    "Brand" text,
    "Branch" text,
    "TotalCost" text,
    "Hold_Qty" text DEFAULT 0
);


ALTER TABLE public.products_qties OWNER TO orientlimraerp_karim;

--
-- Name: products_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_qties_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_qties_id_seq OWNED BY public.products_qties.id;


--
-- Name: products_quotes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_quotes (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "S_Quote" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Tax" text,
    "Exp_Date" text,
    "Patch_Number" text,
    "TDiscount" text,
    "Total_Wight" text,
    "UnitRate" text,
    weight text,
    "SalesProDesc" text,
    "TotCostNew" text,
    "SmallQty" text,
    "SmallCode" text,
    "CostPrice" text,
    "Date" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    "Pro_Note" text,
    "SubVID" text,
    "Total_Net" text
);


ALTER TABLE public.products_quotes OWNER TO orientlimraerp_karim;

--
-- Name: products_quotes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_quotes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_quotes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_quotes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_quotes_id_seq OWNED BY public.products_quotes.id;


--
-- Name: products_return_maintaince_bills; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_return_maintaince_bills (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text NOT NULL,
    "AvQty" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Discount" text NOT NULL,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Return" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Recived_Qty" text,
    "Out" text,
    "Date" text,
    "User" bigint,
    "Eng" bigint,
    "Brand" bigint,
    "Group" bigint,
    "Branch" bigint,
    "Recipient" bigint
);


ALTER TABLE public.products_return_maintaince_bills OWNER TO orientlimraerp_karim;

--
-- Name: products_return_maintaince_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_return_maintaince_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_return_maintaince_bills_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_return_maintaince_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_return_maintaince_bills_id_seq OWNED BY public.products_return_maintaince_bills.id;


--
-- Name: products_secretariat_export_goods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_secretariat_export_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Date" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Export" bigint,
    "Store" bigint NOT NULL,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "RecivedQty" text,
    "Impotence" text,
    "Price" text,
    "Total" text
);


ALTER TABLE public.products_secretariat_export_goods OWNER TO orientlimraerp_karim;

--
-- Name: products_secretariat_export_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_secretariat_export_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_secretariat_export_goods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_secretariat_export_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_secretariat_export_goods_id_seq OWNED BY public.products_secretariat_export_goods.id;


--
-- Name: products_secretariat_import_goods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_secretariat_import_goods (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Date" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Import" bigint,
    "Unit" bigint,
    "Store" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_secretariat_import_goods OWNER TO orientlimraerp_karim;

--
-- Name: products_secretariat_import_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_secretariat_import_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_secretariat_import_goods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_secretariat_import_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_secretariat_import_goods_id_seq OWNED BY public.products_secretariat_import_goods.id;


--
-- Name: products_shortcomings; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_shortcomings (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text NOT NULL,
    "Total_Bf_Tax" text NOT NULL,
    "Total" text NOT NULL,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Shortmings" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_Tax" text,
    "Exp_Date" text,
    "TDiscount" text,
    "Original_Qty" text,
    "SmallCode" text,
    "SmallQty" text,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Coin" text,
    "User" text,
    "Cost_Center" text,
    "Type" text,
    "Ship" text,
    "Payment_Method" text,
    "Total_Net" text
);


ALTER TABLE public.products_shortcomings OWNER TO orientlimraerp_karim;

--
-- Name: products_shortcomings_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_shortcomings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_shortcomings_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_shortcomings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_shortcomings_id_seq OWNED BY public.products_shortcomings.id;


--
-- Name: products_start_periods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_start_periods (
    id bigint NOT NULL,
    "P_Code" text NOT NULL,
    "Qty" text NOT NULL,
    "Price" text NOT NULL,
    "Total" text NOT NULL,
    "Old_Qty" text NOT NULL,
    "Exp_Date" text,
    "SP_ID" bigint,
    "Unit" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "User" bigint,
    "Store" bigint,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Patch_Number" text,
    "SmallQty" text,
    "SmallCode" text
);


ALTER TABLE public.products_start_periods OWNER TO orientlimraerp_karim;

--
-- Name: products_start_periods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_start_periods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_start_periods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_start_periods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_start_periods_id_seq OWNED BY public.products_start_periods.id;


--
-- Name: products_stores; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_stores (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "P_Code" text,
    "V_Name" text,
    "VV_Name" text,
    "Exp_Date" text,
    "Product" bigint,
    "Store" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_stores OWNER TO orientlimraerp_karim;

--
-- Name: products_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_stores_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_stores_id_seq OWNED BY public.products_stores.id;


--
-- Name: products_stores_transfers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_stores_transfers (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "P_Code" text,
    "Price" text,
    "Av_Qty" text,
    "Trans_Qty" text,
    "Total" text,
    "ST_ID" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "To_Store" text,
    "OldPrice" text,
    "SmallTrans_Qty" text,
    "SmallCode" text,
    "Original_Trans_Qty" text,
    "CostPrice" text,
    "Exp_Date" text
);


ALTER TABLE public.products_stores_transfers OWNER TO orientlimraerp_karim;

--
-- Name: products_stores_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_stores_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_stores_transfers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_stores_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_stores_transfers_id_seq OWNED BY public.products_stores_transfers.id;


--
-- Name: products_viras; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.products_viras (
    id bigint NOT NULL,
    "Cost" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.products_viras OWNER TO orientlimraerp_karim;

--
-- Name: products_viras_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.products_viras_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_viras_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: products_viras_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.products_viras_id_seq OWNED BY public.products_viras.id;


--
-- Name: profit_sales_product_column_sechdulrs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.profit_sales_product_column_sechdulrs (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Cost" text,
    "Profit" text,
    "Store" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.profit_sales_product_column_sechdulrs OWNER TO orientlimraerp_karim;

--
-- Name: profit_sales_product_column_sechdulrs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.profit_sales_product_column_sechdulrs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.profit_sales_product_column_sechdulrs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: profit_sales_product_column_sechdulrs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.profit_sales_product_column_sechdulrs_id_seq OWNED BY public.profit_sales_product_column_sechdulrs.id;


--
-- Name: profit_sales_product_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.profit_sales_product_columns (
    id bigint NOT NULL,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Cost" text,
    "Profit" text,
    "Store" text,
    "Branch" text,
    "Group" text,
    "Brand" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.profit_sales_product_columns OWNER TO orientlimraerp_karim;

--
-- Name: profit_sales_product_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.profit_sales_product_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.profit_sales_product_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: profit_sales_product_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.profit_sales_product_columns_id_seq OWNED BY public.profit_sales_product_columns.id;


--
-- Name: project_teams; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.project_teams (
    id bigint NOT NULL,
    "Member" bigint,
    "Project" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.project_teams OWNER TO orientlimraerp_karim;

--
-- Name: project_teams_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.project_teams_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.project_teams_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: project_teams_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.project_teams_id_seq OWNED BY public.project_teams.id;


--
-- Name: projects; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.projects (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Start_Date" text NOT NULL,
    "End_Date" text NOT NULL,
    "Duration" text NOT NULL,
    "Value" text NOT NULL,
    "File" text,
    "Client" bigint NOT NULL,
    "Manager" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "NameEn" text
);


ALTER TABLE public.projects OWNER TO orientlimraerp_karim;

--
-- Name: projects_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.projects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.projects_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: projects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.projects_id_seq OWNED BY public.projects.id;


--
-- Name: purch_bills_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.purch_bills_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.purch_bills_columns OWNER TO orientlimraerp_karim;

--
-- Name: purch_bills_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purch_bills_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: purch_bills_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purch_bills_columns_id_seq OWNED BY public.purch_bills_columns.id;


--
-- Name: purch_bills_columns_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.purch_bills_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.purch_bills_columns_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: purch_bills_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purch_bills_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_columns_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: purch_bills_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purch_bills_columns_sechdules_id_seq OWNED BY public.purch_bills_columns_sechdules.id;


--
-- Name: purch_bills_filter_twos; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.purch_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Later_Due" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purch_bills_filter_twos OWNER TO orientlimraerp_karim;

--
-- Name: purch_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purch_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_filter_twos_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: purch_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purch_bills_filter_twos_id_seq OWNED BY public.purch_bills_filter_twos.id;


--
-- Name: purch_bills_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.purch_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Later_Due" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purch_bills_filters OWNER TO orientlimraerp_karim;

--
-- Name: purch_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purch_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purch_bills_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: purch_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purch_bills_filters_id_seq OWNED BY public.purch_bills_filters.id;


--
-- Name: purchase_petrols; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.purchase_petrols (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Later_Due" text,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Draw" text,
    "Payment_Method" text,
    "Note" text,
    "File" text,
    "Car_Number" text,
    "Delivery_Method" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Pay" text,
    "Full" text,
    "Vendor" bigint,
    "Coin" bigint,
    "Safe" bigint,
    "CompanyCar" bigint,
    "Store" bigint,
    "Recipient" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Number" text
);


ALTER TABLE public.purchase_petrols OWNER TO orientlimraerp_karim;

--
-- Name: purchase_petrols_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purchase_petrols_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchase_petrols_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: purchase_petrols_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purchase_petrols_arr_seq OWNED BY public.purchase_petrols.arr;


--
-- Name: purchase_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purchase_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchase_petrols_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: purchase_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purchase_petrols_id_seq OWNED BY public.purchase_petrols.id;


--
-- Name: purchases; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.purchases (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "P_Order_Num" text,
    "Safe" bigint NOT NULL,
    "Vendor" bigint NOT NULL,
    "Delegate" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ship" bigint,
    "Check_Type" bigint,
    "Check_Number" text,
    "Due_Date" text,
    "ShipStatus" text DEFAULT 0,
    "Later_Due" text,
    "Sent" text,
    "TaxBill" text DEFAULT 0,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "File" text,
    "Current_Credit" text,
    "Residual" text,
    "Total_Net" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.purchases OWNER TO orientlimraerp_karim;

--
-- Name: purchases_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purchases_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: purchases_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purchases_arr_seq OWNED BY public.purchases.arr;


--
-- Name: purchases_default_data; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.purchases_default_data (
    id bigint NOT NULL,
    "Payment_Method" text,
    "Status" text,
    "V_and_C" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Brand" text,
    "Group" text,
    "English_Name" text,
    "Expire" text,
    "Empp" text,
    "Quality_Qty" text,
    "Discount" text,
    "Hide_Product" text,
    "Hide_Edit_Delete" text,
    "Duplicate_Items" text
);


ALTER TABLE public.purchases_default_data OWNER TO orientlimraerp_karim;

--
-- Name: purchases_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purchases_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_default_data_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: purchases_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purchases_default_data_id_seq OWNED BY public.purchases_default_data.id;


--
-- Name: purchases_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purchases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: purchases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purchases_id_seq OWNED BY public.purchases.id;


--
-- Name: purchases_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.purchases_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Payment_Method" text,
    "Status" text,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "P_Order_Num" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ToPurch" text DEFAULT 0,
    "Quality" text DEFAULT 0,
    "Quality_Note" text,
    "Quantity" text DEFAULT 0,
    "Quantity_Note" text,
    "Purchases_Date" text,
    "ShipStatus" text,
    "Ship" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Later_Due" text,
    "Sent" text,
    "TaxBill" text,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "File" text,
    "Current_Credit" text,
    "Residual" text,
    "Total_Net" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.purchases_orders OWNER TO orientlimraerp_karim;

--
-- Name: purchases_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purchases_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_orders_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: purchases_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purchases_orders_arr_seq OWNED BY public.purchases_orders.arr;


--
-- Name: purchases_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purchases_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purchases_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: purchases_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purchases_orders_id_seq OWNED BY public.purchases_orders.id;


--
-- Name: purpose_travel; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.purpose_travel (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.purpose_travel OWNER TO orientlimraerp_karim;

--
-- Name: purpose_travel_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.purpose_travel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.purpose_travel_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: purpose_travel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.purpose_travel_id_seq OWNED BY public.purpose_travel.id;


--
-- Name: q_r_s; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.q_r_s (
    id bigint NOT NULL,
    "QR" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.q_r_s OWNER TO orientlimraerp_karim;

--
-- Name: q_r_s_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.q_r_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.q_r_s_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: q_r_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.q_r_s_id_seq OWNED BY public.q_r_s.id;


--
-- Name: qualities; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.qualities (
    id bigint NOT NULL,
    "Code" text,
    "Execution_Code" text,
    "Date" text,
    "Outcome_Name" text,
    "Outcome_Code" text,
    "Outcome_Qty" text,
    "Except_Qty" text,
    "Outcome_Unit" text,
    "Outcome_Store" text,
    "Production_Manager" bigint,
    "Quality_Manager" bigint,
    "ManuExecution" bigint NOT NULL,
    "Note" text,
    "Status" text,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.qualities OWNER TO orientlimraerp_karim;

--
-- Name: qualities_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.qualities_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.qualities_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: qualities_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.qualities_arr_seq OWNED BY public.qualities.arr;


--
-- Name: qualities_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.qualities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.qualities_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: qualities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.qualities_id_seq OWNED BY public.qualities.id;


--
-- Name: quality_details; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.quality_details (
    id bigint NOT NULL,
    "Exmine_Type" text,
    "Exmine_Unit" text,
    "Exmine_Allow_From" text,
    "Exmine_Allow_To" text,
    "Result" text,
    "Accept" text,
    "Exmine" bigint,
    "Quality" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.quality_details OWNER TO orientlimraerp_karim;

--
-- Name: quality_details_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.quality_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quality_details_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: quality_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.quality_details_id_seq OWNED BY public.quality_details.id;


--
-- Name: quote_images; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.quote_images (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Client" text NOT NULL,
    "User" text NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pay" text,
    "Safe" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Later_Due" text,
    "Sale_Date" text,
    "Total_Wight_Bill" text,
    "ToSales" text,
    "Shipping" text,
    "Delivery_Status" text,
    "Order_Type" text,
    "ProfitPrecent" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "TaxBill" text,
    "TaxCode" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Shift_Code" text,
    "Client_Address" text,
    "Delivery" text,
    "ProfitTax" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "File" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "Total_Net" text,
    "Residual" text,
    "Current_Credit" text,
    "DiscountTax" text,
    "Draw" text,
    "Status" text,
    "Refernce_Number" text,
    "Ship" text,
    "DiscountBill" text DEFAULT 0,
    "Client_Accept" text DEFAULT 0,
    "Done" text DEFAULT 0,
    "EMP_Quote" text
);


ALTER TABLE public.quote_images OWNER TO orientlimraerp_karim;

--
-- Name: quote_images_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.quote_images_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quote_images_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: quote_images_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.quote_images_arr_seq OWNED BY public.quote_images.arr;


--
-- Name: quote_images_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.quote_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quote_images_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: quote_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.quote_images_id_seq OWNED BY public.quote_images.id;


--
-- Name: quotes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.quotes (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" bigint NOT NULL,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Executor" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Later_Due" text,
    "Sale_Date" text,
    "Total_Wight_Bill" text,
    "ToSales" text,
    "Shipping" text,
    "Delivery_Status" text,
    "Order_Type" text,
    "ProfitPrecent" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "TaxBill" text,
    "TaxCode" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Shift_Code" text,
    "Client_Address" text,
    "Delivery" text,
    "ProfitTax" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "File" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "Total_Net" text,
    "Residual" text,
    "Current_Credit" text,
    "DiscountTax" text,
    "Ship" text,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.quotes OWNER TO orientlimraerp_karim;

--
-- Name: quotes_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.quotes_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotes_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: quotes_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.quotes_arr_seq OWNED BY public.quotes.arr;


--
-- Name: quotes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.quotes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: quotes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.quotes_id_seq OWNED BY public.quotes.id;


--
-- Name: rabih_education; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.rabih_education (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Video" text,
    "Package" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rabih_education OWNER TO orientlimraerp_karim;

--
-- Name: rabih_education_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.rabih_education_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rabih_education_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: rabih_education_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.rabih_education_id_seq OWNED BY public.rabih_education.id;


--
-- Name: rates; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.rates (
    id bigint NOT NULL,
    "Rate" text NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rates OWNER TO orientlimraerp_karim;

--
-- Name: rates_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.rates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rates_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: rates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.rates_id_seq OWNED BY public.rates.id;


--
-- Name: reasons; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.reasons (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.reasons OWNER TO orientlimraerp_karim;

--
-- Name: reasons_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reasons_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reasons_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: reasons_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reasons_id_seq OWNED BY public.reasons.id;


--
-- Name: recipt_maintaince_errors; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recipt_maintaince_errors (
    id bigint NOT NULL,
    "Recipt" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Error" bigint NOT NULL,
    "Recived" text DEFAULT 0,
    "Eng" text DEFAULT 0
);


ALTER TABLE public.recipt_maintaince_errors OWNER TO orientlimraerp_karim;

--
-- Name: recipt_maintaince_errors_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recipt_maintaince_errors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_maintaince_errors_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recipt_maintaince_errors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recipt_maintaince_errors_id_seq OWNED BY public.recipt_maintaince_errors.id;


--
-- Name: recipt_maintainces; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recipt_maintainces (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Serial_Num" text,
    "Total" text NOT NULL,
    "Draw" text NOT NULL,
    "Company" bigint,
    "Device_Type" bigint,
    "Device_Case" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "Pattern_Image" text,
    "Time" text,
    "Password" text,
    "Pay" text,
    "Eng_Note" text,
    "Reason" text,
    "Report_Client" text,
    "Work" text,
    "Store" bigint,
    "Eng" bigint,
    "Recipient" bigint,
    "Branch" bigint,
    "Payment_Method" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_Bf_Taxes" text,
    "Total_Taxes" text,
    "RefuseReason" text,
    "NoteRecived" text,
    "Returned" text DEFAULT 0,
    "CustomerGroup" text,
    "Total_Cost" text
);


ALTER TABLE public.recipt_maintainces OWNER TO orientlimraerp_karim;

--
-- Name: recipt_maintainces_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recipt_maintainces_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_maintainces_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: recipt_maintainces_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recipt_maintainces_arr_seq OWNED BY public.recipt_maintainces.arr;


--
-- Name: recipt_maintainces_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recipt_maintainces_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_maintainces_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recipt_maintainces_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recipt_maintainces_id_seq OWNED BY public.recipt_maintainces.id;


--
-- Name: recipt_voucher_details; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recipt_voucher_details (
    id bigint NOT NULL,
    "Creditor" text NOT NULL,
    "Statement" text,
    "Account" bigint NOT NULL,
    "RV_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Bill_Num" text
);


ALTER TABLE public.recipt_voucher_details OWNER TO orientlimraerp_karim;

--
-- Name: recipt_voucher_details_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recipt_voucher_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_voucher_details_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recipt_voucher_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recipt_voucher_details_id_seq OWNED BY public.recipt_voucher_details.id;


--
-- Name: recipt_vouchers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recipt_vouchers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Creditor" text NOT NULL,
    "Note" text,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "Safe" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" text,
    "Shift" text,
    "User" text,
    "Status" text,
    "File" text,
    "Collector" text,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    "Sales_Bill" text
);


ALTER TABLE public.recipt_vouchers OWNER TO orientlimraerp_karim;

--
-- Name: recipt_vouchers_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recipt_vouchers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_vouchers_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: recipt_vouchers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recipt_vouchers_arr_seq OWNED BY public.recipt_vouchers."Code";


--
-- Name: recipt_vouchers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recipt_vouchers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipt_vouchers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recipt_vouchers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recipt_vouchers_id_seq OWNED BY public.recipt_vouchers.id;


--
-- Name: recipts_sales_petrols; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recipts_sales_petrols (
    id bigint NOT NULL,
    "Recipt_Amount" text NOT NULL,
    "Recipt" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.recipts_sales_petrols OWNER TO orientlimraerp_karim;

--
-- Name: recipts_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recipts_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipts_sales_petrols_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recipts_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recipts_sales_petrols_id_seq OWNED BY public.recipts_sales_petrols.id;


--
-- Name: recipts_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recipts_types (
    id bigint NOT NULL,
    "Name" text,
    "Account" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.recipts_types OWNER TO orientlimraerp_karim;

--
-- Name: recipts_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recipts_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recipts_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recipts_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recipts_types_id_seq OWNED BY public.recipts_types.id;


--
-- Name: recived_purch_products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recived_purch_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Recived_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Recived" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.recived_purch_products OWNER TO orientlimraerp_karim;

--
-- Name: recived_purch_products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recived_purch_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_purch_products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recived_purch_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recived_purch_products_id_seq OWNED BY public.recived_purch_products.id;


--
-- Name: recived_purchts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recived_purchts (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Trans_Qty" text NOT NULL,
    "Total_Trans_Value" text NOT NULL,
    "Purchase" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "User" bigint,
    arr bigint
);


ALTER TABLE public.recived_purchts OWNER TO orientlimraerp_karim;

--
-- Name: recived_purchts_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recived_purchts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_purchts_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: recived_purchts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recived_purchts_arr_seq OWNED BY public.recived_purchts.arr;


--
-- Name: recived_purchts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recived_purchts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_purchts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recived_purchts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recived_purchts_id_seq OWNED BY public.recived_purchts.id;


--
-- Name: recived_sales; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recived_sales (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Trans_Qty" text NOT NULL,
    "Total_Trans_Value" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Sales" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "User" bigint
);


ALTER TABLE public.recived_sales OWNER TO orientlimraerp_karim;

--
-- Name: recived_sales_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recived_sales_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_sales_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: recived_sales_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recived_sales_arr_seq OWNED BY public.recived_sales.arr;


--
-- Name: recived_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recived_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_sales_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recived_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recived_sales_id_seq OWNED BY public.recived_sales.id;


--
-- Name: recived_sales_products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.recived_sales_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Recived_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Recived" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.recived_sales_products OWNER TO orientlimraerp_karim;

--
-- Name: recived_sales_products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.recived_sales_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.recived_sales_products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: recived_sales_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.recived_sales_products_id_seq OWNED BY public.recived_sales_products.id;


--
-- Name: reg_courses; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.reg_courses (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Hall" text,
    "Reserve_Course" text,
    "Teacher" text,
    "Teacher_Attend" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Teacher_Attend_From" text,
    "Teacher_Attend_To" text,
    "Teacher_Time" text
);


ALTER TABLE public.reg_courses OWNER TO orientlimraerp_karim;

--
-- Name: reg_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reg_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_courses_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: reg_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reg_courses_id_seq OWNED BY public.reg_courses.id;


--
-- Name: reg_courses_students; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.reg_courses_students (
    id bigint NOT NULL,
    "Student" text,
    "Attend" text,
    "Date" text,
    "Reg" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.reg_courses_students OWNER TO orientlimraerp_karim;

--
-- Name: reg_courses_students_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reg_courses_students_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_courses_students_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: reg_courses_students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reg_courses_students_id_seq OWNED BY public.reg_courses_students.id;


--
-- Name: reg_over_times; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.reg_over_times (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Month" text NOT NULL,
    "Amount" text NOT NULL,
    "Hours_Number" text NOT NULL,
    "Hour_Rate" text NOT NULL,
    "Total_Hours" text NOT NULL,
    "Hour_Cost" text NOT NULL,
    "Note" text,
    "Emp" bigint,
    "Type" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.reg_over_times OWNER TO orientlimraerp_karim;

--
-- Name: reg_over_times_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reg_over_times_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_over_times_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: reg_over_times_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reg_over_times_arr_seq OWNED BY public.reg_over_times.arr;


--
-- Name: reg_over_times_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reg_over_times_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reg_over_times_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: reg_over_times_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reg_over_times_id_seq OWNED BY public.reg_over_times.id;


--
-- Name: remove_products_halls; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.remove_products_halls (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "CostPrice" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total_Tax" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Exp_Date" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "SalesOrder" text,
    "Pro_Note" text,
    "KitchenEnd" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.remove_products_halls OWNER TO orientlimraerp_karim;

--
-- Name: remove_products_halls_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.remove_products_halls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.remove_products_halls_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: remove_products_halls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.remove_products_halls_id_seq OWNED BY public.remove_products_halls.id;


--
-- Name: reports_settings; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.reports_settings (
    id bigint NOT NULL,
    "Product_Info" text,
    "Product_Order_Limit" text,
    "ReportStartPeriodProducts" text,
    "SettlementsReports" text,
    "StoresCost" text,
    "StoresInventory" text,
    "Collection_Delegates" text,
    "Sales_Delegates" text,
    "StagnantItems" text,
    "ItemsMoves" text,
    "StoresBalancesTwo" text,
    "NetPurchases" text,
    "NetSales" text,
    "ClientSales" text,
    "ExecutorSales" text,
    "InstallmentReport" text,
    "ExpiredProucts" text,
    "StoresSalesDetails" text,
    "TotalNetPurchases" text,
    "TotalNetSales" text,
    "Profits" text,
    "Shifts" text,
    "Shifts_Details" text,
    "DailyClosing" text,
    "Products" text,
    "DailyShifts" text,
    "ExpensesReport" text,
    "DailyProducts" text,
    "EmployeeCommissionDiscounts" text,
    "VendorPricesReport" text,
    "DailyMoves" text,
    "GroupsSales" text,
    "VendorPurchases" text,
    "ExceptProfits" text,
    "DelegateSalesDetails" text,
    "CreditStores" text,
    "ProductProfits" text,
    "ExceptProductProfits" text,
    "SalesBills" text,
    "PurchasesBills" text,
    "StoresMovesReport" text,
    "StoresTransferReport" text,
    "SafesTransferReport" text,
    "CompareSalesPrice" text,
    "ProductMoveDetails" text,
    "MostSalesProducts" text,
    "ProfitSalesProduct" text,
    "ClientAccountStatement" text,
    "ClientsStatement" text,
    "VendorAccountStatement" text,
    "VendorsStatement" text,
    "EmpGoals" text,
    "InventorySerial" text,
    "TotalExpensesSafes" text,
    "SubIncomList" text,
    "ExpensesList" text,
    "StoresBalances" text,
    "StoresBalancesCat" text,
    "ItemCost" text,
    "StoresInventoryy" text,
    "DelegateSalesDetailss" text,
    "ProfitDelegateSalesDetails" text,
    "InstallmentCompaniesSales" text,
    "StoresCosts" text,
    "DailyClosingDetails" text,
    "SalesProsMoreDetails" text,
    "StagnantItemss" text,
    "SalesCustomersGroups" text,
    "BrandsSales" text,
    "Customer_Debts" text,
    "Vendor_Debts" text,
    "MaintanceSalesReport" text,
    "Maintenance_Tune" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ProfitGroupsReport" text,
    "IncomListReport" text,
    "AssemblyProQties" text
);


ALTER TABLE public.reports_settings OWNER TO orientlimraerp_karim;

--
-- Name: reports_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reports_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reports_settings_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: reports_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reports_settings_id_seq OWNED BY public.reports_settings.id;


--
-- Name: reservations; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.reservations (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "From" text,
    "To" text,
    "Amount" text,
    "Checkout" text,
    "Expire" text,
    "Draw" text,
    "Client" bigint,
    "Safe" bigint,
    "Coin" bigint,
    "Room" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "User" text,
    "Note" text
);


ALTER TABLE public.reservations OWNER TO orientlimraerp_karim;

--
-- Name: reservations_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reservations_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reservations_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: reservations_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reservations_arr_seq OWNED BY public.reservations.arr;


--
-- Name: reservations_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reservations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reservations_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: reservations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reservations_id_seq OWNED BY public.reservations.id;


--
-- Name: reserve_course_days; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.reserve_course_days (
    id bigint NOT NULL,
    "Day" text,
    "Reserve" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "From_Time" text,
    "To_Time" text
);


ALTER TABLE public.reserve_course_days OWNER TO orientlimraerp_karim;

--
-- Name: reserve_course_days_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reserve_course_days_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reserve_course_days_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: reserve_course_days_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reserve_course_days_id_seq OWNED BY public.reserve_course_days.id;


--
-- Name: reserve_course_students; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.reserve_course_students (
    id bigint NOT NULL,
    "Student" text,
    "Pay" text,
    "Cost" text,
    "Residual" text,
    "Constraint" text,
    "Reserve" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Dollar_Value" text
);


ALTER TABLE public.reserve_course_students OWNER TO orientlimraerp_karim;

--
-- Name: reserve_course_students_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reserve_course_students_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reserve_course_students_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: reserve_course_students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reserve_course_students_id_seq OWNED BY public.reserve_course_students.id;


--
-- Name: reserve_courses; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.reserve_courses (
    id bigint NOT NULL,
    "Code" text,
    "Course" text,
    "Start_Date" text,
    "End_Date" text,
    "Course_Type" text,
    "Teacher" text,
    "Required_Number" text,
    "Certificate" text,
    "Cost" text,
    "Total_Required" text,
    "Status" text,
    "Days" text,
    "Time" text,
    "Total_Paid" text,
    "Total_Num" text,
    "Total_Cost" text,
    "Safe" text,
    "Draw" text,
    "Coin" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Hall" text
);


ALTER TABLE public.reserve_courses OWNER TO orientlimraerp_karim;

--
-- Name: reserve_courses_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.reserve_courses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reserve_courses_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: reserve_courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.reserve_courses_id_seq OWNED BY public.reserve_courses.id;


--
-- Name: resignation_requests; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resignation_requests (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Resignation_Date" text,
    "File" text,
    "Emp" text,
    "Note" text,
    "Status" text,
    "Reason" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resignation_requests OWNER TO orientlimraerp_karim;

--
-- Name: resignation_requests_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resignation_requests_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resignation_requests_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: resignation_requests_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resignation_requests_arr_seq OWNED BY public.resignation_requests."Code";


--
-- Name: resignation_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resignation_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resignation_requests_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resignation_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resignation_requests_id_seq OWNED BY public.resignation_requests.id;


--
-- Name: resturant_abouts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_abouts (
    id bigint NOT NULL,
    "Image_1" text,
    "Image_2" text,
    "Title_Image" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_abouts OWNER TO orientlimraerp_karim;

--
-- Name: resturant_abouts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_abouts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_abouts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_abouts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_abouts_id_seq OWNED BY public.resturant_abouts.id;


--
-- Name: resturant_blogs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_blogs (
    id bigint NOT NULL,
    "Image" text,
    "Sub_Image" text,
    "Date" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_blogs OWNER TO orientlimraerp_karim;

--
-- Name: resturant_blogs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_blogs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_blogs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_blogs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_blogs_id_seq OWNED BY public.resturant_blogs.id;


--
-- Name: resturant_cart_check_styles; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_cart_check_styles (
    id bigint NOT NULL,
    "Cart_BG_Type" text,
    "Cart_BG_Image" text,
    "Cart_BG_Color" text,
    "Cart_Title_Color" text,
    "Cart_Txt_Color" text,
    "Cart_Top_Image" text,
    "Cart_Box_BG" text,
    "Cart_Box_Border" text,
    "Cart_Table_Color" text,
    "Cart_Table_BG" text,
    "Cart_Btn_BG" text,
    "Cart_Btn_Color" text,
    "Checkout_Image" text,
    "Checkout_Title_Color" text,
    "Checkout_BG_Type" text,
    "Checkout_BG_Image" text,
    "Checkout_BG_Color" text,
    "Checkout_Box_BG" text,
    "Checkout_Box_Border" text,
    "Checkout_Input_BG" text,
    "Checkout_Input_Color" text,
    "Checkout_Btn_Color" text,
    "Checkout_Btn_BG" text,
    "Checkout_Txt_Color" text,
    "Checkout_Txt_Hover_Color" text,
    "Checkout_Price_Color" text,
    "MyAccount_BG_Type" text,
    "MyAccount_BG_Image" text,
    "MyAccount_BG_Color" text,
    "MyAccount_Box_BG" text,
    "MyAccount_Box_Border" text,
    "MyAccount_Table_BG" text,
    "MyAccount_Table_Color" text,
    "MyAccount_Table_Head_BG" text,
    "MyAccount_Table_Head_Color" text,
    "MyAccount_Txt_Color" text,
    "MyAccount_Btn_BG" text,
    "MyAccount_Btn_Color" text,
    "MyAccount_Input_BG" text,
    "MyAccount_Input_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Collapse_BG" text,
    "Collapse_Border" text,
    "Collapse_Color" text
);


ALTER TABLE public.resturant_cart_check_styles OWNER TO orientlimraerp_karim;

--
-- Name: resturant_cart_check_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_cart_check_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_cart_check_styles_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_cart_check_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_cart_check_styles_id_seq OWNED BY public.resturant_cart_check_styles.id;


--
-- Name: resturant_cupon_codes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_cupon_codes (
    id bigint NOT NULL,
    "Code" text,
    "Amount" text,
    "Status" text,
    "Num" text,
    "Used" text,
    "Expire" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_cupon_codes OWNER TO orientlimraerp_karim;

--
-- Name: resturant_cupon_codes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_cupon_codes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_cupon_codes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_cupon_codes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_cupon_codes_id_seq OWNED BY public.resturant_cupon_codes.id;


--
-- Name: resturant_galleries; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_galleries (
    id bigint NOT NULL,
    "Image" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_galleries OWNER TO orientlimraerp_karim;

--
-- Name: resturant_galleries_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_galleries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_galleries_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_galleries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_galleries_id_seq OWNED BY public.resturant_galleries.id;


--
-- Name: resturant_homes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_homes (
    id bigint NOT NULL,
    "Image_1" text,
    "Image_2" text,
    "Image_3" text,
    "Image_4" text,
    "Title_Image" text,
    "Arabic_Title" text,
    "English_Title" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "English_Sub_Title" text,
    "Arabic_Sub_Title" text,
    "Year" text
);


ALTER TABLE public.resturant_homes OWNER TO orientlimraerp_karim;

--
-- Name: resturant_homes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_homes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_homes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_homes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_homes_id_seq OWNED BY public.resturant_homes.id;


--
-- Name: resturant_index_style_i_i_s; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_index_style_i_i_s (
    id bigint NOT NULL,
    "About_Body_BG_Type" text,
    "About_Body_BG_Image" text,
    "About_Body_BG_Color" text,
    "About_Txt_Color" text,
    "Gallery_Border_Color" text,
    "Reviews_Image_1" text,
    "Reviews_Image_2" text,
    "Reviews_Nxt_Prev_Color" text,
    "Reviews_Nxt_Prev_BG" text,
    "Reviews_Nxt_Prev_Border" text,
    "Reviews_Txt_Color" text,
    "Reviews_Body_BG_Type" text,
    "Reviews_Body_BG_Image" text,
    "Reviews_Body_BG_Color" text,
    "Reservations_Body_BG_Type" text,
    "Reservations_Body_BG_Image" text,
    "Reservations_Body_BG_Color" text,
    "Reservations_Box_BG" text,
    "Reservations_Input_BG" text,
    "Reservations_Input_Color" text,
    "Reservations_Btn_Color" text,
    "Reservations_Btn_BG" text,
    "Blogs_Home_Body_BG_Type" text,
    "Blogs_Home_Body_BG_Image" text,
    "Blogs_Home_Body_BG_Color" text,
    "Blogs_Home_Box_BG_Color" text,
    "Blogs_Home_Box_Border_Color" text,
    "Blogs_Home_Txt_Color" text,
    "Blogs_Home_Txt_Hover_Color" text,
    "Blogs_Home_Btn_BG" text,
    "Blogs_Home_Btn_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_index_style_i_i_s OWNER TO orientlimraerp_karim;

--
-- Name: resturant_index_style_i_i_s_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_index_style_i_i_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_index_style_i_i_s_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_index_style_i_i_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_index_style_i_i_s_id_seq OWNED BY public.resturant_index_style_i_i_s.id;


--
-- Name: resturant_index_style_i_s; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_index_style_i_s (
    id bigint NOT NULL,
    "Home_1_Nxt_Prev_Color" text,
    "Home_1_Nxt_Prev_BG" text,
    "Home_1_Nxt_Prev_Border" text,
    "Home_2_Image_1" text,
    "Home_2_Image_2" text,
    "Home_2_Image_Arrow" text,
    "Home_2_Number_BG" text,
    "Home_2_Image_Border" text,
    "Home_2_Number_Color" text,
    "Category_Bar_BG" text,
    "Category_Bar_Color" text,
    "Video_Section_Body_BG_Type" text,
    "Video_Section_Body_BG_Image" text,
    "Video_Section_Body_BG_Color" text,
    "Video_Section_Image_1" text,
    "Video_Section_Image_2" text,
    "Menu_Index_Body_BG_Type" text,
    "Menu_Index_Body_BG_Image" text,
    "Menu_Index_Body_BG_Color" text,
    "Menu_Index_Txt_Color" text,
    "Menu_Index_Txt_Hover_Color" text,
    "Menu_Index_Btn_BG" text,
    "Menu_Index_Btn_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Icon_Image" text
);


ALTER TABLE public.resturant_index_style_i_s OWNER TO orientlimraerp_karim;

--
-- Name: resturant_index_style_i_s_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_index_style_i_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_index_style_i_s_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_index_style_i_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_index_style_i_s_id_seq OWNED BY public.resturant_index_style_i_s.id;


--
-- Name: resturant_menu_styles; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_menu_styles (
    id bigint NOT NULL,
    "Menu_1_BG_Type" text,
    "Menu_1_BG_Image" text,
    "Menu_1_BG_Color" text,
    "Menu_1_Image" text,
    "Menu_1_Icon_Image" text,
    "Menu_1_Title" text,
    "Menu_1_Bar_BG" text,
    "Menu_1_Bar_Color" text,
    "Menu_1_Btn_BG" text,
    "Menu_1_Btn_Color" text,
    "Menu_1_Icon_Color" text,
    "Menu_1_Icon_Hover_Color" text,
    "Menu_1_Icon_Active_Color" text,
    "Menu_1_Price_Color" text,
    "Menu_1_Offer_Price_Color" text,
    "Menu_2_Gallery_Border" text,
    "Menu_2_BG_Type" text,
    "Menu_2_BG_Image" text,
    "Menu_2_BG_Color" text,
    "Menu_2_Title" text,
    "Menu_2_Category_Color" text,
    "Menu_2_Category_Hover_Color" text,
    "Menu_2_Category_Active_Color" text,
    "Menu_2_Lines_Color" text,
    "Menu_2_Btn_BG" text,
    "Menu_2_Btn_Color" text,
    "Menu_2_Name_BG" text,
    "Menu_2_Name_Color" text,
    "Menu_2_Icon_Color" text,
    "Menu_2_Icon_Hover_Color" text,
    "Menu_2_Icon_Active_Color" text,
    "Menu_2_Price_Color" text,
    "Menu_2_Offer_Price_Color" text,
    "Menu_3_BG_Type" text,
    "Menu_3_BG_Image" text,
    "Menu_3_BG_Color" text,
    "Menu_3_Image" text,
    "Menu_3_Icon_Image" text,
    "Menu_3_Title" text,
    "Menu_3_Category_Color" text,
    "Menu_3_Category_Hover_Color" text,
    "Menu_3_Category_Active_Color" text,
    "Menu_3_Box_BG" text,
    "Menu_3_Box_Color" text,
    "Menu_3_Btn_BG" text,
    "Menu_3_Btn_Color" text,
    "Menu_3_Icon_Color" text,
    "Menu_3_Icon_Hover_Color" text,
    "Menu_3_Icon_Active_Color" text,
    "Menu_3_Price_Color" text,
    "Menu_3_Offer_Price_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_menu_styles OWNER TO orientlimraerp_karim;

--
-- Name: resturant_menu_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_menu_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_menu_styles_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_menu_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_menu_styles_id_seq OWNED BY public.resturant_menu_styles.id;


--
-- Name: resturant_nav_foot_styles; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_nav_foot_styles (
    id bigint NOT NULL,
    "Navbar_BG" text,
    "Navbar_Txt_Color" text,
    "Navbar_Txt_Hover_Color" text,
    "Navbar_Btn_BG" text,
    "Navbar_Btn_Color" text,
    "Navbar_Sub_Menu_BG" text,
    "Navbar_Sub_Menu_Color" text,
    "Footer_BG_Type" text,
    "Footer_BG_Color" text,
    "Footer_BG_Image" text,
    "Footer_Title_Color" text,
    "Footer_Txt_Color" text,
    "Footer_Social_Color" text,
    "Footer_Social_Hover_Color" text,
    "Footer_CopyRight_Color" text,
    "Footer_CopyRight_Company_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_nav_foot_styles OWNER TO orientlimraerp_karim;

--
-- Name: resturant_nav_foot_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_nav_foot_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_nav_foot_styles_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_nav_foot_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_nav_foot_styles_id_seq OWNED BY public.resturant_nav_foot_styles.id;


--
-- Name: resturant_privacies; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_privacies (
    id bigint NOT NULL,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_privacies OWNER TO orientlimraerp_karim;

--
-- Name: resturant_privacies_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_privacies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_privacies_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_privacies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_privacies_id_seq OWNED BY public.resturant_privacies.id;


--
-- Name: resturant_reservations; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_reservations (
    id bigint NOT NULL,
    "Name" text,
    "Phone" text,
    "Persons" text,
    "Date" text,
    "Time" text,
    "Message" text,
    "Approve" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_reservations OWNER TO orientlimraerp_karim;

--
-- Name: resturant_reservations_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_reservations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_reservations_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_reservations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_reservations_id_seq OWNED BY public.resturant_reservations.id;


--
-- Name: resturant_reviews; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_reviews (
    id bigint NOT NULL,
    "Image" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_reviews OWNER TO orientlimraerp_karim;

--
-- Name: resturant_reviews_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_reviews_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_reviews_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_reviews_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_reviews_id_seq OWNED BY public.resturant_reviews.id;


--
-- Name: resturant_sliders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_sliders (
    id bigint NOT NULL,
    "Status" text,
    "Arabic_Title" text,
    "English_Title" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    "Image" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_sliders OWNER TO orientlimraerp_karim;

--
-- Name: resturant_sliders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_sliders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_sliders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_sliders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_sliders_id_seq OWNED BY public.resturant_sliders.id;


--
-- Name: resturant_socials; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_socials (
    id bigint NOT NULL,
    "Facebook" text,
    "Twitter" text,
    "Instagram" text,
    "Youtube" text,
    "Snapchat" text,
    "Whatsapp" text,
    "Google_Plus" text,
    "LinkedIn" text,
    "Pinterest" text,
    "Telegram" text,
    "iOS" text,
    "Android" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_socials OWNER TO orientlimraerp_karim;

--
-- Name: resturant_socials_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_socials_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_socials_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_socials_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_socials_id_seq OWNED BY public.resturant_socials.id;


--
-- Name: resturant_styles; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_styles (
    id bigint NOT NULL,
    "Font" text,
    "Home" text,
    "Menu" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Reviews" text,
    "Privacy" text,
    "Terms" text,
    "Gallery" text,
    "Blogs" text,
    "Cart" text,
    "PDF" text,
    "Reservations" text,
    "Body_BG_Type" text,
    "Modal_Txt_Color" text,
    "Modal_BG_Color" text,
    "Pagination_Active_Txt_Color" text,
    "Pagination_Active_BG_Color" text,
    "Pagination_Txt_Color" text,
    "Pagination_BG_Color" text,
    "Body_Title_Color" text,
    "Modal_Button_Txt_Color" text,
    "Modal_Button_BG_Color" text,
    "Form_Input_Txt_Color" text,
    "Form_Input_BG" text,
    "Form_Txt_Hover_Color" text,
    "Form_Txt_Color" text,
    "Form_Box_Border_Color" text,
    "Form_Box_BG" text,
    "Preloader_Circle_3_Color" text,
    "Preloader_Circle_2_Color" text,
    "Preloader_Circle_1_Color" text,
    "Form_Btn_Txt_Color" text,
    "Form_Btn_BG" text,
    "Body_BG_Image" text,
    "Body_BG_Color" text
);


ALTER TABLE public.resturant_styles OWNER TO orientlimraerp_karim;

--
-- Name: resturant_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_styles_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_styles_id_seq OWNED BY public.resturant_styles.id;


--
-- Name: resturant_sup_page_styles; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_sup_page_styles (
    id bigint NOT NULL,
    "Blogs_BG_Type" text,
    "Blogs_BG_Image" text,
    "Blogs_BG_Color" text,
    "Blogs_Title_Color" text,
    "Blogs_Top_Image" text,
    "Blogs_Box_BG" text,
    "Blogs_Box_Border" text,
    "Blogs_Box_Txt_Color" text,
    "Blogs_Box_Txt_Hover_Color" text,
    "Blogs_Btn_Color" text,
    "Blogs_Btn_BG" text,
    "Blogs_Details_Box_BG" text,
    "Blogs_Details_Box_Border" text,
    "Blogs_Details_Box_Txt_Color" text,
    "Reviews_Top_Image" text,
    "Reviews_Title_Color" text,
    "Reviews_BG_Type" text,
    "Reviews_BG_Image" text,
    "Reviews_BG_Color" text,
    "Reviews_Box_BG" text,
    "Reviews_Box_Border" text,
    "Reviews_Icon_Color" text,
    "Gallery_Top_Image" text,
    "Gallery_Title_Color" text,
    "Gallery__BG_Type" text,
    "Gallery__BG_Image" text,
    "Gallery__BG_Color" text,
    "Terms_Privacy_Top_Image" text,
    "Terms_Privacy_Title_Color" text,
    "Terms_Privacy_Box_BG" text,
    "Terms_Privacy_Box_Border" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_sup_page_styles OWNER TO orientlimraerp_karim;

--
-- Name: resturant_sup_page_styles_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_sup_page_styles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_sup_page_styles_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_sup_page_styles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_sup_page_styles_id_seq OWNED BY public.resturant_sup_page_styles.id;


--
-- Name: resturant_tables; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_tables (
    id bigint NOT NULL,
    "Table_Number" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Place_Ar" text,
    "Place_En" text,
    "Chairs_Num" text,
    "QR" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_tables OWNER TO orientlimraerp_karim;

--
-- Name: resturant_tables_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_tables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_tables_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_tables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_tables_id_seq OWNED BY public.resturant_tables.id;


--
-- Name: resturant_terms; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_terms (
    id bigint NOT NULL,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_terms OWNER TO orientlimraerp_karim;

--
-- Name: resturant_terms_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_terms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_terms_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_terms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_terms_id_seq OWNED BY public.resturant_terms.id;


--
-- Name: resturant_video_sections; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.resturant_video_sections (
    id bigint NOT NULL,
    "BG_Image" text,
    "Icon" text,
    "Title_Image" text,
    "Video_Link" text,
    "Image_1" text,
    "Image_2" text,
    "Image_3" text,
    "Image_4" text,
    "Number_1" text,
    "Number_2" text,
    "Number_3" text,
    "Number_4" text,
    "Arabic_Title_1" text,
    "Arabic_Title_2" text,
    "Arabic_Title_3" text,
    "Arabic_Title_4" text,
    "English_Title_1" text,
    "English_Title_2" text,
    "English_Title_3" text,
    "English_Title_4" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.resturant_video_sections OWNER TO orientlimraerp_karim;

--
-- Name: resturant_video_sections_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.resturant_video_sections_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resturant_video_sections_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: resturant_video_sections_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.resturant_video_sections_id_seq OWNED BY public.resturant_video_sections.id;


--
-- Name: return_maintaince_bills; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_maintaince_bills (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Serial_Num" text,
    "Pattern_Image" text,
    "Time" text,
    "Payment_Method" text,
    "Password" text,
    "Pay" text,
    "Work" text,
    "Total" text,
    "Total_Cost" text,
    "Cost_Precent" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_Bf_Taxes" text,
    "Total_Taxes" text,
    "Draw" text,
    "Bill" text,
    "Company" bigint,
    "Device_Type" bigint,
    "Device_Case" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "Account" bigint,
    "Store" bigint,
    "Eng" bigint,
    "Recipient" bigint,
    "Branch" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "CustomerGroup" text,
    "Total_Talf" text
);


ALTER TABLE public.return_maintaince_bills OWNER TO orientlimraerp_karim;

--
-- Name: return_maintaince_bills_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_maintaince_bills_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_maintaince_bills_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_maintaince_bills_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_maintaince_bills_arr_seq OWNED BY public.return_maintaince_bills.arr;


--
-- Name: return_maintaince_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_maintaince_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_maintaince_bills_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_maintaince_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_maintaince_bills_id_seq OWNED BY public.return_maintaince_bills.id;


--
-- Name: return_products_stores_transfers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_products_stores_transfers (
    id bigint NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "P_Code" text,
    "Price" text,
    "OldPrice" text,
    "Av_Qty" text,
    "SmallCode" text,
    "ReturnQty" text,
    "Trans_Qty" text,
    "Original_Trans_Qty" text,
    "SmallTrans_Qty" text,
    "Total" text,
    "ST_ID" text,
    "Product" text,
    "V1" text,
    "V2" text,
    "Unit" text,
    "To_Store" text,
    "CostPrice" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_products_stores_transfers OWNER TO orientlimraerp_karim;

--
-- Name: return_products_stores_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_products_stores_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_products_stores_transfers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_products_stores_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_products_stores_transfers_id_seq OWNED BY public.return_products_stores_transfers.id;


--
-- Name: return_purch_bills_filter_twos; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_purch_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Purchase" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_purch_bills_filter_twos OWNER TO orientlimraerp_karim;

--
-- Name: return_purch_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_purch_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purch_bills_filter_twos_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_purch_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_purch_bills_filter_twos_id_seq OWNED BY public.return_purch_bills_filter_twos.id;


--
-- Name: return_purch_bills_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_purch_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Purchase" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Vendor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_purch_bills_filters OWNER TO orientlimraerp_karim;

--
-- Name: return_purch_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_purch_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purch_bills_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_purch_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_purch_bills_filters_id_seq OWNED BY public.return_purch_bills_filters.id;


--
-- Name: return_purch_products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_purch_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Return_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint NOT NULL,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Return" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Date" text,
    "Code" text,
    "Refernce_Number" text,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Coin" bigint,
    "User" bigint,
    "Cost_Center" bigint,
    "Type" text,
    "Ship" bigint,
    "TDiscount" text,
    "TypeEn" text
);


ALTER TABLE public.return_purch_products OWNER TO orientlimraerp_karim;

--
-- Name: return_purch_products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_purch_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purch_products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_purch_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_purch_products_id_seq OWNED BY public.return_purch_products.id;


--
-- Name: return_purches; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_purches (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Return_Qty" text NOT NULL,
    "Total_Return_Value" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Purchase" bigint NOT NULL,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pay" text,
    "Payment_Method" text,
    "TDiscount" text,
    "Total_Discount" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Later_Due" text,
    "Cost_Center" bigint,
    "Safe" bigint,
    "Vendor" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    arr bigint,
    "Ship" bigint,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.return_purches OWNER TO orientlimraerp_karim;

--
-- Name: return_purches_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_purches_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purches_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_purches_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_purches_arr_seq OWNED BY public.return_purches.arr;


--
-- Name: return_purches_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_purches_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_purches_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_purches_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_purches_id_seq OWNED BY public.return_purches.id;


--
-- Name: return_sales; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_sales (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Total_Return_Qty" text NOT NULL,
    "Total_Return_Value" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Sales" bigint NOT NULL,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Pay" text,
    "Payment_Method" text,
    "TDiscount" text,
    "Total_Discount" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Executor" text,
    "Later_Due" text,
    "InstallCompany" text,
    "Delivery" text,
    "TaxBill" text,
    "TaxCode" text,
    uuid text,
    "longId" text,
    "hashKey" text,
    "submissionId" text,
    "Sent" text,
    "Safe" bigint,
    "Cost_Center" bigint,
    "Client" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    arr bigint,
    "Ship" bigint,
    "Edit" text,
    "Delete" text,
    "Edit_New_Code" text,
    "Current_Credit" text,
    "Cost" text,
    "TotalCost" text
);


ALTER TABLE public.return_sales OWNER TO orientlimraerp_karim;

--
-- Name: return_sales_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_sales_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_sales_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_sales_arr_seq OWNED BY public.return_sales.arr;


--
-- Name: return_sales_bills_filter_twos; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_sales_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Sales" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "InstallCompany" text,
    "Delivery" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ID" text,
    "Type" text
);


ALTER TABLE public.return_sales_bills_filter_twos OWNER TO orientlimraerp_karim;

--
-- Name: return_sales_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_sales_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_bills_filter_twos_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_sales_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_sales_bills_filter_twos_id_seq OWNED BY public.return_sales_bills_filter_twos.id;


--
-- Name: return_sales_bills_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_sales_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Total_Return_Qty" text,
    "Total_Return_Value" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Discount" text,
    "Sales" text,
    "Pay" text,
    "Payment_Method" text,
    "User" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Refernce_Number" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Ship" text,
    "Later_Due" text,
    "InstallCompany" text,
    "Delivery" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "ID" text
);


ALTER TABLE public.return_sales_bills_filters OWNER TO orientlimraerp_karim;

--
-- Name: return_sales_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_sales_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_bills_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_sales_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_sales_bills_filters_id_seq OWNED BY public.return_sales_bills_filters.id;


--
-- Name: return_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_sales_id_seq OWNED BY public.return_sales.id;


--
-- Name: return_sales_products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_sales_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Original_Qty" text,
    "Recived_Qty" text,
    "AvQty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Tax" text,
    "Total_Bf_Tax" text,
    "Total" text,
    "Total_Tax" text,
    "Exp_Date" text,
    "Store" bigint,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Unit" bigint,
    "Return" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "Type" text,
    "Cost_Center" bigint,
    "User" bigint,
    "Delegate" bigint,
    "Executor" bigint,
    "Safe" bigint,
    "Coin" bigint,
    "Date" text,
    "Client" bigint,
    "Refernce_Number" text,
    "Ship" bigint,
    "Patch_Number" text,
    "CoinCode" text,
    "CoinPrice" text,
    "CoinRate" text,
    "AmountEGP" text,
    "DiscountAmount" text,
    "TaxType" text,
    "TaxAmount" text,
    "TaxSubType" text,
    "TaxRate" text,
    "TotalBill" text,
    "SalesTotal" text,
    "NetTotal" text
);


ALTER TABLE public.return_sales_products OWNER TO orientlimraerp_karim;

--
-- Name: return_sales_products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_sales_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_sales_products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_sales_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_sales_products_id_seq OWNED BY public.return_sales_products.id;


--
-- Name: return_stors_transfers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_stors_transfers (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Total" text,
    "TotalQty" text,
    "Note" text,
    "From_Store" text,
    "To_Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "Ship" text,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "Branch" text,
    "Total_Cost" text,
    "TypeTransfer" text,
    "Cost_Store" text,
    "OriginalID" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.return_stors_transfers OWNER TO orientlimraerp_karim;

--
-- Name: return_stors_transfers_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_stors_transfers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_stors_transfers_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_stors_transfers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_stors_transfers_arr_seq OWNED BY public.return_stors_transfers.arr;


--
-- Name: return_stors_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_stors_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_stors_transfers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_stors_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_stors_transfers_id_seq OWNED BY public.return_stors_transfers.id;


--
-- Name: return_without_bills; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.return_without_bills (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Payment_Method" text,
    "Status" text,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Total_Cost" text,
    "Pay" text,
    "Safe" text,
    "Vendor" text,
    "Deficit_Account" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Due_Date" text,
    "Later_Due" text,
    "TaxBill" text,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Delete" text DEFAULT 0,
    "Current_Credit" text
);


ALTER TABLE public.return_without_bills OWNER TO orientlimraerp_karim;

--
-- Name: return_without_bills_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_without_bills_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_without_bills_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_without_bills_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_without_bills_arr_seq OWNED BY public.return_without_bills."Code";


--
-- Name: return_without_bills_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.return_without_bills_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.return_without_bills_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: return_without_bills_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.return_without_bills_id_seq OWNED BY public.return_without_bills.id;


--
-- Name: role_has_permissions; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.role_has_permissions (
    permission_id bigint NOT NULL,
    role_id bigint NOT NULL
);


ALTER TABLE public.role_has_permissions OWNER TO orientlimraerp_karim;

--
-- Name: roles; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.roles (
    id bigint NOT NULL,
    name character varying(191) NOT NULL,
    guard_name character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "nameEn" text
);


ALTER TABLE public.roles OWNER TO orientlimraerp_karim;

--
-- Name: roles_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roles_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: roles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.roles_id_seq OWNED BY public.roles.id;


--
-- Name: room_reservations; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.room_reservations (
    id bigint NOT NULL,
    "Date" text,
    "Room" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.room_reservations OWNER TO orientlimraerp_karim;

--
-- Name: room_reservations_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.room_reservations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.room_reservations_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: room_reservations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.room_reservations_id_seq OWNED BY public.room_reservations.id;


--
-- Name: rooms; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.rooms (
    id bigint NOT NULL,
    "Code" text,
    "Floor" text,
    "Bulding_Name" text,
    "Adults_Num" text,
    "Childs_Num" text,
    "Beds_Num" text,
    "Desc" text,
    "Price" text,
    "Reserved" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "RoomsType" text,
    "DescEn" text
);


ALTER TABLE public.rooms OWNER TO orientlimraerp_karim;

--
-- Name: rooms_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.rooms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rooms_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: rooms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.rooms_id_seq OWNED BY public.rooms.id;


--
-- Name: rooms_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.rooms_types (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.rooms_types OWNER TO orientlimraerp_karim;

--
-- Name: rooms_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.rooms_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rooms_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: rooms_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.rooms_types_id_seq OWNED BY public.rooms_types.id;


--
-- Name: safe_transfer_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.safe_transfer_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Safe" text,
    "To_Safe" text,
    "User" text,
    "Coin" text,
    "Cost_Center" text,
    "Note" text,
    "Delegate" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_columns OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfer_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.safe_transfer_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfer_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.safe_transfer_columns_id_seq OWNED BY public.safe_transfer_columns.id;


--
-- Name: safe_transfer_columns_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.safe_transfer_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Safe" text,
    "To_Safe" text,
    "User" text,
    "Coin" text,
    "Cost_Center" text,
    "Note" text,
    "Delegate" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_columns_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfer_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.safe_transfer_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_columns_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfer_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.safe_transfer_columns_sechdules_id_seq OWNED BY public.safe_transfer_columns_sechdules.id;


--
-- Name: safe_transfer_filter_twos; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.safe_transfer_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Amount" text,
    "Note" text,
    "From_Safe" text,
    "To_Safe" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "File" text,
    "OldAmount" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "ID" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_filter_twos OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfer_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.safe_transfer_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_filter_twos_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfer_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.safe_transfer_filter_twos_id_seq OWNED BY public.safe_transfer_filter_twos.id;


--
-- Name: safe_transfer_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.safe_transfer_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Amount" text,
    "Note" text,
    "From_Safe" text,
    "To_Safe" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "File" text,
    "OldAmount" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "ID" text,
    "Type" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.safe_transfer_filters OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfer_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.safe_transfer_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfer_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfer_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.safe_transfer_filters_id_seq OWNED BY public.safe_transfer_filters.id;


--
-- Name: safe_transfers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.safe_transfers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Note" text,
    "From_Safe" bigint NOT NULL,
    "To_Safe" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "File" text,
    "OldAmount" text,
    "Edit" text,
    "Time" text,
    "Delegate" bigint,
    arr bigint,
    "Branch" bigint
);


ALTER TABLE public.safe_transfers OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfers_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.safe_transfers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfers_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.safe_transfers_arr_seq OWNED BY public.safe_transfers."Code";


--
-- Name: safe_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.safe_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safe_transfers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: safe_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.safe_transfers_id_seq OWNED BY public.safe_transfers.id;


--
-- Name: safes_banks; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.safes_banks (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Name" text NOT NULL,
    "Type" text NOT NULL,
    "Note" text,
    "Account" bigint NOT NULL,
    "User" bigint NOT NULL,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text,
    "Service_Fee" text,
    "NameEn" text
);


ALTER TABLE public.safes_banks OWNER TO orientlimraerp_karim;

--
-- Name: safes_banks_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.safes_banks_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safes_banks_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: safes_banks_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.safes_banks_arr_seq OWNED BY public.safes_banks."Code";


--
-- Name: safes_banks_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.safes_banks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.safes_banks_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: safes_banks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.safes_banks_id_seq OWNED BY public.safes_banks.id;


--
-- Name: sales; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Quote" text,
    "SalesOrder" text,
    "Safe" bigint NOT NULL,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Executor" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ship" bigint,
    arr bigint,
    "Check_Type" bigint,
    "Check_Number" text,
    "Due_Date" text,
    "ShipStatus" text DEFAULT 0,
    "Cash" text,
    "Visa" text,
    "Sale_Type" text,
    "Hold" text,
    "Shift_Code" text,
    emp bigint,
    "Store_Code" text,
    "Later_Due" text,
    "Later_Collection" text DEFAULT 1,
    "Client_Address" text,
    "Delivery" text,
    "Delivery_Status" text,
    "Sale_User" text,
    "Sent" text,
    "TaxBill" text DEFAULT 0,
    "TaxCode" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text DEFAULT 0,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    uuid text,
    "longId" text,
    "hashKey" text,
    "submissionId" text,
    "statusBill" text,
    "DiscountTax" text,
    "RecivedDate" text,
    "InstallCompany" bigint,
    "File" text,
    "ResturantOrderType" text,
    "DeliveryTime" text,
    "RecivedOrderTime" text,
    "RecivedOrder" text,
    "KitchenEndTime" text,
    "KitchenEnd" text,
    "Witer" text,
    "TakeawayTime" text,
    "TakeawayStatus" text,
    "Table" bigint,
    "Total_Wight_Bill" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text,
    "Total_Net" text,
    "Residual" text,
    "Current_Credit" text,
    "DiscountBill" text DEFAULT 0,
    "ServiceType" text,
    "ServiceFees" text,
    "ServiceValue" text,
    bill_lat text,
    bill_lng text
);


ALTER TABLE public.sales OWNER TO orientlimraerp_karim;

--
-- Name: sales_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_arr_seq OWNED BY public.sales.arr;


--
-- Name: sales_bills_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_bills_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client" text,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.sales_bills_columns OWNER TO orientlimraerp_karim;

--
-- Name: sales_bills_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_bills_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_bills_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_bills_columns_id_seq OWNED BY public.sales_bills_columns.id;


--
-- Name: sales_bills_columns_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_bills_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "ShiftCode" text,
    "Executor" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Product_Code" text,
    "Product_Name" text,
    "Unit" text,
    "Av_Qty" text,
    "Qty" text,
    "Price" text,
    "Discount" text,
    "Total_BF_Tax" text,
    "Tax" text,
    "Total" text,
    "Group" text,
    "Brand" text,
    "Exp_Date" text,
    "Product_Store" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Client" text,
    "Rate" text,
    "Name_Width" text
);


ALTER TABLE public.sales_bills_columns_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: sales_bills_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_bills_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_columns_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_bills_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_bills_columns_sechdules_id_seq OWNED BY public.sales_bills_columns_sechdules.id;


--
-- Name: sales_bills_filter_twos; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_bills_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Shift_Code" text,
    "Later_Due" text,
    "Later_Collection" text,
    "Delivery" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text,
    "InstallCompany" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ID" text,
    "Type" text
);


ALTER TABLE public.sales_bills_filter_twos OWNER TO orientlimraerp_karim;

--
-- Name: sales_bills_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_bills_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_filter_twos_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_bills_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_bills_filter_twos_id_seq OWNED BY public.sales_bills_filter_twos.id;


--
-- Name: sales_bills_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_bills_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Status" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    "Safe" text,
    "Client" text,
    "Executor" text,
    "Delegate" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Ship" text,
    "Shift_Code" text,
    "Later_Due" text,
    "Later_Collection" text,
    "Delivery" text,
    "ProfitPrecent" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "ProfitTax" text,
    "InstallCompany" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "ID" text
);


ALTER TABLE public.sales_bills_filters OWNER TO orientlimraerp_karim;

--
-- Name: sales_bills_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_bills_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_bills_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_bills_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_bills_filters_id_seq OWNED BY public.sales_bills_filters.id;


--
-- Name: sales_default_data; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_default_data (
    id bigint NOT NULL,
    "Payment_Method" text,
    "Status" text,
    "V_and_C" text,
    "Mainus" text,
    "Price_Sale" text,
    "Safe" bigint,
    "Client" bigint,
    "Delegate" bigint,
    "Store" bigint,
    "Coin" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Brand" text,
    "Group" text,
    "English_Name" text,
    "Expire" text,
    "Draw" text,
    "Shift_Pass" text,
    "Empp" text,
    "Discount" text,
    "Delivery" text,
    "Execute_Precent" text,
    "StoresQty" text,
    "DelegateEmp" text,
    "TaxType" text,
    "DiscountTaxShow" text,
    "SalesOrderType" text,
    "ECommercceSaleType" text,
    "Kitchen_Order" text,
    "Waiter" text,
    "Hall_Service_Type" text,
    "Hall_Service_Precent" text,
    "CountryResturantWebsite" text,
    "Bank" text,
    "Country" text,
    "SalesLowCostPrice" text,
    "ShowJobOrders" text,
    "LimitSalesQty" text,
    "Total_Wight_Bill" text,
    "Duplicate_Items" text,
    "ExecuteEmp" text,
    "Hide_Product" text,
    "Choice_Collector_POS" text,
    "Hide_Discount_POS" text,
    "Hide_Edit_Delete" text,
    "Daily_Clients" text,
    "Location_Conditon" text,
    "Show_Image_Print" text
);


ALTER TABLE public.sales_default_data OWNER TO orientlimraerp_karim;

--
-- Name: sales_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_default_data_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_default_data_id_seq OWNED BY public.sales_default_data.id;


--
-- Name: sales_fifo_qties; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_fifo_qties (
    id bigint NOT NULL,
    "Sales_Qty" text,
    "Sales_ID" text,
    "Fifo_ID" text,
    "Store" text,
    "Product" text,
    "Cost_Price" text,
    "Purchases_Date" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sales_fifo_qties OWNER TO orientlimraerp_karim;

--
-- Name: sales_fifo_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_fifo_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_fifo_qties_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_fifo_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_fifo_qties_id_seq OWNED BY public.sales_fifo_qties.id;


--
-- Name: sales_gifts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_gifts (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Total_Cost" text,
    "Client" text,
    "Store" text,
    "Coin" text,
    "Cost_Center" text,
    "Edit" text DEFAULT '0'::text,
    "Delete" text DEFAULT '0'::text,
    "Edit_New_Code" text,
    "User" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Account" text
);


ALTER TABLE public.sales_gifts OWNER TO orientlimraerp_karim;

--
-- Name: sales_gifts_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_gifts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_gifts_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_gifts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_gifts_arr_seq OWNED BY public.sales_gifts."Code";


--
-- Name: sales_gifts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_gifts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_gifts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_gifts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_gifts_id_seq OWNED BY public.sales_gifts.id;


--
-- Name: sales_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_id_seq OWNED BY public.sales.id;


--
-- Name: sales_maint_fifo_qties; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_maint_fifo_qties (
    id bigint NOT NULL,
    "Sales_Qty" text,
    "Sales_ID" text,
    "Fifo_ID" text,
    "Store" text,
    "Product" text,
    "Cost_Price" text,
    "Purchases_Date" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sales_maint_fifo_qties OWNER TO orientlimraerp_karim;

--
-- Name: sales_maint_fifo_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_maint_fifo_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_maint_fifo_qties_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_maint_fifo_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_maint_fifo_qties_id_seq OWNED BY public.sales_maint_fifo_qties.id;


--
-- Name: sales_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_orders (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    "Total_Discount" text,
    "Total_BF_Taxes" text,
    "Total_Taxes" text,
    "Total_Price" text,
    "Pay" text,
    presenter text,
    annual_interest text,
    monthly_installment text,
    "Years_Number" text,
    total text,
    "installment_Num" text,
    "Date_First_installment" text,
    "Quote" text,
    "Safe" bigint NOT NULL,
    "Client" bigint NOT NULL,
    "Delegate" bigint,
    "Executor" bigint,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ToSales" text DEFAULT 0,
    "Hold" text DEFAULT 0,
    "Later_Due" text,
    "Sale_Date" text,
    "CuponCode" text,
    "Shipping" text,
    "Delivery_Status" text,
    "Order_Type" text,
    "Name" text,
    "Email" text,
    "Phone" text,
    "OtherPhone" text,
    "Address_Name" text,
    "Special_MarkAdd" text,
    "StreetAdd" text,
    "BulidingAdd" text,
    "FloorAdd" text,
    "FlatAdd" text,
    "Governrate" text,
    "City" text,
    "Place" text,
    "LocationAdd" text,
    "Address_DetailsAdd" text,
    "ProfitPrecent" text,
    "InstallCompany" text,
    "ContractNumber" text,
    "PayFees" text,
    "ServiceFee" text,
    "CompanyPrecent" text,
    "Cancel_Order" text,
    "Time" text,
    "Delegate_Recived" text,
    "Delegate_Recived_Time" text,
    "To_Sales_Time" text,
    "Cancel_Order_Time" text,
    "Hold_Qty" text,
    "ResturantOrderType" text,
    "DeliveryTime" text,
    "RecivedOrderTime" text,
    "RecivedOrder" text,
    "KitchenEndTime" text,
    "KitchenEnd" text,
    "Witer" text,
    "TakeawayStatus" text,
    "TakeawayTime" text,
    "Table" bigint,
    "Total_Wight_Bill" text,
    "TaxBill" text,
    "TaxCode" text,
    "TaxOnTotal" text,
    "TaxOnTotalType" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Shift_Code" text,
    "Client_Address" text,
    "Delivery" text,
    "ProfitTax" text,
    "Branch" text,
    "CustomerGroup" text,
    "Total_Cost" text,
    "File" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0,
    "Total_Net" text,
    "Residual" text,
    "DiscountTax" text,
    "Current_Credit" text,
    "Ship" text,
    "DiscountBill" text DEFAULT 0
);


ALTER TABLE public.sales_orders OWNER TO orientlimraerp_karim;

--
-- Name: sales_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_orders_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_orders_arr_seq OWNED BY public.sales_orders.arr;


--
-- Name: sales_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_orders_id_seq OWNED BY public.sales_orders.id;


--
-- Name: sales_petrols; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_petrols (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Note" text,
    "Counter_Name" text,
    "Pervious_Read" text,
    "Petrol_Name" text,
    "Current_Raed" text,
    "Value" text,
    "Total" text,
    "Consumption" text,
    "Cash" text,
    "Calibers" text,
    "Counter" bigint,
    "Coin" bigint,
    "Safe" bigint,
    "Store" bigint,
    "Recipient" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sales_petrols OWNER TO orientlimraerp_karim;

--
-- Name: sales_petrols_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_petrols_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_petrols_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_petrols_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_petrols_arr_seq OWNED BY public.sales_petrols.arr;


--
-- Name: sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_petrols_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_petrols_id_seq OWNED BY public.sales_petrols.id;


--
-- Name: sales_serial; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_serial
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_serial OWNER TO orientlimraerp_karim;

--
-- Name: sales_subscribes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sales_subscribes (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text,
    "Later_Due" text,
    "Product_Numbers" text,
    "Total_Price" text,
    "Notes" text,
    "Coin" bigint,
    "Delegate" bigint,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Safe" bigint,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text,
    "Current_Credit" text
);


ALTER TABLE public.sales_subscribes OWNER TO orientlimraerp_karim;

--
-- Name: sales_subscribes_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_subscribes_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_subscribes_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_subscribes_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_subscribes_arr_seq OWNED BY public.sales_subscribes.arr;


--
-- Name: sales_subscribes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sales_subscribes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sales_subscribes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sales_subscribes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sales_subscribes_id_seq OWNED BY public.sales_subscribes.id;


--
-- Name: scientific_materials; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.scientific_materials (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.scientific_materials OWNER TO orientlimraerp_karim;

--
-- Name: scientific_materials_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.scientific_materials_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.scientific_materials_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: scientific_materials_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.scientific_materials_id_seq OWNED BY public.scientific_materials.id;


--
-- Name: secretariat_export_goods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.secretariat_export_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text DEFAULT 0,
    "StoreGoods" text,
    "Total_Recived_Qty" text,
    "Total_Price" text,
    "Draw" text,
    "Coin" text,
    "Safe" text
);


ALTER TABLE public.secretariat_export_goods OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_export_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.secretariat_export_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_export_goods_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_export_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.secretariat_export_goods_arr_seq OWNED BY public.secretariat_export_goods."Code";


--
-- Name: secretariat_export_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.secretariat_export_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_export_goods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_export_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.secretariat_export_goods_id_seq OWNED BY public.secretariat_export_goods.id;


--
-- Name: secretariat_import_goods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.secretariat_import_goods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Account" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.secretariat_import_goods OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_import_goods_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.secretariat_import_goods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_import_goods_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_import_goods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.secretariat_import_goods_arr_seq OWNED BY public.secretariat_import_goods.arr;


--
-- Name: secretariat_import_goods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.secretariat_import_goods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_import_goods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_import_goods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.secretariat_import_goods_id_seq OWNED BY public.secretariat_import_goods.id;


--
-- Name: secretariat_qties; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.secretariat_qties (
    id bigint NOT NULL,
    "Product_Code" text NOT NULL,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "V_Name" text,
    "VV_Name" text,
    "Qty" text,
    "Product" bigint,
    "V1" bigint,
    "V2" bigint,
    "Store" bigint NOT NULL,
    "Unit" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "PP_Code" text,
    "PPP_Code" text,
    "PPPP_Code" text
);


ALTER TABLE public.secretariat_qties OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.secretariat_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_qties_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.secretariat_qties_id_seq OWNED BY public.secretariat_qties.id;


--
-- Name: secretariat_stores; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.secretariat_stores (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.secretariat_stores OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_stores_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.secretariat_stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.secretariat_stores_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: secretariat_stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.secretariat_stores_id_seq OWNED BY public.secretariat_stores.id;


--
-- Name: select_a_p_i_s; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.select_a_p_i_s (
    id bigint NOT NULL,
    id_ text NOT NULL,
    name text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.select_a_p_i_s OWNER TO orientlimraerp_karim;

--
-- Name: select_a_p_i_s_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.select_a_p_i_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.select_a_p_i_s_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: select_a_p_i_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.select_a_p_i_s_id_seq OWNED BY public.select_a_p_i_s.id;


--
-- Name: settlements; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.settlements (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total_Dificit" text NOT NULL,
    "Total_Excess" text NOT NULL,
    "Total_Dificit_Price" text NOT NULL,
    "Total_Excess_Price" text NOT NULL,
    "Inv_ID" bigint,
    "Account_Excess" bigint NOT NULL,
    "Account_Dificit" bigint NOT NULL,
    "Store" bigint,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Note" text,
    "Time" text,
    "Branch" text
);


ALTER TABLE public.settlements OWNER TO orientlimraerp_karim;

--
-- Name: settlements_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.settlements_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.settlements_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: settlements_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.settlements_arr_seq OWNED BY public.settlements.arr;


--
-- Name: settlements_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.settlements_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.settlements_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: settlements_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.settlements_id_seq OWNED BY public.settlements.id;


--
-- Name: shifts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shifts (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Note" text,
    "Total_Cash" text DEFAULT 0,
    "Total_Later" text DEFAULT 0,
    "Total_Visa" text DEFAULT 0,
    "Total" text DEFAULT 0,
    "Pass" text,
    "Emp" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Close" text,
    "Amount" text,
    "Total_Recipt" text DEFAULT 0,
    "Total_Payment" text DEFAULT 0,
    "Store" text,
    "Safe" text,
    "Total_Later_Not_Paid" text DEFAULT 0,
    "Total_Later_Paid" text DEFAULT 0,
    "Total_Installment" text DEFAULT 0,
    "Total_Checks" text DEFAULT 0,
    "Total_Delivery" text DEFAULT 0,
    "Total_Installment_Companies" text DEFAULT 0,
    "Close_Date" text,
    "Open_Amount" text,
    "Open_Note" text
);


ALTER TABLE public.shifts OWNER TO orientlimraerp_karim;

--
-- Name: shifts_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shifts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shifts_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: shifts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shifts_arr_seq OWNED BY public.shifts.arr;


--
-- Name: shifts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shifts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shifts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shifts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shifts_id_seq OWNED BY public.shifts.id;


--
-- Name: shipment_receipts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipment_receipts (
    id bigint NOT NULL,
    "Recived_Store" text,
    "Code" text,
    "Date" text,
    "Total_Cash" text,
    "Total_Later" text,
    "Total_Price" text,
    "Tickets_Numbers" text,
    "Status" text,
    "ShippingList" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_receipts OWNER TO orientlimraerp_karim;

--
-- Name: shipment_receipts_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipment_receipts_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipment_receipts_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipment_receipts_arr_seq OWNED BY public.shipment_receipts.arr;


--
-- Name: shipment_receipts_clients; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipment_receipts_clients (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "ShipmentReceipts" text,
    "ShipmentReceiptsList" text,
    "Total_Price" text,
    "Total_Qty" text,
    "Pay" text,
    "Payment_Method" text,
    "Safe" text,
    "Coin" text,
    "Draw" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_receipts_clients OWNER TO orientlimraerp_karim;

--
-- Name: shipment_receipts_clients_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipment_receipts_clients_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_clients_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipment_receipts_clients_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipment_receipts_clients_arr_seq OWNED BY public.shipment_receipts_clients.arr;


--
-- Name: shipment_receipts_clients_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipment_receipts_clients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_clients_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipment_receipts_clients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipment_receipts_clients_id_seq OWNED BY public.shipment_receipts_clients.id;


--
-- Name: shipment_receipts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipment_receipts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipment_receipts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipment_receipts_id_seq OWNED BY public.shipment_receipts.id;


--
-- Name: shipment_receipts_lists; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipment_receipts_lists (
    id bigint NOT NULL,
    "Shipping_List" text,
    "Code" text,
    "Sender_Name" text,
    "Addressees_Name" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Payment_Method" text,
    "Notes" text,
    "Ticket" text,
    "ShipmentReceipts" text,
    "Status" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipment_receipts_lists OWNER TO orientlimraerp_karim;

--
-- Name: shipment_receipts_lists_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipment_receipts_lists_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_lists_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipment_receipts_lists_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipment_receipts_lists_arr_seq OWNED BY public.shipment_receipts_lists.arr;


--
-- Name: shipment_receipts_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipment_receipts_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipment_receipts_lists_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipment_receipts_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipment_receipts_lists_id_seq OWNED BY public.shipment_receipts_lists.id;


--
-- Name: shipping_companies; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipping_companies (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "Phone" text,
    "Tax_Card" text,
    "Commercial_Register" text,
    "Account" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.shipping_companies OWNER TO orientlimraerp_karim;

--
-- Name: shipping_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipping_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_companies_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipping_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipping_companies_id_seq OWNED BY public.shipping_companies.id;


--
-- Name: shipping_defaults; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipping_defaults (
    id bigint NOT NULL,
    "Delegate" text,
    "Vendor" text,
    "Client" text,
    "Type" text,
    "Status" text,
    "Breakable" text,
    "Coin" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Safe" text,
    "Show_Length" text,
    "Show_Width" text,
    "Show_Weight" text,
    "Show_Code" text,
    "Show_Safe" text,
    "Show_Draw" text,
    "Show_Coin" text,
    "Show_Height" text,
    "Payment_Method" text
);


ALTER TABLE public.shipping_defaults OWNER TO orientlimraerp_karim;

--
-- Name: shipping_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipping_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_defaults_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipping_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipping_defaults_id_seq OWNED BY public.shipping_defaults.id;


--
-- Name: shipping_list_tickets; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipping_list_tickets (
    id bigint NOT NULL,
    "Shipping_List" text,
    "Code" text,
    "Sender_Name" text,
    "Addressees_Name" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Payment_Method" text,
    "Notes" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Ticket" text
);


ALTER TABLE public.shipping_list_tickets OWNER TO orientlimraerp_karim;

--
-- Name: shipping_list_tickets_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipping_list_tickets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_list_tickets_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipping_list_tickets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipping_list_tickets_id_seq OWNED BY public.shipping_list_tickets.id;


--
-- Name: shipping_lists; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipping_lists (
    id bigint NOT NULL,
    "Ticket_Store" text,
    "Driver" text,
    "Car_Store" text,
    "Travel_Area" text,
    "Access_Area" text,
    "Date_Travel" text,
    "Date_Arrival" text,
    "Car_Number" text,
    "Code" text,
    "Date" text,
    "Total_Cash" text,
    "Total_Later" text,
    "Total_Price" text,
    "Tickets_Numbers" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Status" text
);


ALTER TABLE public.shipping_lists OWNER TO orientlimraerp_karim;

--
-- Name: shipping_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipping_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_lists_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipping_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipping_lists_id_seq OWNED BY public.shipping_lists.id;


--
-- Name: shipping_orders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipping_orders (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Weight" text,
    "Number" text,
    "Goods_Price" text,
    "Shipping_Price" text,
    "Total" text,
    "Breakable" text,
    "Note" text,
    "Draw" text,
    "Coin" text,
    "Cost_Center" text,
    "Vend" text,
    "Cli" text,
    "Open" text,
    "Paid" text,
    "Ship_Sort" text,
    "Adderss" text,
    "Requests" text,
    "Sure" text,
    "Safe" text,
    "Residual" text,
    "Emp_Note" text,
    "Shipping_Delegate" text,
    "Cancel" text,
    "Cancel_Note" text,
    "Cancel_Pay" text,
    "Cancel_Not_Pay" text,
    "Vendor_Shipping" text,
    "Request_Done" text,
    "Status" bigint,
    "Type" bigint,
    "Delegate" bigint,
    "Vendor" bigint,
    "Client" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipping_orders OWNER TO orientlimraerp_karim;

--
-- Name: shipping_orders_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipping_orders_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_orders_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipping_orders_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipping_orders_arr_seq OWNED BY public.shipping_orders.arr;


--
-- Name: shipping_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipping_orders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_orders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipping_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipping_orders_id_seq OWNED BY public.shipping_orders.id;


--
-- Name: shipping_statuses; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipping_statuses (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    "Color" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipping_statuses OWNER TO orientlimraerp_karim;

--
-- Name: shipping_statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipping_statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_statuses_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipping_statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipping_statuses_id_seq OWNED BY public.shipping_statuses.id;


--
-- Name: shipping_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shipping_types (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.shipping_types OWNER TO orientlimraerp_karim;

--
-- Name: shipping_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shipping_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shipping_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shipping_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shipping_types_id_seq OWNED BY public.shipping_types.id;


--
-- Name: shortcomings; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.shortcomings (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Payment_Method" text NOT NULL,
    "Status" text NOT NULL,
    "Vendor_Bill_Date" text,
    "Refernce_Number" text,
    "Note" text,
    "Product_Numbers" text NOT NULL,
    "Total_Qty" text NOT NULL,
    "Total_Discount" text NOT NULL,
    "Total_BF_Taxes" text NOT NULL,
    "Total_Taxes" text NOT NULL,
    "Total_Price" text NOT NULL,
    "Pay" text,
    "ToPurch" text,
    "Safe" bigint NOT NULL,
    "Vendor" bigint NOT NULL,
    "Delegate" bigint NOT NULL,
    "Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Purch_Date" text,
    "Purch_Reason" text,
    "ShipStatus" text,
    "P_Order_Num" text,
    "Ship" text,
    "Check_Type" text,
    "Due_Date" text,
    "Check_Number" text,
    "Later_Due" text,
    "Sent" text,
    "TaxBill" text,
    "TaxCode" text,
    "Time" text,
    "Branch" text,
    "CustomerGroup" text,
    "File" text,
    "Current_Credit" text,
    "Residual" text,
    "Total_Net" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text
);


ALTER TABLE public.shortcomings OWNER TO orientlimraerp_karim;

--
-- Name: shortcomings_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shortcomings_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shortcomings_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: shortcomings_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shortcomings_arr_seq OWNED BY public.shortcomings.arr;


--
-- Name: shortcomings_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.shortcomings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.shortcomings_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: shortcomings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.shortcomings_id_seq OWNED BY public.shortcomings.id;


--
-- Name: show_print_defaults; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.show_print_defaults (
    id bigint NOT NULL,
    "CompanyName" text NOT NULL,
    "ProductName" text NOT NULL,
    "ProductPrice" text NOT NULL,
    "Coin" text NOT NULL,
    "Unit" text NOT NULL,
    "Group" text NOT NULL,
    "Code" text NOT NULL,
    "Logo" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.show_print_defaults OWNER TO orientlimraerp_karim;

--
-- Name: show_print_defaults_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.show_print_defaults_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.show_print_defaults_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: show_print_defaults_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.show_print_defaults_id_seq OWNED BY public.show_print_defaults.id;


--
-- Name: social_media; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.social_media (
    id bigint NOT NULL,
    "Facebook" character varying(191),
    "Twitter" character varying(191),
    "Instagram" character varying(191),
    "Youtube" character varying(191),
    "Snapchat" character varying(191),
    "Whatsapp" character varying(191),
    "Google_Plus" character varying(191),
    "LinkedIn" character varying(191),
    "Pinterest" character varying(191),
    "Telegram" character varying(191),
    "iOS" character varying(191),
    "Android" character varying(191),
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.social_media OWNER TO orientlimraerp_karim;

--
-- Name: social_media_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.social_media_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.social_media_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: social_media_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.social_media_id_seq OWNED BY public.social_media.id;


--
-- Name: special_cases; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.special_cases (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Discount" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.special_cases OWNER TO orientlimraerp_karim;

--
-- Name: special_cases_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.special_cases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.special_cases_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: special_cases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.special_cases_id_seq OWNED BY public.special_cases.id;


--
-- Name: spend_profits; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.spend_profits (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Amount" text NOT NULL,
    "Remaining_Profit" text NOT NULL,
    "Partner" bigint NOT NULL,
    "Safe" bigint NOT NULL,
    "Coin" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Payment_Method" text
);


ALTER TABLE public.spend_profits OWNER TO orientlimraerp_karim;

--
-- Name: spend_profits_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.spend_profits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.spend_profits_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: spend_profits_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.spend_profits_id_seq OWNED BY public.spend_profits.id;


--
-- Name: start_periods; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.start_periods (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Note" text,
    "Total_Products" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Store" bigint,
    "Coin" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Time" text,
    "Branch" text,
    "Edit" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.start_periods OWNER TO orientlimraerp_karim;

--
-- Name: start_periods_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.start_periods_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.start_periods_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: start_periods_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.start_periods_arr_seq OWNED BY public.start_periods.arr;


--
-- Name: start_periods_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.start_periods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.start_periods_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: start_periods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.start_periods_id_seq OWNED BY public.start_periods.id;


--
-- Name: store_count_sales; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.store_count_sales (
    id bigint NOT NULL,
    "Store" text NOT NULL,
    "Total" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Tax" text
);


ALTER TABLE public.store_count_sales OWNER TO orientlimraerp_karim;

--
-- Name: store_count_sales_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.store_count_sales_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_count_sales_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: store_count_sales_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.store_count_sales_id_seq OWNED BY public.store_count_sales.id;


--
-- Name: store_counts; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.store_counts (
    id bigint NOT NULL,
    "Store" text NOT NULL,
    "Total" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Tax" text
);


ALTER TABLE public.store_counts OWNER TO orientlimraerp_karim;

--
-- Name: store_counts_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.store_counts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_counts_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: store_counts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.store_counts_id_seq OWNED BY public.store_counts.id;


--
-- Name: store_transfer_filter_twos; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.store_transfer_filter_twos (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Total" text,
    "TotalQty" text,
    "Note" text,
    "From_Store" text,
    "To_Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "Ship" text,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.store_transfer_filter_twos OWNER TO orientlimraerp_karim;

--
-- Name: store_transfer_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.store_transfer_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_transfer_filter_twos_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: store_transfer_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.store_transfer_filter_twos_id_seq OWNED BY public.store_transfer_filter_twos.id;


--
-- Name: store_transfer_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.store_transfer_filters (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Draw" text,
    "Total" text,
    "TotalQty" text,
    "Note" text,
    "From_Store" text,
    "To_Store" text,
    "Coin" text,
    "Cost_Center" text,
    "User" text,
    "Status" text,
    "Ship" text,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Delegate" text,
    "Time" text,
    "Type" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.store_transfer_filters OWNER TO orientlimraerp_karim;

--
-- Name: store_transfer_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.store_transfer_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_transfer_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: store_transfer_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.store_transfer_filters_id_seq OWNED BY public.store_transfer_filters.id;


--
-- Name: stores; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stores (
    id bigint NOT NULL,
    "Date" text NOT NULL,
    "Time" text NOT NULL,
    "Name" text NOT NULL,
    "Phone" text,
    "Address" text,
    "Account" bigint NOT NULL,
    "User" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Code" text,
    "Branch" bigint,
    "Letter" text,
    "Account_Client" text,
    "NameEn" text
);


ALTER TABLE public.stores OWNER TO orientlimraerp_karim;

--
-- Name: stores_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_arr_seq OWNED BY public.stores."Code";


--
-- Name: stores_default_data; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stores_default_data (
    id bigint NOT NULL,
    "Group" bigint,
    "Unit" bigint,
    "Tax" bigint,
    "Coin" bigint,
    "Account_Excess" bigint,
    "Account_Dificit" bigint,
    "Store" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text,
    "Style" text,
    "StoresTarnsferPrice" text,
    "Guide_Product_Cost" text,
    "Client_Store_Account" text,
    "Show_Ship" text,
    "StoresTarnsferHide" text,
    "CodeType" text,
    "ReturnStoresTransfer" text,
    "Cost_Price" text,
    "Hide_Product" text,
    "StartPeriod_Show_Product" text
);


ALTER TABLE public.stores_default_data OWNER TO orientlimraerp_karim;

--
-- Name: stores_default_data_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_default_data_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_default_data_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_default_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_default_data_id_seq OWNED BY public.stores_default_data.id;


--
-- Name: stores_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_id_seq OWNED BY public.stores.id;


--
-- Name: stores_moves; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stores_moves (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Type" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Ship" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Store" bigint,
    "Cost_Center" bigint,
    "User" bigint,
    "Coin" bigint,
    "Account" bigint,
    "Safe" bigint,
    "TypeEn" text,
    "Delete" text DEFAULT 0,
    "Edit" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.stores_moves OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stores_moves_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_columns OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_moves_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_moves_columns_id_seq OWNED BY public.stores_moves_columns.id;


--
-- Name: stores_moves_columns_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stores_moves_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_columns_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_moves_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_columns_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_moves_columns_sechdules_id_seq OWNED BY public.stores_moves_columns_sechdules.id;


--
-- Name: stores_moves_filter_twos; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stores_moves_filter_twos (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_filter_twos OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_filter_twos_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_moves_filter_twos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_filter_twos_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_filter_twos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_moves_filter_twos_id_seq OWNED BY public.stores_moves_filter_twos.id;


--
-- Name: stores_moves_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stores_moves_filters (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Branch" text,
    "Store" text,
    "Safe" text,
    "Type" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Note" text,
    "Total_Qty" text,
    "Total_Price" text,
    "Account" text,
    "Ship" text,
    "ID" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.stores_moves_filters OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_moves_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_moves_filters_id_seq OWNED BY public.stores_moves_filters.id;


--
-- Name: stores_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_moves_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_moves_id_seq OWNED BY public.stores_moves.id;


--
-- Name: stores_transfer_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stores_transfer_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Store" text,
    "To_Store" text,
    "User" text,
    "Coin" text,
    "Shipping" text,
    "Note" text,
    "Delegate" text,
    "Product_Name" text,
    "Product_Code" text,
    "Group" text,
    "Brand" text,
    "Qty" text,
    "Price" text,
    "Trans_Qty" text,
    "Unit" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.stores_transfer_columns OWNER TO orientlimraerp_karim;

--
-- Name: stores_transfer_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_transfer_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_transfer_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_transfer_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_transfer_columns_id_seq OWNED BY public.stores_transfer_columns.id;


--
-- Name: stores_transfer_columns_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stores_transfer_columns_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Amount" text,
    "From_Store" text,
    "To_Store" text,
    "User" text,
    "Coin" text,
    "Shipping" text,
    "Note" text,
    "Delegate" text,
    "Product_Name" text,
    "Product_Code" text,
    "Group" text,
    "Brand" text,
    "Qty" text,
    "Price" text,
    "Trans_Qty" text,
    "Unit" text,
    "Total" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Branch" text
);


ALTER TABLE public.stores_transfer_columns_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: stores_transfer_columns_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stores_transfer_columns_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_transfer_columns_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stores_transfer_columns_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stores_transfer_columns_sechdules_id_seq OWNED BY public.stores_transfer_columns_sechdules.id;


--
-- Name: stors_transfers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.stors_transfers (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Date" text NOT NULL,
    "Draw" text NOT NULL,
    "Total" text NOT NULL,
    "Note" text,
    "From_Store" bigint NOT NULL,
    "To_Store" bigint NOT NULL,
    "Coin" bigint NOT NULL,
    "Cost_Center" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "TotalQty" text,
    "Status" text DEFAULT 0,
    "CostShip" text,
    "RecivedShip" text,
    "OldQty" text,
    "Edit" text,
    "Time" text,
    "Branch" text,
    "Total_Cost" text,
    "TypeTransfer" text,
    "Cost_Store" text,
    "Delegate" bigint,
    "Ship" bigint,
    "File" text,
    "Edit_t" text DEFAULT 0,
    "Delete" text DEFAULT 0,
    "Edit_New_Code" text DEFAULT 0
);


ALTER TABLE public.stors_transfers OWNER TO orientlimraerp_karim;

--
-- Name: stors_transfers_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stors_transfers_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stors_transfers_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: stors_transfers_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stors_transfers_arr_seq OWNED BY public.stors_transfers.arr;


--
-- Name: stors_transfers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.stors_transfers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stors_transfers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: stors_transfers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.stors_transfers_id_seq OWNED BY public.stors_transfers.id;


--
-- Name: student_groups; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.student_groups (
    id bigint NOT NULL,
    "Image" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Arabic_Desc" text,
    "English_Desc" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.student_groups OWNER TO orientlimraerp_karim;

--
-- Name: student_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.student_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_groups_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: student_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.student_groups_id_seq OWNED BY public.student_groups.id;


--
-- Name: student_importants; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.student_importants (
    id bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Student" text,
    "Course" text
);


ALTER TABLE public.student_importants OWNER TO orientlimraerp_karim;

--
-- Name: student_importants_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.student_importants_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.student_importants_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: student_importants_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.student_importants_id_seq OWNED BY public.student_importants.id;


--
-- Name: students; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.students (
    id bigint NOT NULL,
    "Code" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Group" text,
    "Phone1" text,
    "Phone2" text,
    "Dad_Phone" text,
    "Mom_Phone" text,
    "Special_Case" text,
    "Case" text,
    "Email" text,
    "Whatsapp" text,
    "Age" text,
    "Gov" text,
    "City" text,
    "Place" text,
    "Nationality" text,
    "Address" text,
    "Profession" text,
    "Ntional_ID" text,
    "Account" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.students OWNER TO orientlimraerp_karim;

--
-- Name: students_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.students_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.students_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.students_id_seq OWNED BY public.students.id;


--
-- Name: sub_images; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sub_images (
    id bigint NOT NULL,
    "Image" text NOT NULL,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sub_images OWNER TO orientlimraerp_karim;

--
-- Name: sub_images_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sub_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sub_images_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sub_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sub_images_id_seq OWNED BY public.sub_images.id;


--
-- Name: sub_virables; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sub_virables (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    "V_ID" bigint NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.sub_virables OWNER TO orientlimraerp_karim;

--
-- Name: sub_virables_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sub_virables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sub_virables_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sub_virables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sub_virables_id_seq OWNED BY public.sub_virables.id;


--
-- Name: subscribe_types; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.subscribe_types (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.subscribe_types OWNER TO orientlimraerp_karim;

--
-- Name: subscribe_types_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.subscribe_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.subscribe_types_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: subscribe_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.subscribe_types_id_seq OWNED BY public.subscribe_types.id;


--
-- Name: sup_pages_e_com_designs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sup_pages_e_com_designs (
    id bigint NOT NULL,
    "About_Title_Color" text,
    "About_Txt_Color" text,
    "Blogs_Title_Color" text,
    "Blogs_Txt_Color" text,
    "Blogs_Hover_Txt_Color" text,
    "Contact_Title_Color" text,
    "Contact_Txt_Color" text,
    "Contact_Form_Input_Border_Color" text,
    "Contact_Form_Input_Txt_Color" text,
    "Contact_Form_Button_BG_Color" text,
    "Contact_Form_Button_Txt_Color" text,
    "Contact_Form_Button_Hover_BG_Color" text,
    "Contact_Form_Button_Hover_Txt_Color" text,
    "Faq_Title_Color" text,
    "Faq_Q_BG_Color" text,
    "Faq_Q_Txt_Color" text,
    "Faq_A_Line_Color" text,
    "Faq_A_BG_Color" text,
    "Faq_A_Txt_Color" text,
    "MyAccount_Box_BG_Color" text,
    "MyAccount_Box_Button_BG_Color" text,
    "MyAccount_Box_Button_Txt_Color" text,
    "MyAccount_Box_Button_Hover_BG_Color" text,
    "MyAccount_Box_Button_Hover_Txt_Color" text,
    "MyAccount_Box_Input_Border_Color" text,
    "MyAccount_Box_Input_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sup_pages_e_com_designs OWNER TO orientlimraerp_karim;

--
-- Name: sup_pages_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sup_pages_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sup_pages_e_com_designs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sup_pages_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sup_pages_e_com_designs_id_seq OWNED BY public.sup_pages_e_com_designs.id;


--
-- Name: sup_pages_part_two_e_com_designs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sup_pages_part_two_e_com_designs (
    id bigint NOT NULL,
    "Shop_Product_BG_Color" text,
    "Shop_Product_Group_BG_Color" text,
    "Shop_Product_Group_Txt_Color" text,
    "Shop_Product_Group_Hover_BG_Color" text,
    "Shop_Product_Group_Hover_Txt_Color" text,
    "Shop_Product_Icon_BG_Color" text,
    "Shop_Product_Icon_Txt_Color" text,
    "Shop_Product_Icon_Hover_BG_Color" text,
    "Shop_Product_Icon_Hover_Txt_Color" text,
    "Shop_Product_Txt_Color" text,
    "Shop_Product_Price_Color" text,
    "Shop_Product_Rate_Color" text,
    "Shop_Filter_Title_Color" text,
    "Shop_Filter_Txt_Color" text,
    "Shop_Filter_Search_BG_Color" text,
    "Shop_Filter_Search_Icon_BG_Color" text,
    "Shop_Filter_Search_Icon_Txt_Color" text,
    "Shop_Filter_Search_Icon_BG_Hover_Color" text,
    "Shop_Filter_Search_Icon_Txt_Hover_Color" text,
    "Cart_Button_BG_Color" text,
    "Cart_Button_Txt_Color" text,
    "Cart_Button_BG_Hover_Color" text,
    "Cart_Button_Txt_Hover_Color" text,
    "Cart_Box_BG_Color" text,
    "Cart_Box_Title_Color" text,
    "Cart_Box_Txt_Color" text,
    "Cart_Box_Button_BG_Color" text,
    "Cart_Box_Button_Txt_Color" text,
    "Cart_Box_Button_BG_Hover_Color" text,
    "Cart_Box_Button_Txt_Hover_Color" text,
    "Cart_Cupon_Button_BG_Color" text,
    "Cart_Cupon_Button_Txt_Color" text,
    "Cart_Cupon_Button_BG_Hover_Color" text,
    "Cart_Cupon_Button_Txt_Hover_Color" text,
    "Cart_Cupon_Input_BG_Color" text,
    "Checkout_Box_BG_Color" text,
    "Checkout_Box_Title_Color" text,
    "Checkout_Box_Txt_Color" text,
    "Checkout_Box_Button_BG_Color" text,
    "Checkout_Box_Button_Txt_Color" text,
    "Checkout_Box_Button_BG_Hover_Color" text,
    "Checkout_Box_Button_Txt_Hover_Color" text,
    "Checkout_Head_BG_Color" text,
    "Checkout_Head_Txt_Color" text,
    "Checkout_Input_BG_Color" text,
    "Checkout_Input_Txt_Color" text,
    "Reg_Login_Form_Box_BG_Color" text,
    "Reg_Login_Form_Box_Title_Color" text,
    "Reg_Login_Form_Box_Txt_Color" text,
    "Reg_Login_Form_Box_Txt_Hover_Color" text,
    "Reg_Login_Form_Box_Input_Border_Color" text,
    "Reg_Login_Form_Box_Button_BG_Color" text,
    "Reg_Login_Form_Box_Button_Txt_Color" text,
    "Reg_Login_Form_Box_Button_BG_Hover_Color" text,
    "Reg_Login_Form_Box_Button_Txt_Hover_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sup_pages_part_two_e_com_designs OWNER TO orientlimraerp_karim;

--
-- Name: sup_pages_part_two_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sup_pages_part_two_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sup_pages_part_two_e_com_designs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sup_pages_part_two_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sup_pages_part_two_e_com_designs_id_seq OWNED BY public.sup_pages_part_two_e_com_designs.id;


--
-- Name: sup_pages_wish_comp_e_com_designs; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.sup_pages_wish_comp_e_com_designs (
    id bigint NOT NULL,
    "Wish_Title_BG_Color" text,
    "Wish_Title_Txt_Color" text,
    "Wish_Box_BG_Color" text,
    "Wish_Box_Border_Color" text,
    "Wish_Box_Border_Type" text,
    "Wish_Box_Txt_Color" text,
    "Wish_Box_Button_BG_Color" text,
    "Wish_Box_Button_Txt_Color" text,
    "Wish_Box_Button_BG_Hover_Color" text,
    "Wish_Box_Button_Txt_Hover_Color" text,
    "Compare_Box_BG_Color" text,
    "Compare_Box_Txt_Color" text,
    "Compare_Box_Price_Hover_Color" text,
    "Compare_Box_Delete_Txt_Color" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.sup_pages_wish_comp_e_com_designs OWNER TO orientlimraerp_karim;

--
-- Name: sup_pages_wish_comp_e_com_designs_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.sup_pages_wish_comp_e_com_designs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sup_pages_wish_comp_e_com_designs_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: sup_pages_wish_comp_e_com_designs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.sup_pages_wish_comp_e_com_designs_id_seq OWNED BY public.sup_pages_wish_comp_e_com_designs.id;


--
-- Name: taxes; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.taxes (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Rate" text NOT NULL,
    "Type" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Hide" character varying DEFAULT 0,
    "Account" bigint,
    arr bigint,
    "CodeTax" text,
    "SubType" text,
    "NameEn" text
);


ALTER TABLE public.taxes OWNER TO orientlimraerp_karim;

--
-- Name: taxes_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.taxes_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.taxes_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: taxes_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.taxes_arr_seq OWNED BY public.taxes.arr;


--
-- Name: taxes_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.taxes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.taxes_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: taxes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.taxes_id_seq OWNED BY public.taxes.id;


--
-- Name: teachers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.teachers (
    id bigint NOT NULL,
    "Code" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Image" text,
    "Work_Type" text,
    "Hour_Price" text,
    "Qualification" text,
    "Qualification_Attach" text,
    "National_ID" text,
    "National_ID_Attach" text,
    "CV" text,
    "Nationality" text,
    "Gov" text,
    "City" text,
    "Place" text,
    "Address" text,
    "Age" text,
    "Phone1" text,
    "Phone2" text,
    "Whatsapp" text,
    "Facebook" text,
    "Instagram" text,
    "Linked" text,
    "Telegram" text,
    "Arabic_Bio" text,
    "English_Bio" text,
    "Marital_Status" text,
    "Account" text,
    "Covenant" text,
    "Commission" text,
    "Merit" text,
    "Account_Emp" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teachers OWNER TO orientlimraerp_karim;

--
-- Name: teachers_groups; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.teachers_groups (
    id bigint NOT NULL,
    "Teacher" text,
    "Group" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teachers_groups OWNER TO orientlimraerp_karim;

--
-- Name: teachers_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.teachers_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teachers_groups_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: teachers_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.teachers_groups_id_seq OWNED BY public.teachers_groups.id;


--
-- Name: teachers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.teachers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teachers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: teachers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.teachers_id_seq OWNED BY public.teachers.id;


--
-- Name: teachers_subjects; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.teachers_subjects (
    id bigint NOT NULL,
    "Teacher" text,
    "Subject" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.teachers_subjects OWNER TO orientlimraerp_karim;

--
-- Name: teachers_subjects_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.teachers_subjects_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.teachers_subjects_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: teachers_subjects_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.teachers_subjects_id_seq OWNED BY public.teachers_subjects.id;


--
-- Name: tenants; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.tenants (
    id character varying(191) NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    data json
);


ALTER TABLE public.tenants OWNER TO orientlimraerp_karim;

--
-- Name: terms; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.terms (
    id bigint NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Desc" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.terms OWNER TO orientlimraerp_karim;

--
-- Name: terms_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.terms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.terms_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: terms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.terms_id_seq OWNED BY public.terms.id;


--
-- Name: terms_maintainces; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.terms_maintainces (
    id bigint NOT NULL,
    "Desc_Work" text NOT NULL,
    "Desc_Not_Work" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Desc_Work_En" text,
    "Desc_Not_Work_En" text
);


ALTER TABLE public.terms_maintainces OWNER TO orientlimraerp_karim;

--
-- Name: terms_maintainces_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.terms_maintainces_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.terms_maintainces_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: terms_maintainces_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.terms_maintainces_id_seq OWNED BY public.terms_maintainces.id;


--
-- Name: testclients; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.testclients (
    id bigint NOT NULL,
    "Name" text,
    "Governrate" text,
    "City" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.testclients OWNER TO orientlimraerp_karim;

--
-- Name: testclients_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.testclients_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.testclients_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: testclients_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.testclients_id_seq OWNED BY public.testclients.id;


--
-- Name: ticket_products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.ticket_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Price" text,
    "Weight" text,
    "Length" text,
    "Width" text,
    "Height" text,
    "Qty" text,
    "Unit" text,
    "Total" text,
    "Store" text,
    "Product" text,
    "Ticket" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.ticket_products OWNER TO orientlimraerp_karim;

--
-- Name: ticket_products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.ticket_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ticket_products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: ticket_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.ticket_products_id_seq OWNED BY public.ticket_products.id;


--
-- Name: tickets; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.tickets (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Payment_Method" text,
    "Sender_Name" text,
    "Sender_Address" text,
    "Sender_Phone" text,
    "Addressees_Name" text,
    "Addressees_Address" text,
    "Addressees_Phone" text,
    "Notes" text,
    "Sub_Total" text,
    "Discount" text,
    "Total" text,
    "Store" text,
    "Safe" text,
    "Recived" text,
    "Selected" text,
    "Coin" text,
    "Draw" text,
    "Product_Numbers" text,
    "Total_Qty" text,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Access_Area" text
);


ALTER TABLE public.tickets OWNER TO orientlimraerp_karim;

--
-- Name: tickets_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.tickets_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tickets_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: tickets_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.tickets_arr_seq OWNED BY public.tickets.arr;


--
-- Name: tickets_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.tickets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tickets_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: tickets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.tickets_id_seq OWNED BY public.tickets.id;


--
-- Name: translation_tourism_companies; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.translation_tourism_companies (
    id bigint NOT NULL,
    "Arabic_Name" text,
    "English_Name" text,
    "Precent" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.translation_tourism_companies OWNER TO orientlimraerp_karim;

--
-- Name: translation_tourism_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.translation_tourism_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translation_tourism_companies_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: translation_tourism_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.translation_tourism_companies_id_seq OWNED BY public.translation_tourism_companies.id;


--
-- Name: translte_modules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.translte_modules (
    id bigint NOT NULL,
    "Code" text,
    "Date" text,
    "Arabic_Name" text,
    "English_Name" text,
    "Lang" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.translte_modules OWNER TO orientlimraerp_karim;

--
-- Name: translte_modules_details; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.translte_modules_details (
    id bigint NOT NULL,
    "Arabic_Text" text,
    "Translate_Text" text,
    "Module" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.translte_modules_details OWNER TO orientlimraerp_karim;

--
-- Name: translte_modules_details_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.translte_modules_details_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translte_modules_details_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: translte_modules_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.translte_modules_details_id_seq OWNED BY public.translte_modules_details.id;


--
-- Name: translte_modules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.translte_modules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.translte_modules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: translte_modules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.translte_modules_id_seq OWNED BY public.translte_modules.id;


--
-- Name: transltors; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.transltors (
    id bigint NOT NULL,
    "Original_Name" text NOT NULL,
    "New_Arabic_Name" text NOT NULL,
    "New_English_Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.transltors OWNER TO orientlimraerp_karim;

--
-- Name: transltors_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.transltors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transltors_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: transltors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.transltors_id_seq OWNED BY public.transltors.id;


--
-- Name: update_values_investors; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.update_values_investors (
    id bigint NOT NULL,
    "Date" text,
    "Valye" text,
    "Investor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.update_values_investors OWNER TO orientlimraerp_karim;

--
-- Name: update_values_investors_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.update_values_investors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.update_values_investors_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: update_values_investors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.update_values_investors_id_seq OWNED BY public.update_values_investors.id;


--
-- Name: upload_accountings; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.upload_accountings (
    id bigint NOT NULL,
    "Name" text,
    "Type" text,
    "Parent" text,
    "Note" text,
    "User" text,
    "Account_Code" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.upload_accountings OWNER TO orientlimraerp_karim;

--
-- Name: upload_accountings_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.upload_accountings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.upload_accountings_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: upload_accountings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.upload_accountings_id_seq OWNED BY public.upload_accountings.id;


--
-- Name: users_moves; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.users_moves (
    id bigint NOT NULL,
    "User" bigint NOT NULL,
    "Date" text NOT NULL,
    "Time" text NOT NULL,
    "Screen" text NOT NULL,
    "Type" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Explain" text,
    "ScreenEn" text,
    "TypeEn" text,
    "ExplainEn" text
);


ALTER TABLE public.users_moves OWNER TO orientlimraerp_karim;

--
-- Name: users_moves_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.users_moves_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_moves_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: users_moves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.users_moves_id_seq OWNED BY public.users_moves.id;


--
-- Name: v_a_prices; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.v_a_prices (
    id bigint NOT NULL,
    "Price" text,
    "MainV" bigint,
    "SubV" bigint,
    "Product" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Offer_Price" text,
    "Added" text,
    "VAProductID" text
);


ALTER TABLE public.v_a_prices OWNER TO orientlimraerp_karim;

--
-- Name: v_a_prices_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.v_a_prices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.v_a_prices_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: v_a_prices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.v_a_prices_id_seq OWNED BY public.v_a_prices.id;


--
-- Name: v_a_products; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.v_a_products (
    id bigint NOT NULL,
    "Product_Code" text,
    "P_Ar_Name" text,
    "P_En_Name" text,
    "Unit" text,
    "Product" bigint,
    "ProductID" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.v_a_products OWNER TO orientlimraerp_karim;

--
-- Name: v_a_products_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.v_a_products_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.v_a_products_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: v_a_products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.v_a_products_id_seq OWNED BY public.v_a_products.id;


--
-- Name: v_a_qties; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.v_a_qties (
    id bigint NOT NULL,
    "Qty" text,
    "MainV" bigint,
    "SubV" bigint,
    "Product" bigint,
    "ProductID" bigint,
    "VAProductID" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.v_a_qties OWNER TO orientlimraerp_karim;

--
-- Name: v_a_qties_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.v_a_qties_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.v_a_qties_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: v_a_qties_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.v_a_qties_id_seq OWNED BY public.v_a_qties.id;


--
-- Name: vendor_account_statement_column_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.vendor_account_statement_column_sechdules (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.vendor_account_statement_column_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: vendor_account_statement_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.vendor_account_statement_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_account_statement_column_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: vendor_account_statement_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.vendor_account_statement_column_sechdules_id_seq OWNED BY public.vendor_account_statement_column_sechdules.id;


--
-- Name: vendor_account_statement_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.vendor_account_statement_columns (
    id bigint NOT NULL,
    "Date" text,
    "Code" text,
    "Time" text,
    "Refrence_Number" text,
    "Branch" text,
    "Store" text,
    "Payment_Method" text,
    "Safe" text,
    "Type" text,
    "Shipping" text,
    "Cost_Center" text,
    "User" text,
    "Coin" text,
    "Due_Date" text,
    "Delegate" text,
    "Note" text,
    "Total_Return" text,
    "Total_Price" text,
    "Total_Discount" text,
    "Total_Tax" text,
    "Total_Net" text,
    "Paid" text,
    "Residual" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "ShiftCode" text,
    "Executor" text
);


ALTER TABLE public.vendor_account_statement_columns OWNER TO orientlimraerp_karim;

--
-- Name: vendor_account_statement_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.vendor_account_statement_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_account_statement_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: vendor_account_statement_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.vendor_account_statement_columns_id_seq OWNED BY public.vendor_account_statement_columns.id;


--
-- Name: vendor_filters; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.vendor_filters (
    id bigint NOT NULL,
    "Product" text NOT NULL,
    "Code" text,
    "Name" text,
    "VName" text,
    "VVName" text,
    "V1" text,
    "V2" text,
    "Qty" text,
    "Price" text,
    "Total" text,
    "Vendor" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendor_filters OWNER TO orientlimraerp_karim;

--
-- Name: vendor_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.vendor_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendor_filters_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: vendor_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.vendor_filters_id_seq OWNED BY public.vendor_filters.id;


--
-- Name: vendors; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.vendors (
    id bigint NOT NULL,
    "Code" text NOT NULL,
    "Name" text NOT NULL,
    "Phone" text,
    "Phone2" text,
    "Commercial_Register" text,
    "Tax_Card" text,
    "Price_Level" text,
    "Account" bigint,
    "User" bigint,
    arr bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Tax_Registration_Number" text,
    "Tax_activity_code" text,
    work_nature text,
    "Buliding_Num" text,
    "Street" text,
    "Postal_Code" text,
    tax_magistrate text,
    "Floor" text,
    "Room" text,
    "Landmark" text,
    "Add_Info" text,
    "City" bigint,
    "Place" bigint,
    "Nationality" bigint,
    "Responsible" bigint,
    "Pro_Group" bigint,
    "Brand" bigint,
    "Governrate" bigint,
    "NameEn" text,
    "SearchCode" text,
    "Credit_Limit" text
);


ALTER TABLE public.vendors OWNER TO orientlimraerp_karim;

--
-- Name: vendors_arr_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.vendors_arr_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_arr_seq OWNER TO orientlimraerp_karim;

--
-- Name: vendors_arr_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.vendors_arr_seq OWNED BY public.vendors.arr;


--
-- Name: vendors_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.vendors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: vendors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.vendors_id_seq OWNED BY public.vendors.id;


--
-- Name: vendors_statements_column_sechdules; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.vendors_statements_column_sechdules (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendors_statements_column_sechdules OWNER TO orientlimraerp_karim;

--
-- Name: vendors_statements_column_sechdules_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.vendors_statements_column_sechdules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_statements_column_sechdules_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: vendors_statements_column_sechdules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.vendors_statements_column_sechdules_id_seq OWNED BY public.vendors_statements_column_sechdules.id;


--
-- Name: vendors_statements_columns; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.vendors_statements_columns (
    id bigint NOT NULL,
    "Account_Code" text,
    "Account_Name" text,
    "Debiator_Before" text,
    "Creditor_Before" text,
    "Total_Debitor" text,
    "Total_Creditor" text,
    "Debitor_Balance" text,
    "Creditor_Balance" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vendors_statements_columns OWNER TO orientlimraerp_karim;

--
-- Name: vendors_statements_columns_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.vendors_statements_columns_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vendors_statements_columns_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: vendors_statements_columns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.vendors_statements_columns_id_seq OWNED BY public.vendors_statements_columns.id;


--
-- Name: virables; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.virables (
    id bigint NOT NULL,
    "Name" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "NameEn" text
);


ALTER TABLE public.virables OWNER TO orientlimraerp_karim;

--
-- Name: virables_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.virables_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.virables_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: virables_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.virables_id_seq OWNED BY public.virables.id;


--
-- Name: vouchers; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.vouchers (
    id bigint NOT NULL,
    "Draw" text,
    "Coin" text,
    "Safe" text,
    "Debitor" text,
    "Creditor" text,
    "Account" text,
    "Statement" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.vouchers OWNER TO orientlimraerp_karim;

--
-- Name: vouchers_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.vouchers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.vouchers_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: vouchers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.vouchers_id_seq OWNED BY public.vouchers.id;


--
-- Name: web_sliders; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.web_sliders (
    id bigint NOT NULL,
    "Status" character varying(191) NOT NULL,
    "Arabic_Title" text NOT NULL,
    "English_Title" text NOT NULL,
    "Arabic_Desc" text NOT NULL,
    "English_Desc" text NOT NULL,
    "Image" text NOT NULL,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Type" text
);


ALTER TABLE public.web_sliders OWNER TO orientlimraerp_karim;

--
-- Name: web_sliders_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.web_sliders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.web_sliders_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: web_sliders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.web_sliders_id_seq OWNED BY public.web_sliders.id;


--
-- Name: wishlists; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.wishlists (
    id bigint NOT NULL,
    "Product" bigint,
    "User" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.wishlists OWNER TO orientlimraerp_karim;

--
-- Name: wishlists_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.wishlists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.wishlists_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: wishlists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.wishlists_id_seq OWNED BY public.wishlists.id;


--
-- Name: work_departments; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.work_departments (
    id bigint NOT NULL,
    "Arabic_Name" text NOT NULL,
    "English_Name" text,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone,
    "Parent" text,
    "Budget" text
);


ALTER TABLE public.work_departments OWNER TO orientlimraerp_karim;

--
-- Name: work_departments_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.work_departments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.work_departments_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: work_departments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.work_departments_id_seq OWNED BY public.work_departments.id;


--
-- Name: workers_sales_petrols; Type: TABLE; Schema: public; Owner: orientlimraerp_karim
--

CREATE TABLE public.workers_sales_petrols (
    id bigint NOT NULL,
    "Worker" bigint,
    "SalesPetrol" bigint,
    created_at timestamp(0) without time zone,
    updated_at timestamp(0) without time zone
);


ALTER TABLE public.workers_sales_petrols OWNER TO orientlimraerp_karim;

--
-- Name: workers_sales_petrols_id_seq; Type: SEQUENCE; Schema: public; Owner: orientlimraerp_karim
--

CREATE SEQUENCE public.workers_sales_petrols_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.workers_sales_petrols_id_seq OWNER TO orientlimraerp_karim;

--
-- Name: workers_sales_petrols_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: orientlimraerp_karim
--

ALTER SEQUENCE public.workers_sales_petrols_id_seq OWNED BY public.workers_sales_petrols.id;


--
-- Name: a_v_pro_check_qties id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.a_v_pro_check_qties ALTER COLUMN id SET DEFAULT nextval('public.a_v_pro_check_qties_id_seq'::regclass);


--
-- Name: abouts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.abouts ALTER COLUMN id SET DEFAULT nextval('public.abouts_id_seq'::regclass);


--
-- Name: acccounting_manuals id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.acccounting_manuals ALTER COLUMN id SET DEFAULT nextval('public.acccounting_manuals_id_seq'::regclass);


--
-- Name: accounts_default_data id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.accounts_default_data ALTER COLUMN id SET DEFAULT nextval('public.accounts_default_data_id_seq'::regclass);


--
-- Name: activites id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.activites ALTER COLUMN id SET DEFAULT nextval('public.activites_id_seq'::regclass);


--
-- Name: add_translates id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.add_translates ALTER COLUMN id SET DEFAULT nextval('public.add_translates_id_seq'::regclass);


--
-- Name: additional_products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.additional_products ALTER COLUMN id SET DEFAULT nextval('public.additional_products_id_seq'::regclass);


--
-- Name: addressses id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.addressses ALTER COLUMN id SET DEFAULT nextval('public.addressses_id_seq'::regclass);


--
-- Name: admins id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.admins ALTER COLUMN id SET DEFAULT nextval('public.admins_id_seq'::regclass);


--
-- Name: all_groups id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.all_groups ALTER COLUMN id SET DEFAULT nextval('public.all_groups_id_seq'::regclass);


--
-- Name: allowences_emps id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.allowences_emps ALTER COLUMN id SET DEFAULT nextval('public.allowences_emps_id_seq'::regclass);


--
-- Name: articles id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.articles ALTER COLUMN id SET DEFAULT nextval('public.articles_id_seq'::regclass);


--
-- Name: assembly_products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.assembly_products ALTER COLUMN id SET DEFAULT nextval('public.assembly_products_id_seq'::regclass);


--
-- Name: assets id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.assets ALTER COLUMN id SET DEFAULT nextval('public.assets_id_seq'::regclass);


--
-- Name: assets Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.assets ALTER COLUMN "Code" SET DEFAULT nextval('public.assets_arr_seq'::regclass);


--
-- Name: assets_expenses id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.assets_expenses ALTER COLUMN id SET DEFAULT nextval('public.assets_expenses_id_seq'::regclass);


--
-- Name: attend_departure_import id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.attend_departure_import ALTER COLUMN id SET DEFAULT nextval('public.attend_departure_import_id_seq'::regclass);


--
-- Name: attendance_emps id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.attendance_emps ALTER COLUMN id SET DEFAULT nextval('public.attendance_emps_id_seq'::regclass);


--
-- Name: attendances id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.attendances ALTER COLUMN id SET DEFAULT nextval('public.attendances_id_seq'::regclass);


--
-- Name: attendances Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.attendances ALTER COLUMN "Code" SET DEFAULT nextval('public.attendances_arr_seq'::regclass);


--
-- Name: attendence_policy_emps id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.attendence_policy_emps ALTER COLUMN id SET DEFAULT nextval('public.attendence_policy_emps_id_seq'::regclass);


--
-- Name: barcode_products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.barcode_products ALTER COLUMN id SET DEFAULT nextval('public.barcode_products_id_seq'::regclass);


--
-- Name: barcode_settings id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.barcode_settings ALTER COLUMN id SET DEFAULT nextval('public.barcode_settings_id_seq'::regclass);


--
-- Name: barcode_settings Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.barcode_settings ALTER COLUMN "Code" SET DEFAULT nextval('public.barcode_settings_arr_seq'::regclass);


--
-- Name: barcode_shows id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.barcode_shows ALTER COLUMN id SET DEFAULT nextval('public.barcode_shows_id_seq'::regclass);


--
-- Name: befroe_footers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.befroe_footers ALTER COLUMN id SET DEFAULT nextval('public.befroe_footers_id_seq'::regclass);


--
-- Name: beneftis_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.beneftis_types ALTER COLUMN id SET DEFAULT nextval('public.beneftis_types_id_seq'::regclass);


--
-- Name: bones_sales_petrols id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.bones_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.bones_sales_petrols_id_seq'::regclass);


--
-- Name: bones_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.bones_types ALTER COLUMN id SET DEFAULT nextval('public.bones_types_id_seq'::regclass);


--
-- Name: borrowas id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.borrowas ALTER COLUMN id SET DEFAULT nextval('public.borrowas_id_seq'::regclass);


--
-- Name: borrowas Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.borrowas ALTER COLUMN "Code" SET DEFAULT nextval('public.borrowas_arr_seq'::regclass);


--
-- Name: branches id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.branches ALTER COLUMN id SET DEFAULT nextval('public.branches_id_seq'::regclass);


--
-- Name: brands id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.brands ALTER COLUMN id SET DEFAULT nextval('public.brands_id_seq'::regclass);


--
-- Name: campaigns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.campaigns ALTER COLUMN id SET DEFAULT nextval('public.campaigns_id_seq'::regclass);


--
-- Name: capital_increases id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.capital_increases ALTER COLUMN id SET DEFAULT nextval('public.capital_increases_id_seq'::regclass);


--
-- Name: capitals id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.capitals ALTER COLUMN id SET DEFAULT nextval('public.capitals_id_seq'::regclass);


--
-- Name: cars_sales_petrols id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.cars_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.cars_sales_petrols_id_seq'::regclass);


--
-- Name: cart_stores id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.cart_stores ALTER COLUMN id SET DEFAULT nextval('public.cart_stores_id_seq'::regclass);


--
-- Name: chat_issues id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.chat_issues ALTER COLUMN id SET DEFAULT nextval('public.chat_issues_id_seq'::regclass);


--
-- Name: checks_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.checks_types ALTER COLUMN id SET DEFAULT nextval('public.checks_types_id_seq'::regclass);


--
-- Name: cities id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.cities ALTER COLUMN id SET DEFAULT nextval('public.cities_id_seq'::regclass);


--
-- Name: client_account_statement_column_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.client_account_statement_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.client_account_statement_column_sechdules_id_seq'::regclass);


--
-- Name: client_account_statement_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.client_account_statement_columns ALTER COLUMN id SET DEFAULT nextval('public.client_account_statement_columns_id_seq'::regclass);


--
-- Name: client_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.client_filters ALTER COLUMN id SET DEFAULT nextval('public.client_filters_id_seq'::regclass);


--
-- Name: client_sales_petrols id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.client_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.client_sales_petrols_id_seq'::regclass);


--
-- Name: client_statuses id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.client_statuses ALTER COLUMN id SET DEFAULT nextval('public.client_statuses_id_seq'::regclass);


--
-- Name: clients_statements_column_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.clients_statements_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.clients_statements_column_sechdules_id_seq'::regclass);


--
-- Name: clients_statements_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.clients_statements_columns ALTER COLUMN id SET DEFAULT nextval('public.clients_statements_columns_id_seq'::regclass);


--
-- Name: coins id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.coins ALTER COLUMN id SET DEFAULT nextval('public.coins_id_seq'::regclass);


--
-- Name: comments id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.comments ALTER COLUMN id SET DEFAULT nextval('public.comments_id_seq'::regclass);


--
-- Name: comments_clients id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.comments_clients ALTER COLUMN id SET DEFAULT nextval('public.comments_clients_id_seq'::regclass);


--
-- Name: company_cars id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.company_cars ALTER COLUMN id SET DEFAULT nextval('public.company_cars_id_seq'::regclass);


--
-- Name: company_data id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.company_data ALTER COLUMN id SET DEFAULT nextval('public.company_data_id_seq'::regclass);


--
-- Name: compare_prices_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.compare_prices_columns ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_columns_id_seq'::regclass);


--
-- Name: compare_prices_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.compare_prices_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_columns_sechdules_id_seq'::regclass);


--
-- Name: compare_prices_filter_twos id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.compare_prices_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_filter_twos_id_seq'::regclass);


--
-- Name: compare_prices_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.compare_prices_filters ALTER COLUMN id SET DEFAULT nextval('public.compare_prices_filters_id_seq'::regclass);


--
-- Name: compares id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.compares ALTER COLUMN id SET DEFAULT nextval('public.compares_id_seq'::regclass);


--
-- Name: competitors id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.competitors ALTER COLUMN id SET DEFAULT nextval('public.competitors_id_seq'::regclass);


--
-- Name: consist_maintainces id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.consist_maintainces ALTER COLUMN id SET DEFAULT nextval('public.consist_maintainces_id_seq'::regclass);


--
-- Name: consists id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.consists ALTER COLUMN id SET DEFAULT nextval('public.consists_id_seq'::regclass);


--
-- Name: consists Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.consists ALTER COLUMN "Code" SET DEFAULT nextval('public.consists_arr_seq'::regclass);


--
-- Name: contact_u_s id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.contact_u_s ALTER COLUMN id SET DEFAULT nextval('public.contact_u_s_id_seq'::regclass);


--
-- Name: cost_centers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.cost_centers ALTER COLUMN id SET DEFAULT nextval('public.cost_centers_id_seq'::regclass);


--
-- Name: counters_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.counters_types ALTER COLUMN id SET DEFAULT nextval('public.counters_types_id_seq'::regclass);


--
-- Name: countris id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.countris ALTER COLUMN id SET DEFAULT nextval('public.countris_id_seq'::regclass);


--
-- Name: coupon_codes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.coupon_codes ALTER COLUMN id SET DEFAULT nextval('public.coupon_codes_id_seq'::regclass);


--
-- Name: courses id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.courses ALTER COLUMN id SET DEFAULT nextval('public.courses_id_seq'::regclass);


--
-- Name: courses_categories id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.courses_categories ALTER COLUMN id SET DEFAULT nextval('public.courses_categories_id_seq'::regclass);


--
-- Name: courses_halls id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.courses_halls ALTER COLUMN id SET DEFAULT nextval('public.courses_halls_id_seq'::regclass);


--
-- Name: courses_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.courses_types ALTER COLUMN id SET DEFAULT nextval('public.courses_types_id_seq'::regclass);


--
-- Name: crm_default_data id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.crm_default_data ALTER COLUMN id SET DEFAULT nextval('public.crm_default_data_id_seq'::regclass);


--
-- Name: custom_prints id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.custom_prints ALTER COLUMN id SET DEFAULT nextval('public.custom_prints_id_seq'::regclass);


--
-- Name: customer_follow_ups id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.customer_follow_ups ALTER COLUMN id SET DEFAULT nextval('public.customer_follow_ups_id_seq'::regclass);


--
-- Name: customer_follow_ups Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.customer_follow_ups ALTER COLUMN "Code" SET DEFAULT nextval('public.customer_follow_ups_arr_seq'::regclass);


--
-- Name: customers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.customers ALTER COLUMN id SET DEFAULT nextval('public.customers_id_seq'::regclass);


--
-- Name: customers Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.customers ALTER COLUMN "Code" SET DEFAULT nextval('public.customers_arr_seq'::regclass);


--
-- Name: customers_files id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.customers_files ALTER COLUMN id SET DEFAULT nextval('public.customers_files_id_seq'::regclass);


--
-- Name: customers_groups id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.customers_groups ALTER COLUMN id SET DEFAULT nextval('public.customers_groups_id_seq'::regclass);


--
-- Name: customers_rate_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.customers_rate_types ALTER COLUMN id SET DEFAULT nextval('public.customers_rate_types_id_seq'::regclass);


--
-- Name: customers_tickets id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.customers_tickets ALTER COLUMN id SET DEFAULT nextval('public.customers_tickets_id_seq'::regclass);


--
-- Name: customers_tickets Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.customers_tickets ALTER COLUMN "Code" SET DEFAULT nextval('public.customers_tickets_arr_seq'::regclass);


--
-- Name: deducations_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.deducations_types ALTER COLUMN id SET DEFAULT nextval('public.deducations_types_id_seq'::regclass);


--
-- Name: deductions id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.deductions ALTER COLUMN id SET DEFAULT nextval('public.deductions_id_seq'::regclass);


--
-- Name: deductions Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.deductions ALTER COLUMN "Code" SET DEFAULT nextval('public.deductions_arr_seq'::regclass);


--
-- Name: default_data_show_hides id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.default_data_show_hides ALTER COLUMN id SET DEFAULT nextval('public.default_data_show_hides_id_seq'::regclass);


--
-- Name: depaarture_policy_emps id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.depaarture_policy_emps ALTER COLUMN id SET DEFAULT nextval('public.depaarture_policy_emps_id_seq'::regclass);


--
-- Name: departure_emps id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.departure_emps ALTER COLUMN id SET DEFAULT nextval('public.departure_emps_id_seq'::regclass);


--
-- Name: departures id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.departures ALTER COLUMN id SET DEFAULT nextval('public.departures_id_seq'::regclass);


--
-- Name: departures Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.departures ALTER COLUMN "Code" SET DEFAULT nextval('public.departures_arr_seq'::regclass);


--
-- Name: desvice_cases id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.desvice_cases ALTER COLUMN id SET DEFAULT nextval('public.desvice_cases_id_seq'::regclass);


--
-- Name: device_descrips id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.device_descrips ALTER COLUMN id SET DEFAULT nextval('public.device_descrips_id_seq'::regclass);


--
-- Name: devices_typesies id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.devices_typesies ALTER COLUMN id SET DEFAULT nextval('public.devices_typesies_id_seq'::regclass);


--
-- Name: disclaimers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.disclaimers ALTER COLUMN id SET DEFAULT nextval('public.disclaimers_id_seq'::regclass);


--
-- Name: discounts_emps id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.discounts_emps ALTER COLUMN id SET DEFAULT nextval('public.discounts_emps_id_seq'::regclass);


--
-- Name: emp_covenants id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emp_covenants ALTER COLUMN id SET DEFAULT nextval('public.emp_covenants_id_seq'::regclass);


--
-- Name: emp_excs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emp_excs ALTER COLUMN id SET DEFAULT nextval('public.emp_excs_id_seq'::regclass);


--
-- Name: emp_installment_details id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emp_installment_details ALTER COLUMN id SET DEFAULT nextval('public.emp_installment_details_id_seq'::regclass);


--
-- Name: emp_installments id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emp_installments ALTER COLUMN id SET DEFAULT nextval('public.emp_installments_id_seq'::regclass);


--
-- Name: emp_mails id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emp_mails ALTER COLUMN id SET DEFAULT nextval('public.emp_mails_id_seq'::regclass);


--
-- Name: emp_p_o_s_stores id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emp_p_o_s_stores ALTER COLUMN id SET DEFAULT nextval('public.emp_p_o_s_stores_id_seq'::regclass);


--
-- Name: emp_ratios id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emp_ratios ALTER COLUMN id SET DEFAULT nextval('public.emp_ratios_id_seq'::regclass);


--
-- Name: emp_safes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emp_safes ALTER COLUMN id SET DEFAULT nextval('public.emp_safes_id_seq'::regclass);


--
-- Name: empassies id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.empassies ALTER COLUMN id SET DEFAULT nextval('public.empassies_id_seq'::regclass);


--
-- Name: empassy_reserve_dates id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.empassy_reserve_dates ALTER COLUMN id SET DEFAULT nextval('public.empassy_reserve_dates_id_seq'::regclass);


--
-- Name: employesses id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.employesses ALTER COLUMN id SET DEFAULT nextval('public.employesses_id_seq'::regclass);


--
-- Name: employesses Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.employesses ALTER COLUMN "Code" SET DEFAULT nextval('public.employesses_arr_seq'::regclass);


--
-- Name: employment_levels id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.employment_levels ALTER COLUMN id SET DEFAULT nextval('public.employment_levels_id_seq'::regclass);


--
-- Name: emps_producation_points id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emps_producation_points ALTER COLUMN id SET DEFAULT nextval('public.emps_producation_points_id_seq'::regclass);


--
-- Name: emps_producation_quantities id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.emps_producation_quantities ALTER COLUMN id SET DEFAULT nextval('public.emps_producation_quantities_id_seq'::regclass);


--
-- Name: entitlements id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.entitlements ALTER COLUMN id SET DEFAULT nextval('public.entitlements_id_seq'::regclass);


--
-- Name: entitlements Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.entitlements ALTER COLUMN "Code" SET DEFAULT nextval('public.entitlements_arr_seq'::regclass);


--
-- Name: events id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.events ALTER COLUMN id SET DEFAULT nextval('public.events_id_seq'::regclass);


--
-- Name: examinations_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.examinations_types ALTER COLUMN id SET DEFAULT nextval('public.examinations_types_id_seq'::regclass);


--
-- Name: exchange_commissions id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.exchange_commissions ALTER COLUMN id SET DEFAULT nextval('public.exchange_commissions_id_seq'::regclass);


--
-- Name: exchange_commissions Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.exchange_commissions ALTER COLUMN "Code" SET DEFAULT nextval('public.exchange_commissions_arr_seq'::regclass);


--
-- Name: execute_job_order_models id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.execute_job_order_models ALTER COLUMN id SET DEFAULT nextval('public.execute_job_order_models_id_seq'::regclass);


--
-- Name: execute_job_order_workmanships id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.execute_job_order_workmanships ALTER COLUMN id SET DEFAULT nextval('public.execute_job_order_workmanships_id_seq'::regclass);


--
-- Name: execute_job_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.execute_job_orders ALTER COLUMN id SET DEFAULT nextval('public.execute_job_orders_id_seq'::regclass);


--
-- Name: execute_job_orders Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.execute_job_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.execute_job_orders_arr_seq'::regclass);


--
-- Name: executing_receiving_secretariats id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.executing_receiving_secretariats ALTER COLUMN id SET DEFAULT nextval('public.executing_receiving_secretariats_id_seq'::regclass);


--
-- Name: executing_receiving_secretariats Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.executing_receiving_secretariats ALTER COLUMN "Code" SET DEFAULT nextval('public.executing_receiving_secretariats_arr_seq'::regclass);


--
-- Name: executing_receivings id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.executing_receivings ALTER COLUMN id SET DEFAULT nextval('public.executing_receivings_id_seq'::regclass);


--
-- Name: executing_receivings Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.executing_receivings ALTER COLUMN "Code" SET DEFAULT nextval('public.executing_receivings_arr_seq'::regclass);


--
-- Name: executor_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.executor_filters ALTER COLUMN id SET DEFAULT nextval('public.executor_filters_id_seq'::regclass);


--
-- Name: expenses_list_column_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.expenses_list_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.expenses_list_column_sechdules_id_seq'::regclass);


--
-- Name: expenses_list_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.expenses_list_columns ALTER COLUMN id SET DEFAULT nextval('public.expenses_list_columns_id_seq'::regclass);


--
-- Name: expire_date_qties id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.expire_date_qties ALTER COLUMN id SET DEFAULT nextval('public.expire_date_qties_id_seq'::regclass);


--
-- Name: export_checks id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.export_checks ALTER COLUMN id SET DEFAULT nextval('public.export_checks_id_seq'::regclass);


--
-- Name: export_checks Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.export_checks ALTER COLUMN "Code" SET DEFAULT nextval('public.export_checks_arr_seq'::regclass);


--
-- Name: f_a_q_s id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.f_a_q_s ALTER COLUMN id SET DEFAULT nextval('public.f_a_q_s_id_seq'::regclass);


--
-- Name: failed_jobs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.failed_jobs ALTER COLUMN id SET DEFAULT nextval('public.failed_jobs_id_seq'::regclass);


--
-- Name: faults_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.faults_types ALTER COLUMN id SET DEFAULT nextval('public.faults_types_id_seq'::regclass);


--
-- Name: fifo_qties id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.fifo_qties ALTER COLUMN id SET DEFAULT nextval('public.fifo_qties_id_seq'::regclass);


--
-- Name: follow_lists id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.follow_lists ALTER COLUMN id SET DEFAULT nextval('public.follow_lists_id_seq'::regclass);


--
-- Name: general_dailies id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.general_dailies ALTER COLUMN id SET DEFAULT nextval('public.general_dailies_id_seq'::regclass);


--
-- Name: general_dailies Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.general_dailies ALTER COLUMN "Code" SET DEFAULT nextval('public.general_dailies_arr_seq'::regclass);


--
-- Name: governrates id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.governrates ALTER COLUMN id SET DEFAULT nextval('public.governrates_id_seq'::regclass);


--
-- Name: group_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.group_filters ALTER COLUMN id SET DEFAULT nextval('public.group_filters_id_seq'::regclass);


--
-- Name: holidays id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.holidays ALTER COLUMN id SET DEFAULT nextval('public.holidays_id_seq'::regclass);


--
-- Name: holidays Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.holidays ALTER COLUMN "Code" SET DEFAULT nextval('public.holidays_arr_seq'::regclass);


--
-- Name: holidays_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.holidays_types ALTER COLUMN id SET DEFAULT nextval('public.holidays_types_id_seq'::regclass);


--
-- Name: home_e_com_designs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.home_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.home_e_com_designs_id_seq'::regclass);


--
-- Name: home_product_e_com_designs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.home_product_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.home_product_e_com_designs_id_seq'::regclass);


--
-- Name: import_new_prods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.import_new_prods ALTER COLUMN id SET DEFAULT nextval('public.import_new_prods_id_seq'::regclass);


--
-- Name: import_new_prods_starts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.import_new_prods_starts ALTER COLUMN id SET DEFAULT nextval('public.import_new_prods_starts_id_seq'::regclass);


--
-- Name: incom_checks id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.incom_checks ALTER COLUMN id SET DEFAULT nextval('public.incom_checks_id_seq'::regclass);


--
-- Name: incom_checks Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.incom_checks ALTER COLUMN "Code" SET DEFAULT nextval('public.incom_checks_arr_seq'::regclass);


--
-- Name: incom_manufacturing_models id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.incom_manufacturing_models ALTER COLUMN id SET DEFAULT nextval('public.incom_manufacturing_models_id_seq'::regclass);


--
-- Name: incom_manufacturing_secretariat_models id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.incom_manufacturing_secretariat_models ALTER COLUMN id SET DEFAULT nextval('public.incom_manufacturing_secretariat_models_id_seq'::regclass);


--
-- Name: install_companies_sales_bills_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.install_companies_sales_bills_columns ALTER COLUMN id SET DEFAULT nextval('public.install_companies_sales_bills_columns_id_seq'::regclass);


--
-- Name: install_companies_sales_bills_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.install_companies_sales_bills_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.install_companies_sales_bills_columns_sechdules_id_seq'::regclass);


--
-- Name: installment_companies id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.installment_companies ALTER COLUMN id SET DEFAULT nextval('public.installment_companies_id_seq'::regclass);


--
-- Name: installment_companies_ratios id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.installment_companies_ratios ALTER COLUMN id SET DEFAULT nextval('public.installment_companies_ratios_id_seq'::regclass);


--
-- Name: installment_dates id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.installment_dates ALTER COLUMN id SET DEFAULT nextval('public.installment_dates_id_seq'::regclass);


--
-- Name: installments id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.installments ALTER COLUMN id SET DEFAULT nextval('public.installments_id_seq'::regclass);


--
-- Name: insurance_companies id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.insurance_companies ALTER COLUMN id SET DEFAULT nextval('public.insurance_companies_id_seq'::regclass);


--
-- Name: insurance_papers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.insurance_papers ALTER COLUMN id SET DEFAULT nextval('public.insurance_papers_id_seq'::regclass);


--
-- Name: insurance_papers Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.insurance_papers ALTER COLUMN "Code" SET DEFAULT nextval('public.insurance_papers_arr_seq'::regclass);


--
-- Name: interviews id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.interviews ALTER COLUMN id SET DEFAULT nextval('public.interviews_id_seq'::regclass);


--
-- Name: interviews Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.interviews ALTER COLUMN "Code" SET DEFAULT nextval('public.interviews_arr_seq'::regclass);


--
-- Name: interviews_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.interviews_types ALTER COLUMN id SET DEFAULT nextval('public.interviews_types_id_seq'::regclass);


--
-- Name: intros id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.intros ALTER COLUMN id SET DEFAULT nextval('public.intros_id_seq'::regclass);


--
-- Name: inventories id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.inventories ALTER COLUMN id SET DEFAULT nextval('public.inventories_id_seq'::regclass);


--
-- Name: inventories Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.inventories ALTER COLUMN "Code" SET DEFAULT nextval('public.inventories_arr_seq'::regclass);


--
-- Name: investors id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.investors ALTER COLUMN id SET DEFAULT nextval('public.investors_id_seq'::regclass);


--
-- Name: issues id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.issues ALTER COLUMN id SET DEFAULT nextval('public.issues_id_seq'::regclass);


--
-- Name: items_groups id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.items_groups ALTER COLUMN id SET DEFAULT nextval('public.items_groups_id_seq'::regclass);


--
-- Name: itineraries id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.itineraries ALTER COLUMN id SET DEFAULT nextval('public.itineraries_id_seq'::regclass);


--
-- Name: itinerary_visits id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.itinerary_visits ALTER COLUMN id SET DEFAULT nextval('public.itinerary_visits_id_seq'::regclass);


--
-- Name: job_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.job_orders ALTER COLUMN id SET DEFAULT nextval('public.job_orders_id_seq'::regclass);


--
-- Name: job_orders Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.job_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.job_orders_arr_seq'::regclass);


--
-- Name: job_orders_executors id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.job_orders_executors ALTER COLUMN id SET DEFAULT nextval('public.job_orders_executors_id_seq'::regclass);


--
-- Name: jobs_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.jobs_types ALTER COLUMN id SET DEFAULT nextval('public.jobs_types_id_seq'::regclass);


--
-- Name: journalizing_details id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.journalizing_details ALTER COLUMN id SET DEFAULT nextval('public.journalizing_details_id_seq'::regclass);


--
-- Name: journalizings id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.journalizings ALTER COLUMN id SET DEFAULT nextval('public.journalizings_id_seq'::regclass);


--
-- Name: journalizings Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.journalizings ALTER COLUMN "Code" SET DEFAULT nextval('public.journalizings_arr_seq'::regclass);


--
-- Name: languages id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.languages ALTER COLUMN id SET DEFAULT nextval('public.languages_id_seq'::regclass);


--
-- Name: loan_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.loan_types ALTER COLUMN id SET DEFAULT nextval('public.loan_types_id_seq'::regclass);


--
-- Name: loans id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.loans ALTER COLUMN id SET DEFAULT nextval('public.loans_id_seq'::regclass);


--
-- Name: loans Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.loans ALTER COLUMN "Code" SET DEFAULT nextval('public.loans_arr_seq'::regclass);


--
-- Name: login_sliders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.login_sliders ALTER COLUMN id SET DEFAULT nextval('public.login_sliders_id_seq'::regclass);


--
-- Name: main_e_com_designs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.main_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.main_e_com_designs_id_seq'::regclass);


--
-- Name: maintainc_bills id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.maintainc_bills ALTER COLUMN id SET DEFAULT nextval('public.maintainc_bills_id_seq'::regclass);


--
-- Name: maintainc_bills Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.maintainc_bills ALTER COLUMN "Code" SET DEFAULT nextval('public.maintainc_bills_arr_seq'::regclass);


--
-- Name: maintaince_colors id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.maintaince_colors ALTER COLUMN id SET DEFAULT nextval('public.maintaince_colors_id_seq'::regclass);


--
-- Name: maintaince_default_data id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.maintaince_default_data ALTER COLUMN id SET DEFAULT nextval('public.maintaince_default_data_id_seq'::regclass);


--
-- Name: manu_store_counts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manu_store_counts ALTER COLUMN id SET DEFAULT nextval('public.manu_store_counts_id_seq'::regclass);


--
-- Name: manufacture_companies id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacture_companies ALTER COLUMN id SET DEFAULT nextval('public.manufacture_companies_id_seq'::regclass);


--
-- Name: manufacturing_default_data id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_default_data ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_default_data_id_seq'::regclass);


--
-- Name: manufacturing_executions id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_executions ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_executions_id_seq'::regclass);


--
-- Name: manufacturing_executions Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_executions ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_executions_arr_seq'::regclass);


--
-- Name: manufacturing_halls id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_halls ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_halls_id_seq'::regclass);


--
-- Name: manufacturing_models id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_models ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_models_id_seq'::regclass);


--
-- Name: manufacturing_models Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_models ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_models_arr_seq'::regclass);


--
-- Name: manufacturing_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_orders ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_orders_id_seq'::regclass);


--
-- Name: manufacturing_orders Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_orders_arr_seq'::regclass);


--
-- Name: manufacturing_requests id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_requests ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_requests_id_seq'::regclass);


--
-- Name: manufacturing_requests Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_requests ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_requests_arr_seq'::regclass);


--
-- Name: manufacturing_secretariat_models id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_secretariat_models ALTER COLUMN id SET DEFAULT nextval('public.manufacturing_secretariat_models_id_seq'::regclass);


--
-- Name: manufacturing_secretariat_models Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.manufacturing_secretariat_models ALTER COLUMN "Code" SET DEFAULT nextval('public.manufacturing_secretariat_models_arr_seq'::regclass);


--
-- Name: measuerments id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.measuerments ALTER COLUMN id SET DEFAULT nextval('public.measuerments_id_seq'::regclass);


--
-- Name: missions id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.missions ALTER COLUMN id SET DEFAULT nextval('public.missions_id_seq'::regclass);


--
-- Name: module_settings_nums id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.module_settings_nums ALTER COLUMN id SET DEFAULT nextval('public.module_settings_nums_id_seq'::regclass);


--
-- Name: modules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.modules ALTER COLUMN id SET DEFAULT nextval('public.modules_id_seq'::regclass);


--
-- Name: more_products_halls id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.more_products_halls ALTER COLUMN id SET DEFAULT nextval('public.more_products_halls_id_seq'::regclass);


--
-- Name: most_sales_products_column_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.most_sales_products_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.most_sales_products_column_sechdules_id_seq'::regclass);


--
-- Name: most_sales_products_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.most_sales_products_columns ALTER COLUMN id SET DEFAULT nextval('public.most_sales_products_columns_id_seq'::regclass);


--
-- Name: msg_rqsts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.msg_rqsts ALTER COLUMN id SET DEFAULT nextval('public.msg_rqsts_id_seq'::regclass);


--
-- Name: my_follow_lists id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.my_follow_lists ALTER COLUMN id SET DEFAULT nextval('public.my_follow_lists_id_seq'::regclass);


--
-- Name: notifications id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.notifications ALTER COLUMN id SET DEFAULT nextval('public.notifications_id_seq'::regclass);


--
-- Name: opening_entries id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.opening_entries ALTER COLUMN id SET DEFAULT nextval('public.opening_entries_id_seq'::regclass);


--
-- Name: opening_entries Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.opening_entries ALTER COLUMN "Code" SET DEFAULT nextval('public.opening_entries_arr_seq'::regclass);


--
-- Name: opening_entries_details id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.opening_entries_details ALTER COLUMN id SET DEFAULT nextval('public.opening_entries_details_id_seq'::regclass);


--
-- Name: order_pays id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.order_pays ALTER COLUMN id SET DEFAULT nextval('public.order_pays_id_seq'::regclass);


--
-- Name: outcom_manufacturing_models id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.outcom_manufacturing_models ALTER COLUMN id SET DEFAULT nextval('public.outcom_manufacturing_models_id_seq'::regclass);


--
-- Name: outcome_manufacturing_secretariat_models id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.outcome_manufacturing_secretariat_models ALTER COLUMN id SET DEFAULT nextval('public.outcome_manufacturing_secretariat_models_id_seq'::regclass);


--
-- Name: over_times id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.over_times ALTER COLUMN id SET DEFAULT nextval('public.over_times_id_seq'::regclass);


--
-- Name: pack_prems id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.pack_prems ALTER COLUMN id SET DEFAULT nextval('public.pack_prems_id_seq'::regclass);


--
-- Name: packages id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.packages ALTER COLUMN id SET DEFAULT nextval('public.packages_id_seq'::regclass);


--
-- Name: partners id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.partners ALTER COLUMN id SET DEFAULT nextval('public.partners_id_seq'::regclass);


--
-- Name: pay_profit_investors id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.pay_profit_investors ALTER COLUMN id SET DEFAULT nextval('public.pay_profit_investors_id_seq'::regclass);


--
-- Name: pay_salaries id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.pay_salaries ALTER COLUMN id SET DEFAULT nextval('public.pay_salaries_id_seq'::regclass);


--
-- Name: pay_salaries Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.pay_salaries ALTER COLUMN "Code" SET DEFAULT nextval('public.pay_salaries_arr_seq'::regclass);


--
-- Name: payment_voucher_details id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.payment_voucher_details ALTER COLUMN id SET DEFAULT nextval('public.payment_voucher_details_id_seq'::regclass);


--
-- Name: payment_vouchers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.payment_vouchers ALTER COLUMN id SET DEFAULT nextval('public.payment_vouchers_id_seq'::regclass);


--
-- Name: payment_vouchers Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.payment_vouchers ALTER COLUMN "Code" SET DEFAULT nextval('public.payment_vouchers_arr_seq'::regclass);


--
-- Name: permission_to_exchange_goods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.permission_to_exchange_goods ALTER COLUMN id SET DEFAULT nextval('public.permission_to_exchange_goods_id_seq'::regclass);


--
-- Name: permission_to_exchange_goods Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.permission_to_exchange_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.permission_to_exchange_goods_arr_seq'::regclass);


--
-- Name: permission_to_recived_goods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.permission_to_recived_goods ALTER COLUMN id SET DEFAULT nextval('public.permission_to_recived_goods_id_seq'::regclass);


--
-- Name: permission_to_recived_goods Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.permission_to_recived_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.permission_to_recived_goods_arr_seq'::regclass);


--
-- Name: permissions id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.permissions ALTER COLUMN id SET DEFAULT nextval('public.permissions_id_seq'::regclass);


--
-- Name: places id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.places ALTER COLUMN id SET DEFAULT nextval('public.places_id_seq'::regclass);


--
-- Name: platforms id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.platforms ALTER COLUMN id SET DEFAULT nextval('public.platforms_id_seq'::regclass);


--
-- Name: polices id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.polices ALTER COLUMN id SET DEFAULT nextval('public.polices_id_seq'::regclass);


--
-- Name: pro_details_imgs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.pro_details_imgs ALTER COLUMN id SET DEFAULT nextval('public.pro_details_imgs_id_seq'::regclass);


--
-- Name: pro_notes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.pro_notes ALTER COLUMN id SET DEFAULT nextval('public.pro_notes_id_seq'::regclass);


--
-- Name: product_details_e_com_designs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_details_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.product_details_e_com_designs_id_seq'::regclass);


--
-- Name: product_executing_receiving_secretariats id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_executing_receiving_secretariats ALTER COLUMN id SET DEFAULT nextval('public.product_executing_receiving_secretariats_id_seq'::regclass);


--
-- Name: product_inventories id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_inventories ALTER COLUMN id SET DEFAULT nextval('public.product_inventories_id_seq'::regclass);


--
-- Name: product_job_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_job_orders ALTER COLUMN id SET DEFAULT nextval('public.product_job_orders_id_seq'::regclass);


--
-- Name: product_maintainc_bills id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_maintainc_bills ALTER COLUMN id SET DEFAULT nextval('public.product_maintainc_bills_id_seq'::regclass);


--
-- Name: product_manufacturing_executions id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_manufacturing_executions ALTER COLUMN id SET DEFAULT nextval('public.product_manufacturing_executions_id_seq'::regclass);


--
-- Name: product_moves id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_moves ALTER COLUMN id SET DEFAULT nextval('public.product_moves_id_seq'::regclass);


--
-- Name: product_moves_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_moves_columns ALTER COLUMN id SET DEFAULT nextval('public.product_moves_columns_id_seq'::regclass);


--
-- Name: product_moves_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_moves_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.product_moves_columns_sechdules_id_seq'::regclass);


--
-- Name: product_moves_filter_twos id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_moves_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.product_moves_filter_twos_id_seq'::regclass);


--
-- Name: product_moves_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_moves_filters ALTER COLUMN id SET DEFAULT nextval('public.product_moves_filters_id_seq'::regclass);


--
-- Name: product_quote_images id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_quote_images ALTER COLUMN id SET DEFAULT nextval('public.product_quote_images_id_seq'::regclass);


--
-- Name: product_return_without_bills id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_return_without_bills ALTER COLUMN id SET DEFAULT nextval('public.product_return_without_bills_id_seq'::regclass);


--
-- Name: product_sales id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_sales ALTER COLUMN id SET DEFAULT nextval('public.product_sales_id_seq'::regclass);


--
-- Name: product_sales_gifts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_sales_gifts ALTER COLUMN id SET DEFAULT nextval('public.product_sales_gifts_id_seq'::regclass);


--
-- Name: product_sales_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_sales_orders ALTER COLUMN id SET DEFAULT nextval('public.product_sales_orders_id_seq'::regclass);


--
-- Name: product_sales_subscribes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_sales_subscribes ALTER COLUMN id SET DEFAULT nextval('public.product_sales_subscribes_id_seq'::regclass);


--
-- Name: product_settlements id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_settlements ALTER COLUMN id SET DEFAULT nextval('public.product_settlements_id_seq'::regclass);


--
-- Name: product_type_defaults id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_type_defaults ALTER COLUMN id SET DEFAULT nextval('public.product_type_defaults_id_seq'::regclass);


--
-- Name: product_units id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.product_units ALTER COLUMN id SET DEFAULT nextval('public.product_units_id_seq'::regclass);


--
-- Name: products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products ALTER COLUMN id SET DEFAULT nextval('public.products_id_seq'::regclass);


--
-- Name: products_consists id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_consists ALTER COLUMN id SET DEFAULT nextval('public.products_consists_id_seq'::regclass);


--
-- Name: products_executing_receivings id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_executing_receivings ALTER COLUMN id SET DEFAULT nextval('public.products_executing_receivings_id_seq'::regclass);


--
-- Name: products_manufacturing_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_manufacturing_orders ALTER COLUMN id SET DEFAULT nextval('public.products_manufacturing_orders_id_seq'::regclass);


--
-- Name: products_manufacturing_requests id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_manufacturing_requests ALTER COLUMN id SET DEFAULT nextval('public.products_manufacturing_requests_id_seq'::regclass);


--
-- Name: products_permission_to_exchange_goods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_permission_to_exchange_goods ALTER COLUMN id SET DEFAULT nextval('public.products_permission_to_exchange_goods_id_seq'::regclass);


--
-- Name: products_permission_to_recived_goods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_permission_to_recived_goods ALTER COLUMN id SET DEFAULT nextval('public.products_permission_to_recived_goods_id_seq'::regclass);


--
-- Name: products_purchase_petrols id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_purchase_petrols ALTER COLUMN id SET DEFAULT nextval('public.products_purchase_petrols_id_seq'::regclass);


--
-- Name: products_purchases id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_purchases ALTER COLUMN id SET DEFAULT nextval('public.products_purchases_id_seq'::regclass);


--
-- Name: products_purchases_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_purchases_orders ALTER COLUMN id SET DEFAULT nextval('public.products_purchases_orders_id_seq'::regclass);


--
-- Name: products_qties id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_qties ALTER COLUMN id SET DEFAULT nextval('public.products_qties_id_seq'::regclass);


--
-- Name: products_quotes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_quotes ALTER COLUMN id SET DEFAULT nextval('public.products_quotes_id_seq'::regclass);


--
-- Name: products_return_maintaince_bills id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_return_maintaince_bills ALTER COLUMN id SET DEFAULT nextval('public.products_return_maintaince_bills_id_seq'::regclass);


--
-- Name: products_secretariat_export_goods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_secretariat_export_goods ALTER COLUMN id SET DEFAULT nextval('public.products_secretariat_export_goods_id_seq'::regclass);


--
-- Name: products_secretariat_import_goods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_secretariat_import_goods ALTER COLUMN id SET DEFAULT nextval('public.products_secretariat_import_goods_id_seq'::regclass);


--
-- Name: products_shortcomings id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_shortcomings ALTER COLUMN id SET DEFAULT nextval('public.products_shortcomings_id_seq'::regclass);


--
-- Name: products_start_periods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_start_periods ALTER COLUMN id SET DEFAULT nextval('public.products_start_periods_id_seq'::regclass);


--
-- Name: products_stores id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_stores ALTER COLUMN id SET DEFAULT nextval('public.products_stores_id_seq'::regclass);


--
-- Name: products_stores_transfers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_stores_transfers ALTER COLUMN id SET DEFAULT nextval('public.products_stores_transfers_id_seq'::regclass);


--
-- Name: products_viras id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.products_viras ALTER COLUMN id SET DEFAULT nextval('public.products_viras_id_seq'::regclass);


--
-- Name: profit_sales_product_column_sechdulrs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.profit_sales_product_column_sechdulrs ALTER COLUMN id SET DEFAULT nextval('public.profit_sales_product_column_sechdulrs_id_seq'::regclass);


--
-- Name: profit_sales_product_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.profit_sales_product_columns ALTER COLUMN id SET DEFAULT nextval('public.profit_sales_product_columns_id_seq'::regclass);


--
-- Name: project_teams id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.project_teams ALTER COLUMN id SET DEFAULT nextval('public.project_teams_id_seq'::regclass);


--
-- Name: projects id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.projects ALTER COLUMN id SET DEFAULT nextval('public.projects_id_seq'::regclass);


--
-- Name: purch_bills_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purch_bills_columns ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_columns_id_seq'::regclass);


--
-- Name: purch_bills_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purch_bills_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_columns_sechdules_id_seq'::regclass);


--
-- Name: purch_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purch_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_filter_twos_id_seq'::regclass);


--
-- Name: purch_bills_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purch_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.purch_bills_filters_id_seq'::regclass);


--
-- Name: purchase_petrols id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purchase_petrols ALTER COLUMN id SET DEFAULT nextval('public.purchase_petrols_id_seq'::regclass);


--
-- Name: purchase_petrols Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purchase_petrols ALTER COLUMN "Code" SET DEFAULT nextval('public.purchase_petrols_arr_seq'::regclass);


--
-- Name: purchases id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purchases ALTER COLUMN id SET DEFAULT nextval('public.purchases_id_seq'::regclass);


--
-- Name: purchases Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purchases ALTER COLUMN "Code" SET DEFAULT nextval('public.purchases_arr_seq'::regclass);


--
-- Name: purchases_default_data id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purchases_default_data ALTER COLUMN id SET DEFAULT nextval('public.purchases_default_data_id_seq'::regclass);


--
-- Name: purchases_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purchases_orders ALTER COLUMN id SET DEFAULT nextval('public.purchases_orders_id_seq'::regclass);


--
-- Name: purchases_orders Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purchases_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.purchases_orders_arr_seq'::regclass);


--
-- Name: purpose_travel id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.purpose_travel ALTER COLUMN id SET DEFAULT nextval('public.purpose_travel_id_seq'::regclass);


--
-- Name: q_r_s id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.q_r_s ALTER COLUMN id SET DEFAULT nextval('public.q_r_s_id_seq'::regclass);


--
-- Name: qualities id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.qualities ALTER COLUMN id SET DEFAULT nextval('public.qualities_id_seq'::regclass);


--
-- Name: qualities Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.qualities ALTER COLUMN "Code" SET DEFAULT nextval('public.qualities_arr_seq'::regclass);


--
-- Name: quality_details id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.quality_details ALTER COLUMN id SET DEFAULT nextval('public.quality_details_id_seq'::regclass);


--
-- Name: quote_images id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.quote_images ALTER COLUMN id SET DEFAULT nextval('public.quote_images_id_seq'::regclass);


--
-- Name: quote_images Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.quote_images ALTER COLUMN "Code" SET DEFAULT nextval('public.quote_images_arr_seq'::regclass);


--
-- Name: quotes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.quotes ALTER COLUMN id SET DEFAULT nextval('public.quotes_id_seq'::regclass);


--
-- Name: quotes Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.quotes ALTER COLUMN "Code" SET DEFAULT nextval('public.quotes_arr_seq'::regclass);


--
-- Name: rabih_education id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.rabih_education ALTER COLUMN id SET DEFAULT nextval('public.rabih_education_id_seq'::regclass);


--
-- Name: rates id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.rates ALTER COLUMN id SET DEFAULT nextval('public.rates_id_seq'::regclass);


--
-- Name: reasons id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reasons ALTER COLUMN id SET DEFAULT nextval('public.reasons_id_seq'::regclass);


--
-- Name: recipt_maintaince_errors id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recipt_maintaince_errors ALTER COLUMN id SET DEFAULT nextval('public.recipt_maintaince_errors_id_seq'::regclass);


--
-- Name: recipt_maintainces id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recipt_maintainces ALTER COLUMN id SET DEFAULT nextval('public.recipt_maintainces_id_seq'::regclass);


--
-- Name: recipt_maintainces Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recipt_maintainces ALTER COLUMN "Code" SET DEFAULT nextval('public.recipt_maintainces_arr_seq'::regclass);


--
-- Name: recipt_voucher_details id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recipt_voucher_details ALTER COLUMN id SET DEFAULT nextval('public.recipt_voucher_details_id_seq'::regclass);


--
-- Name: recipt_vouchers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recipt_vouchers ALTER COLUMN id SET DEFAULT nextval('public.recipt_vouchers_id_seq'::regclass);


--
-- Name: recipt_vouchers Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recipt_vouchers ALTER COLUMN "Code" SET DEFAULT nextval('public.recipt_vouchers_arr_seq'::regclass);


--
-- Name: recipts_sales_petrols id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recipts_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.recipts_sales_petrols_id_seq'::regclass);


--
-- Name: recipts_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recipts_types ALTER COLUMN id SET DEFAULT nextval('public.recipts_types_id_seq'::regclass);


--
-- Name: recived_purch_products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recived_purch_products ALTER COLUMN id SET DEFAULT nextval('public.recived_purch_products_id_seq'::regclass);


--
-- Name: recived_purchts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recived_purchts ALTER COLUMN id SET DEFAULT nextval('public.recived_purchts_id_seq'::regclass);


--
-- Name: recived_purchts Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recived_purchts ALTER COLUMN "Code" SET DEFAULT nextval('public.recived_purchts_arr_seq'::regclass);


--
-- Name: recived_sales id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recived_sales ALTER COLUMN id SET DEFAULT nextval('public.recived_sales_id_seq'::regclass);


--
-- Name: recived_sales Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recived_sales ALTER COLUMN "Code" SET DEFAULT nextval('public.recived_sales_arr_seq'::regclass);


--
-- Name: recived_sales_products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.recived_sales_products ALTER COLUMN id SET DEFAULT nextval('public.recived_sales_products_id_seq'::regclass);


--
-- Name: reg_courses id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reg_courses ALTER COLUMN id SET DEFAULT nextval('public.reg_courses_id_seq'::regclass);


--
-- Name: reg_courses_students id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reg_courses_students ALTER COLUMN id SET DEFAULT nextval('public.reg_courses_students_id_seq'::regclass);


--
-- Name: reg_over_times id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reg_over_times ALTER COLUMN id SET DEFAULT nextval('public.reg_over_times_id_seq'::regclass);


--
-- Name: reg_over_times Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reg_over_times ALTER COLUMN "Code" SET DEFAULT nextval('public.reg_over_times_arr_seq'::regclass);


--
-- Name: remove_products_halls id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.remove_products_halls ALTER COLUMN id SET DEFAULT nextval('public.remove_products_halls_id_seq'::regclass);


--
-- Name: reports_settings id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reports_settings ALTER COLUMN id SET DEFAULT nextval('public.reports_settings_id_seq'::regclass);


--
-- Name: reservations id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reservations ALTER COLUMN id SET DEFAULT nextval('public.reservations_id_seq'::regclass);


--
-- Name: reservations Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reservations ALTER COLUMN "Code" SET DEFAULT nextval('public.reservations_arr_seq'::regclass);


--
-- Name: reserve_course_days id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reserve_course_days ALTER COLUMN id SET DEFAULT nextval('public.reserve_course_days_id_seq'::regclass);


--
-- Name: reserve_course_students id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reserve_course_students ALTER COLUMN id SET DEFAULT nextval('public.reserve_course_students_id_seq'::regclass);


--
-- Name: reserve_courses id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.reserve_courses ALTER COLUMN id SET DEFAULT nextval('public.reserve_courses_id_seq'::regclass);


--
-- Name: resignation_requests id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resignation_requests ALTER COLUMN id SET DEFAULT nextval('public.resignation_requests_id_seq'::regclass);


--
-- Name: resignation_requests Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resignation_requests ALTER COLUMN "Code" SET DEFAULT nextval('public.resignation_requests_arr_seq'::regclass);


--
-- Name: resturant_abouts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_abouts ALTER COLUMN id SET DEFAULT nextval('public.resturant_abouts_id_seq'::regclass);


--
-- Name: resturant_blogs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_blogs ALTER COLUMN id SET DEFAULT nextval('public.resturant_blogs_id_seq'::regclass);


--
-- Name: resturant_cart_check_styles id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_cart_check_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_cart_check_styles_id_seq'::regclass);


--
-- Name: resturant_cupon_codes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_cupon_codes ALTER COLUMN id SET DEFAULT nextval('public.resturant_cupon_codes_id_seq'::regclass);


--
-- Name: resturant_galleries id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_galleries ALTER COLUMN id SET DEFAULT nextval('public.resturant_galleries_id_seq'::regclass);


--
-- Name: resturant_homes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_homes ALTER COLUMN id SET DEFAULT nextval('public.resturant_homes_id_seq'::regclass);


--
-- Name: resturant_index_style_i_i_s id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_index_style_i_i_s ALTER COLUMN id SET DEFAULT nextval('public.resturant_index_style_i_i_s_id_seq'::regclass);


--
-- Name: resturant_index_style_i_s id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_index_style_i_s ALTER COLUMN id SET DEFAULT nextval('public.resturant_index_style_i_s_id_seq'::regclass);


--
-- Name: resturant_menu_styles id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_menu_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_menu_styles_id_seq'::regclass);


--
-- Name: resturant_nav_foot_styles id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_nav_foot_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_nav_foot_styles_id_seq'::regclass);


--
-- Name: resturant_privacies id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_privacies ALTER COLUMN id SET DEFAULT nextval('public.resturant_privacies_id_seq'::regclass);


--
-- Name: resturant_reservations id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_reservations ALTER COLUMN id SET DEFAULT nextval('public.resturant_reservations_id_seq'::regclass);


--
-- Name: resturant_reviews id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_reviews ALTER COLUMN id SET DEFAULT nextval('public.resturant_reviews_id_seq'::regclass);


--
-- Name: resturant_sliders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_sliders ALTER COLUMN id SET DEFAULT nextval('public.resturant_sliders_id_seq'::regclass);


--
-- Name: resturant_socials id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_socials ALTER COLUMN id SET DEFAULT nextval('public.resturant_socials_id_seq'::regclass);


--
-- Name: resturant_styles id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_styles_id_seq'::regclass);


--
-- Name: resturant_sup_page_styles id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_sup_page_styles ALTER COLUMN id SET DEFAULT nextval('public.resturant_sup_page_styles_id_seq'::regclass);


--
-- Name: resturant_tables id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_tables ALTER COLUMN id SET DEFAULT nextval('public.resturant_tables_id_seq'::regclass);


--
-- Name: resturant_terms id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_terms ALTER COLUMN id SET DEFAULT nextval('public.resturant_terms_id_seq'::regclass);


--
-- Name: resturant_video_sections id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.resturant_video_sections ALTER COLUMN id SET DEFAULT nextval('public.resturant_video_sections_id_seq'::regclass);


--
-- Name: return_maintaince_bills id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_maintaince_bills ALTER COLUMN id SET DEFAULT nextval('public.return_maintaince_bills_id_seq'::regclass);


--
-- Name: return_maintaince_bills Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_maintaince_bills ALTER COLUMN "Code" SET DEFAULT nextval('public.return_maintaince_bills_arr_seq'::regclass);


--
-- Name: return_products_stores_transfers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_products_stores_transfers ALTER COLUMN id SET DEFAULT nextval('public.return_products_stores_transfers_id_seq'::regclass);


--
-- Name: return_purch_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_purch_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.return_purch_bills_filter_twos_id_seq'::regclass);


--
-- Name: return_purch_bills_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_purch_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.return_purch_bills_filters_id_seq'::regclass);


--
-- Name: return_purch_products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_purch_products ALTER COLUMN id SET DEFAULT nextval('public.return_purch_products_id_seq'::regclass);


--
-- Name: return_purches id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_purches ALTER COLUMN id SET DEFAULT nextval('public.return_purches_id_seq'::regclass);


--
-- Name: return_purches Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_purches ALTER COLUMN "Code" SET DEFAULT nextval('public.return_purches_arr_seq'::regclass);


--
-- Name: return_sales id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_sales ALTER COLUMN id SET DEFAULT nextval('public.return_sales_id_seq'::regclass);


--
-- Name: return_sales Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_sales ALTER COLUMN "Code" SET DEFAULT nextval('public.return_sales_arr_seq'::regclass);


--
-- Name: return_sales_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_sales_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.return_sales_bills_filter_twos_id_seq'::regclass);


--
-- Name: return_sales_bills_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_sales_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.return_sales_bills_filters_id_seq'::regclass);


--
-- Name: return_sales_products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_sales_products ALTER COLUMN id SET DEFAULT nextval('public.return_sales_products_id_seq'::regclass);


--
-- Name: return_stors_transfers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_stors_transfers ALTER COLUMN id SET DEFAULT nextval('public.return_stors_transfers_id_seq'::regclass);


--
-- Name: return_stors_transfers Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_stors_transfers ALTER COLUMN "Code" SET DEFAULT nextval('public.return_stors_transfers_arr_seq'::regclass);


--
-- Name: return_without_bills id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_without_bills ALTER COLUMN id SET DEFAULT nextval('public.return_without_bills_id_seq'::regclass);


--
-- Name: return_without_bills Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.return_without_bills ALTER COLUMN "Code" SET DEFAULT nextval('public.return_without_bills_arr_seq'::regclass);


--
-- Name: roles id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.roles ALTER COLUMN id SET DEFAULT nextval('public.roles_id_seq'::regclass);


--
-- Name: room_reservations id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.room_reservations ALTER COLUMN id SET DEFAULT nextval('public.room_reservations_id_seq'::regclass);


--
-- Name: rooms id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.rooms ALTER COLUMN id SET DEFAULT nextval('public.rooms_id_seq'::regclass);


--
-- Name: rooms_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.rooms_types ALTER COLUMN id SET DEFAULT nextval('public.rooms_types_id_seq'::regclass);


--
-- Name: safe_transfer_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.safe_transfer_columns ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_columns_id_seq'::regclass);


--
-- Name: safe_transfer_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.safe_transfer_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_columns_sechdules_id_seq'::regclass);


--
-- Name: safe_transfer_filter_twos id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.safe_transfer_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_filter_twos_id_seq'::regclass);


--
-- Name: safe_transfer_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.safe_transfer_filters ALTER COLUMN id SET DEFAULT nextval('public.safe_transfer_filters_id_seq'::regclass);


--
-- Name: safe_transfers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.safe_transfers ALTER COLUMN id SET DEFAULT nextval('public.safe_transfers_id_seq'::regclass);


--
-- Name: safe_transfers Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.safe_transfers ALTER COLUMN "Code" SET DEFAULT nextval('public.safe_transfers_arr_seq'::regclass);


--
-- Name: safes_banks id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.safes_banks ALTER COLUMN id SET DEFAULT nextval('public.safes_banks_id_seq'::regclass);


--
-- Name: safes_banks Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.safes_banks ALTER COLUMN "Code" SET DEFAULT nextval('public.safes_banks_arr_seq'::regclass);


--
-- Name: sales id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales ALTER COLUMN id SET DEFAULT nextval('public.sales_id_seq'::regclass);


--
-- Name: sales Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_arr_seq'::regclass);


--
-- Name: sales_bills_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_bills_columns ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_columns_id_seq'::regclass);


--
-- Name: sales_bills_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_bills_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_columns_sechdules_id_seq'::regclass);


--
-- Name: sales_bills_filter_twos id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_bills_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_filter_twos_id_seq'::regclass);


--
-- Name: sales_bills_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_bills_filters ALTER COLUMN id SET DEFAULT nextval('public.sales_bills_filters_id_seq'::regclass);


--
-- Name: sales_default_data id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_default_data ALTER COLUMN id SET DEFAULT nextval('public.sales_default_data_id_seq'::regclass);


--
-- Name: sales_fifo_qties id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_fifo_qties ALTER COLUMN id SET DEFAULT nextval('public.sales_fifo_qties_id_seq'::regclass);


--
-- Name: sales_gifts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_gifts ALTER COLUMN id SET DEFAULT nextval('public.sales_gifts_id_seq'::regclass);


--
-- Name: sales_gifts Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_gifts ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_gifts_arr_seq'::regclass);


--
-- Name: sales_maint_fifo_qties id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_maint_fifo_qties ALTER COLUMN id SET DEFAULT nextval('public.sales_maint_fifo_qties_id_seq'::regclass);


--
-- Name: sales_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_orders ALTER COLUMN id SET DEFAULT nextval('public.sales_orders_id_seq'::regclass);


--
-- Name: sales_orders Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_orders_arr_seq'::regclass);


--
-- Name: sales_petrols id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.sales_petrols_id_seq'::regclass);


--
-- Name: sales_petrols Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_petrols ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_petrols_arr_seq'::regclass);


--
-- Name: sales_subscribes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_subscribes ALTER COLUMN id SET DEFAULT nextval('public.sales_subscribes_id_seq'::regclass);


--
-- Name: sales_subscribes Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sales_subscribes ALTER COLUMN "Code" SET DEFAULT nextval('public.sales_subscribes_arr_seq'::regclass);


--
-- Name: scientific_materials id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.scientific_materials ALTER COLUMN id SET DEFAULT nextval('public.scientific_materials_id_seq'::regclass);


--
-- Name: secretariat_export_goods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.secretariat_export_goods ALTER COLUMN id SET DEFAULT nextval('public.secretariat_export_goods_id_seq'::regclass);


--
-- Name: secretariat_export_goods Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.secretariat_export_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.secretariat_export_goods_arr_seq'::regclass);


--
-- Name: secretariat_import_goods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.secretariat_import_goods ALTER COLUMN id SET DEFAULT nextval('public.secretariat_import_goods_id_seq'::regclass);


--
-- Name: secretariat_import_goods Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.secretariat_import_goods ALTER COLUMN "Code" SET DEFAULT nextval('public.secretariat_import_goods_arr_seq'::regclass);


--
-- Name: secretariat_qties id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.secretariat_qties ALTER COLUMN id SET DEFAULT nextval('public.secretariat_qties_id_seq'::regclass);


--
-- Name: secretariat_stores id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.secretariat_stores ALTER COLUMN id SET DEFAULT nextval('public.secretariat_stores_id_seq'::regclass);


--
-- Name: select_a_p_i_s id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.select_a_p_i_s ALTER COLUMN id SET DEFAULT nextval('public.select_a_p_i_s_id_seq'::regclass);


--
-- Name: settlements id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.settlements ALTER COLUMN id SET DEFAULT nextval('public.settlements_id_seq'::regclass);


--
-- Name: settlements Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.settlements ALTER COLUMN "Code" SET DEFAULT nextval('public.settlements_arr_seq'::regclass);


--
-- Name: shifts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shifts ALTER COLUMN id SET DEFAULT nextval('public.shifts_id_seq'::regclass);


--
-- Name: shifts Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shifts ALTER COLUMN "Code" SET DEFAULT nextval('public.shifts_arr_seq'::regclass);


--
-- Name: shipment_receipts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipment_receipts ALTER COLUMN id SET DEFAULT nextval('public.shipment_receipts_id_seq'::regclass);


--
-- Name: shipment_receipts Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipment_receipts ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_receipts_arr_seq'::regclass);


--
-- Name: shipment_receipts_clients id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipment_receipts_clients ALTER COLUMN id SET DEFAULT nextval('public.shipment_receipts_clients_id_seq'::regclass);


--
-- Name: shipment_receipts_clients Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipment_receipts_clients ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_receipts_clients_arr_seq'::regclass);


--
-- Name: shipment_receipts_lists id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipment_receipts_lists ALTER COLUMN id SET DEFAULT nextval('public.shipment_receipts_lists_id_seq'::regclass);


--
-- Name: shipment_receipts_lists Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipment_receipts_lists ALTER COLUMN "Code" SET DEFAULT nextval('public.shipment_receipts_lists_arr_seq'::regclass);


--
-- Name: shipping_companies id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipping_companies ALTER COLUMN id SET DEFAULT nextval('public.shipping_companies_id_seq'::regclass);


--
-- Name: shipping_defaults id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipping_defaults ALTER COLUMN id SET DEFAULT nextval('public.shipping_defaults_id_seq'::regclass);


--
-- Name: shipping_list_tickets id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipping_list_tickets ALTER COLUMN id SET DEFAULT nextval('public.shipping_list_tickets_id_seq'::regclass);


--
-- Name: shipping_lists id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipping_lists ALTER COLUMN id SET DEFAULT nextval('public.shipping_lists_id_seq'::regclass);


--
-- Name: shipping_orders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipping_orders ALTER COLUMN id SET DEFAULT nextval('public.shipping_orders_id_seq'::regclass);


--
-- Name: shipping_orders Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipping_orders ALTER COLUMN "Code" SET DEFAULT nextval('public.shipping_orders_arr_seq'::regclass);


--
-- Name: shipping_statuses id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipping_statuses ALTER COLUMN id SET DEFAULT nextval('public.shipping_statuses_id_seq'::regclass);


--
-- Name: shipping_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shipping_types ALTER COLUMN id SET DEFAULT nextval('public.shipping_types_id_seq'::regclass);


--
-- Name: shortcomings id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shortcomings ALTER COLUMN id SET DEFAULT nextval('public.shortcomings_id_seq'::regclass);


--
-- Name: shortcomings Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.shortcomings ALTER COLUMN "Code" SET DEFAULT nextval('public.shortcomings_arr_seq'::regclass);


--
-- Name: show_print_defaults id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.show_print_defaults ALTER COLUMN id SET DEFAULT nextval('public.show_print_defaults_id_seq'::regclass);


--
-- Name: social_media id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.social_media ALTER COLUMN id SET DEFAULT nextval('public.social_media_id_seq'::regclass);


--
-- Name: special_cases id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.special_cases ALTER COLUMN id SET DEFAULT nextval('public.special_cases_id_seq'::regclass);


--
-- Name: spend_profits id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.spend_profits ALTER COLUMN id SET DEFAULT nextval('public.spend_profits_id_seq'::regclass);


--
-- Name: start_periods id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.start_periods ALTER COLUMN id SET DEFAULT nextval('public.start_periods_id_seq'::regclass);


--
-- Name: start_periods Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.start_periods ALTER COLUMN "Code" SET DEFAULT nextval('public.start_periods_arr_seq'::regclass);


--
-- Name: store_count_sales id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.store_count_sales ALTER COLUMN id SET DEFAULT nextval('public.store_count_sales_id_seq'::regclass);


--
-- Name: store_counts id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.store_counts ALTER COLUMN id SET DEFAULT nextval('public.store_counts_id_seq'::regclass);


--
-- Name: store_transfer_filter_twos id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.store_transfer_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.store_transfer_filter_twos_id_seq'::regclass);


--
-- Name: store_transfer_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.store_transfer_filters ALTER COLUMN id SET DEFAULT nextval('public.store_transfer_filters_id_seq'::regclass);


--
-- Name: stores id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores ALTER COLUMN id SET DEFAULT nextval('public.stores_arr_seq'::regclass);


--
-- Name: stores Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores ALTER COLUMN "Code" SET DEFAULT nextval('public.stores_id_seq'::regclass);


--
-- Name: stores_default_data id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores_default_data ALTER COLUMN id SET DEFAULT nextval('public.stores_default_data_id_seq'::regclass);


--
-- Name: stores_moves id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores_moves ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_id_seq'::regclass);


--
-- Name: stores_moves_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores_moves_columns ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_columns_id_seq'::regclass);


--
-- Name: stores_moves_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores_moves_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_columns_sechdules_id_seq'::regclass);


--
-- Name: stores_moves_filter_twos id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores_moves_filter_twos ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_filter_twos_id_seq'::regclass);


--
-- Name: stores_moves_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores_moves_filters ALTER COLUMN id SET DEFAULT nextval('public.stores_moves_filters_id_seq'::regclass);


--
-- Name: stores_transfer_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores_transfer_columns ALTER COLUMN id SET DEFAULT nextval('public.stores_transfer_columns_id_seq'::regclass);


--
-- Name: stores_transfer_columns_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stores_transfer_columns_sechdules ALTER COLUMN id SET DEFAULT nextval('public.stores_transfer_columns_sechdules_id_seq'::regclass);


--
-- Name: stors_transfers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stors_transfers ALTER COLUMN id SET DEFAULT nextval('public.stors_transfers_id_seq'::regclass);


--
-- Name: stors_transfers Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.stors_transfers ALTER COLUMN "Code" SET DEFAULT nextval('public.stors_transfers_arr_seq'::regclass);


--
-- Name: student_groups id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.student_groups ALTER COLUMN id SET DEFAULT nextval('public.student_groups_id_seq'::regclass);


--
-- Name: student_importants id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.student_importants ALTER COLUMN id SET DEFAULT nextval('public.student_importants_id_seq'::regclass);


--
-- Name: students id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.students ALTER COLUMN id SET DEFAULT nextval('public.students_id_seq'::regclass);


--
-- Name: sub_images id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sub_images ALTER COLUMN id SET DEFAULT nextval('public.sub_images_id_seq'::regclass);


--
-- Name: sub_virables id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sub_virables ALTER COLUMN id SET DEFAULT nextval('public.sub_virables_id_seq'::regclass);


--
-- Name: subscribe_types id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.subscribe_types ALTER COLUMN id SET DEFAULT nextval('public.subscribe_types_id_seq'::regclass);


--
-- Name: sup_pages_e_com_designs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sup_pages_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.sup_pages_e_com_designs_id_seq'::regclass);


--
-- Name: sup_pages_part_two_e_com_designs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sup_pages_part_two_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.sup_pages_part_two_e_com_designs_id_seq'::regclass);


--
-- Name: sup_pages_wish_comp_e_com_designs id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.sup_pages_wish_comp_e_com_designs ALTER COLUMN id SET DEFAULT nextval('public.sup_pages_wish_comp_e_com_designs_id_seq'::regclass);


--
-- Name: taxes id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.taxes ALTER COLUMN id SET DEFAULT nextval('public.taxes_id_seq'::regclass);


--
-- Name: taxes Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.taxes ALTER COLUMN "Code" SET DEFAULT nextval('public.taxes_arr_seq'::regclass);


--
-- Name: teachers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.teachers ALTER COLUMN id SET DEFAULT nextval('public.teachers_id_seq'::regclass);


--
-- Name: teachers_groups id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.teachers_groups ALTER COLUMN id SET DEFAULT nextval('public.teachers_groups_id_seq'::regclass);


--
-- Name: teachers_subjects id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.teachers_subjects ALTER COLUMN id SET DEFAULT nextval('public.teachers_subjects_id_seq'::regclass);


--
-- Name: terms id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.terms ALTER COLUMN id SET DEFAULT nextval('public.terms_id_seq'::regclass);


--
-- Name: terms_maintainces id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.terms_maintainces ALTER COLUMN id SET DEFAULT nextval('public.terms_maintainces_id_seq'::regclass);


--
-- Name: testclients id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.testclients ALTER COLUMN id SET DEFAULT nextval('public.testclients_id_seq'::regclass);


--
-- Name: ticket_products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.ticket_products ALTER COLUMN id SET DEFAULT nextval('public.ticket_products_id_seq'::regclass);


--
-- Name: tickets id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.tickets ALTER COLUMN id SET DEFAULT nextval('public.tickets_id_seq'::regclass);


--
-- Name: tickets Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.tickets ALTER COLUMN "Code" SET DEFAULT nextval('public.tickets_arr_seq'::regclass);


--
-- Name: translation_tourism_companies id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.translation_tourism_companies ALTER COLUMN id SET DEFAULT nextval('public.translation_tourism_companies_id_seq'::regclass);


--
-- Name: translte_modules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.translte_modules ALTER COLUMN id SET DEFAULT nextval('public.translte_modules_id_seq'::regclass);


--
-- Name: translte_modules_details id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.translte_modules_details ALTER COLUMN id SET DEFAULT nextval('public.translte_modules_details_id_seq'::regclass);


--
-- Name: transltors id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.transltors ALTER COLUMN id SET DEFAULT nextval('public.transltors_id_seq'::regclass);


--
-- Name: update_values_investors id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.update_values_investors ALTER COLUMN id SET DEFAULT nextval('public.update_values_investors_id_seq'::regclass);


--
-- Name: upload_accountings id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.upload_accountings ALTER COLUMN id SET DEFAULT nextval('public.upload_accountings_id_seq'::regclass);


--
-- Name: users_moves id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.users_moves ALTER COLUMN id SET DEFAULT nextval('public.users_moves_id_seq'::regclass);


--
-- Name: v_a_prices id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.v_a_prices ALTER COLUMN id SET DEFAULT nextval('public.v_a_prices_id_seq'::regclass);


--
-- Name: v_a_products id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.v_a_products ALTER COLUMN id SET DEFAULT nextval('public.v_a_products_id_seq'::regclass);


--
-- Name: v_a_qties id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.v_a_qties ALTER COLUMN id SET DEFAULT nextval('public.v_a_qties_id_seq'::regclass);


--
-- Name: vendor_account_statement_column_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.vendor_account_statement_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.vendor_account_statement_column_sechdules_id_seq'::regclass);


--
-- Name: vendor_account_statement_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.vendor_account_statement_columns ALTER COLUMN id SET DEFAULT nextval('public.vendor_account_statement_columns_id_seq'::regclass);


--
-- Name: vendor_filters id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.vendor_filters ALTER COLUMN id SET DEFAULT nextval('public.vendor_filters_id_seq'::regclass);


--
-- Name: vendors id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.vendors ALTER COLUMN id SET DEFAULT nextval('public.vendors_id_seq'::regclass);


--
-- Name: vendors Code; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.vendors ALTER COLUMN "Code" SET DEFAULT nextval('public.vendors_arr_seq'::regclass);


--
-- Name: vendors_statements_column_sechdules id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.vendors_statements_column_sechdules ALTER COLUMN id SET DEFAULT nextval('public.vendors_statements_column_sechdules_id_seq'::regclass);


--
-- Name: vendors_statements_columns id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.vendors_statements_columns ALTER COLUMN id SET DEFAULT nextval('public.vendors_statements_columns_id_seq'::regclass);


--
-- Name: virables id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.virables ALTER COLUMN id SET DEFAULT nextval('public.virables_id_seq'::regclass);


--
-- Name: vouchers id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.vouchers ALTER COLUMN id SET DEFAULT nextval('public.vouchers_id_seq'::regclass);


--
-- Name: web_sliders id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.web_sliders ALTER COLUMN id SET DEFAULT nextval('public.web_sliders_id_seq'::regclass);


--
-- Name: wishlists id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.wishlists ALTER COLUMN id SET DEFAULT nextval('public.wishlists_id_seq'::regclass);


--
-- Name: work_departments id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.work_departments ALTER COLUMN id SET DEFAULT nextval('public.work_departments_id_seq'::regclass);


--
-- Name: workers_sales_petrols id; Type: DEFAULT; Schema: public; Owner: orientlimraerp_karim
--

ALTER TABLE ONLY public.workers_sales_petrols ALTER COLUMN id SET DEFAULT nextval('public.workers_sales_petrols_id_seq'::regclass);


--
-- Data for Name: a_v_pro_check_qties; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.a_v_pro_check_qties (id, "Product", "AvQty", "Qty", "RequestQty", created_at, updated_at, "OriginalProduct", "NewRequestQty") FROM stdin;
\.


--
-- Data for Name: abouts; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.abouts (id, "Image", "Image_2", "Image_3", "Arabic_Title", "English_Title", "Arabic_Desc", "English_Desc", created_at, updated_at) FROM stdin;
1	AboutImages/bTiXmoIvZgg7T3RUX9Y1.jpeg	AboutImages/NqfSP0j3p9wn3n5X4N3s.jpeg	AboutImages/DdpthioSZUZlqRR1szE9.jpeg	BELLE MULTIPURPOSE BOOTSTRAP 4 HTML TEMPLATE	BELLE MULTIPURPOSE BOOTSTRAP 4 HTML TEMPLATE	SED UT PERSPICIATIS UNDE OMNIS ISTE NATUS ERROR\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain.\r\n\nsimple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted.\r\n\nABOUT ANNIMEX WEB\r\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\nAt vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.	SED UT PERSPICIATIS UNDE OMNIS ISTE NATUS ERROR\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain.\r\n\nsimple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted.\r\n\nABOUT ANNIMEX WEB\r\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\r\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\nAt vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.	\N	2022-06-04 15:13:12
\.


--
-- Data for Name: acccounting_manuals; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.acccounting_manuals (id, "Code", "Name", "Type", "Parent", "Note", "User", created_at, updated_at, "Account_Code", "Pro_Group", "NameEn", "SearchCode") FROM stdin;
824	606	مصروفات البيع و التوزيع	0	20	\N	1	2022-04-13 19:11:41	2022-10-18 22:42:48	75	\N	Selling and Distribution Expenses	\N
826	403	تحصيل دليفري	1	18	\N	11	2022-05-15 16:52:32	2022-10-18 22:42:47	57	\N	Delivery Service Collection	\N
2523	20102	مورد افتراضي	1	37	\N	11	2024-02-09 00:08:40	2024-02-09 00:08:40	\N	\N	Default Vendor	\N
119	205	مجمع الاهلاك	0	16	\N	1	2021-10-02 08:23:41	2024-02-14 23:12:23	41	\N	Asset Depreciation Accumulator	\N
852	607	رسوم بنوك	0	20	\N	11	2022-11-03 07:48:29	2022-11-03 07:48:29	٠	\N	Bank Fees	\N
853	608	مصاريف شركات التقسيط	0	20	\N	11	2022-11-03 07:49:34	2022-11-03 07:49:34	0	\N	Installment Companies Expenses	\N
854	60701	رسوم خدمه	1	852	\N	11	2022-11-03 07:49:52	2022-11-03 07:49:52	0	\N	Service Charges	\N
856	404	إيردات اخري	0	18	\N	11	2022-11-03 07:55:13	2022-11-03 07:55:13	0	\N	Other Revenues	\N
888	1020103	شركات التقسيط	0	23	\N	11	2022-11-03 07:54:02	2022-11-03 07:54:02	0	\N	Installment Companies	\N
2497	6060204	تكلفه مصنعيه	1	55	\N	11	2022-12-21 02:46:32	2022-12-21 02:46:32	0	\N	Manufacturing Cost	\N
2498	6060205	تالف الصيانه	1	55	\N	11	2023-01-16 18:58:53	2023-01-16 18:58:53	0	\N	Maintenance Damaged	\N
2503	6060107	مندوب مبيعات افتراضي  عموله 	1	164	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales  Commission 	\N
2505	20401	مندوب مبيعات افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales  Merit 	\N
2513	20403	مهندس افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng  Merit 	\N
2518	60113	نادل افتراضي	1	53	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter	\N
2502	60109	مندوب مبيعات افتراضي	1	53	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales	\N
2504	102040108	مندوب مبيعات افتراضي  عهده 	1	121	\N	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	Default Sales  Custody 	\N
2510	60111	مهندس افتراضي	1	53	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng	\N
2511	6060109	مهندس افتراضي  عموله 	1	164	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng  Commission 	\N
2512	102040110	مهندس افتراضي  عهده 	1	121	\N	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	Default Eng  Custody 	\N
2519	6060111	نادل افتراضي  عموله 	1	164	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter  Commission 	\N
2520	102040112	نادل افتراضي  عهده 	1	121	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter  Custody 	\N
2521	20405	نادل افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	Default Waiter  Merit 	\N
2496	405	ايراد مصنعية	1	18	\N	11	2022-12-21 02:46:07	2024-02-14 23:15:25	0	\N	Manufacturing Revenue	\N
895	40401	ايردات رسوم الخدمة	1	856	\N	11	2022-11-03 07:55:46	2024-02-14 23:15:43	0	\N	Service Charges Revenues	\N
2527	209	استحقاق مستثمرين	0	16	\N	11	2024-11-05 12:49:22	2024-11-05 12:49:22	\N	\N	Investors' Eligibility	\N
57	6060202	كهرباء	1	55	\N	1	2021-06-16 01:26:56	2022-10-18 22:42:48	85	\N	Electricity	\N
58	6060203	مصروفات ضيافه	1	55	\N	1	2021-06-16 01:41:37	2022-10-18 22:42:48	86	\N	Hosting Expenses	\N
70	10206	وسيط المخازن	0	22	\N	1	2021-07-16 12:00:41	2022-10-18 22:42:47	29	\N	Intermediate Warehouse Account	\N
71	1020601	وسيط المخازن	1	70	\N	1	2021-07-16 12:01:10	2022-10-18 22:42:47	30	\N	Intermediate Warehouse Account	\N
97	603	شركات الشحن	0	20	\N	1	2021-08-08 10:48:13	2022-10-18 22:42:48	70	\N	Freight Companies	\N
112	20202	بدون ضريبة	1	39	\N	1	2021-08-23 00:16:53	2022-10-18 22:42:47	37	\N	Without Taxes	\N
121	1020401	العهد	0	26	\N	1	2021-10-02 08:24:25	2022-10-18 22:42:47	18	\N	Custody	\N
122	10102	الأثاث المكتبي	0	21	\N	1	2021-10-02 08:25:42	2022-10-18 22:42:47	3	\N	Office Furniture	\N
136	303	الارباح و الخسائر	0	17	\N	1	2021-10-09 12:10:07	2022-10-18 22:42:47	47	\N	Profits and Losses	\N
139	30301	الارباح الحالية	0	136	\N	1	2021-10-13 17:36:17	2022-10-18 22:42:47	48	\N	Current Profits	\N
140	30302	الارباح الرأس مالية	0	136	\N	1	2021-10-13 17:36:41	2022-10-18 22:42:47	49	\N	Capital Profits	\N
141	30303	الارباح المرحلة	0	136	\N	1	2021-10-13 17:37:01	2022-10-18 22:42:47	50	\N	Retained Earnings	\N
147	103	اصول اخري	0	15	\N	1	2021-10-14 17:02:03	2022-10-18 22:42:47	31	\N	Other Assets	\N
148	207	خصوم طويلة الاجل	0	16	\N	1	2021-10-14 17:02:50	2022-10-18 22:42:47	42	\N	Long-Term Liabilities	\N
164	60601	عمولات الموظفين	0	824	\N	1	2021-10-28 09:42:04	2022-10-18 22:42:48	76	\N	Employee Commissions	\N
206	402	خصم مكتسب	1	18	\N	1	2022-02-16 22:01:22	2022-10-18 22:42:47	56	\N	Earned Discount	\N
15	1	الأصول	0	0	\N	1	\N	\N	0	\N	Assets	\N
2499	1020503	مخزن الطلبات	1	27	\N	11	2023-08-30 11:11:31	2023-08-30 11:11:31	\N	\N	Requests Store	\N
16	2	الخصوم	0	0	\N	1	2021-06-16 00:29:12	2022-10-18 22:42:47	32	\N	Liabilities	\N
17	3	حقوق الملكية	0	0	\N	1	2021-06-16 00:29:32	2022-10-18 22:42:47	43	\N	Shareholders equity	\N
18	4	الايرادات	0	0	\N	1	2021-06-16 00:29:56	2022-10-18 22:42:47	51	\N	Revenues	\N
19	5	تكلفة المبيعات	0	0	\N	1	2021-06-16 00:30:22	2022-10-18 22:42:48	58	\N	Cost Of Goods Sold (COGS)	\N
20	6	المصروفات	0	0	\N	1	2021-06-16 00:30:50	2022-10-18 22:42:48	60	\N	Expenses	\N
21	101	أصول ثابتة	0	15	\N	1	2021-06-16 00:31:46	2022-10-18 22:42:47	2	\N	Fixed Assets	\N
22	102	أصول متداولة	0	15	\N	1	2021-06-16 00:32:28	2022-10-18 22:42:47	4	\N	Current Assets	\N
23	10201	النقدية وما في حكمها	0	22	\N	1	2021-06-16 00:34:14	2022-10-18 22:42:47	5	\N	All kinds of cash	\N
24	10202	العملاء	0	22	\N	1	2021-06-16 00:34:53	2022-10-18 22:42:47	11	\N	Customers	\N
25	10203	أوراق قبض	0	22	\N	1	2021-06-16 00:36:12	2022-10-18 22:42:47	15	\N	Notes Receivable	\N
26	10204	مدينين	0	22	\N	1	2021-06-16 00:37:03	2022-10-18 22:42:47	17	\N	Debtors	\N
27	10205	المخزون	0	22	\N	1	2021-06-16 00:37:44	2022-10-18 22:42:47	26	\N	Inventory	\N
28	1020101	الخزينة	0	23	\N	1	2021-06-16 00:38:47	2022-10-18 22:42:47	6	\N	Cash Fund	\N
29	1020102	نقدية بالبنك	0	23	\N	1	2021-06-16 00:40:04	2022-10-18 22:42:47	8	\N	Bank cash	\N
35	1020301	أوراق قبض	1	25	\N	1	2021-06-16 00:46:08	2022-10-18 22:42:47	16	\N	Notes Receivable	\N
37	201	الموردين	0	16	\N	1	2021-06-16 01:12:06	2022-10-18 22:42:47	33	\N	Suppliers	\N
39	202	الضرائب	0	16	\N	1	2021-06-16 01:13:20	2022-10-18 22:42:47	35	\N	Taxes	\N
2525	20501	مجمع اهلاك الاثاث المكتبي	1	119	\N	11	2024-02-14 23:13:11	2024-02-14 23:13:11	0	\N	مجمع اهلاك الاثاث المكتبي	\N
41	203	أوراق دفع	0	16	\N	1	2021-06-16 01:14:38	2022-10-18 22:42:47	38	\N	Notes Payable	\N
42	20301	أوراق دفع	1	41	\N	1	2021-06-16 01:15:16	2022-10-18 22:42:47	39	\N	Notes Payable	\N
43	204	دائنين	0	16	\N	1	2021-06-16 01:15:57	2022-10-18 22:42:47	40	\N	Creditors	\N
44	301	رأس المال	0	17	\N	1	2021-06-16 01:16:55	2022-10-18 22:42:47	44	\N	Capital	\N
45	30101	رأس المال	1	44	\N	1	2021-06-16 01:17:44	2022-10-18 22:42:47	45	\N	Capital	\N
46	302	جاري الشركاء	0	17	\N	1	2021-06-16 01:18:34	2022-10-18 22:42:47	46	\N	Partners Current Account	\N
47	401	إيرادات المبيعات	0	18	\N	1	2021-06-16 01:19:32	2022-10-18 22:42:47	52	\N	Sales Revenue	\N
48	40101	المبيعات	1	47	\N	1	2021-06-16 01:20:15	2022-10-18 22:42:47	53	\N	Sales	\N
49	40102	مردودات المبيعات	1	47	\N	1	2021-06-16 01:20:45	2022-10-18 22:42:47	54	\N	Sales Return	\N
50	60401	خصم مسموح به	1	851	\N	1	2021-06-16 01:21:13	2022-10-18 22:42:48	72	\N	Allowed Discount	\N
51	40104	خدمة صالة	1	47	\N	1	2021-06-16 01:21:57	2022-10-18 22:42:47	55	\N	Lounge Service	\N
52	501	تكلفه بضاعه مباعه	1	19	\N	1	2021-06-16 01:23:13	2022-10-18 22:42:48	59	\N	Cost Of Goods Sold (COGS)	\N
53	601	المرتبات والأجور	0	20	\N	1	2021-06-16 01:24:33	2022-10-18 22:42:48	61	\N	Salaries and Wages	\N
54	60101	الموظفين	0	53	\N	1	2021-06-16 01:25:07	2022-10-18 22:42:48	62	\N	Employees	\N
55	60602	مصروفات التشغيل	0	824	\N	1	2021-06-16 01:25:48	2022-10-18 22:42:48	83	\N	Operating Expenses	\N
56	6060201	الإيجار	1	55	\N	1	2021-06-16 01:26:20	2022-10-18 22:42:48	84	\N	Rentals	\N
188	60501	مصروف اهلاك الاثاث المكتبي	1	120	\N	1	2021-12-29 11:16:16	2024-02-14 23:14:32	74	\N	New Depreciation	\N
2526	208	المستثمرين	0	16	\N	11	2024-11-05 12:49:01	2024-11-05 12:49:01	\N	\N	Investors	\N
2506	60110	مندوب مشتريات افتراضي	1	53	\N	11	2024-02-08 23:54:06	2024-02-08 23:55:02	\N	\N	Default Purchaser	\N
2522	1020205	عميل افتراضي	1	24	\N	11	2024-02-09 00:08:02	2024-02-09 00:08:02	\N	\N	Default Customer	\N
825	602	مصروفات عمومية وادارية	0	20	\N	1	2022-04-13 19:12:04	2022-10-18 22:42:48	69	\N	General and Administrative Expenses	\N
30	102010101	الخزينة الرئيسية	1	28	\N	1	2021-06-16 00:41:19	2024-02-09 00:18:47	7	\N	Main Safe	\N
830	1020402	حساب معايره	1	26	\N	11	2022-05-21 01:12:14	2022-10-18 22:42:47	25	\N	Calibrated Account	\N
2508	102040109	مندوب مشتريات افتراضي  عهده 	1	121	\N	11	2024-02-08 23:54:07	2024-02-08 23:55:02	\N	\N	Default Purchaser  Custody 	\N
851	604	خصم مسموح به	0	20	\N	1	\N	2022-10-18 22:42:48	71	\N	Allowed Discount	\N
2500	1020504	المخزن الرئيسي	1	27	\N	11	2024-02-08 23:43:55	2024-02-08 23:43:55	\N	\N	Main Store	\N
2501	1020204	المخزن الرئيسي   عميل مخزن 	1	24	\N	11	2024-02-08 23:43:55	2024-02-08 23:43:55	\N	\N	Main Store    Store Client 	\N
2507	6060108	مندوب مشتريات افتراضي  عموله 	1	164	\N	11	2024-02-08 23:54:07	2024-02-08 23:55:02	\N	\N	Default Purchaser  Commission 	\N
2509	20402	مندوب مشتريات افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:54:07	2024-02-08 23:55:02	\N	\N	Default Purchaser  Merit 	\N
2514	60112	مندوب توصيل افتراضي	1	53	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery	\N
2515	6060110	مندوب توصيل افتراضي  عموله 	1	164	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery  Commission 	\N
2516	102040111	مندوب توصيل افتراضي  عهده 	1	121	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery  Custody 	\N
2517	20404	مندوب توصيل افتراضي  استحقاق 	1	43	\N	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	Default Delivery  Merit 	\N
32	102010201	البنك الاهلي	1	29	\N	1	2021-06-16 00:42:58	2024-02-09 00:20:06	9	\N	SNB	\N
2524	60301	زاجل	1	97	\N	11	2024-02-09 00:41:56	2024-02-09 00:41:56	\N	\N	Zagel	\N
120	605	مصروفات الاهلاك	0	20	\N	1	2021-10-02 08:23:55	2024-02-14 23:13:50	73	\N	Depreciation	\N
2528	304	مصروفات ارباح مستثمرين	0	17	\N	11	2024-11-05 12:49:39	2024-11-13 08:56:22	0	\N	Investors' Dividend Expenses	\N
2529	1020206	TUV	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2530	1020207	اولاد تمام حلوان	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2533	1020210	شركة الزهور للمنظفات دار السلام	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2535	1020212	منظفات التوحيد	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2537	1020214	شركة ميرو للالبان	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2539	1020216	الفتح للبلاستيك	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2540	1020217	مصنع النسر للمناديل	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2541	1020218	مصنع سيلكي للمناديل	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2542	1020219	توفير اونلاين	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2543	1020220	جيت	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2545	1020222	لولو	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2546	1020223	جملة ماركت	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2547	1020224	الشيخ عمرو	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2548	1020225	مرتب اسماء	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2549	1020226	الفا ماركت	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2550	1020227	كارفور المعادي	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2551	1020228	تالف اوريانت جلوري	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2552	1020229	صيدلية الدكتور علاء	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
40	20201	القيمة المضافة	1	39	\N	1	2021-06-16 01:13:49	2025-01-27 18:52:22	36	\N	VAT	\N
2553	1020230	مكسب اون لاين	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2554	1020231	طلبات ماركت	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2555	1020232	الحاج رمضان سيد	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2556	1020233	الازهري ادوات مكتبية	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2557	1020234	تكنولوجي  مول الكمبيوتر	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2558	1020235	مواصلات	1	24	\N	11	2025-01-15 08:41:34	2025-01-15 08:41:34	\N	\N	\N	\N
2559	1020236	كازيون ماركت	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2560	1020237	التوحيد والنور	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2561	1020238	طه حسين	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2562	1020239	طارق عبد الحميد	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2563	1020240	محمود فاروق مطبعة	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2564	1020241	شركة دلتا للتطوير العقاري	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2565	1020242	البيت	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2566	1020243	هوم سنتر	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2567	1020244	عام	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2568	1020245	اولاد عبد المقصود	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2569	1020246	شركة جوهر باب البحر	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2570	1020247	بن العروبة	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2571	1020248	نادى سماش	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2572	1020249	بدون	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2573	1020250	فرست	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2574	1020251	دالتا	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2575	1020252	سى اتش	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2576	1020253	شركه المعادى	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2577	1020254	خلودى للدعايه والاعلان	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2578	1020255	الموسسه المتخصصه للموازين	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2579	1020256	الدلتا	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2580	1020257	محل البركه للعطاره	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2581	1020258	نسكافيه	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2582	1020259	الكوننتتال	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2583	1020260	اجورا	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2584	1020261	خالد جلوان	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2585	1020262	مول العتبه	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2586	1020263	بيت الجمله	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2587	1020264	كريم الديب	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2588	1020265	ابو وليد	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2589	1020266	مطاحن ومخابز شمال القاهره	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2590	1020267	فرع المحل الصغير	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2591	1020268	طيبات	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2592	1020269	النبراوى	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2593	1020270	العالميه ام اتش	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2594	1020271	نادى سماش المطار	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2595	1020272	حكيم بلاستيك	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2596	1020273	الوكاله للتجاره	1	24	\N	11	2025-01-15 08:41:35	2025-01-15 08:41:35	\N	\N	\N	\N
2597	1020274	ينوفيد	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2598	1020275	العربى	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2599	1020276	ايزيس	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2600	1020277	المتحده للتوريدات	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2601	1020278	جورى	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2602	1020279	حيدر التجاريه	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2603	1020280	قناه الغد	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2604	1020281	ارتليا	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2605	1020282	امورادو	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2606	1020283	شركه كونكت	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2607	1020284	مكتب المعادى	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2608	1020285	عينات	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2609	1020286	محل سلمان	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2610	1020287	مكه باك	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2611	1020288	yes mac	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2612	1020289	yes pac	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2613	1020290	ابو عوف	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2614	1020291	العالميه للتوريدات	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2615	1020292	ايه ا  ام للخدمات الطبيه	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2616	1020293	y.m	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2617	1020294	جلوبر	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2618	1020295	موسسه بلال	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2619	1020296	طلابيه	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2620	1020297	جو ى للاستيراد	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2621	1020298	كامينا	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2622	1020299	جامعه نيو جيزه	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2623	10202100	ام ايه جروب	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2624	10202101	الشركه المصريه للتجاره والتوزيع	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2625	10202102	جوهر المعادى	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2626	10202103	بلاتنيوم	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2627	10202104	توريده	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2628	10202105	جمله الجمله	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2629	10202106	رجب العطار	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2630	10202107	اسولق الشريف	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2631	10202108	SGS اسكندريه	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2633	10202110	السويس SGS	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2634	10202111	بن شاهين	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2635	10202112	فلاى	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2636	10202113	سوق الحميديه	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2637	10202114	شوقى العوام	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2638	10202115	الاصيل للمواد الغذائيه	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2639	10202116	المخزن	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2640	10202117	رومانتيك	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2641	10202118	العجيل للاجهزه	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2642	10202119	هيرو	1	24	\N	11	2025-01-15 08:41:36	2025-01-15 08:41:36	\N	\N	\N	\N
2643	10202120	كاش	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2644	10202121	dme	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2645	10202122	سترو	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2646	10202123	ابو جبه	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2647	10202124	ام سكوير المصيف	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2648	10202125	بن سليمان	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2649	10202126	ال خان	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2650	10202127	جوى	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2651	10202128	المعادى تربو	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2652	10202129	شركه ثروه	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2653	10202130	شركه ثروه بريد	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2654	10202131	ترجمه الدقى	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2655	10202132	عطاره ال خان	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2656	10202133	المستقبل	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2657	10202134	محمد حلاوه	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2658	10202135	ال طه	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2659	10202136	هانى سعد	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2660	10202137	جازتك	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2661	10202138	المنيع	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2662	10202139	الفيومى	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2663	10202140	اسميلى للاداره والتطوير السياحى	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2664	10202141	AG	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2665	10202142	جرد	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2666	10202143	ECSD	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2667	10202144	هليوبليس	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2668	10202145	بن الحبشى	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2669	10202146	EURO	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2670	10202147	دلتا كابيتال	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2671	10202148	اندلسيه	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2672	10202149	جامعه القاهره	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2673	10202150	نيوم للتنميه  اركان	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2674	10202151	ندى	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2675	10202152	بود ايجيبت	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2676	10202153	المطورون العرب	1	24	\N	11	2025-01-15 08:41:37	2025-01-15 08:41:37	\N	\N	\N	\N
2677	10202154	نيوم للتنميه   الشيخ زايد	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2678	10202155	هانى سعيد	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2679	10202156	اسماش التجمع	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2680	10202157	petro	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2681	10202158	زغلول	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2682	10202159	GMC	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2683	10202160	بترومين	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2684	10202161	بطرس	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2685	10202162	لوكس سرى	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2686	10202163	افيز	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2687	10202164	حازم جراج	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2688	10202165	جليد	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2689	10202166	عواد نسكافيه	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2690	10202167	سكر مظبوط	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2691	10202168	عبد الرحمن  نسكافيه	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2692	10202169	خالد حسين	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2693	10202170	ارسيلوميتال	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2694	10202171	فيوتشر	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2695	10202172	الشركه الرباعيه	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2696	10202173	بريف ماركت	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2697	10202174	DMCاداره رقم  1	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2698	10202175	دى ام سى  اللوتس	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2699	10202176	دى ام سى  الرحاب	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2700	10202177	دى ام سى  الوفاء والامل	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2701	10202178	دى ام سى  احمد ورشه الصيانه	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2702	10202179	دى ام سى الاداره 4 مكتب فنى	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2703	10202180	دى ام سى اداره رقم 2	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2704	10202181	دى ام سى الحميات	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2705	10202182	دى ام سى  اداره رقم 5	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2706	10202183	دى ام سى مخزن الرحاب	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2707	10202184	دى ام سى  مخن بلبيس	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2708	10202185	دى ام سى مخزن المشير	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2709	10202186	دى ام سى مخزن الحميات	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2710	10202187	دى ام سى مخزن الوفاء والامل	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2711	10202188	دى ام سى مخزن اللوتس	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2712	10202189	دى ام سى امنا مخازنweb help	1	24	\N	11	2025-01-15 08:41:38	2025-01-15 08:41:38	\N	\N	\N	\N
2713	10202190	دى ام سى غفير  help	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2714	10202191	دى ام سى موقع web help	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2715	10202192	دى ام سى استشارى web  help	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2716	10202193	دى ام سى استشارى ساجا 2	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2717	10202194	جذور  المعادىhq	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2718	10202195	دى ام سى غفير  ساجا 2	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2719	10202196	تسويه فواتير	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2720	10202197	دى ام  عمومى	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2721	10202198	دى ام  س عمومى	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2722	10202199	جى ام سى	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2723	10202200	باز للصناعات	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2724	10202201	اوتو موبيلتى	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2725	10202202	دى ام سى غفير زيزنيا	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2726	10202203	امازون اونلاين	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2727	10202204	عمرو القصر العيني الفرنساوي	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2728	10202205	احمد عبد العزيز الفجالة	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2729	10202206	بن الغرباوي	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2730	10202207	بن عبد المعبود	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2731	10202208	مشتريات القصر العيني	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2732	10202209	اولاد الشيخ	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2733	10202210	عبد الرحمن	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2734	10202211	شركه الفتح للتوريدات	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2735	10202212	جذور  الابراج الصينيه العاصمه	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2736	10202213	جذور سوديك الشروق	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2737	10202214	جذور  قطاميه التجمع	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2738	10202215	جذور بدون	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2739	10202216	اولاد رجب للادوات الصحيه	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2740	10202217	شركه نزيه العطار	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2741	10202218	ال اسماعيل للمحاماه	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2742	10202219	سماش الخمايل	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2743	10202220	مخزن	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2744	10202221	الجامعه الامريكيه	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2745	10202222	عينه	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2746	10202223	البردى لصناعة الورق	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2747	10202224	شركه ام سكوير	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2748	10202225	مول صن سيتى	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2749	10202226	اولاد ابو على	1	24	\N	11	2025-01-15 08:41:39	2025-01-15 08:41:39	\N	\N	\N	\N
2750	10202227	شركه الفكهانيه	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2751	10202228	مكتب صقر	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2752	10202229	اسواق الشريف	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2753	10202230	اسلام مودرن	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2754	10202231	فريندز	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2755	10202232	نيوم للتنميه السياحيه الماظه	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2756	10202233	الجمعيه المصريه للابداع	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2757	10202234	جامعه هليوبليس	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2758	10202235	ماركت  المحطه	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2759	10202236	دى ام سى  غفير مصنع العاشر	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2760	10202237	دى ام سى مخزن ساجا 2	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2761	10202238	دى ام سى  ساجا  22	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2762	10202239	جذور تاج فيلا طريق السويس	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2763	10202240	جيلى	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2764	10202241	ياز	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2765	10202242	ابراهيم سائق	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2766	10202243	شركه المزارعون العرب	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2767	10202244	مصطفى مخزن	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2768	10202245	sgs دمياط	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2769	10202246	شركه اتصال	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2770	10202247	جى ام سى احمد رشاد +عامل الصيانخ	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2771	10202248	جى ام سى اداره 2	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2772	10202249	جى ام سى مستلزمات بوفيه الاداره	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2773	10202250	جى ام سى المخزن العام	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2774	10202251	جى ام سى الرحاب	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2775	10202252	جى ام سى الوفاء والامل	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2776	10202253	جى ام سى سجا 2	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2777	10202254	جى ام سى موقع الوفاء والامل	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2778	10202255	جذور مخزن وشاليه	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2779	10202256	جذذور استبت جديد اكتوبر	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2780	10202257	جذور مستقبل اكتوبر	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2781	10202258	المعادى SGS	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2782	10202259	جى ام سى ايمن ابو الفتوح	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2783	10202260	جى ام سى اداره رقم 4	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2784	10202261	جى ام سى اداره رقم 1	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2785	10202262	جى ام سى مكتب الاستشارى	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2786	10202263	جى ام سى مهندسين ومشرفين الموقع	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2787	10202264	جى ام سى امناء مخازن عدد4	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2788	10202265	جى ام سى البوفيه للفنين	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2789	10202266	جى ام سى اداره رقم 5	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2790	10202267	جى ام سى غير موقع زيزنيا	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2791	10202268	جى ام سى الغفير +2 عمال بالمصنع	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2792	10202269	جذور	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2793	10202270	مجموع مرتبات	1	24	\N	11	2025-01-15 08:41:40	2025-01-15 08:41:40	\N	\N	\N	\N
2794	10202271	ابراهيم سائق	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2795	10202272	مصطفى	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2796	10202273	رمضان	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2797	10202274	محمد	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2798	10202275	ندى نشأت	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2799	10202276	اسماء	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2800	10202277	ام خالد	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2801	10202278	فاطمه	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2802	10202279	شركه حرسات	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2803	10202280	ممشي مصر	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2804	10202281	بود ايجبت   المطار	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2805	10202282	بود ايجبت شيراتون	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2806	10202283	اسواق للتطوير العقاري	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2807	10202284	ام سكوير  المصيف	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2808	10202285	ام سكوير المعادى الهندسيه	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2809	10202286	ام سكوير موكب تريو	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2810	10202287	ام سكوير المعادى الضيافه	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2811	10202288	ام سكوير كرفان تريو	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2812	10202289	جذور المعادى	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2813	10202290	جذور سانت فاتيما	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2814	10202291	جذور مستقبل سيتى	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2815	10202292	جذور  مخزن اوديسنت	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2816	10202293	جامعه البادية	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2817	10202294	محمد فتحى	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2818	10202295	شركه مكه	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2819	10202296	شركة النيل التطوير العقارى	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2820	10202297	شركة اللبنانيه السويسريه	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2821	10202298	يوروتولز	1	24	\N	11	2025-01-15 08:41:41	2025-01-15 08:41:41	\N	\N	\N	\N
2823	102010103	خزينة ندي	1	28	\N	1	2025-01-16 18:21:18	2025-01-16 18:21:18	\N	\N	خزينة ندي	\N
2824	102010104	خزينة أسماء	1	28	\N	1	2025-01-16 18:21:32	2025-01-16 18:21:32	\N	\N	خزينة أسماء	\N
2825	102010105	خزينة محمد	1	28	\N	1	2025-01-16 18:21:50	2025-01-16 18:21:50	\N	\N	خزينة محمد	\N
2826	102010106	خزينة رمضان	1	28	\N	1	2025-01-16 18:22:05	2025-01-16 18:22:05	\N	\N	خزينة رمضان	\N
2827	102010107	خزينة فاطمة	1	28	\N	1	2025-01-16 18:22:18	2025-01-16 18:22:18	\N	\N	خزينة فاطمة	\N
2840	60117	اسماء	1	53	\N	1	2025-01-16 18:52:08	2025-01-25 12:53:35	\N	\N	اسماء	\N
2842	102040116	اسماء  عهده 	1	121	\N	1	2025-01-16 18:52:08	2025-01-25 12:53:35	\N	\N	اسماء  Custody 	\N
2841	6060115	اسماء  عموله 	1	164	\N	1	2025-01-16 18:52:08	2025-01-25 12:53:35	\N	\N	اسماء  Commission 	\N
2832	60115	ندى	1	53	\N	1	2025-01-16 18:27:53	2025-01-25 12:54:28	\N	\N	ندى	\N
2834	102040114	ندى  عهده 	1	121	\N	1	2025-01-16 18:27:53	2025-01-25 12:54:28	\N	\N	ندى  Custody 	\N
2833	6060113	ندى  عموله 	1	164	\N	1	2025-01-16 18:27:53	2025-01-25 12:54:28	\N	\N	ندى  Commission 	\N
2835	20407	ندى  استحقاق 	1	43	\N	1	2025-01-16 18:27:53	2025-01-25 12:54:28	\N	\N	ندى  Merit 	\N
2864	102010108	خزينة ندي هاشم	1	28	\N	1	2025-01-16 19:54:03	2025-01-16 19:54:03	\N	\N	خزينة ندي هاشم	\N
2865	102010109	خزينة ولاء	1	28	\N	1	2025-01-16 19:54:33	2025-01-16 19:54:33	\N	\N	خزينة ولاء	\N
2870	60124	ولاء	1	53	\N	1	2025-01-16 19:56:45	2025-01-16 19:56:45	\N	\N	ولاء	\N
2871	6060122	ولاء  عموله 	1	164	\N	1	2025-01-16 19:56:45	2025-01-16 19:56:45	\N	\N	ولاء  Commission 	\N
2872	102040123	ولاء  عهده 	1	121	\N	1	2025-01-16 19:56:45	2025-01-16 19:56:45	\N	\N	ولاء  Custody 	\N
2873	20416	ولاء  استحقاق 	1	43	\N	1	2025-01-16 19:56:45	2025-01-16 19:56:45	\N	\N	ولاء  Merit 	\N
2878	60126	رقية	1	53	\N	1	2025-01-16 20:12:08	2025-01-16 20:12:08	\N	\N	رقية	\N
2879	6060124	رقية  عموله 	1	164	\N	1	2025-01-16 20:12:08	2025-01-16 20:12:08	\N	\N	رقية  Commission 	\N
2880	102040125	رقية  عهده 	1	121	\N	1	2025-01-16 20:12:08	2025-01-16 20:12:08	\N	\N	رقية  Custody 	\N
2881	20418	رقية  استحقاق 	1	43	\N	1	2025-01-16 20:12:08	2025-01-16 20:12:08	\N	\N	رقية  Merit 	\N
2866	60123	ندي هاشم	1	53	\N	1	2025-01-16 19:55:35	2025-01-17 19:23:05	\N	\N	ندي هاشم	\N
2868	102040122	ندي هاشم  عهده 	1	121	\N	1	2025-01-16 19:55:35	2025-01-17 19:23:05	\N	\N	ندي هاشم  Custody 	\N
2867	6060121	ندي هاشم  عموله 	1	164	\N	1	2025-01-16 19:55:35	2025-01-17 19:23:05	\N	\N	ندي هاشم  Commission 	\N
2869	20415	ندي هاشم  استحقاق 	1	43	\N	1	2025-01-16 19:55:35	2025-01-17 19:23:05	\N	\N	ندي هاشم  Merit 	\N
2882	102010110	خزينه زين	1	28	\N	59	2025-01-18 17:40:12	2025-01-18 17:40:12	\N	\N	خزينه زين	\N
2883	102010111	خزينه شعبان	1	28	\N	59	2025-01-18 17:40:36	2025-01-18 17:40:36	\N	\N	خزينه شعبان	\N
2884	102010112	خزينه احمد	1	28	\N	59	2025-01-18 17:41:00	2025-01-18 17:41:00	\N	\N	خزينه احمد	\N
2885	60127	زين	1	53	\N	59	2025-01-18 17:42:51	2025-01-18 17:42:51	\N	\N	زين	\N
2886	6060125	زين  عموله 	1	164	\N	59	2025-01-18 17:42:51	2025-01-18 17:42:51	\N	\N	زين  Commission 	\N
2887	102040126	زين  عهده 	1	121	\N	59	2025-01-18 17:42:51	2025-01-18 17:42:51	\N	\N	زين  Custody 	\N
2888	20419	زين  استحقاق 	1	43	\N	59	2025-01-18 17:42:51	2025-01-18 17:42:51	\N	\N	زين  Merit 	\N
2889	60128	شعبان	1	53	\N	59	2025-01-18 17:44:25	2025-01-18 17:44:25	\N	\N	شعبان	\N
2890	6060126	شعبان  عموله 	1	164	\N	59	2025-01-18 17:44:25	2025-01-18 17:44:25	\N	\N	شعبان  Commission 	\N
2891	102040127	شعبان  عهده 	1	121	\N	59	2025-01-18 17:44:25	2025-01-18 17:44:25	\N	\N	شعبان  Custody 	\N
2892	20420	شعبان  استحقاق 	1	43	\N	59	2025-01-18 17:44:25	2025-01-18 17:44:25	\N	\N	شعبان  Merit 	\N
2893	60129	احمد	1	53	\N	59	2025-01-18 17:45:33	2025-01-18 17:45:33	\N	\N	احمد	\N
2894	6060127	احمد  عموله 	1	164	\N	59	2025-01-18 17:45:33	2025-01-18 17:45:33	\N	\N	احمد  Commission 	\N
2895	102040128	احمد  عهده 	1	121	\N	59	2025-01-18 17:45:33	2025-01-18 17:45:33	\N	\N	احمد  Custody 	\N
2896	20421	احمد  استحقاق 	1	43	\N	59	2025-01-18 17:45:33	2025-01-18 17:45:33	\N	\N	احمد  Merit 	\N
2897	10202299	fly in	1	24	\N	63	2025-01-20 16:05:23	2025-01-20 16:05:23	\N	\N	fly in	\N
2898	20103	سكر مظبوط	1	37	\N	59	2025-01-22 17:26:42	2025-01-22 17:26:42	\N	\N	سكر مظبوط	\N
2899	20104	بن شاهين	1	37	\N	59	2025-01-22 18:03:13	2025-01-22 18:03:13	\N	\N	بن شاهين	\N
2632	10202109	SGS سفاجا	1	24	\N	11	2025-01-15 08:41:36	2025-01-23 11:22:51	\N	\N	SGS سفاجا	\N
2900	10202300	جذور التجمع الثالث	1	24	\N	59	2025-01-23 12:52:19	2025-01-23 12:52:19	\N	\N	جذور التجمع الثالث	\N
2901	10202301	جذور مستبل سيتى	1	24	\N	59	2025-01-23 12:53:21	2025-01-23 12:53:21	\N	\N	جذور مستبل سيتى	\N
2852	60120	ابوعلاء	1	53	\N	1	2025-01-16 18:56:12	2025-01-23 19:19:08	\N	\N	ابوعلاء	\N
2856	60121	ام خالد	1	53	\N	1	2025-01-16 18:56:52	2025-01-23 19:20:27	\N	\N	ام خالد	\N
2858	102040120	ام خالد  عهده 	1	121	\N	1	2025-01-16 18:56:52	2025-01-23 19:20:27	\N	\N	ام خالد  Custody 	\N
2857	6060119	ام خالد  عموله 	1	164	\N	1	2025-01-16 18:56:52	2025-01-23 19:20:27	\N	\N	ام خالد  Commission 	\N
2859	20413	ام خالد  استحقاق 	1	43	\N	1	2025-01-16 18:56:52	2025-01-23 19:20:27	\N	\N	ام خالد  Merit 	\N
2860	60122	ام كريمه	1	53	\N	1	2025-01-16 18:57:38	2025-01-23 19:21:14	\N	\N	ام كريمه	\N
2862	102040121	ام كريمه  عهده 	1	121	\N	1	2025-01-16 18:57:38	2025-01-23 19:21:14	\N	\N	ام كريمه  Custody 	\N
2861	6060120	ام كريمه  عموله 	1	164	\N	1	2025-01-16 18:57:38	2025-01-23 19:21:14	\N	\N	ام كريمه  Commission 	\N
2863	20414	ام كريمه  استحقاق 	1	43	\N	1	2025-01-16 18:57:38	2025-01-23 19:21:14	\N	\N	ام كريمه  Merit 	\N
2844	60118	فاطمة عبد الوهاب	1	53	\N	1	2025-01-16 18:53:10	2025-01-25 12:51:56	\N	\N	فاطمة عبد الوهاب	\N
2846	102040117	فاطمة عبد الوهاب  عهده 	1	121	\N	1	2025-01-16 18:53:10	2025-01-25 12:51:56	\N	\N	فاطمة عبد الوهاب  Custody 	\N
2845	6060116	فاطمة عبد الوهاب  عموله 	1	164	\N	1	2025-01-16 18:53:10	2025-01-25 12:51:56	\N	\N	فاطمة عبد الوهاب  Commission 	\N
2848	60119	رمضان	1	53	\N	1	2025-01-16 18:53:49	2025-01-25 12:53:00	\N	\N	رمضان	\N
2850	102040118	رمضان  عهده 	1	121	\N	1	2025-01-16 18:53:49	2025-01-25 12:53:00	\N	\N	رمضان  Custody 	\N
2849	6060117	رمضان  عموله 	1	164	\N	1	2025-01-16 18:53:49	2025-01-25 12:53:00	\N	\N	رمضان  Commission 	\N
2851	20411	رمضان  استحقاق 	1	43	\N	1	2025-01-16 18:53:49	2025-01-25 12:53:00	\N	\N	رمضان  Merit 	\N
2843	20409	اسماء  استحقاق 	1	43	\N	1	2025-01-16 18:52:08	2025-01-25 12:53:35	\N	\N	اسماء  Merit 	\N
2874	60125	ابراهيم	1	53	\N	1	2025-01-16 20:10:58	2025-01-25 12:55:22	\N	\N	ابراهيم	\N
2876	102040124	ابراهيم  عهده 	1	121	\N	1	2025-01-16 20:10:58	2025-01-25 12:55:22	\N	\N	ابراهيم  Custody 	\N
2875	6060123	ابراهيم  عموله 	1	164	\N	1	2025-01-16 20:10:58	2025-01-25 12:55:22	\N	\N	ابراهيم  Commission 	\N
2877	20417	ابراهيم  استحقاق 	1	43	\N	1	2025-01-16 20:10:58	2025-01-25 12:55:22	\N	\N	ابراهيم  Merit 	\N
2945	10202343	sgs دمياط	1	24	\N	59	2025-01-27 13:41:38	2025-01-27 13:41:38	\N	\N	sgs دمياط	\N
2946	10202344	sgs  اسكندريه	1	24	\N	59	2025-01-27 13:42:19	2025-01-27 13:42:19	\N	\N	sgs  اسكندريه	\N
2947	10202345	sgs  السويس	1	24	\N	59	2025-01-27 13:43:24	2025-01-27 13:43:24	\N	\N	sgs  السويس	\N
2948	10202346	SGS المعادى	1	24	\N	59	2025-01-27 13:46:48	2025-01-27 13:46:48	\N	\N	SGS المعادى	\N
2949	10202347	SGS المعادى	1	24	\N	59	2025-01-27 13:48:44	2025-01-27 13:48:44	\N	\N	SGS المعادى	\N
2902	10202302	جزور الطريق الدائرى	1	24	\N	59	2025-01-23 12:53:57	2025-01-23 12:53:57	\N	\N	جزور الطريق الدائرى	\N
2903	10202303	جذور الشروق	1	24	\N	59	2025-01-23 12:54:35	2025-01-23 12:54:35	\N	\N	جذور الشروق	\N
2904	10202304	جذور الابراج الصنيه	1	24	\N	59	2025-01-23 12:55:05	2025-01-23 12:55:05	\N	\N	جذور الابراج الصنيه	\N
2905	10202305	جذور اكتوبر	1	24	\N	59	2025-01-23 12:55:29	2025-01-23 12:55:29	\N	\N	جذور اكتوبر	\N
2906	10202306	ام سكوير  المصيف	1	24	\N	59	2025-01-23 12:56:22	2025-01-23 12:56:22	\N	\N	ام سكوير  المصيف	\N
2907	10202307	ام سكوير كرفان تريو	1	24	\N	59	2025-01-23 12:56:55	2025-01-23 12:56:55	\N	\N	ام سكوير كرفان تريو	\N
2908	10202308	ام سكوير ضيافه المعادى	1	24	\N	59	2025-01-23 12:57:29	2025-01-23 12:57:29	\N	\N	ام سكوير ضيافه المعادى	\N
2909	10202309	ام ام سكوير موكب تريو	1	24	\N	59	2025-01-23 12:58:13	2025-01-23 12:58:13	\N	\N	ام ام سكوير موكب تريو	\N
2910	10202310	ام سكوير المعادى الهندسيه	1	24	\N	59	2025-01-23 12:58:50	2025-01-23 12:58:50	\N	\N	ام سكوير المعادى الهندسيه	\N
2911	10202311	ام سكوير  المهندسين	1	24	\N	59	2025-01-23 12:59:51	2025-01-23 12:59:51	\N	\N	ام سكوير  المهندسين	\N
2912	10202312	جى ام سى الغفراء الاسبوع	1	24	\N	59	2025-01-23 13:01:02	2025-01-23 13:01:02	\N	\N	جى ام سى الغفراء الاسبوع	\N
2913	10202313	جى ام سى الغراء ال 14	1	24	\N	59	2025-01-23 13:01:46	2025-01-23 13:01:46	\N	\N	جى ام سى الغراء ال 14	\N
2914	10202314	جى ام سى اداره رقم 1	1	24	\N	59	2025-01-23 13:02:16	2025-01-23 13:02:16	\N	\N	جى ام سى اداره رقم 1	\N
2915	10202315	جى ام سى اداره 2	1	24	\N	59	2025-01-23 13:02:38	2025-01-23 13:02:38	\N	\N	جى ام سى اداره 2	\N
2916	10202316	جى ام سى اداره رقم 5	1	24	\N	59	2025-01-23 13:03:10	2025-01-23 13:03:10	\N	\N	جى ام سى اداره رقم 5	\N
2917	10202317	جى ام سى الرحاب	1	24	\N	59	2025-01-23 13:03:34	2025-01-23 13:03:34	\N	\N	جى ام سى الرحاب	\N
2918	10202318	جى ام سى المخزن العام	1	24	\N	59	2025-01-23 13:04:05	2025-01-23 13:04:05	\N	\N	جى ام سى المخزن العام	\N
2919	10202319	جى ام سى مستلزمات بوفيه الاداره	1	24	\N	59	2025-01-23 13:04:29	2025-01-23 13:04:29	\N	\N	جى ام سى مستلزمات بوفيه الاداره	\N
2920	10202320	جى ام سى ايمن ابو الفتوح	1	24	\N	59	2025-01-23 13:05:00	2025-01-23 13:05:00	\N	\N	جى ام سى ايمن ابو الفتوح	\N
2921	10202321	جى ام سى فنين مصنع العاشر	1	24	\N	59	2025-01-23 13:05:34	2025-01-23 13:05:34	\N	\N	جى ام سى فنين مصنع العاشر	\N
2922	10202322	جى ام سى سجا 2 مهندسين	1	24	\N	59	2025-01-23 13:07:41	2025-01-23 13:07:41	\N	\N	جى ام سى سجا 2 مهندسين	\N
2923	10202323	جى ام سى  مشروع الرحاب	1	24	\N	59	2025-01-23 13:08:21	2025-01-23 13:08:21	\N	\N	جى ام سى  مشروع الرحاب	\N
2924	10202324	جى ام سى اداره رقم 4	1	24	\N	59	2025-01-23 13:08:52	2025-01-23 13:08:52	\N	\N	جى ام سى اداره رقم 4	\N
2925	10202325	جى ام سى احمد رشاد	1	24	\N	59	2025-01-23 13:09:19	2025-01-23 13:09:19	\N	\N	جى ام سى احمد رشاد	\N
2926	10202326	جى ام سى سجا 2	1	24	\N	59	2025-01-23 13:10:12	2025-01-23 13:10:12	\N	\N	جى ام سى سجا 2	\N
2927	10202327	جى ام سى غفير +2 عمال	1	24	\N	59	2025-01-23 13:10:47	2025-01-23 13:10:47	\N	\N	جى ام سى غفير +2 عمال	\N
2928	10202328	جى ام سى موقع الوفاء والامل	1	24	\N	59	2025-01-23 13:11:22	2025-01-23 13:11:22	\N	\N	جى ام سى موقع الوفاء والامل	\N
2929	10202329	جى ام سى  الاستشارى	1	24	\N	59	2025-01-23 13:12:04	2025-01-23 13:12:04	\N	\N	جى ام سى  الاستشارى	\N
2930	10202330	جى ام سى غفير زيزنيا	1	24	\N	59	2025-01-23 13:12:54	2025-01-23 13:12:54	\N	\N	جى ام سى غفير زيزنيا	\N
2931	20105	نسله عبد الرحمن	1	37	\N	59	2025-01-23 15:09:31	2025-01-23 15:09:31	\N	\N	نسله عبد الرحمن	\N
2932	10202331	جى ام سى اداره 5	1	24	\N	59	2025-01-23 16:17:18	2025-01-23 16:17:18	\N	\N	جى ام سى اداره 5	\N
2933	10202332	شركه فريندز	1	24	\N	63	2025-01-23 17:31:33	2025-01-23 17:31:33	\N	\N	شركه فريندز	\N
2934	10202333	جى ام سى غفير +2 عمال	1	24	\N	59	2025-01-23 17:58:31	2025-01-23 17:58:31	\N	\N	جى ام سى غفير +2 عمال	\N
2935	10202334	جى ام سى لعدد 14 غفير	1	24	\N	59	2025-01-23 18:04:31	2025-01-23 18:04:31	\N	\N	جى ام سى لعدد 14 غفير	\N
2936	10202335	جى ام سى اداره رقم 1	1	24	\N	59	2025-01-23 18:18:34	2025-01-23 18:18:34	\N	\N	جى ام سى اداره رقم 1	\N
2854	102040119	ابوعلاء  عهده 	1	121	\N	1	2025-01-16 18:56:12	2025-01-23 19:19:08	\N	\N	ابوعلاء  Custody 	\N
2853	6060118	ابوعلاء  عموله 	1	164	\N	1	2025-01-16 18:56:12	2025-01-23 19:19:08	\N	\N	ابوعلاء  Commission 	\N
2855	20412	ابوعلاء  استحقاق 	1	43	\N	1	2025-01-16 18:56:12	2025-01-23 19:19:08	\N	\N	ابوعلاء  Merit 	\N
2847	20410	فاطمة عبد الوهاب  استحقاق 	1	43	\N	1	2025-01-16 18:53:10	2025-01-25 12:51:56	\N	\N	فاطمة عبد الوهاب  Merit 	\N
2836	60116	محمد عبد الوهاب	1	53	\N	1	2025-01-16 18:51:37	2025-01-25 12:53:58	\N	\N	محمد عبد الوهاب	\N
2838	102040115	محمد عبد الوهاب  عهده 	1	121	\N	1	2025-01-16 18:51:37	2025-01-25 12:53:58	\N	\N	محمد عبد الوهاب  Custody 	\N
2837	6060114	محمد عبد الوهاب  عموله 	1	164	\N	1	2025-01-16 18:51:37	2025-01-25 12:53:58	\N	\N	محمد عبد الوهاب  Commission 	\N
2839	20408	محمد عبد الوهاب  استحقاق 	1	43	\N	1	2025-01-16 18:51:37	2025-01-25 12:53:58	\N	\N	محمد عبد الوهاب  Merit 	\N
2937	10202336	شركة فيكينج ريفر	1	24	\N	63	2025-01-26 14:15:08	2025-01-26 14:15:08	\N	\N	شركة فيكينج ريفر	\N
2938	20106	بن سليمان	1	37	\N	59	2025-01-26 17:21:20	2025-01-26 17:21:20	\N	\N	بن سليمان	\N
2939	10202337	ارسليو ميتال	1	24	\N	59	2025-01-26 17:35:54	2025-01-26 17:35:54	\N	\N	ارسليو ميتال	\N
2940	10202338	ام سكوير التجمع	1	24	\N	59	2025-01-26 17:59:32	2025-01-26 17:59:32	\N	\N	ام سكوير التجمع	\N
2941	10202339	جذور الطريق الدائرى	1	24	\N	59	2025-01-26 18:06:37	2025-01-26 18:06:37	\N	\N	جذور الطريق الدائرى	\N
2942	10202340	جى ام سى  الغفير +2 عمال	1	24	\N	59	2025-01-26 18:19:08	2025-01-26 18:19:08	\N	\N	جى ام سى  الغفير +2 عمال	\N
2943	10202341	مكتب المعادى	1	24	\N	59	2025-01-27 11:46:06	2025-01-27 11:46:06	\N	\N	مكتب المعادى	\N
2944	10202342	SGS المعادى	1	24	\N	59	2025-01-27 13:41:12	2025-01-27 13:41:12	\N	\N	SGS المعادى	\N
2950	10202348	Dart Caffe	1	24	\N	63	2025-01-27 14:56:04	2025-01-27 14:56:04	\N	\N	Dart Caffe	\N
2951	10202349	جامعه الباديه	1	24	\N	63	2025-01-27 19:18:35	2025-01-27 19:18:35	\N	\N	جامعه الباديه	\N
2952	10202350	ام سكوير الشيخ زايد	1	24	\N	59	2025-01-28 14:49:52	2025-01-28 14:49:52	\N	\N	ام سكوير الشيخ زايد	\N
2953	7	فاتوره الارضى +نت	0	0	\N	59	2025-01-28 15:09:27	2025-01-28 15:09:27	\N	\N	فاتوره الارضى +نت	\N
2954	609	فاتوره الارضى +نت	0	20	\N	59	2025-01-28 15:12:29	2025-01-28 15:12:29	\N	\N	فاتوره الارضى +نت	\N
2955	10202351	شركة العشرى	1	24	\N	63	2025-01-30 10:22:06	2025-01-30 10:22:06	\N	\N	شركة العشرى	\N
2956	10202352	شركة العشرى	1	24	\N	63	2025-01-30 10:22:06	2025-01-30 10:22:06	\N	\N	شركة العشرى	\N
2957	10202353	شركه بيكو	1	24	\N	63	2025-02-02 11:32:03	2025-02-02 11:32:03	\N	\N	شركه بيكو	\N
2958	10202354	جى ام سى الغفراء الاسبوع	1	24	\N	59	2025-02-04 19:25:38	2025-02-04 19:25:38	\N	\N	جى ام سى الغفراء الاسبوع	\N
2959	20107	الازهرى	1	37	\N	59	2025-02-05 12:31:28	2025-02-05 12:31:28	\N	\N	الازهرى	\N
2960	10202355	جي  ام سي  الغفير الاسبوعي	1	24	\N	1	2025-02-09 14:04:43	2025-02-09 14:04:43	\N	\N	جي  ام سي  الغفير الاسبوعي	\N
2961	10202356	Podeygpt  المطار	1	24	\N	63	2025-02-11 15:54:53	2025-02-11 15:54:53	\N	\N	Podeygpt  المطار	\N
2962	10202357	يونى كلين	1	24	\N	63	2025-02-11 16:48:31	2025-02-11 16:48:31	\N	\N	يونى كلين	\N
2963	10202358	شركه فارس	1	24	\N	63	2025-02-11 16:56:22	2025-02-11 16:56:22	\N	\N	شركه فارس	\N
2964	10202359	شركه سيستكس	1	24	\N	63	2025-02-11 19:00:45	2025-02-11 19:00:45	\N	\N	شركه سيستكس	\N
2965	10202360	Cite podegypt	1	24	\N	63	2025-02-13 16:54:57	2025-02-13 16:54:57	\N	\N	Cite podegypt	\N
2966	10202361	هشام درويش	1	24	\N	59	2025-02-19 17:29:02	2025-02-19 17:29:02	\N	\N	هشام درويش	\N
2967	20108	هشام درويش	1	37	\N	59	2025-02-20 14:23:53	2025-02-20 14:23:53	\N	\N	هشام درويش	\N
2968	10202362	بود ايجبت   المطار	1	24	\N	59	2025-02-20 14:42:20	2025-02-20 14:42:20	\N	\N	بود ايجبت   المطار	\N
2969	10202363	بود ايجيبت اكتوبر	1	24	\N	59	2025-02-20 14:42:59	2025-02-20 14:42:59	\N	\N	بود ايجيبت اكتوبر	\N
2970	10202364	SGS المعادى	1	24	\N	59	2025-02-20 15:39:05	2025-02-20 15:39:05	\N	\N	SGS المعادى	\N
\.


--
-- Data for Name: accounts_default_data; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.accounts_default_data (id, "Draw", "Coin", created_at, updated_at, "Sure_Recipts", "Show_Group", "Account_Balance", "Salary", "Commission", "Coin_Show", "Cost_Show", "Draw_Show", "Collect_Show", "Sales_Bill_Show", "Hide_Edit_Delete", "Order_Number") FROM stdin;
2	1	1	2021-08-13 16:44:14	2025-01-19 14:43:00	0	0	0	2	2	0	0	0	0	0	0	0
\.


--
-- Data for Name: activites; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.activites (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
8	تجاري	Commercial	2022-04-13 02:50:04	2024-02-09 00:52:30
9	مجموعه سكر مظبوط	مجموعه سكر مظبوط	2025-01-25 15:26:47	2025-01-25 15:26:47
\.


--
-- Data for Name: add_translates; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.add_translates (id, "Code", "Date", "Client", "Client_Type", "From_Lang", "To_Lang", "Company", "Num_Translted_Word", "ID_Name", "ID_Profession", "ID_Martial_Status", "Passport_Name", "Passport_Profession", "Passport_Martial_Status", "Extracted", "Extracted_Birthplace", "Extracted_Issuer", "CommercialRegistration", "Commercial_Name", "Commercial_Type", "Commercial_Start_Date", "Commercial_Number", "Commercial_Capital", "Commercial_Issuer", "Commercial_Address", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: additional_products; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.additional_products (id, "Additional_Product", "Product", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: addressses; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.addressses (id, "Address_Name", "Street", "Special_Mark", "Buliding", "Floor", "Flat", "Details", "Location", "Governrate", "City", "Place", "Customer", created_at, updated_at, "Lat", "Lng") FROM stdin;
\.


--
-- Data for Name: admins; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.admins (id, email, name, password, image, phone, hidden, emp, ship, vend, status, remember_token, created_at, updated_at, cli, lat, long, account, safe, store, type, roles_name, code, token, price_sale, discount, price_1, price_2, price_3, pos_pay, executor, cost_price, price_level, guest, pos_stores, pos_hold, cost_price_purch, cost_price_sales, manu_order_precent, pos_product, "Cash", "Later", "Check", "Installment", "Cash_Visa", "Cash_Collection", "Delivery", "InstallmentCompanies", "Date", ticket_price, ticket_discount, "nameEn", package, job_order_price, "Visa_Network", bill_discount, pos_safes, expire, expire_type) FROM stdin;
11	Klar@test.com	Admin	$2y$10$QnqbBX6.vzR3f.jtAVDl9.grQaOWASw8IxcoJcma4GX0nFaJ3GJga	AdminsImages/zUmg7MdzbQVBLGEt0WE7.png	01062201060	1	0	0	0	0	\N	2021-08-08 10:29:23	2024-12-04 22:09:02	0	\N	\N	0	\N	\N	Admin	Owner	\N	\N	0	0	\N	\N	\N	0	\N	0	\N	\N	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	Admin	1	0	\N	0	0	\N	0
45	GuestO@test.com	Guest	$2y$10$0DrRyqpJGzxh8sY5lqK8g.u4XXo9VNUUx24bqWiGuFCGidiEF6EvO	AdminsImages/FCad1Zo5eARHkj6f1DwJ.png	23123	1	0	0	0	0	\N	2021-12-14 17:23:09	2024-12-04 22:09:46	0	\N	\N	0	\N	\N	Admin	Guest	\N	\N	0	0	\N	\N	\N	0	\N	0	1	1	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	1	1	0	\N	0	0	\N	0
46	GuestTw@test.com	Guest T	$2y$10$PvmLA3AHV4DfzXMI2Y3HP.Is4Ulyd0NZU9dasKtR.J4kOOgYxO7EK	AdminsImages/ql9kcuPqE6pjB743YQBg.png	12313	1	0	0	0	0	\N	2021-12-14 17:24:12	2024-12-04 22:09:57	0	\N	\N	0	\N	\N	Admin	Guest	\N	\N	0	0	\N	\N	\N	0	\N	0	2	1	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	2	1	0	\N	0	0	\N	0
47	GuestTh@test.com	GuestTh	$2y$10$AhaiV.Ao3D236mryP91C4uF.2C/7Ri33vHNN1nn6dF9M1/YCM8vn2	AdminsImages/C1WJh3cJRQs8sOwJarNc.png	31123	1	0	0	0	0	\N	2021-12-14 17:24:51	2024-12-04 22:10:07	0	\N	\N	0	\N	\N	Admin	Guest	\N	\N	0	0	\N	\N	\N	0	\N	0	3	1	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	3	1	0	\N	0	0	\N	0
65	nadahashem@orient.com	ندي هاشم	$2y$10$4rGZq3oguJ0F9zI6b7dkje26MsBwwXuFOpRsRUxo70VBbEbRvZ.5a	\N	\N	0	52	0	0	0	\N	2025-01-16 20:00:11	2025-01-16 20:00:11	0	\N	\N	53	2864	21	Emp	صلاحية ندي	\N	\N	1	1	1	1	1	1	52	0	\N	\N	0	0	0	0	0	1	1	1	\N	\N	1	\N	\N	\N	1	0	0	ندي هاشم	1	0	\N	1	0	\N	\N
66	wlaa@orient.com	ولاء	$2y$10$hMnufArNFSjBmWZQHWSj8OTamR5u.Nd/NGCCmqHtq9DEmu8sGnCT.	\N	\N	0	53	0	0	0	\N	2025-01-16 20:08:06	2025-01-16 20:08:06	0	\N	\N	53	2865	21	Emp	صلاحيات ولاء	\N	\N	1	1	1	1	\N	1	53	0	\N	\N	0	1	0	0	0	1	1	1	\N	\N	\N	\N	\N	\N	0	0	0	ولاء	1	0	\N	1	0	\N	\N
1	admin@rabih.com	Admin	$2y$10$rraVwmtkXA.0utYGbaiSNOzFfbPT1zg1lb7I.isn4OaFWj6xO/Wy.	AdminsImages/PDk0eltFIlYtSRmI0XwM.png	01062201060	1	0	0	0	0	\N	\N	2025-01-16 20:54:41	0	\N	\N	0	\N	\N	\N	Owner	\N	\N	0	0	\N	\N	\N	0	\N	0	\N	\N	0	0	0	0	0	0	\N	\N	\N	\N	\N	\N	\N	\N	0	0	0	Admin	1	0	\N	0	0	\N	0
60	fatma@orient.com	فاطمة	$2y$10$Ooaz0YmLvqusJN3ziT1oUu5C1NX7aFN3yUuWi.aLlyiiSX8ZbECcW	\N	01000606267	0	47	0	0	0	\N	2025-01-16 19:30:38	2025-01-19 17:39:05	0	\N	\N	53	2827	21	\N	الإدارة	\N	\N	1	1	1	1	1	1	47	0	\N	\N	0	1	0	0	0	1	1	1	1	1	1	\N	\N	\N	1	0	0	فاطمة	1	0	\N	1	1	\N	\N
67	zain@orient.com	زين	$2y$10$JwxGOCFQyGDGS1qtBIoGi.HiIiaan5h9Ayz/5WSV902n8rkx93kCG	\N	\N	0	56	0	0	0	\N	2025-01-18 18:35:21	2025-01-18 18:35:21	0	\N	\N	53	2882	21	Emp	صلاحية كاشير	\N	\N	1	0	1	1	\N	1	56	0	\N	\N	0	1	0	0	0	1	1	1	\N	\N	1	1	\N	\N	1	0	0	زين	1	0	1	1	0	\N	\N
68	shaban@orient.com	شعبان	$2y$10$UmN.z2bpD5txqvtwBQMxTu47CLauVIAHBuBtBKkItpY2U004YzxCC	\N	\N	0	57	0	0	0	\N	2025-01-18 18:36:47	2025-01-18 18:36:47	0	\N	\N	53	2883	21	Emp	صلاحية كاشير	\N	\N	1	0	1	1	\N	1	57	0	\N	\N	0	1	0	0	0	1	1	1	\N	\N	1	1	\N	\N	1	\N	0	شعبان	1	0	1	1	0	\N	\N
69	ahmed@orient.com	أحمد	$2y$10$aljRQt2TNnf/inO4spCw9.W6vV6KRC1GKDz.we/0Ke.xhOCUc4/y6	\N	\N	0	58	0	0	0	\N	2025-01-18 18:38:10	2025-01-18 18:38:10	0	\N	\N	53	2884	21	Emp	صلاحية كاشير	\N	\N	1	0	1	1	\N	1	58	0	\N	\N	0	1	0	0	0	1	1	1	\N	\N	1	1	\N	\N	1	0	0	أحمد	1	0	1	1	0	\N	\N
61	mohamed@orient.com	محمد عبدالوهاب	$2y$10$Ls3hNO0qlpiWXCtf2etrqOPtBcMG6O7z0YkULpiJgGRk0IX/dk15C	\N	\N	0	45	0	0	0	\N	2025-01-16 19:32:38	2025-01-25 15:47:27	0	\N	\N	53	2825	21	\N	صلاحية محمد	\N	\N	1	1	1	1	\N	1	45	0	\N	\N	0	0	0	0	0	1	1	1	\N	\N	\N	\N	\N	\N	1	0	0	محمد عبدالوهاب	1	0	\N	0	0	\N	\N
59	ramdan@orient.com	رمضان حافظ	$2y$10$V81CHIi05jsSfSSg4DQ1U.aqLuvMi3PKpNCvi/jpjVUKhwG3vrEIu	\N	\N	0	0	0	0	0	\N	2025-01-16 19:29:46	2025-01-25 17:34:00	0	29.9681956	31.2554963	0	2826	21	\N	الإدارة	\N	bqcFPnU3w2l2PRwcPif3Y3Ao9TEGIgwoFSDsTw4U0pJh9FhX8tY0Kgm3vYZbfH68V8LGAA41kayyLTjscOozs6Qmft3fAKxS6033	1	1	1	1	1	1	48	0	\N	\N	0	1	0	1	0	1	1	1	1	\N	1	1	\N	\N	1	0	0	رمضان حافظ	1	0	1	1	0	\N	\N
63	nada@orient.com	nada	$2y$10$CbMWqXKts67bKDS62Zvm9euNTm3jgtFM14Us4PftoSBJGmdrQoXoK	\N	\N	0	44	0	0	0	\N	2025-01-16 19:40:22	2025-01-28 13:21:54	0	\N	\N	53	2823	21	\N	صلاحية ندي	\N	\N	1	1	1	1	1	1	44	0	\N	\N	0	1	0	0	0	1	1	1	\N	\N	1	1	\N	\N	1	0	0	NADA	1	0	\N	1	0	\N	\N
62	asmaa@orient.com	أسماء	$2y$10$ZphKwR4SEp.9QSyNTQBdwOddHrQvhaNFu56DFxxBJO9SU74iUADMa	\N	\N	0	46	0	0	0	\N	2025-01-16 19:35:05	2025-02-25 17:27:55	0	\N	\N	53	2824	21	Emp	الإدارة	\N	\N	1	1	1	1	\N	1	46	0	\N	\N	0	0	0	0	0	1	1	1	\N	\N	\N	\N	\N	\N	1	0	0	أسماء	1	0	\N	1	0	\N	\N
\.


--
-- Data for Name: all_groups; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.all_groups (id, "Group", created_at, updated_at, "Name") FROM stdin;
\.


--
-- Data for Name: allowences_emps; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.allowences_emps (id, "AmountAllow", "Allow", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: articles; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.articles (id, "Image", "Sub_Image", "Date", "Arabic_Title", "English_Title", "Arabic_Desc", "English_Desc", created_at, updated_at) FROM stdin;
1	ArticlesImages/Tc4BdtjP1euOSuW9OmoC.jpeg	ArticlesImages/8pWQWSpnZFPjdliv8uuk.jpeg	May 02, 2017	It's all about how you wear	It's all about how you wear	On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de.\r\n\nLorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.\r\n\nSample Text Listing\r\n\nDonec et lacus mattis ipsum feugiat interdum non id sapien.\r\n\nQuisque et mauris eget nisi vestibulum rhoncus molestie a ante.\r\n\nCurabitur pulvinar ex at tempus sodales.\r\n\nMauris efficitur magna quis lectus lobortis venenatis.\r\n\nNunc id enim eget augue molestie lobortis in a purus.\r\n\nDonec maximus quam at lectus bibendum, non suscipit nunc tristique.\r\n\nThe standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.	On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de.\r\n\nLorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.\r\n\nSample Text Listing\r\n\nDonec et lacus mattis ipsum feugiat interdum non id sapien.\r\n\nQuisque et mauris eget nisi vestibulum rhoncus molestie a ante.\r\n\nCurabitur pulvinar ex at tempus sodales.\r\n\nMauris efficitur magna quis lectus lobortis venenatis.\r\n\nNunc id enim eget augue molestie lobortis in a purus.\r\n\nDonec maximus quam at lectus bibendum, non suscipit nunc tristique.\r\n\nThe standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.	2022-06-04 15:34:21	2022-06-04 15:34:21
2	ArticlesImages/hFg38z7lhXhdL5p3YGS4.jpeg	ArticlesImages/0JIkTM2ovwsZJsVLPTag.jpeg	May 02, 2017	IT'S ALL ABOUT HOW YOU WEAR	IT'S ALL ABOUT HOW YOU WEAR	qweqweqwe	qweqeqweqwe	2022-06-06 20:02:53	2022-06-06 20:02:53
\.


--
-- Data for Name: assembly_products; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.assembly_products (id, "Qty", "Price", "Total", "P_Ar_Name", "P_En_Name", "P_Code", "Unit", "Product", p_id, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: assets; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.assets (id, "Code", "Name", "Asset_Type", "Depreciation_Method", "Purchases_Date", "Operation_Date", "Cost", "Previous_Depreciation", "Asset_Net", "Annual_Depreciation_Ratio", "Annual_Depreciation", "Life_Span", "Image", "Note", "Depreciation_Expenses", "Depreciation_Complex", "Main_Account", "Account", "User", created_at, updated_at, "Draw", "Coin", "Cost_Center", "Branch", "Sort_Asset", "Vendor", "Safe", "Ehlak", "Payment_Method", "M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12", "NameEn", "Asset_Type_En", "Depreciation_Method_En", arr, "Delete", "Sale", "Amount", "Client", "CurrentAssetPrice") FROM stdin;
\.


--
-- Data for Name: assets_expenses; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.assets_expenses (id, "Code", "Date", "Name", "Draw", "Amount", "Asset", "Safe", "Coin", "Cost_Center", "User", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: attend_departure_import; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.attend_departure_import (id, "In_Time", "Out_Time", "Date", "Month", "Note", "Attend", "Emp", created_at, updated_at) FROM stdin;
1	7:30	16:30	01-01-2024	45292	\N	3	33	\N	\N
2	8:30	17:30	01-01-2024	45292	\N	3	34	\N	\N
\.


--
-- Data for Name: attendance_emps; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.attendance_emps (id, "In_Time", "Date", "Month", "Note", "Attend", "Emp", created_at, updated_at) FROM stdin;
7	22:20	2025-01-18	2025-01	\N	3	48	2025-01-18 17:21:03	2025-01-18 17:21:03
\.


--
-- Data for Name: attendances; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.attendances (id, "Code", "Date", "Month", "Note", "User", created_at, updated_at, "Status", arr) FROM stdin;
3	1	2025-01-18	2025-01	\N	59	\N	2025-01-18 17:21:36	1	\N
\.


--
-- Data for Name: attendence_policy_emps; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.attendence_policy_emps (id, "From", "To", "Discount", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: barcode_products; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.barcode_products (id, "Name", "Code", "Qty", "Price", "Product", "V1", "V2", "Unit", created_at, updated_at, "Group") FROM stdin;
\.


--
-- Data for Name: barcode_settings; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.barcode_settings (id, "Code", "Name", "Type", "Direction", "Width", "Height", "Padding_L", "Padding_R", "Padding_T", "Padding_B", "Margin_L", "Margin_R", "Margin_T", "Margin_B", "Barcode_Width", "Barcode_Height", "Font_Size", "Line_Height", created_at, updated_at, "Height_Logo", "Width_Logo", "NameEn", arr) FROM stdin;
6	2	الطباعة الافتراضية	2	1	3.8	2.5	.5	.5	.5	.5	.5	.5	.5	.5	3	0.5	6	4	2022-03-09 09:57:35	2024-02-09 00:42:34	0	0	Default Print	\N
\.


--
-- Data for Name: barcode_shows; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.barcode_shows (id, "Company_Name", "Product_Name", "Product_Price", "Unit", "Coin", "Group", created_at, updated_at, "Code", "Logo") FROM stdin;
1	1	\N	\N	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	\N	\N
2	1	1	\N	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	\N	\N
3	1	1	1	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	\N	\N
4	1	1	1	\N	\N	\N	2022-03-31 18:05:19	2022-03-31 18:05:19	1	\N
\.


--
-- Data for Name: befroe_footers; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.befroe_footers (id, "Image", "Arabic_Title", "Arabic_Desc", "English_Title", "English_Desc", created_at, updated_at) FROM stdin;
2	<i class="icon anm anm-credit-card-front-r"></i>	SECURE PAYMENTS	All payment are Secured and trusted.	SECURE PAYMENTS	All payment are Secured and trusted.	\N	2022-06-04 19:54:42
3	<i class="icon anm anm-comments-l"></i>	ONLINE SUPPORT	We support online 24/7 on day	ONLINE SUPPORT	We support online 24/7 on day	\N	2022-06-04 19:55:04
4	<i class="icon anm anm-dollar-sign-r"></i>	MONEY GUARANTEE	30 days money back guarantee	MONEY GUARANTEE	30 days money back guarantee	\N	2022-06-04 19:55:16
5	<i class="icon anm anm-truck-l"></i>	FREE SHIPPING & RETURN	Free shipping on all US orders	FREE SHIPPING & RETURN	Free shipping on all US orders	\N	2022-06-04 19:55:29
\.


--
-- Data for Name: beneftis_types; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.beneftis_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: bones_sales_petrols; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.bones_sales_petrols (id, "Bone_Amount", "Bone", "SalesPetrol", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: bones_types; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.bones_types (id, "Name", "Account", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: borrowas; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.borrowas (id, "Code", "Date", "Month", "Amount", "Draw", "Note", "Safe", "Emp", "Coin", "Cost_Center", "User", arr, created_at, updated_at, "Delete") FROM stdin;
4	1	2025-01-25	2025-01	500	1	300+200	30	51	1	\N	59	\N	2025-01-25 12:41:37	2025-01-25 12:41:37	0
5	2	2025-01-25	2025-01	5000	1	\N	30	45	1	\N	59	\N	2025-01-25 12:43:35	2025-01-25 12:43:35	0
7	4	2025-01-25	2025-01	20000	1	\N	30	48	1	\N	59	\N	2025-01-25 13:18:36	2025-01-25 13:18:36	0
6	3	2025-01-25	2025-01	20000	1	\N	30	47	1	\N	59	\N	2025-01-25 12:56:49	2025-01-25 13:21:05	1
8	5	2025-01-25	2025-01	21501	1	\N	30	47	1	\N	59	\N	2025-01-25 13:22:01	2025-01-25 13:22:01	0
9	6	2025-02-27	2025-02	900	1	ام كريمه	30	51	1	\N	59	\N	2025-02-27 18:12:19	2025-02-27 18:12:19	0
\.


--
-- Data for Name: branches; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.branches (id, "Arabic_Name", "English_Name", created_at, updated_at, "Letter", "Code", "Location", "Budget") FROM stdin;
3	الفرع الرئيسي	main Branch	2022-10-18 22:34:33	2024-02-09 00:17:43	\N	\N	\N	\N
4	بريف ماركت	The Brave Market	2025-01-16 21:44:04	2025-01-16 21:44:04	B	\N	<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3452.889941555532!2d31.269044724980095!3d30.068689074911426!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14584080400b2755%3A0x446fd9123fdb8d12!2z2KjZhtiy2YrZhtipINmF2YjYqNmK2YQ!5e0!3m2!1sar!2seg!4v1737054277671!5m2!1sar!2seg" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>	\N
\.


--
-- Data for Name: brands; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.brands (id, "Name", "Note", created_at, updated_at, "Image", "Sales_Show", "Store_Show", "NameEn", "Sales_Precet") FROM stdin;
17	الماركة الافتراضية	\N	2022-06-06 19:15:43	2024-02-09 00:27:02	BrandsImages/5hcSrdUnrIK1AmXf3s61.png	1	3	Default Brand	0
\.


--
-- Data for Name: campaigns; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.campaigns (id, "Arabic_Name", "English_Name", "Platform", created_at, updated_at) FROM stdin;
7	حملة 2024	حملة 2024	8	2022-04-13 02:50:33	2024-02-09 00:51:37
\.


--
-- Data for Name: capital_increases; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.capital_increases (id, "Date", "Month", "Value", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: capitals; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.capitals (id, "Authorized_Capital", "Source_Capital", "Shares_Number", "Nominal_Value_of_Shares", "Actual_Share_Value", "Actual_Capital", created_at, updated_at, "Working_Capital", "New_Shares_Number", "Capital_Increase", "New_Source_Capital", "Total_Investment") FROM stdin;
1	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2	100000	150000	10	15000	15000	150000	2021-10-13 15:36:23	2021-10-13 15:36:23	\N	\N	\N	\N	\N
\.


--
-- Data for Name: cars_sales_petrols; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.cars_sales_petrols (id, "Car_Amount", "Car", "SalesPetrol", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: cart_stores; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.cart_stores (id, "Name", "NameEn", "V_Name", "VV_Name", "P_Code", "AvQty", "Qty", "Price", "Image", "Total", "User", created_at, updated_at, "Product") FROM stdin;
\.


--
-- Data for Name: chat_issues; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.chat_issues (id, "Name", "Date", "Time", "Desc", "Image", "Issue", created_at, updated_at, "Type", "Appear") FROM stdin;
30	Admin	2024-02-04	09-37 PM	\N	AdminsImages/H1fQroGeALye9kfwlLOJ.png	9	2024-02-04 21:37:45	2024-02-04 21:37:45	1	\N
31	Admin	2024-02-04	09-41 PM	\N	AdminsImages/ZUWBoib7IOGJVz5bRYO7.png	9	2024-02-04 21:41:18	2024-02-04 21:41:18	1	\N
\.


--
-- Data for Name: checks_types; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.checks_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
4	مسطر	Underlined	2022-05-24 00:44:58	2024-02-09 00:22:37
\.


--
-- Data for Name: cities; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.cities (id, "Arabic_Name", "English_Name", "Gov", created_at, updated_at, "Ship_Price", "Shipping_Company", "SearchCode") FROM stdin;
9	الرياض	Riyadh	5	2024-02-09 00:56:49	2024-02-09 00:56:49	1	5	\N
1	مدينة نصر	Nasr City	2	2021-07-25 23:46:59	2024-02-09 00:58:24	1	5	\N
\.


--
-- Data for Name: client_account_statement_column_sechdules; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.client_account_statement_column_sechdules (id, "Date", "Code", "Time", "Refrence_Number", "Branch", "Store", "Payment_Method", "Safe", "Type", "Shipping", "Cost_Center", "User", "Coin", "Due_Date", "Delegate", "Note", "Total_Return", "Total_Price", "Total_Discount", "Total_Tax", "Total_Net", "Paid", "Residual", "Client", created_at, updated_at, "ShiftCode", "Executor") FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2025-02-09 13:45:03	1	1
\.


--
-- Data for Name: client_account_statement_columns; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.client_account_statement_columns (id, "Date", "Code", "Time", "Refrence_Number", "Branch", "Store", "Payment_Method", "Safe", "Type", "Shipping", "Cost_Center", "User", "Coin", "Due_Date", "Delegate", "Note", "Total_Return", "Total_Price", "Total_Discount", "Total_Tax", "Total_Net", "Paid", "Residual", "Client", created_at, updated_at, "ShiftCode", "Executor") FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-16 21:43:33	1	1
\.


--
-- Data for Name: client_filters; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.client_filters (id, "Product", "Code", "Name", "VName", "VVName", "V1", "V2", "Qty", "Price", "Total", created_at, updated_at, "Client") FROM stdin;
\.


--
-- Data for Name: client_sales_petrols; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.client_sales_petrols (id, "Customer_Amount", "Customer", "SalesPetrol", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: client_statuses; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.client_statuses (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
5	عميل مهم	VIP	2022-03-08 01:33:27	2024-02-09 00:51:55
4	محتمل	Perhaps	2022-02-18 01:19:26	2024-02-09 00:52:13
\.


--
-- Data for Name: clients_statements_column_sechdules; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.clients_statements_column_sechdules (id, "Account_Code", "Account_Name", "Debiator_Before", "Creditor_Before", "Total_Debitor", "Total_Creditor", "Debitor_Balance", "Creditor_Balance", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	\N	2022-10-17 13:26:19
\.


--
-- Data for Name: clients_statements_columns; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.clients_statements_columns (id, "Account_Code", "Account_Name", "Debiator_Before", "Creditor_Before", "Total_Debitor", "Total_Creditor", "Debitor_Balance", "Creditor_Balance", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	\N	2022-10-17 13:08:16
\.


--
-- Data for Name: coins; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.coins (id, "Arabic_Name", "English_Name", created_at, updated_at, "Draw", "Symbol", "Code") FROM stdin;
1	جنيه مصري	Egyptian Pound	2021-06-14 15:44:02	2022-06-08 17:39:50	1	EGP	\N
7	دولار	Dollar	2024-02-09 00:21:32	2024-02-09 00:21:32	3.75	$	$
4	ريال سعودي	SAR	2021-06-16 01:47:03	2024-02-09 00:21:54	1	SAR	1
\.


--
-- Data for Name: comments; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.comments (id, "Comment", "Date", "Product", "User", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: comments_clients; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.comments_clients (id, "Comment", "Responsible", "Customer", created_at, updated_at, "CommentEn", "Code", "Date", "Rate", "Visit_Cost", "Note", "Time", "Type", lat, lng) FROM stdin;
\.


--
-- Data for Name: company_cars; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.company_cars (id, "Name", "Number", "Account", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: company_data; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.company_data (id, "Name", "Phone1", "Phone2", "Address", "Commercial_Record", "Tax_File_Number", "Logo", "Icon", "Print_Text", created_at, updated_at, "Print_Text_Footer", "Seal", "Print_Text_Footer_Sales", "Name_Sales_Bill", "Name_Sales_Order_Bill", "Print_Text_Footer_Quote", "Name_Quote_Bill", "Print_Text_Footer_Secretariat", "Logo_Store", "Phone3", "Phone4", "Icon_Store", "View", "Tax_Registration_Number", "Tax_activity_code", work_nature, "Governrate", "City", "Place", "Nationality", "Buliding_Num", "Street", "Postal_Code", tax_magistrate, "Client_ID", "Serial_Client_ID", "Version_Type", "Computer_SN", "Invoice_Type", "Floor", "Room", "Landmark", "Add_Info", "Print_Text_Footer_Manufacturing", "POS_Version", "Path", "DB_Backup", "NameEn", "Print_Text_En", "Print_Text_Footer_En", "Print_Text_Footer_Manufacturing_En", "Print_Text_Footer_Sales_En", "Print_Text_Footer_Quote_En", "Print_Text_Footer_Secretariat_En", "Name_Sales_Bill_En", "Name_Sales_Order_Bill_En", "Name_Quote_Bill_En", "AddressEn", "HomeMainScreen", "PDF", "Email", "Location", "Bill_View", "Font_Type", "Welcome_Arabic_Word_App", "Welcome_English_Word_App") FROM stdin;
1	أورينت للتوريدات العمومية	01000610615	0225275276	المعادي	28875	310511143	LogoImages/9qeNIn7CyB5ZO7vyFX0e.png	IconImages/lXxCl4u84zQkkTi8meJ6.png	تشرفنا بزيارتكم	2021-08-13 16:30:58	2025-01-27 17:12:42	تشرفنا بزيارتكم	LogoImages/DrZ9IR5TvZPjwUv5GUWp.png	تشرفنا بزيارتكم	فاتورة مبيعات	امر بيع	تشرفنا بزيارتكم	عرض سعر	\N	LogoImages/fUKrHNbVqinc4eHesd4q.png	01000606267	\N	LogoImages/pco3zfDXOoK5x2FGD6N6.png	0	310511143	530	B	2	1	6	2	1	1	1	1	1	1	1.0	1	Experimental	1	1	1	1	تشرفنا بزيارتكم	1	1	1	Orient	Welcome	Welcome	Welcome	Welcome	Welcome	\N	Sales Invoice	Sales Order	Quotation	المعادي	1	\N	fatma@orientglorygroup.com	<iframe src="https://www.google.com/maps/embed?pb=!1m17!1m12!1m3!1d3456.5036804217257!2d31.246170076231916!3d29.96495162233149!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m2!1m1!2zMjnCsDU3JzUzLjgiTiAzMcKwMTQnNTUuNSJF!5e0!3m2!1sen!2ssa!4v1737815866372!5m2!1sen!2ssa" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>	1	8	\N	\N
\.


--
-- Data for Name: compare_prices_columns; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.compare_prices_columns (id, "Date", "Product_Code", "Product_Name", "Unit", "Type", "Bill_Num", "Incom", "Outcom", "Credit", "Group", "Brand", "Store", "User", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-09 18:47:57
\.


--
-- Data for Name: compare_prices_columns_sechdules; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.compare_prices_columns_sechdules (id, "Date", "Product_Code", "Product_Name", "Unit", "Type", "Bill_Num", "Incom", "Outcom", "Credit", "Group", "Brand", "Store", "User", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	1	\N	2022-10-09 18:48:22
\.


--
-- Data for Name: compare_prices_filter_twos; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.compare_prices_filter_twos (id, "Date", "Type", "Bill_Num", "Incom", "Outcom", "Current", "P_Ar_Name", "P_En_Name", "P_Code", "Unit", "Group", "Store", "Product", "V1", "V2", "User", "CostIn", "CostOut", "CostCurrent", "CostOneIn", "CostOneOut", "CostOneCurrent", "QTY", "Brand", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: compare_prices_filters; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.compare_prices_filters (id, "Date", "Type", "Bill_Num", "Incom", "Outcom", "Current", "P_Ar_Name", "P_En_Name", "P_Code", "Unit", "Group", "Store", "Product", "V1", "V2", "User", "CostIn", "CostOut", "CostCurrent", "CostOneIn", "CostOneOut", "CostOneCurrent", "QTY", "Brand", "Safe", "Branch", "SalePrice", "ProductPrice", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: compares; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.compares (id, "Product", "User", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: competitors; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.competitors (id, "Facebook", "Twitter", "Instagram", "Name", "Country", "Whatsapp", "Addtional_Link", "Phone", "Pinterest", created_at, updated_at, "NameEn", "Website") FROM stdin;
\.


--
-- Data for Name: consist_maintainces; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.consist_maintainces (id, "Product_Code", "P_Ar_Name", "P_En_Name", "V_Name", "VV_Name", "Original_Qty", "AvQty", "Qty", "Price", "Discount", "Tax", "Total_Bf_Tax", "Total_Tax", "Total", "Exp_Date", "Store", "Product", "V1", "V2", "Unit", "Maintaince", "TDiscount", "Group", "Brand", "Code", "Date", "Note", "Serial_Num", "Total_Price", "Product_Numbers", "Total_Qty", "Total_Discount", "Total_Cost", "Total_Bf_Taxes", "Total_Taxes", "Draw", "Company", "Device_Type", "Device_Case", "Coin", "Cost_Center", "Account", "User", "Status", "Pattern_Image", "Time", "Payment_Method", "Password", "Pay", "Eng_Note", "Reason", "Report_Client", "Work", "StoreMain", "Eng", "Recipient", "Branch", "RefuseReason", "NoteRecived", "Returned", "CustomerGroup", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: consists; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.consists (id, "Code", "Date", "Darw", "Products_Number", "Total_Qty", "Total_Price", "Account", "Store", "Coin", "User", created_at, updated_at, "Time", "Branch", arr, "Delete") FROM stdin;
\.


--
-- Data for Name: contact_u_s; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.contact_u_s (id, "Map", "Arabic_Title", "English_Title", "Arabic_Desc", "English_Desc", "Opening_Hours", "Phone1", "Phone2", "Phone_Header", "Email", "Arabic_Address", "English_Address", created_at, updated_at) FROM stdin;
1	www.google.com/maps/embed?pb	DROP US A LINE	DROP US A LINE	Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500	Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500	Mon - Sat : 9am - 11pm	01062201060	0105206971	01062201060	info@klarapps.com	Cairo,Egypt	Cairo,Egypt	\N	2022-06-04 15:27:21
\.


--
-- Data for Name: cost_centers; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.cost_centers (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
4	مركز تكلفة	Cost Center	2022-02-18 01:22:58	2024-02-09 00:22:59
\.


--
-- Data for Name: counters_types; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.counters_types (id, "Name", "Current_Read", "Store", "Product", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: countris; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.countris (id, "Arabic_Name", "English_Name", "Flag", created_at, updated_at, "Safe", "Coin", "Store", "Code", "SearchCode") FROM stdin;
2	مصر	Egypt	CountriesImages/0YNgesTQQDPJblD7725Y.png	2022-06-04 19:37:49	2024-02-09 00:53:35	30	1	21	\N	\N
3	السعوديه	Saudi Arabia	CountriesImages/pgME9vgrOAqViEVToi4i.png	2022-06-04 19:39:05	2024-02-09 00:53:46	32	4	21	\N	\N
\.


--
-- Data for Name: coupon_codes; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.coupon_codes (id, "Code", "Amount", "Status", "Num", "Used", "Expire", created_at, updated_at) FROM stdin;
1	224466	100	0	3	2	2022-06-30	2022-06-04 15:19:31	2022-06-10 02:33:22
\.


--
-- Data for Name: courses; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.courses (id, "Code", "Arabic_Name", "English_Name", "Arabic_Desc", "English_Desc", "Category", "Lec_Num", "Hours", "Subject", created_at, updated_at, "Note") FROM stdin;
1	1	Course 1	Course 1	Course 1	Course 1	1	8	100	1	2024-01-21 00:37:23	2024-01-21 00:38:01	\N
\.


--
-- Data for Name: courses_categories; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.courses_categories (id, "Image", "Arabic_Name", "English_Name", "Arabic_Desc", "English_Desc", created_at, updated_at) FROM stdin;
1	CoursesCategoryImages/5CCMF4VEBCKWsSvv9ej3.png	فئة ١	فئة ١	فئة ١	فئة ١	2024-01-19 10:58:18	2024-01-19 10:58:18
\.


--
-- Data for Name: courses_halls; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.courses_halls (id, "Arabic_Name", "English_Name", "Chairs_Num", "Wiifii", "Air_Condition", "Place", "Number", created_at, updated_at) FROM stdin;
1	قاعة ١	قاعة ١	\N	1	1	\N	1	2024-01-19 11:02:53	2024-01-19 11:02:53
\.


--
-- Data for Name: courses_types; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.courses_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
1	خاص	خاص	2024-01-19 11:00:19	2024-01-19 11:00:19
2	VIP	VIP	2024-01-19 11:00:30	2024-01-19 11:00:30
3	مجموعة	مجموعة	2024-01-19 11:00:42	2024-01-19 11:00:42
\.


--
-- Data for Name: crm_default_data; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.crm_default_data (id, "Price_Level", "Governrate", "City", "Responsible", "Activity", "Campagin", "ClientStatus", "Platforms", created_at, updated_at, "Client_Delegate", "Nationality", "ClientGroup") FROM stdin;
3	1	2	1	38	8	7	5	8	2022-04-13 02:52:58	2025-01-26 14:20:20	0	2	3
\.


--
-- Data for Name: custom_prints; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.custom_prints (id, "Sales_Print_Type", "Sales_Bill_Code", "Sales_Date", "Sales_Coin", "Sales_Draw", "Sales_Payment_Method", "Sales_Status", "Sales_Executor", "Sales_Refernce_Number", "Sales_Safe", "Sales_Client", "Sales_Delegate", "Sales_Store", "Sales_User", "Sales_Cost_Center", "Sales_Notes", "Sales_Pro_Code", "Sales_Pro_Name", "Sales_Pro_Unit", "Sales_Pro_Qty", "Sales_Pro_Price", "Sales_Pro_Discount", "Sales_Pro_Total_Bf_Tax", "Sales_Pro_Total_Tax", "Sales_Pro_Total", "Sales_Pro_Store", "Sales_Pro_Desc", "Sales_Pro_Exp_Date", "Sales_Pro_Weight", "Sales_Pro_Patch_Number", "Sales_Product_Numbers", "Sales_Total_Qty", "Sales_Total_Discount", "Sales_Total_Bf_Taxes", "Sales_Total_Taxes", "Sales_Total_Price", "Sales_Paid", "Sales_Residual", "Sales_Taknet", "Sales_Credit", "Sales_Barcode", "Sales_Text", "Sales_Seal", "Purch_Print_Type", "Purch_Bill_Code", "Purch_Date", "Purch_Vendor_Bill_Date", "Purch_Coin", "Purch_Draw", "Purch_Payment_Method", "Purch_Status", "Purch_Refernce_Number", "Purch_Safe", "Purch_Vendor", "Purch_Delegate", "Purch_Store", "Purch_User", "Purch_Cost_Center", "Purch_Notes", "Purch_Pro_Code", "Purch_Pro_Name", "Purch_Pro_Unit", "Purch_Pro_Qty", "Purch_Pro_Price", "Purch_Pro_Discount", "Purch_Pro_Total_Bf_Tax", "Purch_Pro_Total_Tax", "Purch_Pro_Total", "Purch_Pro_Store", "Purch_Pro_Exp_Date", "Purch_Product_Numbers", "Purch_Total_Qty", "Purch_Total_Discount", "Purch_Total_Bf_Taxes", "Purch_Total_Taxes", "Purch_Total_Price", "Purch_Paid", "Purch_Residual", "Purch_Taknet", "Purch_Credit", "Purch_Barcode", "Purch_Text", "Purch_Seal", created_at, updated_at, "Sales_Client_Phone", "Sales_Resdiual", "Sales_Total_Return", "Sales_Client_Address", "Sales_Pro_Total_Net", "Purch_Pro_Total_Net") FROM stdin;
1	2	1	1	0	0	0	0	0	0	0	1	1	0	0	0	1	1	1	0	1	1	0	0	1	1	0	0	0	0	0	0	0	0	0	1	1	0	0	0	0	1	1	0	2	1	1	0	0	0	0	0	0	0	1	1	0	0	0	1	1	1	0	1	1	0	0	0	1	0	0	0	0	0	0	1	1	0	0	0	1	1	1	0	2024-04-14 16:57:48	2025-01-28 10:32:10	0	0	0	0	0	0
\.


--
-- Data for Name: customer_follow_ups; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.customer_follow_ups (id, "Code", "Date", "Client", "Subject", "Rate", "Emp", "Visit_Cost", "Note", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: customers; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.customers (id, "Code", "Date", "Name", "Price_Level", "Phone", email, password, "ID_Number", "Address", "Qualifications", "Birthdate", "Social_Status", "Passport_Number", "Company_Name", "Commercial_Registration_No", "Tax_Card_No", "Bank_Account", "Image", "Next_Time", "Executions_Status", "Governrate", "City", "Responsible", "Activity", "Campagin", "ClientStatus", "Account", "User", created_at, updated_at, "Platform", "Contract_Start", "Contract_End", code, country, "Tax_Registration_Number", "Tax_activity_code", work_nature, "Buliding_Num", "Street", "Postal_Code", tax_magistrate, "Floor", "Room", "Landmark", "Add_Info", "Phone2", "Phone3", "Phone4", "Warranty", "Group", "Place", "Nationality", "Product", token, "NameEn", arr, "SearchCode", "Credit_Limit", "Respon_Person", "Respon_Person_Phone", "Operating_Date", "Activation_Serial", "Activation_Code", "Repayment_Period") FROM stdin;
1	1	2024-02-09	عميل افتراضي	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2522	11	2024-02-09 00:08:02	2024-02-09 00:08:02	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	Default Customer	\N	\N	\N	\N	\N	\N	\N	\N	\N
8	14	44633	منظفات التوحيد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2535	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	منظفات التوحيد	\N	\N	\N	\N	\N	\N	\N	\N	\N
10	17	44635	شركة ميرو للالبان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2537	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركة ميرو للالبان	\N	\N	\N	\N	\N	\N	\N	\N	\N
12	19	44637	الفتح للبلاستيك	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2539	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الفتح للبلاستيك	\N	\N	\N	\N	\N	\N	\N	\N	\N
13	20	44638	مصنع النسر للمناديل	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2540	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مصنع النسر للمناديل	\N	\N	\N	\N	\N	\N	\N	\N	\N
14	21	44639	مصنع سيلكي للمناديل	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2541	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مصنع سيلكي للمناديل	\N	\N	\N	\N	\N	\N	\N	\N	\N
15	22	44640	توفير اونلاين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2542	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	توفير اونلاين	\N	\N	\N	\N	\N	\N	\N	\N	\N
16	23	44641	جيت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2543	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جيت	\N	\N	\N	\N	\N	\N	\N	\N	\N
18	25	44643	لولو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2545	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	لولو	\N	\N	\N	\N	\N	\N	\N	\N	\N
19	26	44644	جملة ماركت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2546	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جملة ماركت	\N	\N	\N	\N	\N	\N	\N	\N	\N
20	28	44645	الشيخ عمرو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2547	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الشيخ عمرو	\N	\N	\N	\N	\N	\N	\N	\N	\N
22	30	44647	الفا ماركت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2549	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الفا ماركت	\N	\N	\N	\N	\N	\N	\N	\N	\N
23	31	44648	كارفور المعادي	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2550	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	كارفور المعادي	\N	\N	\N	\N	\N	\N	\N	\N	\N
24	32	44649	تالف اوريانت جلوري	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2551	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	تالف اوريانت جلوري	\N	\N	\N	\N	\N	\N	\N	\N	\N
25	34	44650	صيدلية الدكتور علاء	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2552	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	صيدلية الدكتور علاء	\N	\N	\N	\N	\N	\N	\N	\N	\N
27	36	44652	طلبات ماركت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2554	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	طلبات ماركت	\N	\N	\N	\N	\N	\N	\N	\N	\N
28	37	44653	الحاج رمضان سيد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2555	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الحاج رمضان سيد	\N	\N	\N	\N	\N	\N	\N	\N	\N
29	38	44654	الازهري ادوات مكتبية	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2556	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الازهري ادوات مكتبية	\N	\N	\N	\N	\N	\N	\N	\N	\N
30	39	44655	تكنولوجي  مول الكمبيوتر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2557	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	تكنولوجي  مول الكمبيوتر	\N	\N	\N	\N	\N	\N	\N	\N	\N
31	41	44656	مواصلات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2558	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مواصلات	\N	\N	\N	\N	\N	\N	\N	\N	\N
32	42	44657	كازيون ماركت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2559	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	كازيون ماركت	\N	\N	\N	\N	\N	\N	\N	\N	\N
33	43	44658	التوحيد والنور	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2560	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	التوحيد والنور	\N	\N	\N	\N	\N	\N	\N	\N	\N
34	44	44659	طه حسين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2561	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	طه حسين	\N	\N	\N	\N	\N	\N	\N	\N	\N
36	46	44661	محمود فاروق مطبعة	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2563	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	محمود فاروق مطبعة	\N	\N	\N	\N	\N	\N	\N	\N	\N
37	47	44662	شركة دلتا للتطوير العقاري	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2564	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركة دلتا للتطوير العقاري	\N	\N	\N	\N	\N	\N	\N	\N	\N
38	48	44663	البيت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2565	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	البيت	\N	\N	\N	\N	\N	\N	\N	\N	\N
39	49	44664	هوم سنتر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2566	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	هوم سنتر	\N	\N	\N	\N	\N	\N	\N	\N	\N
40	50	44665	عام	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2567	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	عام	\N	\N	\N	\N	\N	\N	\N	\N	\N
42	53	44667	شركة جوهر باب البحر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2569	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركة جوهر باب البحر	\N	\N	\N	\N	\N	\N	\N	\N	\N
43	54	44668	بن العروبة	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2570	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بن العروبة	\N	\N	\N	\N	\N	\N	\N	\N	\N
44	55	44669	نادى سماش	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2571	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	نادى سماش	\N	\N	\N	\N	\N	\N	\N	\N	\N
45	56	44670	بدون	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2572	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بدون	\N	\N	\N	\N	\N	\N	\N	\N	\N
46	57	44671	فرست	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2573	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	فرست	\N	\N	\N	\N	\N	\N	\N	\N	\N
47	58	44672	دالتا	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2574	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دالتا	\N	\N	\N	\N	\N	\N	\N	\N	\N
48	60	44673	سى اتش	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2575	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	سى اتش	\N	\N	\N	\N	\N	\N	\N	\N	\N
49	123	44674	شركه المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2576	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه المعادى	\N	\N	\N	\N	\N	\N	\N	\N	\N
51	64	44676	الموسسه المتخصصه للموازين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2578	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الموسسه المتخصصه للموازين	\N	\N	\N	\N	\N	\N	\N	\N	\N
52	65	44677	الدلتا	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2579	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الدلتا	\N	\N	\N	\N	\N	\N	\N	\N	\N
53	66	44678	محل البركه للعطاره	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2580	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	محل البركه للعطاره	\N	\N	\N	\N	\N	\N	\N	\N	\N
54	67	44679	نسكافيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2581	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	نسكافيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
55	68	44680	الكوننتتال	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2582	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الكوننتتال	\N	\N	\N	\N	\N	\N	\N	\N	\N
56	69	44681	اجورا	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2583	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اجورا	\N	\N	\N	\N	\N	\N	\N	\N	\N
57	70	44682	خالد جلوان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2584	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	خالد جلوان	\N	\N	\N	\N	\N	\N	\N	\N	\N
58	71	44683	مول العتبه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2585	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مول العتبه	\N	\N	\N	\N	\N	\N	\N	\N	\N
60	73	44685	كريم الديب	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2587	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	كريم الديب	\N	\N	\N	\N	\N	\N	\N	\N	\N
61	74	44686	ابو وليد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2588	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ابو وليد	\N	\N	\N	\N	\N	\N	\N	\N	\N
62	76	44687	مطاحن ومخابز شمال القاهره	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2589	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مطاحن ومخابز شمال القاهره	\N	\N	\N	\N	\N	\N	\N	\N	\N
64	78	44689	طيبات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2591	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	طيبات	\N	\N	\N	\N	\N	\N	\N	\N	\N
65	79	44690	النبراوى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2592	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	النبراوى	\N	\N	\N	\N	\N	\N	\N	\N	\N
66	80	44691	العالميه ام اتش	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2593	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	العالميه ام اتش	\N	\N	\N	\N	\N	\N	\N	\N	\N
67	81	44692	نادى سماش المطار	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2594	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	نادى سماش المطار	\N	\N	\N	\N	\N	\N	\N	\N	\N
68	83	44693	حكيم بلاستيك	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2595	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	حكيم بلاستيك	\N	\N	\N	\N	\N	\N	\N	\N	\N
70	85	44695	ينوفيد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2597	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ينوفيد	\N	\N	\N	\N	\N	\N	\N	\N	\N
71	86	44696	العربى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2598	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	العربى	\N	\N	\N	\N	\N	\N	\N	\N	\N
72	87	44697	ايزيس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2599	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ايزيس	\N	\N	\N	\N	\N	\N	\N	\N	\N
73	88	44698	المتحده للتوريدات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2600	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	المتحده للتوريدات	\N	\N	\N	\N	\N	\N	\N	\N	\N
74	89	44699	جورى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2601	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جورى	\N	\N	\N	\N	\N	\N	\N	\N	\N
75	90	44700	حيدر التجاريه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2602	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	حيدر التجاريه	\N	\N	\N	\N	\N	\N	\N	\N	\N
76	91	44701	قناه الغد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2603	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	قناه الغد	\N	\N	\N	\N	\N	\N	\N	\N	\N
77	93	44702	ارتليا	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2604	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ارتليا	\N	\N	\N	\N	\N	\N	\N	\N	\N
79	95	44704	شركه كونكت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2606	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه كونكت	\N	\N	\N	\N	\N	\N	\N	\N	\N
80	98	44705	مكتب المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2607	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مكتب المعادى	\N	\N	\N	\N	\N	\N	\N	\N	\N
81	99	44706	عينات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2608	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	عينات	\N	\N	\N	\N	\N	\N	\N	\N	\N
82	101	44707	محل سلمان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2609	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	محل سلمان	\N	\N	\N	\N	\N	\N	\N	\N	\N
83	102	44708	مكه باك	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2610	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مكه باك	\N	\N	\N	\N	\N	\N	\N	\N	\N
84	105	44709	yes mac	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2611	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	yes mac	\N	\N	\N	\N	\N	\N	\N	\N	\N
86	107	44711	ابو عوف	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2613	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ابو عوف	\N	\N	\N	\N	\N	\N	\N	\N	\N
88	110	44713	ايه ا  ام للخدمات الطبيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2615	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ايه ا  ام للخدمات الطبيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
89	111	44714	y.m	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2616	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	y.m	\N	\N	\N	\N	\N	\N	\N	\N	\N
90	112	44715	جلوبر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2617	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جلوبر	\N	\N	\N	\N	\N	\N	\N	\N	\N
91	113	44716	موسسه بلال	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2618	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	موسسه بلال	\N	\N	\N	\N	\N	\N	\N	\N	\N
92	114	44717	طلابيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2619	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	طلابيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
93	116	44718	جو ى للاستيراد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2620	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جو ى للاستيراد	\N	\N	\N	\N	\N	\N	\N	\N	\N
94	118	44719	كامينا	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2621	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	كامينا	\N	\N	\N	\N	\N	\N	\N	\N	\N
95	119	44720	جامعه نيو جيزه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2622	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جامعه نيو جيزه	\N	\N	\N	\N	\N	\N	\N	\N	\N
96	121	44721	ام ايه جروب	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2623	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ام ايه جروب	\N	\N	\N	\N	\N	\N	\N	\N	\N
98	125	44723	جوهر المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2625	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جوهر المعادى	\N	\N	\N	\N	\N	\N	\N	\N	\N
99	126	44724	بلاتنيوم	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2626	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بلاتنيوم	\N	\N	\N	\N	\N	\N	\N	\N	\N
100	127	44725	توريده	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2627	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	توريده	\N	\N	\N	\N	\N	\N	\N	\N	\N
101	129	44726	جمله الجمله	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2628	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جمله الجمله	\N	\N	\N	\N	\N	\N	\N	\N	\N
102	130	44727	رجب العطار	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2629	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	رجب العطار	\N	\N	\N	\N	\N	\N	\N	\N	\N
103	131	44728	اسولق الشريف	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2630	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اسولق الشريف	\N	\N	\N	\N	\N	\N	\N	\N	\N
104	97	44729	SGS اسكندريه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2631	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	SGS اسكندريه	\N	\N	\N	\N	\N	\N	\N	\N	\N
106	96	44731	السويس SGS	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2633	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	السويس SGS	\N	\N	\N	\N	\N	\N	\N	\N	\N
107	132	44732	بن شاهين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2634	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بن شاهين	\N	\N	\N	\N	\N	\N	\N	\N	\N
109	135	44734	سوق الحميديه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2636	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	سوق الحميديه	\N	\N	\N	\N	\N	\N	\N	\N	\N
110	136	44735	شوقى العوام	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2637	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شوقى العوام	\N	\N	\N	\N	\N	\N	\N	\N	\N
112	138	44737	المخزن	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2639	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	المخزن	\N	\N	\N	\N	\N	\N	\N	\N	\N
113	139	44738	رومانتيك	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2640	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	رومانتيك	\N	\N	\N	\N	\N	\N	\N	\N	\N
114	140	44739	العجيل للاجهزه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2641	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	العجيل للاجهزه	\N	\N	\N	\N	\N	\N	\N	\N	\N
115	141	44740	هيرو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2642	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	هيرو	\N	\N	\N	\N	\N	\N	\N	\N	\N
116	142	44741	كاش	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2643	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	كاش	\N	\N	\N	\N	\N	\N	\N	\N	\N
117	144	44742	dme	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2644	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	dme	\N	\N	\N	\N	\N	\N	\N	\N	\N
118	145	44743	سترو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2645	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	سترو	\N	\N	\N	\N	\N	\N	\N	\N	\N
119	146	44744	ابو جبه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2646	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ابو جبه	\N	\N	\N	\N	\N	\N	\N	\N	\N
120	147	44745	ام سكوير المصيف	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2647	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ام سكوير المصيف	\N	\N	\N	\N	\N	\N	\N	\N	\N
121	148	44746	بن سليمان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2648	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بن سليمان	\N	\N	\N	\N	\N	\N	\N	\N	\N
122	149	44747	ال خان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2649	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ال خان	\N	\N	\N	\N	\N	\N	\N	\N	\N
123	150	44748	جوى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2650	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جوى	\N	\N	\N	\N	\N	\N	\N	\N	\N
125	153	44750	شركه ثروه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2652	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه ثروه	\N	\N	\N	\N	\N	\N	\N	\N	\N
126	154	44751	شركه ثروه بريد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2653	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه ثروه بريد	\N	\N	\N	\N	\N	\N	\N	\N	\N
127	155	44752	ترجمه الدقى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2654	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ترجمه الدقى	\N	\N	\N	\N	\N	\N	\N	\N	\N
128	156	44753	عطاره ال خان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2655	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	عطاره ال خان	\N	\N	\N	\N	\N	\N	\N	\N	\N
130	159	44755	محمد حلاوه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2657	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	محمد حلاوه	\N	\N	\N	\N	\N	\N	\N	\N	\N
131	160	44756	ال طه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2658	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ال طه	\N	\N	\N	\N	\N	\N	\N	\N	\N
133	163	44758	جازتك	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2660	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جازتك	\N	\N	\N	\N	\N	\N	\N	\N	\N
134	165	44759	المنيع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2661	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	المنيع	\N	\N	\N	\N	\N	\N	\N	\N	\N
136	167	44761	اسميلى للاداره والتطوير السياحى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2663	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اسميلى للاداره والتطوير السياحى	\N	\N	\N	\N	\N	\N	\N	\N	\N
137	168	44762	AG	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2664	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	AG	\N	\N	\N	\N	\N	\N	\N	\N	\N
138	169	44763	جرد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2665	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جرد	\N	\N	\N	\N	\N	\N	\N	\N	\N
139	170	44764	ECSD	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2666	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ECSD	\N	\N	\N	\N	\N	\N	\N	\N	\N
140	171	44765	هليوبليس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2667	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	هليوبليس	\N	\N	\N	\N	\N	\N	\N	\N	\N
142	174	44767	EURO	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2669	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	EURO	\N	\N	\N	\N	\N	\N	\N	\N	\N
143	175	44768	دلتا كابيتال	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2670	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دلتا كابيتال	\N	\N	\N	\N	\N	\N	\N	\N	\N
144	176	44769	اندلسيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2671	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اندلسيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
145	177	44770	جامعه القاهره	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2672	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جامعه القاهره	\N	\N	\N	\N	\N	\N	\N	\N	\N
147	180	44772	ندى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2674	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ندى	\N	\N	\N	\N	\N	\N	\N	\N	\N
148	181	44773	بود ايجيبت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2675	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بود ايجيبت	\N	\N	\N	\N	\N	\N	\N	\N	\N
149	182	44774	المطورون العرب	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2676	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	المطورون العرب	\N	\N	\N	\N	\N	\N	\N	\N	\N
150	183	44775	نيوم للتنميه   الشيخ زايد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2677	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	نيوم للتنميه   الشيخ زايد	\N	\N	\N	\N	\N	\N	\N	\N	\N
151	184	44776	هانى سعيد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2678	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	هانى سعيد	\N	\N	\N	\N	\N	\N	\N	\N	\N
152	185	44777	اسماش التجمع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2679	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اسماش التجمع	\N	\N	\N	\N	\N	\N	\N	\N	\N
153	186	44778	petro	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2680	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	petro	\N	\N	\N	\N	\N	\N	\N	\N	\N
154	187	44779	زغلول	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2681	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	زغلول	\N	\N	\N	\N	\N	\N	\N	\N	\N
155	243	44780	GMC	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2682	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	GMC	\N	\N	\N	\N	\N	\N	\N	\N	\N
157	190	44782	بطرس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2684	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بطرس	\N	\N	\N	\N	\N	\N	\N	\N	\N
158	191	44783	لوكس سرى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2685	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	لوكس سرى	\N	\N	\N	\N	\N	\N	\N	\N	\N
159	192	44784	افيز	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2686	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	افيز	\N	\N	\N	\N	\N	\N	\N	\N	\N
160	193	44785	حازم جراج	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2687	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	حازم جراج	\N	\N	\N	\N	\N	\N	\N	\N	\N
161	195	44786	جليد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2688	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جليد	\N	\N	\N	\N	\N	\N	\N	\N	\N
163	197	44788	سكر مظبوط	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2690	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	سكر مظبوط	\N	\N	\N	\N	\N	\N	\N	\N	\N
164	198	44789	عبد الرحمن  نسكافيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2691	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	عبد الرحمن  نسكافيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
165	199	44790	خالد حسين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2692	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	خالد حسين	\N	\N	\N	\N	\N	\N	\N	\N	\N
166	200	44791	ارسيلوميتال	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2693	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ارسيلوميتال	\N	\N	\N	\N	\N	\N	\N	\N	\N
167	201	44792	فيوتشر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2694	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	فيوتشر	\N	\N	\N	\N	\N	\N	\N	\N	\N
169	204	44794	بريف ماركت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2696	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بريف ماركت	\N	\N	\N	\N	\N	\N	\N	\N	\N
170	205	44795	DMCاداره رقم  1	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2697	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	DMCاداره رقم  1	\N	\N	\N	\N	\N	\N	\N	\N	\N
171	206	44796	دى ام سى  اللوتس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2698	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى  اللوتس	\N	\N	\N	\N	\N	\N	\N	\N	\N
172	207	44797	دى ام سى  الرحاب	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2699	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى  الرحاب	\N	\N	\N	\N	\N	\N	\N	\N	\N
173	209	44798	دى ام سى  الوفاء والامل	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2700	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى  الوفاء والامل	\N	\N	\N	\N	\N	\N	\N	\N	\N
175	211	44800	دى ام سى الاداره 4 مكتب فنى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2702	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى الاداره 4 مكتب فنى	\N	\N	\N	\N	\N	\N	\N	\N	\N
176	212	44801	دى ام سى اداره رقم 2	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2703	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى اداره رقم 2	\N	\N	\N	\N	\N	\N	\N	\N	\N
177	213	44802	دى ام سى الحميات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2704	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى الحميات	\N	\N	\N	\N	\N	\N	\N	\N	\N
178	214	44803	دى ام سى  اداره رقم 5	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2705	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى  اداره رقم 5	\N	\N	\N	\N	\N	\N	\N	\N	\N
179	215	44804	دى ام سى مخزن الرحاب	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2706	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى مخزن الرحاب	\N	\N	\N	\N	\N	\N	\N	\N	\N
180	216	44805	دى ام سى  مخن بلبيس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2707	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى  مخن بلبيس	\N	\N	\N	\N	\N	\N	\N	\N	\N
181	218	44806	دى ام سى مخزن المشير	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2708	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى مخزن المشير	\N	\N	\N	\N	\N	\N	\N	\N	\N
182	219	44807	دى ام سى مخزن الحميات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2709	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى مخزن الحميات	\N	\N	\N	\N	\N	\N	\N	\N	\N
184	221	44809	دى ام سى مخزن اللوتس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2711	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى مخزن اللوتس	\N	\N	\N	\N	\N	\N	\N	\N	\N
185	222	44810	دى ام سى امنا مخازنweb help	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2712	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى امنا مخازنweb help	\N	\N	\N	\N	\N	\N	\N	\N	\N
186	223	44811	دى ام سى غفير  help	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2713	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى غفير  help	\N	\N	\N	\N	\N	\N	\N	\N	\N
187	224	44812	دى ام سى موقع web help	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2714	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى موقع web help	\N	\N	\N	\N	\N	\N	\N	\N	\N
188	225	44813	دى ام سى استشارى web  help	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2715	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى استشارى web  help	\N	\N	\N	\N	\N	\N	\N	\N	\N
189	227	44814	دى ام سى استشارى ساجا 2	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2716	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى استشارى ساجا 2	\N	\N	\N	\N	\N	\N	\N	\N	\N
190	231	44815	جذور  المعادىhq	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2717	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور  المعادىhq	\N	\N	\N	\N	\N	\N	\N	\N	\N
191	235	44816	دى ام سى غفير  ساجا 2	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2718	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى غفير  ساجا 2	\N	\N	\N	\N	\N	\N	\N	\N	\N
192	236	44817	تسويه فواتير	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2719	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	تسويه فواتير	\N	\N	\N	\N	\N	\N	\N	\N	\N
193	237	44818	دى ام  عمومى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2720	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام  عمومى	\N	\N	\N	\N	\N	\N	\N	\N	\N
194	238	44819	دى ام  س عمومى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2721	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام  س عمومى	\N	\N	\N	\N	\N	\N	\N	\N	\N
196	240	44821	باز للصناعات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2723	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	باز للصناعات	\N	\N	\N	\N	\N	\N	\N	\N	\N
198	242	44823	دى ام سى غفير زيزنيا	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2725	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى غفير زيزنيا	\N	\N	\N	\N	\N	\N	\N	\N	\N
199	5	44824	امازون اونلاين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2726	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	امازون اونلاين	\N	\N	\N	\N	\N	\N	\N	\N	\N
200	8	44825	عمرو القصر العيني الفرنساوي	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2727	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	عمرو القصر العيني الفرنساوي	\N	\N	\N	\N	\N	\N	\N	\N	\N
201	15	44826	احمد عبد العزيز الفجالة	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2728	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	احمد عبد العزيز الفجالة	\N	\N	\N	\N	\N	\N	\N	\N	\N
202	27	44827	بن الغرباوي	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2729	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بن الغرباوي	\N	\N	\N	\N	\N	\N	\N	\N	\N
203	33	44828	بن عبد المعبود	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2730	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بن عبد المعبود	\N	\N	\N	\N	\N	\N	\N	\N	\N
205	51	44830	اولاد الشيخ	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2732	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اولاد الشيخ	\N	\N	\N	\N	\N	\N	\N	\N	\N
206	59	44831	عبد الرحمن	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2733	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	عبد الرحمن	\N	\N	\N	\N	\N	\N	\N	\N	\N
207	61	44832	شركه الفتح للتوريدات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2734	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه الفتح للتوريدات	\N	\N	\N	\N	\N	\N	\N	\N	\N
208	228	44833	جذور  الابراج الصينيه العاصمه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2735	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور  الابراج الصينيه العاصمه	\N	\N	\N	\N	\N	\N	\N	\N	\N
209	230	44834	جذور سوديك الشروق	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2736	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور سوديك الشروق	\N	\N	\N	\N	\N	\N	\N	\N	\N
210	232	44835	جذور  قطاميه التجمع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2737	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور  قطاميه التجمع	\N	\N	\N	\N	\N	\N	\N	\N	\N
211	234	44836	جذور بدون	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2738	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور بدون	\N	\N	\N	\N	\N	\N	\N	\N	\N
213	75	44838	شركه نزيه العطار	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2740	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه نزيه العطار	\N	\N	\N	\N	\N	\N	\N	\N	\N
214	82	44839	ال اسماعيل للمحاماه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2741	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ال اسماعيل للمحاماه	\N	\N	\N	\N	\N	\N	\N	\N	\N
215	92	44840	سماش الخمايل	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2742	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	سماش الخمايل	\N	\N	\N	\N	\N	\N	\N	\N	\N
216	100	44841	مخزن	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2743	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مخزن	\N	\N	\N	\N	\N	\N	\N	\N	\N
217	104	44842	الجامعه الامريكيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2744	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الجامعه الامريكيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
218	115	44843	عينه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2745	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	عينه	\N	\N	\N	\N	\N	\N	\N	\N	\N
219	120	44844	البردى لصناعة الورق	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2746	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	البردى لصناعة الورق	\N	\N	\N	\N	\N	\N	\N	\N	\N
220	124	44845	شركه ام سكوير	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2747	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه ام سكوير	\N	\N	\N	\N	\N	\N	\N	\N	\N
221	128	44846	مول صن سيتى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2748	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مول صن سيتى	\N	\N	\N	\N	\N	\N	\N	\N	\N
223	143	44848	شركه الفكهانيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2750	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه الفكهانيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
224	151	44849	مكتب صقر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2751	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مكتب صقر	\N	\N	\N	\N	\N	\N	\N	\N	\N
225	157	44850	اسواق الشريف	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2752	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اسواق الشريف	\N	\N	\N	\N	\N	\N	\N	\N	\N
226	164	44851	اسلام مودرن	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2753	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اسلام مودرن	\N	\N	\N	\N	\N	\N	\N	\N	\N
227	172	44852	فريندز	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2754	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	فريندز	\N	\N	\N	\N	\N	\N	\N	\N	\N
229	188	44854	الجمعيه المصريه للابداع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2756	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الجمعيه المصريه للابداع	\N	\N	\N	\N	\N	\N	\N	\N	\N
230	194	44855	جامعه هليوبليس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2757	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جامعه هليوبليس	\N	\N	\N	\N	\N	\N	\N	\N	\N
231	202	44856	ماركت  المحطه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2758	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ماركت  المحطه	\N	\N	\N	\N	\N	\N	\N	\N	\N
232	208	44857	دى ام سى  غفير مصنع العاشر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2759	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى  غفير مصنع العاشر	\N	\N	\N	\N	\N	\N	\N	\N	\N
233	217	44858	دى ام سى مخزن ساجا 2	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2760	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى مخزن ساجا 2	\N	\N	\N	\N	\N	\N	\N	\N	\N
234	226	44859	دى ام سى  ساجا  22	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2761	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى  ساجا  22	\N	\N	\N	\N	\N	\N	\N	\N	\N
235	233	44860	جذور تاج فيلا طريق السويس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2762	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور تاج فيلا طريق السويس	\N	\N	\N	\N	\N	\N	\N	\N	\N
236	248	44861	جيلى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2763	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جيلى	\N	\N	\N	\N	\N	\N	\N	\N	\N
237	249	44862	ياز	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2764	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ياز	\N	\N	\N	\N	\N	\N	\N	\N	\N
238	250	44863	ابراهيم سائق	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2765	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ابراهيم سائق	\N	\N	\N	\N	\N	\N	\N	\N	\N
240	252	44865	مصطفى مخزن	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2767	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مصطفى مخزن	\N	\N	\N	\N	\N	\N	\N	\N	\N
241	253	44866	sgs دمياط	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2768	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	sgs دمياط	\N	\N	\N	\N	\N	\N	\N	\N	\N
242	254	44867	شركه اتصال	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2769	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه اتصال	\N	\N	\N	\N	\N	\N	\N	\N	\N
243	255	44868	جى ام سى احمد رشاد +عامل الصيانخ	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2770	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى احمد رشاد +عامل الصيانخ	\N	\N	\N	\N	\N	\N	\N	\N	\N
244	256	44869	جى ام سى اداره 2	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2771	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى اداره 2	\N	\N	\N	\N	\N	\N	\N	\N	\N
246	258	44871	جى ام سى المخزن العام	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2773	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى المخزن العام	\N	\N	\N	\N	\N	\N	\N	\N	\N
247	259	44872	جى ام سى الرحاب	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2774	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى الرحاب	\N	\N	\N	\N	\N	\N	\N	\N	\N
248	260	44873	جى ام سى الوفاء والامل	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2775	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى الوفاء والامل	\N	\N	\N	\N	\N	\N	\N	\N	\N
249	261	44874	جى ام سى سجا 2	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2776	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى سجا 2	\N	\N	\N	\N	\N	\N	\N	\N	\N
250	262	44875	جى ام سى موقع الوفاء والامل	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2777	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى موقع الوفاء والامل	\N	\N	\N	\N	\N	\N	\N	\N	\N
251	244	44876	جذور مخزن وشاليه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2778	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور مخزن وشاليه	\N	\N	\N	\N	\N	\N	\N	\N	\N
252	246	44877	جذذور استبت جديد اكتوبر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2779	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذذور استبت جديد اكتوبر	\N	\N	\N	\N	\N	\N	\N	\N	\N
2	7	44627	TUV	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2529	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	TUV	\N	\N	\N	\N	\N	\N	\N	\N	\N
3	9	44628	اولاد تمام حلوان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2530	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اولاد تمام حلوان	\N	\N	\N	\N	\N	\N	\N	\N	\N
6	12	44631	شركة الزهور للمنظفات دار السلام	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2533	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركة الزهور للمنظفات دار السلام	\N	\N	\N	\N	\N	\N	\N	\N	\N
21	29	44646	مرتب اسماء	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2548	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مرتب اسماء	\N	\N	\N	\N	\N	\N	\N	\N	\N
26	35	44651	مكسب اون لاين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2553	1	\N	2025-01-15 08:41:34	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مكسب اون لاين	\N	\N	\N	\N	\N	\N	\N	\N	\N
35	45	44660	طارق عبد الحميد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2562	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	طارق عبد الحميد	\N	\N	\N	\N	\N	\N	\N	\N	\N
41	52	44666	اولاد عبد المقصود	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2568	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اولاد عبد المقصود	\N	\N	\N	\N	\N	\N	\N	\N	\N
50	62	44675	خلودى للدعايه والاعلان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2577	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	خلودى للدعايه والاعلان	\N	\N	\N	\N	\N	\N	\N	\N	\N
59	72	44684	بيت الجمله	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2586	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بيت الجمله	\N	\N	\N	\N	\N	\N	\N	\N	\N
63	77	44688	فرع المحل الصغير	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2590	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	فرع المحل الصغير	\N	\N	\N	\N	\N	\N	\N	\N	\N
69	84	44694	الوكاله للتجاره	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2596	1	\N	2025-01-15 08:41:35	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الوكاله للتجاره	\N	\N	\N	\N	\N	\N	\N	\N	\N
78	94	44703	امورادو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2605	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	امورادو	\N	\N	\N	\N	\N	\N	\N	\N	\N
85	106	44710	yes pac	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2612	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	yes pac	\N	\N	\N	\N	\N	\N	\N	\N	\N
87	108	44712	العالميه للتوريدات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2614	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	العالميه للتوريدات	\N	\N	\N	\N	\N	\N	\N	\N	\N
97	122	44722	الشركه المصريه للتجاره والتوزيع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2624	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الشركه المصريه للتجاره والتوزيع	\N	\N	\N	\N	\N	\N	\N	\N	\N
254	6	44879	المعادى SGS	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2781	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	المعادى SGS	\N	\N	\N	\N	\N	\N	\N	\N	\N
256	264	44881	جى ام سى اداره رقم 4	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2783	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى اداره رقم 4	\N	\N	\N	\N	\N	\N	\N	\N	\N
257	265	44882	جى ام سى اداره رقم 1	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2784	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى اداره رقم 1	\N	\N	\N	\N	\N	\N	\N	\N	\N
258	266	44883	جى ام سى مكتب الاستشارى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2785	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى مكتب الاستشارى	\N	\N	\N	\N	\N	\N	\N	\N	\N
259	267	44884	جى ام سى مهندسين ومشرفين الموقع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2786	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى مهندسين ومشرفين الموقع	\N	\N	\N	\N	\N	\N	\N	\N	\N
260	268	44885	جى ام سى امناء مخازن عدد4	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2787	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى امناء مخازن عدد4	\N	\N	\N	\N	\N	\N	\N	\N	\N
261	269	44886	جى ام سى البوفيه للفنين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2788	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى البوفيه للفنين	\N	\N	\N	\N	\N	\N	\N	\N	\N
262	270	44887	جى ام سى اداره رقم 5	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2789	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى اداره رقم 5	\N	\N	\N	\N	\N	\N	\N	\N	\N
263	271	44888	جى ام سى غير موقع زيزنيا	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2790	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى غير موقع زيزنيا	\N	\N	\N	\N	\N	\N	\N	\N	\N
265	273	44890	جذور	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2792	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور	\N	\N	\N	\N	\N	\N	\N	\N	\N
266	274	44891	مجموع مرتبات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2793	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مجموع مرتبات	\N	\N	\N	\N	\N	\N	\N	\N	\N
267	275	44892	ابراهيم سائق	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2794	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ابراهيم سائق	\N	\N	\N	\N	\N	\N	\N	\N	\N
268	276	44893	مصطفى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2795	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مصطفى	\N	\N	\N	\N	\N	\N	\N	\N	\N
269	277	44894	رمضان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2796	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	رمضان	\N	\N	\N	\N	\N	\N	\N	\N	\N
270	278	44895	محمد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2797	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	محمد	\N	\N	\N	\N	\N	\N	\N	\N	\N
271	279	44896	ندى نشأت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2798	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ندى نشأت	\N	\N	\N	\N	\N	\N	\N	\N	\N
272	280	44897	اسماء	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2799	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اسماء	\N	\N	\N	\N	\N	\N	\N	\N	\N
273	281	44898	ام خالد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2800	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ام خالد	\N	\N	\N	\N	\N	\N	\N	\N	\N
274	282	44899	فاطمه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2801	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	فاطمه	\N	\N	\N	\N	\N	\N	\N	\N	\N
275	283	44900	شركه حرسات	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2802	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه حرسات	\N	\N	\N	\N	\N	\N	\N	\N	\N
276	284	44901	ممشي مصر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2803	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ممشي مصر	\N	\N	\N	\N	\N	\N	\N	\N	\N
278	286	44903	بود ايجبت شيراتون	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2805	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بود ايجبت شيراتون	\N	\N	\N	\N	\N	\N	\N	\N	\N
279	287	44904	اسواق للتطوير العقاري	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2806	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اسواق للتطوير العقاري	\N	\N	\N	\N	\N	\N	\N	\N	\N
280	288	44905	ام سكوير  المصيف	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2807	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ام سكوير  المصيف	\N	\N	\N	\N	\N	\N	\N	\N	\N
281	289	44906	ام سكوير المعادى الهندسيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2808	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ام سكوير المعادى الهندسيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
282	290	44907	ام سكوير موكب تريو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2809	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ام سكوير موكب تريو	\N	\N	\N	\N	\N	\N	\N	\N	\N
284	292	44909	ام سكوير كرفان تريو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2811	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ام سكوير كرفان تريو	\N	\N	\N	\N	\N	\N	\N	\N	\N
285	293	44910	جذور المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2812	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور المعادى	\N	\N	\N	\N	\N	\N	\N	\N	\N
286	294	44911	جذور سانت فاتيما	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2813	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور سانت فاتيما	\N	\N	\N	\N	\N	\N	\N	\N	\N
287	229	44912	جذور مستقبل سيتى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2814	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور مستقبل سيتى	\N	\N	\N	\N	\N	\N	\N	\N	\N
288	245	44913	جذور  مخزن اوديسنت	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2815	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور  مخزن اوديسنت	\N	\N	\N	\N	\N	\N	\N	\N	\N
289	295	44914	جامعه البادية	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2816	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جامعه البادية	\N	\N	\N	\N	\N	\N	\N	\N	\N
290	296	44915	محمد فتحى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2817	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	محمد فتحى	\N	\N	\N	\N	\N	\N	\N	\N	\N
291	297	44916	شركه مكه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2818	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه مكه	\N	\N	\N	\N	\N	\N	\N	\N	\N
293	299	44918	شركة اللبنانيه السويسريه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2820	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركة اللبنانيه السويسريه	\N	\N	\N	\N	\N	\N	\N	\N	\N
294	161	44919	يوروتولز	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2821	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	يوروتولز	\N	\N	\N	\N	\N	\N	\N	\N	\N
108	133	44733	فلاى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2635	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	فلاى	\N	\N	\N	\N	\N	\N	\N	\N	\N
111	137	44736	الاصيل للمواد الغذائيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2638	1	\N	2025-01-15 08:41:36	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الاصيل للمواد الغذائيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
124	152	44749	المعادى تربو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2651	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	المعادى تربو	\N	\N	\N	\N	\N	\N	\N	\N	\N
129	158	44754	المستقبل	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2656	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	المستقبل	\N	\N	\N	\N	\N	\N	\N	\N	\N
132	162	44757	هانى سعد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2659	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	هانى سعد	\N	\N	\N	\N	\N	\N	\N	\N	\N
135	166	44760	الفيومى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2662	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الفيومى	\N	\N	\N	\N	\N	\N	\N	\N	\N
141	173	44766	بن الحبشى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2668	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بن الحبشى	\N	\N	\N	\N	\N	\N	\N	\N	\N
146	179	44771	نيوم للتنميه  اركان	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2673	1	\N	2025-01-15 08:41:37	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	نيوم للتنميه  اركان	\N	\N	\N	\N	\N	\N	\N	\N	\N
156	189	44781	بترومين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2683	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بترومين	\N	\N	\N	\N	\N	\N	\N	\N	\N
162	196	44787	عواد نسكافيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2689	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	عواد نسكافيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
168	203	44793	الشركه الرباعيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2695	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	الشركه الرباعيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
174	210	44799	دى ام سى  احمد ورشه الصيانه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2701	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى  احمد ورشه الصيانه	\N	\N	\N	\N	\N	\N	\N	\N	\N
183	220	44808	دى ام سى مخزن الوفاء والامل	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2710	1	\N	2025-01-15 08:41:38	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	دى ام سى مخزن الوفاء والامل	\N	\N	\N	\N	\N	\N	\N	\N	\N
195	239	44820	جى ام سى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2722	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى	\N	\N	\N	\N	\N	\N	\N	\N	\N
197	241	44822	اوتو موبيلتى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2724	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اوتو موبيلتى	\N	\N	\N	\N	\N	\N	\N	\N	\N
204	40	44829	مشتريات القصر العيني	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2731	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مشتريات القصر العيني	\N	\N	\N	\N	\N	\N	\N	\N	\N
212	63	44837	اولاد رجب للادوات الصحيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2739	1	\N	2025-01-15 08:41:39	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اولاد رجب للادوات الصحيه	\N	\N	\N	\N	\N	\N	\N	\N	\N
222	134	44847	اولاد ابو على	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2749	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	اولاد ابو على	\N	\N	\N	\N	\N	\N	\N	\N	\N
228	178	44853	نيوم للتنميه السياحيه الماظه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2755	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	نيوم للتنميه السياحيه الماظه	\N	\N	\N	\N	\N	\N	\N	\N	\N
239	251	44864	شركه المزارعون العرب	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2766	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه المزارعون العرب	\N	\N	\N	\N	\N	\N	\N	\N	\N
245	257	44870	جى ام سى مستلزمات بوفيه الاداره	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2772	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى مستلزمات بوفيه الاداره	\N	\N	\N	\N	\N	\N	\N	\N	\N
253	247	44878	جذور مستقبل اكتوبر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2780	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جذور مستقبل اكتوبر	\N	\N	\N	\N	\N	\N	\N	\N	\N
255	263	44880	جى ام سى ايمن ابو الفتوح	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2782	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى ايمن ابو الفتوح	\N	\N	\N	\N	\N	\N	\N	\N	\N
264	272	44889	جى ام سى الغفير +2 عمال بالمصنع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2791	1	\N	2025-01-15 08:41:40	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جى ام سى الغفير +2 عمال بالمصنع	\N	\N	\N	\N	\N	\N	\N	\N	\N
277	285	44902	بود ايجبت   المطار	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2804	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	بود ايجبت   المطار	\N	\N	\N	\N	\N	\N	\N	\N	\N
283	291	44908	ام سكوير المعادى الضيافه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2810	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ام سكوير المعادى الضيافه	\N	\N	\N	\N	\N	\N	\N	\N	\N
292	298	44917	شركة النيل التطوير العقارى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	38	\N	\N	\N	2819	1	\N	2025-01-15 08:41:41	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركة النيل التطوير العقارى	\N	\N	\N	\N	\N	\N	\N	\N	\N
295	162	2025-01-20	fly in	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	44	8	7	5	2897	63	2025-01-20 16:05:23	2025-01-20 16:05:23	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	fly in	\N	\N	\N	\N	\N	\N	\N	\N	30
105	117	\N	SGS سفاجا	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	\N	7	\N	2632	59	\N	2025-01-23 11:22:51	\N	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	\N	\N	\N	\N	SGS سفاجا	\N	\N	\N	\N	\N	\N	\N	\N	\N
296	163	2025-01-23	جذور التجمع الثالث	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2900	59	2025-01-23 12:52:19	2025-01-23 12:52:19	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	\N	2	\N	\N	جذور التجمع الثالث	\N	\N	\N	\N	\N	\N	\N	\N	30
297	164	2025-01-23	جذور مستبل سيتى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2901	59	2025-01-23 12:53:21	2025-01-23 12:53:21	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	\N	2	\N	\N	جذور مستبل سيتى	\N	\N	\N	\N	\N	\N	\N	\N	30
298	165	2025-01-23	جزور الطريق الدائرى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2902	59	2025-01-23 12:53:57	2025-01-23 12:53:57	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	\N	2	\N	\N	جزور الطريق الدائرى	\N	\N	\N	\N	\N	\N	\N	\N	30
299	166	2025-01-23	جذور الشروق	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2903	59	2025-01-23 12:54:35	2025-01-23 12:54:35	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	\N	2	\N	\N	جذور الشروق	\N	\N	\N	\N	\N	\N	\N	\N	30
300	167	2025-01-23	جذور الابراج الصنيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2904	59	2025-01-23 12:55:05	2025-01-23 12:55:05	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	\N	2	\N	\N	جذور الابراج الصنيه	\N	\N	\N	\N	\N	\N	\N	\N	30
301	168	2025-01-23	جذور اكتوبر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2905	59	2025-01-23 12:55:30	2025-01-23 12:55:30	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	\N	2	\N	\N	جذور اكتوبر	\N	\N	\N	\N	\N	\N	\N	\N	30
302	169	2025-01-23	ام سكوير  المصيف	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2906	59	2025-01-23 12:56:22	2025-01-23 12:56:22	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	\N	2	\N	\N	ام سكوير  المصيف	\N	\N	\N	\N	\N	\N	\N	\N	30
303	170	2025-01-23	ام سكوير كرفان تريو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2907	59	2025-01-23 12:56:55	2025-01-23 12:56:55	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	\N	2	\N	\N	ام سكوير كرفان تريو	\N	\N	\N	\N	\N	\N	\N	\N	30
304	171	2025-01-23	ام سكوير ضيافه المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2908	59	2025-01-23 12:57:29	2025-01-23 12:57:29	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	\N	2	\N	\N	ام سكوير ضيافه المعادى	\N	\N	\N	\N	\N	\N	\N	\N	30
305	172	2025-01-23	ام ام سكوير موكب تريو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2909	59	2025-01-23 12:58:13	2025-01-23 12:58:13	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	\N	2	\N	\N	ام ام سكوير موكب تريو	\N	\N	\N	\N	\N	\N	\N	\N	30
306	173	2025-01-23	ام سكوير المعادى الهندسيه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2910	59	2025-01-23 12:58:50	2025-01-23 12:58:50	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	\N	2	\N	\N	ام سكوير المعادى الهندسيه	\N	\N	\N	\N	\N	\N	\N	\N	30
307	174	2025-01-23	ام سكوير  المهندسين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2911	59	2025-01-23 12:59:51	2025-01-23 12:59:51	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	\N	2	\N	\N	ام سكوير  المهندسين	\N	\N	\N	\N	\N	\N	\N	\N	30
308	175	2025-01-23	جى ام سى الغفراء الاسبوع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2912	59	2025-01-23 13:01:02	2025-01-23 13:01:02	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى الغفراء الاسبوع	\N	\N	\N	\N	\N	\N	\N	\N	30
309	176	2025-01-23	جى ام سى الغراء ال 14	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2913	59	2025-01-23 13:01:46	2025-01-23 13:01:46	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى الغراء ال 14	\N	\N	\N	\N	\N	\N	\N	\N	30
310	177	2025-01-23	جى ام سى اداره رقم 1	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2914	59	2025-01-23 13:02:16	2025-01-23 13:02:16	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى اداره رقم 1	\N	\N	\N	\N	\N	\N	\N	\N	30
311	178	2025-01-23	جى ام سى اداره 2	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2915	59	2025-01-23 13:02:38	2025-01-23 13:02:38	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى اداره 2	\N	\N	\N	\N	\N	\N	\N	\N	30
312	179	2025-01-23	جى ام سى اداره رقم 5	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2916	59	2025-01-23 13:03:10	2025-01-23 13:03:10	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى اداره رقم 5	\N	\N	\N	\N	\N	\N	\N	\N	30
313	180	2025-01-23	جى ام سى الرحاب	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2917	59	2025-01-23 13:03:34	2025-01-23 13:03:34	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى الرحاب	\N	\N	\N	\N	\N	\N	\N	\N	30
314	181	2025-01-23	جى ام سى المخزن العام	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2918	59	2025-01-23 13:04:05	2025-01-23 13:04:05	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى المخزن العام	\N	\N	\N	\N	\N	\N	\N	\N	30
315	182	2025-01-23	جى ام سى مستلزمات بوفيه الاداره	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2919	59	2025-01-23 13:04:29	2025-01-23 13:04:29	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى مستلزمات بوفيه الاداره	\N	\N	\N	\N	\N	\N	\N	\N	30
316	183	2025-01-23	جى ام سى ايمن ابو الفتوح	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2920	59	2025-01-23 13:05:00	2025-01-23 13:05:00	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى ايمن ابو الفتوح	\N	\N	\N	\N	\N	\N	\N	\N	30
317	184	2025-01-23	جى ام سى فنين مصنع العاشر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2921	59	2025-01-23 13:05:34	2025-01-23 13:05:34	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى فنين مصنع العاشر	\N	\N	\N	\N	\N	\N	\N	\N	30
318	185	2025-01-23	جى ام سى سجا 2 مهندسين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2922	59	2025-01-23 13:07:41	2025-01-23 13:07:41	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى سجا 2 مهندسين	\N	\N	\N	\N	\N	\N	\N	\N	30
319	186	2025-01-23	جى ام سى  مشروع الرحاب	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2923	59	2025-01-23 13:08:21	2025-01-23 13:08:21	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى  مشروع الرحاب	\N	\N	\N	\N	\N	\N	\N	\N	30
320	187	2025-01-23	جى ام سى اداره رقم 4	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2924	59	2025-01-23 13:08:52	2025-01-23 13:08:52	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى اداره رقم 4	\N	\N	\N	\N	\N	\N	\N	\N	30
321	188	2025-01-23	جى ام سى احمد رشاد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2925	59	2025-01-23 13:09:19	2025-01-23 13:09:19	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى احمد رشاد	\N	\N	\N	\N	\N	\N	\N	\N	30
322	189	2025-01-23	جى ام سى سجا 2	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2926	59	2025-01-23 13:10:12	2025-01-23 13:10:12	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى سجا 2	\N	\N	\N	\N	\N	\N	\N	\N	30
323	190	2025-01-23	جى ام سى غفير +2 عمال	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2927	59	2025-01-23 13:10:47	2025-01-23 13:10:47	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى غفير +2 عمال	\N	\N	\N	\N	\N	\N	\N	\N	30
324	191	2025-01-23	جى ام سى موقع الوفاء والامل	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2928	59	2025-01-23 13:11:22	2025-01-23 13:11:22	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى موقع الوفاء والامل	\N	\N	\N	\N	\N	\N	\N	\N	30
325	192	2025-01-23	جى ام سى  الاستشارى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2929	59	2025-01-23 13:12:04	2025-01-23 13:12:04	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى  الاستشارى	\N	\N	\N	\N	\N	\N	\N	\N	30
326	193	2025-01-23	جى ام سى غفير زيزنيا	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2930	59	2025-01-23 13:12:54	2025-01-23 13:12:54	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى غفير زيزنيا	\N	\N	\N	\N	\N	\N	\N	\N	30
327	194	2025-01-23	جى ام سى اداره 5	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2932	59	2025-01-23 16:17:18	2025-01-23 16:17:18	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى اداره 5	\N	\N	\N	\N	\N	\N	\N	\N	30
328	195	2025-01-23	شركه فريندز	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2933	63	2025-01-23 17:31:33	2025-01-23 17:31:33	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه فريندز	\N	\N	\N	\N	\N	\N	\N	\N	\N
329	196	2025-01-23	جى ام سى غفير +2 عمال	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2934	59	2025-01-23 17:58:31	2025-01-23 17:58:31	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى غفير +2 عمال	\N	\N	\N	\N	\N	\N	\N	\N	30
330	197	2025-01-23	جى ام سى لعدد 14 غفير	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2935	59	2025-01-23 18:04:31	2025-01-23 18:04:31	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى لعدد 14 غفير	\N	\N	\N	\N	\N	\N	\N	\N	30
331	198	2025-01-23	جى ام سى اداره رقم 1	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2936	59	2025-01-23 18:18:34	2025-01-23 18:18:34	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى اداره رقم 1	\N	\N	\N	\N	\N	\N	\N	\N	30
332	199	2025-01-26	شركة فيكينج ريفر	1	01284082076	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2937	63	2025-01-26 14:15:08	2025-01-26 14:15:08	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركة فيكينج ريفر	\N	\N	\N	\N	\N	\N	\N	\N	\N
333	200	2025-01-26	ارسليو ميتال	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	2939	59	2025-01-26 17:35:54	2025-01-26 17:35:54	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ارسليو ميتال	\N	\N	\N	\N	\N	\N	\N	\N	\N
334	201	2025-01-26	ام سكوير التجمع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2940	59	2025-01-26 17:59:32	2025-01-26 17:59:32	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	\N	2	\N	\N	ام سكوير التجمع	\N	\N	\N	\N	\N	\N	\N	\N	30
335	202	2025-01-26	جذور الطريق الدائرى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2941	59	2025-01-26 18:06:37	2025-01-26 18:06:37	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	\N	2	\N	\N	جذور الطريق الدائرى	\N	\N	\N	\N	\N	\N	\N	\N	30
336	203	2025-01-26	جى ام سى  الغفير +2 عمال	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2942	59	2025-01-26 18:19:08	2025-01-26 18:19:08	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى  الغفير +2 عمال	\N	\N	\N	\N	\N	\N	\N	\N	30
337	204	2025-01-27	مكتب المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	2943	59	2025-01-27 11:46:06	2025-01-27 11:46:06	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	مكتب المعادى	\N	\N	\N	\N	\N	\N	\N	\N	\N
338	205	2025-01-27	SGS المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2944	59	2025-01-27 13:41:12	2025-01-27 13:41:12	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	\N	2	\N	\N	SGS المعادى	\N	\N	\N	\N	\N	\N	\N	\N	30
339	206	2025-01-27	sgs دمياط	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2945	59	2025-01-27 13:41:38	2025-01-27 13:41:38	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	\N	2	\N	\N	sgs دمياط	\N	\N	\N	\N	\N	\N	\N	\N	30
340	207	2025-01-27	sgs  اسكندريه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2946	59	2025-01-27 13:42:19	2025-01-27 13:42:19	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	\N	2	\N	\N	sgs  اسكندريه	\N	\N	\N	\N	\N	\N	\N	\N	30
341	208	2025-01-27	sgs  السويس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2947	59	2025-01-27 13:43:24	2025-01-27 13:43:24	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	\N	2	\N	\N	sgs  السويس	\N	\N	\N	\N	\N	\N	\N	\N	30
342	209	2025-01-27	SGS المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2948	59	2025-01-27 13:46:48	2025-01-27 13:46:48	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	\N	2	\N	\N	SGS المعادى	\N	\N	\N	\N	\N	\N	\N	\N	30
343	210	2025-01-27	SGS المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	2949	59	2025-01-27 13:48:44	2025-01-27 13:48:44	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	SGS المعادى	\N	\N	\N	\N	\N	\N	\N	\N	\N
344	211	2025-01-27	Dart Caffe	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	44	8	7	5	2950	63	2025-01-27 14:56:04	2025-01-27 14:56:04	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	Dart Caffe	\N	\N	\N	\N	\N	\N	\N	\N	30
345	212	2025-01-27	جامعه الباديه	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	44	8	7	5	2951	63	2025-01-27 19:18:35	2025-01-27 19:18:35	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	\N	2	\N	\N	جامعه الباديه	\N	\N	\N	\N	\N	\N	\N	\N	30
346	213	2025-01-28	ام سكوير الشيخ زايد	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2952	59	2025-01-28 14:49:52	2025-01-28 14:49:52	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	\N	2	\N	\N	ام سكوير الشيخ زايد	\N	\N	\N	\N	\N	\N	\N	\N	30
347	214	2025-01-30	شركة العشرى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2955	63	2025-01-30 10:22:06	2025-01-30 10:22:06	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركة العشرى	\N	\N	\N	\N	\N	\N	\N	\N	\N
348	215	2025-01-30	شركة العشرى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2956	63	2025-01-30 10:22:06	2025-01-30 10:22:06	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركة العشرى	\N	\N	\N	\N	\N	\N	\N	\N	\N
349	216	2025-02-02	شركه بيكو	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2957	63	2025-02-02 11:32:03	2025-02-02 11:32:03	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه بيكو	\N	\N	\N	\N	\N	\N	\N	\N	\N
350	217	2025-02-04	جى ام سى الغفراء الاسبوع	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2958	59	2025-02-04 19:25:38	2025-02-04 19:25:38	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	\N	2	\N	\N	جى ام سى الغفراء الاسبوع	\N	\N	\N	\N	\N	\N	\N	\N	30
351	218	2025-02-09	جي  ام سي  الغفير الاسبوعي	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	2960	1	2025-02-09 14:04:43	2025-02-09 14:04:43	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	جي  ام سي  الغفير الاسبوعي	\N	\N	\N	\N	\N	\N	\N	\N	\N
352	219	2025-02-11	Podeygpt  المطار	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2961	63	2025-02-11 15:54:53	2025-02-11 15:54:53	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	Podeygpt  المطار	\N	\N	\N	\N	\N	\N	\N	\N	\N
353	220	2025-02-11	يونى كلين	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2962	63	2025-02-11 16:48:31	2025-02-11 16:48:31	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	يونى كلين	\N	\N	\N	\N	\N	\N	\N	\N	\N
354	221	2025-02-11	شركه فارس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2963	63	2025-02-11 16:56:22	2025-02-11 16:56:22	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه فارس	\N	\N	\N	\N	\N	\N	\N	\N	\N
355	222	2025-02-11	شركه سيستكس	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2964	63	2025-02-11 19:00:45	2025-02-11 19:00:45	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	شركه سيستكس	\N	\N	\N	\N	\N	\N	\N	\N	\N
356	223	2025-02-13	Cite podegypt	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	44	\N	\N	\N	2965	63	2025-02-13 16:54:57	2025-02-13 16:54:57	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	Cite podegypt	\N	\N	\N	\N	\N	\N	\N	\N	\N
357	224	2025-02-19	هشام درويش	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	2966	59	2025-02-19 17:29:02	2025-02-19 17:29:02	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	هشام درويش	\N	\N	\N	\N	\N	\N	\N	\N	\N
358	225	2025-02-20	بود ايجبت   المطار	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2968	59	2025-02-20 14:42:20	2025-02-20 14:42:20	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	7	\N	2	\N	\N	بود ايجبت   المطار	\N	\N	\N	\N	\N	\N	\N	\N	30
359	226	2025-02-20	بود ايجيبت اكتوبر	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2969	59	2025-02-20 14:42:59	2025-02-20 14:42:59	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	7	\N	2	\N	\N	بود ايجيبت اكتوبر	\N	\N	\N	\N	\N	\N	\N	\N	30
360	227	2025-02-20	SGS المعادى	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	potential_client	\N	\N	38	8	7	5	2970	59	2025-02-20 15:39:05	2025-02-20 15:39:05	8	\N	\N	\N	\N	\N	\N	P	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	\N	2	\N	\N	SGS المعادى	\N	\N	\N	\N	\N	\N	\N	\N	30
\.


--
-- Data for Name: customers_files; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.customers_files (id, "File", "Customer", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: customers_groups; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.customers_groups (id, "Arabic_Name", "English_Name", created_at, updated_at, "Discount") FROM stdin;
3	مجموعة عامة	General Group	\N	\N	0
4	مجموعة sgs	مجموعة sgs	2025-01-23 11:16:57	2025-01-23 11:16:57	0
5	مجموعه جى ام سى	مجموعه جى ام سى	2025-01-23 11:17:13	2025-01-23 11:17:13	0
6	مجموعه جذور	مجموعه جذور	2025-01-23 11:17:28	2025-01-23 11:17:28	0
7	مجموعه بود ايجبت	مجموعه بود ايجبت	2025-01-23 11:17:50	2025-01-23 11:17:50	0
8	مجموعه ام سكوير	مجموعه ام سكوير	2025-01-23 11:18:05	2025-01-23 11:18:05	0
9	مجموعه سكر مظبوط	مجموعه سكر مظبوط	2025-01-25 15:21:37	2025-01-25 15:21:37	0
\.


--
-- Data for Name: customers_rate_types; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.customers_rate_types (id, "Arabic_Name", "English_Name", "Color", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: customers_tickets; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.customers_tickets (id, "Code", "Problem", "Status", "Bill_Number", "Responsible", "Customer", "User", created_at, updated_at, "ProblemEn", arr) FROM stdin;
\.


--
-- Data for Name: deducations_types; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.deducations_types (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: deductions; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.deductions (id, "Code", "Date", "Month", "Amount", "Draw", "Note", "Emp", "Coin", "Type", "User", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: default_data_show_hides; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.default_data_show_hides (id, "Status", "Shipping_Company", "Vendor_Date", "Expire_Date", "Total_BF_Taxes", "Total_Taxes", "Coin", "Draw", "Delegate_Sale", "Delegate_Purchase", "Note", "Refrence_Number", created_at, updated_at, "Cost_Center", "Branch", "Serial_Num", "Pass", "Pattern_Image", "Barcode_Print", "Unit_Print", "Total_BF_Print", "Discount_Print", "Tax_Print", "A5", "A4", "CM8", "Group_Brand", "Patch_Number", "Manufacturing_Model_Shortcomings", "Search_Typical", "Validity_Product", "Executor_Sale", "Totuch_Screen", "Tax_POS", "TotalDiscountPrint", "TotalTaxPrint", "ProductsNumber", "TotalQtyPrint", "Credit", "Barcode", "Taknet", "Address", "Phone1", "Phone2", "Phone3", "Phone4", "Text", "Seal", "Code_Report", "Unit", "Refrence_Number_Print", "Icon_Payment_Recipt", "SearchCode", "TaxOnTotal", "TotalBfTax", "AvQty", "Disc", "Tax", "Store", "TaxBill", "Change_Way_Stores_Transfer", "Note_POS", "Open_Drawer", client_delivery, "POS_RecivedDate", "POS_Barcode", "POS_Qty", "Show_File_InsurancePaper", "Show_File_Checks", "Show_File_Purchases", "Show_File_Sales", "Show_File_PaymentVoucher", "Show_File_ReciptVoucher", "Show_File_TransferStores", "Thickness_Print", "Height_Print", "Thickness", "Height", "Items_Guide_Store_Show", "Sales_Pro_Desc", "Show_Barcode", "Show_Net", "Show_Unit", "Show_Total") FROM stdin;
1	1	0	1	0	0	0	0	0	0	1	0	0	2021-12-07 14:08:32	2025-02-05 11:55:13	0	0	1	0	0	0	1	0	1	0	0	1	1	1	0	1	0	1	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	1	1	1	1	1	1	0	0	0	0	0	0	1	0	0	0	0	0	1	0	0	0	0	0	0	0	0	1	1	1	1	1
\.


--
-- Data for Name: depaarture_policy_emps; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.depaarture_policy_emps (id, "From", "To", "Discount", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: departure_emps; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.departure_emps (id, "In_Time", "Out_Time", "Hours_Number", "Date", "Month", "Note", "Departure", "Emp", created_at, updated_at, "Disc_Late", "Disc_Early") FROM stdin;
7	22:20	23:21	1.0166666666666693	2025-01-18	2025-01	\N	2	48	2025-01-18 17:21:36	2025-01-18 17:21:36	0	0
\.


--
-- Data for Name: departures; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.departures (id, "Code", "Date", "Month", "Note", "Attend", "User", arr, created_at, updated_at) FROM stdin;
2	1	2025-01-18	2025-01	\N	3	59	\N	\N	\N
\.


--
-- Data for Name: desvice_cases; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.desvice_cases (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
3	جديد	New	2022-02-18 01:21:48	2024-02-09 01:04:51
\.


--
-- Data for Name: device_descrips; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.device_descrips (id, "Arabic_Name", "English_Name", "Sort", created_at, updated_at) FROM stdin;
8	جديد	New	0	2022-04-13 02:50:50	2022-04-13 02:50:50
9	مستعمل	Used	1	2022-06-20 21:54:53	2022-06-20 21:54:53
\.


--
-- Data for Name: devices_typesies; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.devices_typesies (id, "Arabic_Name", "English_Name", "Company", created_at, updated_at) FROM stdin;
6	Oppo	Oppo	14	2022-04-13 02:50:40	2022-04-13 02:50:40
\.


--
-- Data for Name: disclaimers; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.disclaimers (id, "Date", "File", "Emp", "Note", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: discounts_emps; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.discounts_emps (id, "AmountDiscount", "Discount", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: domains; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.domains (id, domain, tenant_id, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_covenants; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emp_covenants (id, "Emp", "Date", "Name", "Price", "Reason", "Life_Expectancy", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_excs; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emp_excs (id, "Name", "Account", "Emp_Type", "Salary", "Phone", "Job", "Department", "Store1", "Store2", "Store3", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_installment_details; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emp_installment_details (id, "Date", "Value", "Status", "Emp", "Install", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_installments; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emp_installments (id, "Amount", "Years_Number", "First_Date", "Install", "Install_Numbers", "Status", "Emp", "Loan", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_mails; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emp_mails (id, "Message", "Emp", "Status", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emp_p_o_s_stores; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emp_p_o_s_stores (id, "Emp", created_at, updated_at, "Store") FROM stdin;
19	38	2024-02-08 23:54:43	2024-02-08 23:54:43	21
20	39	2024-02-08 23:55:02	2024-02-08 23:55:02	21
21	40	2024-02-08 23:56:24	2024-02-08 23:56:24	21
22	41	2024-02-08 23:57:46	2024-02-08 23:57:46	21
23	42	2024-02-08 23:58:21	2024-02-08 23:58:21	21
34	53	2025-01-16 19:56:45	2025-01-16 19:56:45	21
36	55	2025-01-16 20:12:08	2025-01-16 20:12:08	21
37	52	2025-01-17 19:23:05	2025-01-17 19:23:05	21
38	56	2025-01-18 17:42:51	2025-01-18 17:42:51	21
39	57	2025-01-18 17:44:25	2025-01-18 17:44:25	21
40	58	2025-01-18 17:45:33	2025-01-18 17:45:33	21
41	49	2025-01-23 19:19:08	2025-01-23 19:19:08	21
42	50	2025-01-23 19:20:27	2025-01-23 19:20:27	21
43	51	2025-01-23 19:21:14	2025-01-23 19:21:14	21
44	47	2025-01-25 12:51:56	2025-01-25 12:51:56	21
46	48	2025-01-25 12:53:00	2025-01-25 12:53:00	21
47	46	2025-01-25 12:53:35	2025-01-25 12:53:35	21
48	45	2025-01-25 12:53:58	2025-01-25 12:53:58	21
49	44	2025-01-25 12:54:28	2025-01-25 12:54:28	21
50	54	2025-01-25 12:55:22	2025-01-25 12:55:22	21
\.


--
-- Data for Name: emp_ratios; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emp_ratios (id, "From", "To", "Salary", "Rate", "Type", "Emp", created_at, updated_at, "Typee") FROM stdin;
\.


--
-- Data for Name: emp_safes; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emp_safes (id, "Safe", "Emp", created_at, updated_at) FROM stdin;
11	2865	53	2025-01-16 19:56:45	2025-01-16 19:56:45
13	30	55	2025-01-16 20:12:08	2025-01-16 20:12:08
14	2864	52	2025-01-17 19:23:05	2025-01-17 19:23:05
15	2882	56	2025-01-18 17:42:51	2025-01-18 17:42:51
16	2883	57	2025-01-18 17:44:25	2025-01-18 17:44:25
17	2884	58	2025-01-18 17:45:33	2025-01-18 17:45:33
18	30	49	2025-01-23 19:19:08	2025-01-23 19:19:08
19	30	50	2025-01-23 19:20:27	2025-01-23 19:20:27
20	30	51	2025-01-23 19:21:14	2025-01-23 19:21:14
21	2827	47	2025-01-25 12:51:56	2025-01-25 12:51:56
23	2826	48	2025-01-25 12:53:00	2025-01-25 12:53:00
24	2824	46	2025-01-25 12:53:35	2025-01-25 12:53:35
25	2825	45	2025-01-25 12:53:58	2025-01-25 12:53:58
26	2823	44	2025-01-25 12:54:28	2025-01-25 12:54:28
27	30	54	2025-01-25 12:55:22	2025-01-25 12:55:22
28	2822	43	2025-02-19 18:30:26	2025-02-19 18:30:26
\.


--
-- Data for Name: empassies; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.empassies (id, "Arabic_Name", "English_Name", "Arabic_Address", "English_Address", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: empassy_reserve_dates; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.empassy_reserve_dates (id, "Code", "Date", "Client", "Purpose", "Empassy", "Booking_Date", "Cost", "Pay", "Residual", "Safe", "Draw", "Coin", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: employesses; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.employesses (id, "Code", "Name", "Emp_Type", "Salary", "Attendence", "Departure", "Hours_Numbers", "Days_Numbers", "Day_Price", "Precentage_of_Sales", "Precentage_of_Profits", "Image", "Bank_Account", "Qualifications", "Address", "Social_Status", "ID_Number", "Contract_Start", "Contract_End", "Phone", "Phone2", "Email", "Password", "Job", "Department", "Account", "Account_Emp", "User", created_at, updated_at, "Note", "Precentage_of_Execution", "Covenant", "Commission", "Price_Level", "Bill_Num", "NumbersOfBill", "EmpSort", "CV", "ID_Image", "Criminal_status", "Contract", health_certificate, "Search_Card", "Recruitment_certificate", employee_profile, duration_criminal_investigation, "Birthdate", "Attitude_recruiting", "Job_Number", date_resignation, "Living", "Branch", "Level", "Religion", "Insurance_salary", "Insurance_companies", "Previous_experience", "Nationality", "MonthlyTarget", "QuarterTarget", "SemiTarget", "YearlyTarget", "IDExpireDate", "LicensExpireDate", "PassportExpireDate", "Merit", "Pro_Group", "NameEn", arr, "SearchCode", "Active", "Delete") FROM stdin;
38	5	مندوب مبيعات افتراضي	Saller	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	6	53	2502	11	2024-02-08 23:52:53	2024-02-08 23:54:43	\N	\N	2504	2503	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2505	\N	Default Sales	\N	\N	1	0
39	6	مندوب مشتريات افتراضي	Buyer	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2506	11	2024-02-08 23:54:06	2024-02-08 23:55:02	\N	\N	2508	2507	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2509	\N	Default Purchaser	\N	\N	1	0
40	7	مهندس افتراضي	Engineer	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	7	26	53	2510	11	2024-02-08 23:56:24	2024-02-08 23:56:24	\N	\N	2512	2511	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2513	\N	Default Eng	\N	\N	1	0
41	8	مندوب توصيل افتراضي	Delivery	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	21	53	2514	11	2024-02-08 23:57:46	2024-02-08 23:57:46	\N	\N	2516	2515	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2517	\N	Default Delivery	\N	\N	1	0
42	9	نادل افتراضي	Waiter	1	09:00:00	17:00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	21	53	2518	11	2024-02-08 23:58:21	2024-02-08 23:58:21	\N	\N	2520	2519	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2521	\N	Default Waiter	\N	\N	1	0
53	11	ولاء	Buyer	10000	00:00	00:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	6	53	2870	1	2025-01-16 19:56:45	2025-01-16 19:56:45	\N	\N	2872	2871	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2873	\N	ولاء	\N	\N	1	0
55	13	رقية	Worker	4000	09:00:00	09:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	6	53	2878	1	2025-01-16 20:12:08	2025-01-16 20:12:08	\N	\N	2880	2879	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2881	\N	رقية	\N	\N	1	0
52	10	ندي هاشم	Buyer	5000	00:00	12:01	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	4	6	53	2866	59	2025-01-16 19:55:35	2025-01-17 19:23:05	\N	\N	2868	2867	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2869	\N	ندي هاشم	\N	\N	1	0
56	14	زين	Cashier	6000	09:00:00	21:00	312	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	10	6	53	2885	59	2025-01-18 17:42:51	2025-01-18 17:42:51	\N	\N	2887	2886	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2888	\N	زين	\N	\N	1	0
57	15	شعبان	Cashier	6000	21:00	09:00	312	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	10	6	53	2889	59	2025-01-18 17:44:25	2025-01-18 17:44:25	\N	\N	2891	2890	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2892	\N	شعبان	\N	\N	1	0
58	16	احمد	Supervisor	5000	00:00	12:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	11	6	53	2893	59	2025-01-18 17:45:33	2025-01-18 17:45:33	\N	\N	2895	2894	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2896	\N	احمد	\N	\N	1	0
49	7	ابوعلاء	Worker	3500	00:00	12:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	6	53	2852	59	2025-01-16 18:56:12	2025-01-23 19:19:08	\N	\N	2854	2853	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2855	\N	ابوعلاء	\N	\N	1	0
50	8	ام خالد	Worker	4000	00:00	12:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	6	53	2856	59	2025-01-16 18:56:52	2025-01-23 19:20:27	\N	\N	2858	2857	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2859	\N	ام خالد	\N	\N	1	0
51	9	ام كريمه	Worker	4000	00:00	12:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	6	6	53	2860	59	2025-01-16 18:57:38	2025-01-23 19:21:14	\N	\N	2862	2861	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2863	\N	ام كريمه	\N	\N	1	0
47	5	فاطمة عبد الوهاب	Manager	30000	00:00	12:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	5	6	53	2844	59	2025-01-16 18:53:10	2025-01-25 12:51:56	\N	\N	2846	2845	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2847	\N	فاطمة عبد الوهاب	\N	\N	1	0
48	6	رمضان	Manager	20000	00:00	12:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2848	59	2025-01-16 18:53:49	2025-01-25 12:53:00	\N	\N	2850	2849	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2851	\N	رمضان	\N	\N	1	0
46	4	اسماء	Manager	25000	00:00	12:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	8	6	53	2840	59	2025-01-16 18:52:08	2025-01-25 12:53:35	\N	\N	2842	2841	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2843	\N	اسماء	\N	\N	1	0
45	3	محمد عبد الوهاب	Manager	12000	00:00	12:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	6	53	2836	59	2025-01-16 18:51:37	2025-01-25 12:53:58	\N	\N	2838	2837	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2839	\N	محمد عبد الوهاب	\N	\N	1	0
44	2	ندى	Accountant	15000	12:00	12:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	3	6	53	2832	59	2025-01-16 18:27:53	2025-01-25 12:54:28	\N	\N	2834	2833	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2835	\N	ندى	\N	\N	1	0
54	12	ابراهيم	Driver	24000	09:00:00	09:00	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	9	6	53	2874	59	2025-01-16 20:10:58	2025-01-25 12:55:22	\N	\N	2876	2875	1	0	\N	1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1	1	1	1	\N	\N	\N	2877	\N	ابراهيم	\N	\N	1	0
\.


--
-- Data for Name: employment_levels; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.employment_levels (id, "Arabic_Name", "English_Name", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: emps_producation_points; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emps_producation_points (id, "Month", "Point", "Emp", created_at, updated_at, "Date") FROM stdin;
\.


--
-- Data for Name: emps_producation_quantities; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.emps_producation_quantities (id, "FromQ", "ToQ", "ValueQ", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: entitlements; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.entitlements (id, "Code", "Date", "Month", "Amount", "Draw", "Note", "Emp", "Coin", "Type", "User", arr, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: events; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.events (id, "Start_Date", "End_Date", "Event_Ar_Name", "Event_En_Name", "Type", "Type_ID", "Type_Code", "Emp", "Client", "Product", "Customer", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: examinations_types; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.examinations_types (id, "Name", "Allow_From", "Allow_To", "Unit", created_at, updated_at, "NameEn") FROM stdin;
\.


--
-- Data for Name: exchange_commissions; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.exchange_commissions (id, "Code", "Date", "Month", "Note", "Return_Maintaince", "Draw", "Amount", "Commision", "Pre_Sales", "Pre_Execu", "Safe", "Coin", "Cost_Center", "Emp", "User", arr, created_at, updated_at, "Total_Exchange_Commision", "Collection", "Delete") FROM stdin;
\.


--
-- Data for Name: execute_job_order_models; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.execute_job_order_models (id, "Model", "Qty", "Total_Cost", "Outcome", "Execute", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: execute_job_order_workmanships; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.execute_job_order_workmanships (id, "Product_Code", "P_Ar_Name", "P_En_Name", "Qty", "Price", "Discount", "TDiscount", "Tax", "Total_Bf_Tax", "Total_Tax", "Total", "Store", "Product", "Unit", "Execute", created_at, updated_at, "Total_Net") FROM stdin;
\.


--
-- Data for Name: execute_job_orders; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.execute_job_orders (id, "Code", "Date", "Note", "Client", "Executor", "Delegate", "RecivedDate", "Recipient", "Order", created_at, updated_at, "Transfer", "Edit", "Delete", "Edit_New_Code", "Current_Credit", "Model", "Status") FROM stdin;
\.


--
-- Data for Name: executing_receiving_secretariats; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.executing_receiving_secretariats (id, "Code", "Date", "Qty", "Total", "Model", "User", "Time", "Branch", "StoreIn", "StoreOut", "Client", arr, created_at, updated_at, "Total_Workmanship_Price") FROM stdin;
\.


--
-- Data for Name: executing_receivings; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.executing_receivings (id, "Code", "Date", "Qty", "Total", "Model", "User", created_at, updated_at, "Branch", "Time", "StoreIn", "StoreOut", "Sort", "Vendor", "Cost_Workmentship", "Total_Workmentship", arr) FROM stdin;
\.


--
-- Data for Name: executor_filters; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.executor_filters (id, "Product", "Code", "Name", "VName", "VVName", "V1", "V2", "Qty", "Price", "Total", "Emp", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: expenses_list_column_sechdules; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.expenses_list_column_sechdules (id, "Date", "Code_Type", "Statement", "Debitor", "Cost_Center", "Coin", "User", "Account", "Branch", created_at, updated_at) FROM stdin;
1	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	2022-10-17 22:05:11
\.


--
-- Data for Name: expenses_list_columns; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.expenses_list_columns (id, "Date", "Code_Type", "Statement", "Debitor", "Cost_Center", "Coin", "User", "Account", "Branch", created_at, updated_at) FROM stdin;
1	1	1	1	1	1	1	1	1	1	\N	2022-10-17 21:37:09
\.


--
-- Data for Name: expire_date_qties; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.expire_date_qties (id, "Qty", "P_Ar_Name", "P_En_Name", "P_Code", "PP_Code", "PPP_Code", "PPPP_Code", "V_Name", "VV_Name", "Store", "Unit", "Product", "V1", "V2", "Low_Unit", "Exp_Date", "Group", "Brand", "Branch", created_at, updated_at, "Hold_Qty") FROM stdin;
\.


--
-- Data for Name: export_checks; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.export_checks (id, "Code", "Date", "Draw", "Note", "Check_Num", "Due_Date", "Amount", "Status", "Reason", "Check_Type", "Coin", "Cost_Center", "Account", "Bank", "Pay_Account", "Bene_Account", "User", created_at, updated_at, "File", arr, "Image", "Signture_Name", "Bank_Branch", "Edit", "Edit_New_Code", "Delete", "BankSafe_Account", "Transfer") FROM stdin;
\.


--
-- Data for Name: f_a_q_s; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.f_a_q_s (id, "Arabic_Question", "English_Question", "Arabic_Answer", "English_Answer", created_at, updated_at) FROM stdin;
1	What is Lorem Ipsum?	What is Lorem Ipsum?	Nullam sed neque luctus, maximus diam sed, facilisis orci. Nunc ultricies neque a aliquam sollicitudin. Vivamus sit amet finibus sapien. Duis est dui, sodales nec pretium a, interdum in lacus. Sed et est vel velit vestibulum tincidunt non a felis. Phasellus convallis, diam eu facilisis tincidunt, ex nibh vulputate dolor, eu maximus massa libero vel eros. In vulputate metus lacus, eu vehicula dolor feugiat id. Nulla vitae nisl in ex consequat porttitor vel a lectus. Vestibulum viverra in velit ac consequat. Nullam porta nulla eu dignissim cursus.	Nullam sed neque luctus, maximus diam sed, facilisis orci. Nunc ultricies neque a aliquam sollicitudin. Vivamus sit amet finibus sapien. Duis est dui, sodales nec pretium a, interdum in lacus. Sed et est vel velit vestibulum tincidunt non a felis. Phasellus convallis, diam eu facilisis tincidunt, ex nibh vulputate dolor, eu maximus massa libero vel eros. In vulputate metus lacus, eu vehicula dolor feugiat id. Nulla vitae nisl in ex consequat porttitor vel a lectus. Vestibulum viverra in velit ac consequat. Nullam porta nulla eu dignissim cursus.	2022-06-04 19:39:45	2022-06-04 19:39:45
2	Why do we use it?	Why do we use it?	Cras non gravida urna. Ut venenatis nulla in tellus lobortis, vel mollis lectus condimentum. Duis elementum sapien purus, et sagittis nulla efficitur in. Phasellus vitae eros sed nisi fringilla auctor nec quis nunc. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque rutrum faucibus nibh vitae fermentum. Aliquam commodo sem sit amet malesuada consectetur. Ut sit amet vestibulum diam. Etiam quis dictum turpis, eget condimentum velit. Sed cursus odio dapibus, consectetur massa sit amet, fringilla purus.	Cras non gravida urna. Ut venenatis nulla in tellus lobortis, vel mollis lectus condimentum. Duis elementum sapien purus, et sagittis nulla efficitur in. Phasellus vitae eros sed nisi fringilla auctor nec quis nunc. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque rutrum faucibus nibh vitae fermentum. Aliquam commodo sem sit amet malesuada consectetur. Ut sit amet vestibulum diam. Etiam quis dictum turpis, eget condimentum velit. Sed cursus odio dapibus, consectetur massa sit amet, fringilla purus.	2022-06-04 19:40:14	2022-06-04 19:40:14
\.


--
-- Data for Name: failed_jobs; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.failed_jobs (id, uuid, connection, queue, payload, exception, failed_at) FROM stdin;
\.


--
-- Data for Name: faults_types; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.faults_types (id, "Arabic_Name", "English_Name", "Note", "Amount", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: fifo_qties; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.fifo_qties (id, "Qty", "P_Ar_Name", "P_En_Name", "P_Code", "PP_Code", "PPP_Code", "PPPP_Code", "V_Name", "VV_Name", "Cost_Price", "Store", "Unit", "Product", "V1", "V2", "Low_Unit", "Exp_Date", "SearchCode1", "SearchCode2", "Group", "Brand", "Branch", "Purchases_Date", created_at, updated_at, "Original_Qty", "Hold_Qty") FROM stdin;
\.


--
-- Data for Name: firewall_ips; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.firewall_ips (id, ip, log_id, blocked, created_at, updated_at, deleted_at) FROM stdin;
\.


--
-- Data for Name: firewall_logs; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.firewall_logs (id, ip, level, middleware, user_id, url, referrer, request, created_at, updated_at, deleted_at) FROM stdin;
1	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=Wh8VUBPPpctrwoHMRWnx1DvypLmxzN1uDIRM22YQ&valid_from=eyJpdiI6IktLMytNc0RnSDlXNC9GdDFndC81ckE9PSIsInZhbHVlIjoielhlUVNtU21YMGtzNE9NSEkrK3Q4dz09IiwibWFjIjoiMTJiMjY5MzIwMGM3YTY4YTEyOGMwOTIyOTM4ZDZkYWVhNzQwOGFmMzZiNDYxODNjMWZmODdlNGNjMWU0M2IzNSJ9&email=Admin@test.com&password=******	2022-02-08 09:54:21	2022-02-08 09:54:21	\N
2	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=mCKNd0b5SqhsbzCncHR1Zsg4pppOjFi3miWeyJTo&valid_from=eyJpdiI6IklFWlVxK2pZRCsyUHhZNHd2ZzBWUFE9PSIsInZhbHVlIjoibFQvN1dsb0lreTJFT2FSNHoydkRiQT09IiwibWFjIjoiMjNhODUxNWM3ZjUyZGRlZTAwNWUxMmQyZThjZTJjOWMyOGFhNDdiM2Q5MWI0MjI3ZWY4YTcwZThlODVjZDVlMSIsInRhZyI6IiJ9&email=Klar@test.com&password=******	2022-06-01 15:04:13	2022-06-01 15:04:13	\N
3	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/Login	http://localhost:8888/laravel/ERP/public/AdminLogin	_token=mCKNd0b5SqhsbzCncHR1Zsg4pppOjFi3miWeyJTo&valid_from=eyJpdiI6InJVNDBPK3J5QWRlcXJCdnc4cTNKc2c9PSIsInZhbHVlIjoiVnhMQUpZanRXdldjYVd1RTZVcDJCUT09IiwibWFjIjoiMTIyMjZmNWY3OTczZjVmMmUwNmViYjBiMTNiYzU0OTQzN2IwNzUyYjkxZGJhMTM1ZTE4OWYwNjJhNDI1MDAxYSIsInRhZyI6IiJ9&email=Klar@test.com&password=******	2022-06-01 15:04:26	2022-06-01 15:04:26	\N
4	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkgyZEx5V3BDUzBsa1pLcExjUjlhb0E9PSIsInZhbHVlIjoiTmF5UFh0a0lOYXhuS2ErY1h5Mzc4Zz09IiwibWFjIjoiMGQxYzYxMGEyMjlhMWM5NDJhODM2NmJmMDY2NTQ4ZDZjOTk4OTNhYzQyNmU1M2E1NTc0YmJmY2IxNzg3ZGViYyIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=<iframe src="https://www.google.com/maps/embed?pb=" height="350" allowfullscreen></iframe>	2022-06-04 15:25:25	2022-06-04 15:25:25	\N
5	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkFZZ280WjQ2anpsZ2ZrLy94R3BXYUE9PSIsInZhbHVlIjoiZnRtZjQwU0JWRGs4K2dndm5ZRlRpUT09IiwibWFjIjoiZjM3ZmFkMzUyNmZkYmRlNWVhOWUwZDdjNGM1ZDRmNjg4ZGZkYzQ4MzUyOGMzZTZjZDBjMjNiNjM4NjRmZTRiZSIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=<iframe src="https://www.google.com/maps/embed?pb=" height="350" allowfullscreen></iframe>	2022-06-04 15:25:53	2022-06-04 15:25:53	\N
6	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkFZZ280WjQ2anpsZ2ZrLy94R3BXYUE9PSIsInZhbHVlIjoiZnRtZjQwU0JWRGs4K2dndm5ZRlRpUT09IiwibWFjIjoiZjM3ZmFkMzUyNmZkYmRlNWVhOWUwZDdjNGM1ZDRmNjg4ZGZkYzQ4MzUyOGMzZTZjZDBjMjNiNjM4NjRmZTRiZSIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=https://www.google.com/maps/embed?pb=	2022-06-04 15:26:34	2022-06-04 15:26:34	\N
7	::1	medium	rfi	11	http://localhost:8888/laravel/ERP/public/ContactUSUpdate/1	http://localhost:8888/laravel/ERP/public/ContactUS	_token=cMggGWc3GiRQ9RpsUo0yM0WTatiVJrHf9VyvpkkA&valid_from=eyJpdiI6IkFZZ280WjQ2anpsZ2ZrLy94R3BXYUE9PSIsInZhbHVlIjoiZnRtZjQwU0JWRGs4K2dndm5ZRlRpUT09IiwibWFjIjoiZjM3ZmFkMzUyNmZkYmRlNWVhOWUwZDdjNGM1ZDRmNjg4ZGZkYzQ4MzUyOGMzZTZjZDBjMjNiNjM4NjRmZTRiZSIsInRhZyI6IiJ9&Arabic_Title=DROP US A LINE&English_Title=DROP US A LINE&Arabic_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&English_Desc=Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500&Opening_Hours=Mon - Sat : 9am - 11pm&Phone1=440000000&Phone2=440000000&Phone_Header=440000000&Email=sales@yousite.com&Arabic_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&English_Address=55 Gallaxy Enque, 2568 steet, 23568 NY&Map=https://www.google.com/maps/embed?pb=	2022-06-04 15:26:55	2022-06-04 15:26:55	\N
8	::1	medium	xss	11	http://localhost:8888/laravel/ERP/public/AddArticles	http://localhost:8888/laravel/ERP/public/Articles	_token=doVeFV3XD2rH8l1cPooyMAao9nq89yqum3PtXs41&valid_from=eyJpdiI6IlB6U25kQnRaUkZOTHJhOTJwNDIreXc9PSIsInZhbHVlIjoiS2QzTVJwd3paNXNiMUx3UDFGbDAzQT09IiwibWFjIjoiMWQ5NmQ3MThhODI1NDk0NzEyNWZiNTQxYmFlMzQyMTdmMGE0MThmODhkZDE1YmFjNjBkMTUyODBkNGI0YThiOCIsInRhZyI6IiJ9&Date=May 02, 2017&Arabic_Title=IT'S ALL ABOUT HOW YOU WEAR&English_Title=IT'S ALL ABOUT HOW YOU WEAR&Arabic_Desc=<h4 class="modal-title" style="color: rgb(102, 102, 102); letter-spacing: 0.1px;">On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. Sample Text Listing Donec et lacus mattis ipsum feugiat interdum non id sapien. Quisque et mauris eget nisi vestibulum rhoncus molestie a ante. Curabitur pulvinar ex at tempus sodales. Mauris efficitur magna quis lectus lobortis venenatis. Nunc id enim eget augue molestie lobortis in a purus. Donec maximus quam at lectus bibendum, non suscipit nunc tristique. The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</h4><button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin: -1.25rem; padding: 1.25rem;"><span aria-hidden="true"><span class="fal fa-times"></span></span></button>&English_Desc=<h4 class="modal-title" style="color: rgb(102, 102, 102); letter-spacing: 0.1px;">On sait depuis longtemps que travailler avec du texte lisible et contenant du sens est source de distractions, et empêche de se concentrer sur la mise en page elle-même. L'avantage du Lorem Ipsum sur un texte générique comme 'Du texte. Du texte. Du texte.' est qu'il possède une distribution de lettres plus ou moins normale, et en tout cas comparable avec celle du français standard. De nombreuses suites logicielles de. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum. Sample Text Listing Donec et lacus mattis ipsum feugiat interdum non id sapien. Quisque et mauris eget nisi vestibulum rhoncus molestie a ante. Curabitur pulvinar ex at tempus sodales. Mauris efficitur magna quis lectus lobortis venenatis. Nunc id enim eget augue molestie lobortis in a purus. Donec maximus quam at lectus bibendum, non suscipit nunc tristique. The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</h4><button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin: -1.25rem; padding: 1.25rem;"><span aria-hidden="true"><span class="fal fa-times"></span></span></button>	2022-06-06 20:02:03	2022-06-06 20:02:03	\N
9	::1	medium	xss	11	http://localhost:8888/laravel/ERP/public/UpdatePolices/2	http://localhost:8888/laravel/ERP/public/Polices	_token=doVeFV3XD2rH8l1cPooyMAao9nq89yqum3PtXs41&valid_from=eyJpdiI6Ik9LaHdHOXluQzBFMlNSWG5qcThncUE9PSIsInZhbHVlIjoicGxudDdPNi9sbThzNTEwYi9URGZCZz09IiwibWFjIjoiMTRhOWMzNmM4MjFjOGZjOTQ4MjU0MzZmNjc4MzliNGFkMzcyZmVhNzk4OTQ0MTgyNzcyZjYxMzhiODhlMGI2MCIsInRhZyI6IiJ9&Arabic_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>&English_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>	2022-06-06 22:22:15	2022-06-06 22:22:15	\N
10	::1	medium	xss	11	http://localhost:8888/laravel/ERP/public/UpdatePolices/2	http://localhost:8888/laravel/ERP/public/Polices	_token=doVeFV3XD2rH8l1cPooyMAao9nq89yqum3PtXs41&valid_from=eyJpdiI6IkIvaUJZMFBOUStFbXNJZHY5Mmd4dmc9PSIsInZhbHVlIjoickNFdURkM0ZneVlyV3MyZEtSUDc1dz09IiwibWFjIjoiMmFiNjc4OTIyZjM3NjY2M2U3M2U5ZjI3M2RhNWQ3NTQ3ZDZiOTE2ZDU4YzlkNWVmMDM2ZGJhODM1YWExMTQ5MyIsInRhZyI6IiJ9&Arabic_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>&English_Desc=<h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Returns Policy</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eros justo, accumsan non dui sit amet. Phasellus semper volutpat mi sed imperdiet. Ut odio lectus, vulputate non ex non, mattis sollicitudin purus. Mauris consequat justo a enim interdum, in consequat dolor accumsan. Nulla iaculis diam purus, ut vehicula leo efficitur at.</p><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Interdum et malesuada fames ac ante ipsum primis in faucibus. In blandit nunc enim, sit amet pharetra erat aliquet ac.</p><h4 style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 1.2; font-size: 13px; overflow-wrap: break-word; letter-spacing: normal; text-align: left; text-size-adjust: auto;">Shipping</h4><p style="font-family: &quot;IBM Plex Sans Arabic&quot;, sans-serif; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; color: rgb(85, 85, 85); letter-spacing: normal; text-align: left; text-size-adjust: auto;">Pellentesque ultrices ut sem sit amet lacinia. Sed nisi dui, ultrices ut turpis pulvinar. Sed fringilla ex eget lorem consectetur, consectetur blandit lacus varius. Duis vel scelerisque elit, et vestibulum metus. Integer sit amet tincidunt tortor. Ut lacinia ullamcorper massa, a fermentum arcu vehicula ut. Ut efficitur faucibus dui Nullam tristique dolor eget turpis consequat varius. Quisque a interdum augue. Nam ut nibh mauris.</p>	2022-06-06 22:22:27	2022-06-06 22:22:27	\N
11	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:05:21	2022-06-07 12:05:21	\N
12	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:18:58	2022-06-07 12:18:58	\N
13	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:27:07	2022-06-07 12:27:07	\N
14	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:43:03	2022-06-07 12:43:03	\N
15	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:43:39	2022-06-07 12:43:39	\N
16	::1	medium	login	0	http://localhost:8888/laravel/ERP/public/PostLoginSite	http://localhost:8888/laravel/ERP/public/LoginSite	_token=xBCZkelPEYieOfzSztHnCsRpprRAIrzVwqOEO7D9&Email=islamyousief353@gmail.com&Password=123456&password=******	2022-06-07 12:49:43	2022-06-07 12:49:43	\N
17	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=GLVdh1jacR3kqsCLRcqBhUKjoXHIJgQBLUdVEBe4&valid_from=eyJpdiI6IkVXc1BIYkRkTGVHcVRMTHk5VWdoOFE9PSIsInZhbHVlIjoiSUJ5eHJmREtqRjhwemhUZlprYUw4QT09IiwibWFjIjoiNTUwNzY5NGZkMmVkMmYxYjkyMGQ1N2Y1Mzk1OTNjM2ZjZTM2MGY5MjVhMmFmMmZiNjUyNDcxZWQ5YzA3MWNjNyIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:44:54	2025-01-15 16:44:54	\N
18	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=GLVdh1jacR3kqsCLRcqBhUKjoXHIJgQBLUdVEBe4&valid_from=eyJpdiI6IldDTWJrMktzeHlMWmI2Y0hDOEMxRmc9PSIsInZhbHVlIjoiUnk4Y3NuL0dxa3JmNXJiWjZDZm9xQT09IiwibWFjIjoiNTQ5NjFjYjk4YjQ5YjQyNmFjZDVkY2YwNzIwMTU2ZDRiZWVjNmE1Y2UzMGM2YjI0Zjk1ZDdhODUzMjZkMzZlMiIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:45:07	2025-01-15 16:45:07	\N
19	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=GLVdh1jacR3kqsCLRcqBhUKjoXHIJgQBLUdVEBe4&valid_from=eyJpdiI6ImtEaVdkS2JDa3dJblNLVnZyc2Fvenc9PSIsInZhbHVlIjoiZ21CNWxFMWJILzNXaVo5L1Z5Y1Zqdz09IiwibWFjIjoiMDAwMmFlMTExYjBkOTgxOWMxNmQyMDEyNzE5OGJiM2VkZTY3YWZmZmI3NWE3NTJlMzFhMWRmMjNmNDlkODVhOCIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:45:27	2025-01-15 16:45:27	\N
20	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=GLVdh1jacR3kqsCLRcqBhUKjoXHIJgQBLUdVEBe4&valid_from=eyJpdiI6InkrQUlEOGgvYUc5TkNFSmp2amE3b0E9PSIsInZhbHVlIjoiT2pjVmdHSy8yblMvcXVKSnlSMmM3dz09IiwibWFjIjoiMDQ5NjFhNGRmZDlkYmI4NjIyYTAxZDY0NDE3ZmQyNGQyNjAyMTYzM2E0OTU4YmRhMzBlNmJmMDAxNzQ5M2VjOCIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:45:50	2025-01-15 16:45:50	\N
21	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=GLVdh1jacR3kqsCLRcqBhUKjoXHIJgQBLUdVEBe4&valid_from=eyJpdiI6ImRCbXVBZ3laOGZZeWttY0traVVCQXc9PSIsInZhbHVlIjoiQ3BRWnBjdDdRLzYrdXdYdEh0NWs2QT09IiwibWFjIjoiMzlmMGFiOWE1NTA2Y2EyZDJmNWYwNjUwOWQwNmJlODA1ODk5ODRkMGJiMjUyNTBhMDI3NzFmYzg1MmJhYTM5ZSIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:46:25	2025-01-15 16:46:25	\N
22	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=GLVdh1jacR3kqsCLRcqBhUKjoXHIJgQBLUdVEBe4&valid_from=eyJpdiI6InFEcjA3Si80RUs0a0dNUkNxOUxtUlE9PSIsInZhbHVlIjoiUEJwTVFCc2hXaHlJWGh0MCt2V29hdz09IiwibWFjIjoiMDQ1MjYyMjJmZTE3YmFjM2FhZWE0YzQ5MGI0OGY1YWJmMWE0NGM4ODAzYTMyYjEwYTMyOTZjZTE0Y2FhMTFiZiIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:46:53	2025-01-15 16:46:53	\N
23	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=GLVdh1jacR3kqsCLRcqBhUKjoXHIJgQBLUdVEBe4&valid_from=eyJpdiI6InJ4aUxmVkFyQ1hPeHZ4UTkzSmQ2d0E9PSIsInZhbHVlIjoiZ2xRdmN0dnpKanJ0ZU1kZ0NpT2JFZz09IiwibWFjIjoiNmUwMDdiMzk1ZTljMWNkYWYwMzg3ZWQwZTQxMGRkMDdmODlmOGMyYWExZDZhODMzMzU3YWY1NjYyMTFmMWE0OSIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:47:27	2025-01-15 16:47:27	\N
24	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=GLVdh1jacR3kqsCLRcqBhUKjoXHIJgQBLUdVEBe4&valid_from=eyJpdiI6ImlZKzF1b2U2ZzIvVWNuUGVvR082M2c9PSIsInZhbHVlIjoiei9EcGVsMlVLMkFSbTdEd3dtWHlHUT09IiwibWFjIjoiYjBhMTdjODgwMDUyZDM1N2MwYzlhMzQ2N2FiYzQzODM4Y2ZjZmE5NDBkYWQ3YjJmNTBhNGE0MmVlZThmZDhlNyIsInRhZyI6IiJ9&email=nada@orient.com&password=******	2025-01-15 16:47:37	2025-01-15 16:47:37	\N
25	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=GLVdh1jacR3kqsCLRcqBhUKjoXHIJgQBLUdVEBe4&valid_from=eyJpdiI6IjQ5SHliVFR3ZUNQYnE4dHF3Z3NRVXc9PSIsInZhbHVlIjoiYzVHNWM3QzlaQ0ZmTUJyTWhnRXpHQT09IiwibWFjIjoiMmZmYWQ5Y2Y1ZWY0M2QxOTI2ZjJjYTgwMDNkNjQ3OGZmZDkzZjc2NDljMWNmNTBjOTEzZDFkODJmNDIwNzgwZCIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:49:41	2025-01-15 16:49:41	\N
26	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=AKZmOqBVL1ohpDMvFedieR9zuGPvL8foCqQRNDNe&valid_from=eyJpdiI6IkNGYk9QVWd6ay83TUZ2SjhLNzFzcGc9PSIsInZhbHVlIjoiV0pTYlA2dVZMVzZxbm53TjIyeCtwdz09IiwibWFjIjoiYzJlMDMyYmYyZmJhODIwOGVlZjczYWE0MjVkZTFmYmNiZTM1ZmExYTJkNTJmNjFhODgyZDA2NTQyNDk3MWQ3NyIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:50:15	2025-01-15 16:50:15	\N
27	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=AKZmOqBVL1ohpDMvFedieR9zuGPvL8foCqQRNDNe&valid_from=eyJpdiI6IlVEVVQrZ3VOM1B5VUF1TStnVlVWR1E9PSIsInZhbHVlIjoiN21oaFc0OXIyYW44cFpNVnlualVwUT09IiwibWFjIjoiMzIyMzYyNjJjZWU5ZmJhYjg0MGVjZWRlYmI1NjhiZjY4ZGUyNWI1NjRmNWZhYmMyNGU2YmZiYTJmMmNkMzQ1NiIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:50:56	2025-01-15 16:50:56	\N
28	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=AKZmOqBVL1ohpDMvFedieR9zuGPvL8foCqQRNDNe&valid_from=eyJpdiI6IkhVT2xKUWF1YzZ0aERMT3haRVNHNGc9PSIsInZhbHVlIjoiRnV2Z3VWWEcwbFpkdHp4cUJyWk5Cdz09IiwibWFjIjoiOTJkYTk2MzE2YjI4ODlhZGNmZmMxOTc0NjgxMGJjZGE3OTllMTg4YThlM2NmYmU2M2ViYTY5MzhkODM2Yjk3MCIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-15 16:51:29	2025-01-15 16:51:29	\N
29	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=AKZmOqBVL1ohpDMvFedieR9zuGPvL8foCqQRNDNe&valid_from=eyJpdiI6Im5rOERKVFcrN0orNEtLRTdPWHgvckE9PSIsInZhbHVlIjoiS3QwUzJoY05kR1JqTGo2bk8rekZlZz09IiwibWFjIjoiN2QyOWZiMTBlZmJhNzg0ZTZkZmIwYTg3ZTlkNDZmZWU3NTYxZjhkMGQ2MTFhMjQ4YTE5YjU2YzRhZTE0NWMzYiIsInRhZyI6IiJ9&email=nada@orient.com&password=******	2025-01-15 17:01:10	2025-01-15 17:01:10	\N
30	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=AKZmOqBVL1ohpDMvFedieR9zuGPvL8foCqQRNDNe&valid_from=eyJpdiI6IkZDblZZTFlPZzF6ZnU5dFAxdkR5Ync9PSIsInZhbHVlIjoiRjFsYTQ3S201NS81dktkWC9hamgydz09IiwibWFjIjoiM2Q2ZmU4NWQxMDg4ZmQyNWYxYmE4ODVlYzA0YmE2ZGFiYTc3Nzc0NWM5MTVhMTI1MzI1ZWVmMDYxNjZlYTkzZSIsInRhZyI6IiJ9&email=nada@orient.com&password=******	2025-01-15 17:01:24	2025-01-15 17:01:24	\N
31	156.223.124.43	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=AKZmOqBVL1ohpDMvFedieR9zuGPvL8foCqQRNDNe&valid_from=eyJpdiI6IldDVjJ5aHViZjFCTE9kQWh6SWJRS2c9PSIsInZhbHVlIjoiSjZub1RLKzJPUGl6c2VHSEJqMmZOdz09IiwibWFjIjoiNzVkOWYyMDY5ZmZkY2EwNWQ0N2U1MDgyMzk2ZmVlMmExNjA1NzRkNzY2YWUwMDI4MzkyNjJlNGZmOWZiZDhhNCIsInRhZyI6IiJ9&email=nada@orient.com&password=******	2025-01-15 17:02:58	2025-01-15 17:02:58	\N
32	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=nnTHRTODe5cgVYPfCUjoef0FjTwbtoYbw88BO1jW&valid_from=eyJpdiI6IjU0OHQvVWlUQUFGSnhkVVFsNVNoVFE9PSIsInZhbHVlIjoiejNIZE9wdkZoRHMrdHppcW44ejdxQT09IiwibWFjIjoiZjYxMWI3OTY2ZTA2MWRlMTNiZTAwNDFlNTMyNjlhNDY0MDI5OTM2ZDgyN2U4MmE2ZTA4MTI1Y2VhN2RmZjA0YyIsInRhZyI6IiJ9&email=ramdan@orient.com&password=******	2025-01-16 09:05:06	2025-01-16 09:05:06	\N
33	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=nnTHRTODe5cgVYPfCUjoef0FjTwbtoYbw88BO1jW&valid_from=eyJpdiI6IjU0OHQvVWlUQUFGSnhkVVFsNVNoVFE9PSIsInZhbHVlIjoiejNIZE9wdkZoRHMrdHppcW44ejdxQT09IiwibWFjIjoiZjYxMWI3OTY2ZTA2MWRlMTNiZTAwNDFlNTMyNjlhNDY0MDI5OTM2ZDgyN2U4MmE2ZTA4MTI1Y2VhN2RmZjA0YyIsInRhZyI6IiJ9&email=ramdan@orient.com&password=******&rememberme=on	2025-01-16 09:05:10	2025-01-16 09:05:10	\N
34	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=nnTHRTODe5cgVYPfCUjoef0FjTwbtoYbw88BO1jW&valid_from=eyJpdiI6IkF3NjhjNmlGVitoNm5hOU4wSVVUbWc9PSIsInZhbHVlIjoiL2FpYWdudTFVTi9VVzRKNWNncGpnUT09IiwibWFjIjoiM2Q5ODZlZjY4MjQxNTgxYjUwOTZiNTg3ZmEyZTRiN2I5NWE5M2JiNDg4NmExNDE2OGQ0NTdkZDYwZDUyZjEyOSIsInRhZyI6IiJ9&email=sales@orient.com&password=******	2025-01-16 09:05:24	2025-01-16 09:05:24	\N
35	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=nnTHRTODe5cgVYPfCUjoef0FjTwbtoYbw88BO1jW&valid_from=eyJpdiI6Ijg5UTlnbGV2OExCK0hhUFU3U2c3Q0E9PSIsInZhbHVlIjoiblhmNjRlYXhjYThocnM3ZldYdnMxZz09IiwibWFjIjoiZmEwYjQ2Nzc0YTFjZWRjNDQzODA1MjFjZmM4YzI2YTlkYjRmODFkMGRkMDg5YTg4ZTdkM2EyMWRmM2RjYmU2NyIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-16 09:06:27	2025-01-16 09:06:27	\N
36	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=nnTHRTODe5cgVYPfCUjoef0FjTwbtoYbw88BO1jW&valid_from=eyJpdiI6IlNIaU05ZDY0ZTJiWExqa3F0MmVWc3c9PSIsInZhbHVlIjoiT3VyZkpPOTNLdUNWQ1EwOGJ1MytIQT09IiwibWFjIjoiMTZlMTliYTI2MDQ3OTc3OTI3NDMzM2ZlZjc3N2ZjN2NmYmUwMDk5NThmNjY2MmQyMjhiYWViOTM2MGM5NTk2ZiIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-16 09:07:11	2025-01-16 09:07:11	\N
37	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=DydCxPpln6BmdTIWBuXibWVPf9noHtUHxen4DwAy&valid_from=eyJpdiI6IjJOL3dUaUhoY1BkdDRRUmw3SWZBcmc9PSIsInZhbHVlIjoiYXV5NXgyMVF3akpyS2RUeGF4MU1Odz09IiwibWFjIjoiYzAyY2FkMGNiYzRiZDg2NzYzODRiYjVmZGRjYzYyOTg2NzFlOTFmZjUzN2UxYjdlYTQyNTY3ZmE3ZjI5N2I3MiIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-16 17:16:51	2025-01-16 17:16:51	\N
38	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=9OfiBgRr3w5AkNswkBgb4HehOUcrJVfBbHt20m7I&valid_from=eyJpdiI6Ii9SYVdZZS8zeTFtWTR6enNSZnZ1TUE9PSIsInZhbHVlIjoiSzZVWlVGVDBIUy9sVFZYM0praFQ5QT09IiwibWFjIjoiMTBjNDA4YWUzMzhmZGM2NDU2MzQ0ZmY5NzdhNzJkOTFhZTE1OGU2M2FmNTgyZjcyOGNhYTAyNmE5MzI0NjBmZCIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-16 20:45:49	2025-01-16 20:45:49	\N
39	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=9OfiBgRr3w5AkNswkBgb4HehOUcrJVfBbHt20m7I&valid_from=eyJpdiI6IjBOSWg5TmFWUjFkNHQxZjAyckdaSmc9PSIsInZhbHVlIjoieUpjSktreFhKenVNNVRERkpaNEV1Zz09IiwibWFjIjoiMDZjZDY5YmMyNDczMmRiNTliY2ViODAyNzlhMzliYTdkNmQwMTExYmIxMzY4NDhkOWI1ZmFmMTMzY2ZmODdhNCIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-16 20:46:15	2025-01-16 20:46:15	\N
40	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=9OfiBgRr3w5AkNswkBgb4HehOUcrJVfBbHt20m7I&valid_from=eyJpdiI6Im5EN0M2aC9BaWZpWFVEak1FbW1Oc2c9PSIsInZhbHVlIjoidWN6cFFPZ0drYmZ5dSs0MElIMS8yZz09IiwibWFjIjoiOTgyNTM2YmI1YmVmY2Q5MWRjN2Q3NGZlZTYzMGJlZWQ3MTFhN2RkY2Y0YTRjZmNhM2MxYmM1ZmJhMTU4NzIzYiIsInRhZyI6IiJ9&email=admin@orient&password=******	2025-01-16 20:47:40	2025-01-16 20:47:40	\N
41	2c0f:fc89:10a:a8cb:cdeb:1241:d11c:1833	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=jmphJ70b2hBefrO7dgzDofrRN1Qi6zouMJtXkBpk&valid_from=eyJpdiI6IjVZZi9tZ0t1V2hwL1JOVW4yNUZFcUE9PSIsInZhbHVlIjoibmkrejJ6dmRVNHl3MmFMYU1rcFVlZz09IiwibWFjIjoiY2M5ODk2MzcwMGEwYTM0ZDA5ZDcwNTI3YzY2YTljYTk1MDRhYzQzMmUwMDY2ZGMxNWQ3MzU3MzNlMzM0ZDEyMiIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-01-17 00:03:13	2025-01-17 00:03:13	\N
42	2c0f:fc89:10a:a8cb:cdeb:1241:d11c:1833	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=jmphJ70b2hBefrO7dgzDofrRN1Qi6zouMJtXkBpk&valid_from=eyJpdiI6ImJka00yYmg5TzFuSkJBRHFGaExGcnc9PSIsInZhbHVlIjoiNEcrRjRGaHZPSUxzQ1c5S1ZtaWRQUT09IiwibWFjIjoiOTYwZTNjZWMxZGExNWYyOTk4MDMyOThjMjhhMjAwNGQ3OTZkNTA2ZjgyZDY4MzNiNDdmOWEyZTBjNzQ1NzBiYSIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-01-17 00:03:43	2025-01-17 00:03:43	\N
43	2c0f:fc89:10a:a8cb:cdeb:1241:d11c:1833	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=jmphJ70b2hBefrO7dgzDofrRN1Qi6zouMJtXkBpk&valid_from=eyJpdiI6IkwvbWcwRWZROXRpd2pvYzUzMGtEY2c9PSIsInZhbHVlIjoiUllGSEUwa3cybUVJZlVFVC9rWFJNZz09IiwibWFjIjoiMzgzNDc5NDEyYzc3ODdlZGZjY2IwOWUwYmMxYTBlZGVkMWQ1NDE2MmYzMDI1MTg0OTE5MTM0ZWUzZmIzYTI5ZiIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-01-17 00:04:00	2025-01-17 00:04:00	\N
44	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=Py4OeIKNzcgGatBOC2vitSfmM7lmx6gFKbXlKjBN&valid_from=eyJpdiI6Ikw1ZTNUOGs5WjJvRXdSM3hpeVh4Snc9PSIsInZhbHVlIjoiY0dwRVAzMC9JWGNLcU5WNXJSMk5HUT09IiwibWFjIjoiYTkwMzhiYmQ2NTgxMTUwYmRmODUzNTAxMDdjNjQ1NTgwNjE2MTBjOTNiMGJiYzk4MjUwMDc4NjkzMTA2Yzc5OCIsInRhZyI6IiJ9&email=sales@orient.com&password=******	2025-01-18 15:04:37	2025-01-18 15:04:37	\N
45	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=4ZaNlgm5hDDYI6aJ5NKXoc0MwuUhGnTBbbuQS2qf&valid_from=eyJpdiI6IkNMSUFWNGlWNXFkWjN0Tll4TSt2ZFE9PSIsInZhbHVlIjoiQVc2dk52azZvazd0YitmR2xGZVNVdz09IiwibWFjIjoiNDhmNjkxMDYyMzI3Mjg0YTUzZmVkYmY5NGRjNTg4MWE4Y2JkNzc4NTk3MWJmZjFkZmEwZjA1ZTQ3YmZkMDFiMSIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-18 17:48:45	2025-01-18 17:48:45	\N
46	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=4ZaNlgm5hDDYI6aJ5NKXoc0MwuUhGnTBbbuQS2qf&valid_from=eyJpdiI6InJIZmdBU3BOZjVDYldBbWpYZXdxeGc9PSIsInZhbHVlIjoieURITlhsbXpMQ0tQOXFVYXNJSUtodz09IiwibWFjIjoiZmRjNGY2MDZmZjNlYzdhYzYxYWEzMWFjZWZjNTBhYjJmYmFmNmQzOWEwZTI5MWYyZDMwOGFlNDc4Mjg0MTc1OSIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-01-18 17:49:07	2025-01-18 17:49:07	\N
47	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=DydCxPpln6BmdTIWBuXibWVPf9noHtUHxen4DwAy&valid_from=eyJpdiI6IjVrd2J0UEJNVFNWbjhhcXgyU2lMZUE9PSIsInZhbHVlIjoidmxyV3JhV0l6am9CUlcyMnBOR1BBQT09IiwibWFjIjoiNjU1YjEzOGIxNmFjMzMyNmRlNWIwZjc3M2I2NzEyMzA4ZjNmZmM0NjIwZTY0ZWRjYjA4MzA5MjU5MGZjMjE0NiIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-01-18 17:59:59	2025-01-18 17:59:59	\N
48	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=DydCxPpln6BmdTIWBuXibWVPf9noHtUHxen4DwAy&valid_from=eyJpdiI6IjB4NklXUkxhNmlyWG5UbGJiRU96SEE9PSIsInZhbHVlIjoiWE11M1FwN2Z6UmlaTFFrNVdmM0RPUT09IiwibWFjIjoiNmY0NzI1YWQ1YWQ1ZTM5NjVkMDhmMjVhYzU3MzZlMDg5YzZhMmVlNDIyMDQ3YWRmMTY0ZDNhZjNmYWYzZmE2NSIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-18 18:00:07	2025-01-18 18:00:07	\N
49	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=DydCxPpln6BmdTIWBuXibWVPf9noHtUHxen4DwAy&valid_from=eyJpdiI6Ing4NDVQNnIwaFl0R0hnWlVQWGtoZ3c9PSIsInZhbHVlIjoiZ0llNEh4S05udHYzVmxOTlVmaVJRdz09IiwibWFjIjoiOWM5ZTczNTA2MTk5ZjlkZDVlZWYxYTJkYWYxMGQyMjM5ZDZlYWNjZDlhNjdiNGZkNDIwN2ZjZDkwMTQ5NGFjYyIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-01-18 18:00:12	2025-01-18 18:00:12	\N
50	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=DydCxPpln6BmdTIWBuXibWVPf9noHtUHxen4DwAy&valid_from=eyJpdiI6InhnOThVOUZpY0dhall3Znh0dlRIQkE9PSIsInZhbHVlIjoicTFZcHp4V3FBbXpmYUN0MVhmMjM3Zz09IiwibWFjIjoiOWIwNzgyYzFlYWUxMWE0YzE3YTIyZjE3N2FmN2Q4OWMxZDVkNmIyYjcyNGRlMDFmNjg4ZjM0NjYwYTE4MDBjYyIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-01-18 18:00:34	2025-01-18 18:00:34	\N
51	156.223.178.227	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=9nkuQqTSfcMeJdNMPO6qthO9lrA3LjKDkbDNjMo2&valid_from=eyJpdiI6InE5ZSsvaDJKS2R6Sk83MUMwZ1NTb1E9PSIsInZhbHVlIjoiS0UyV1hQblVUQ3hzYUUxZHcwM2E3QT09IiwibWFjIjoiNGQ1NGQ2ODYwNmNlNmFhNzI2MGJhMzViMmNlNWIzNTAyMzU3NTUyNzhkYzY3NmY5NWFjZjIyZTIzMjBmNjAxMSIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-18 18:37:34	2025-01-18 18:37:34	\N
52	156.223.118.126	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=INiRCbONO8oau3maRXme6XkDMH8SoN70HvyVCAha&valid_from=eyJpdiI6InpWWXJ1Y1REZW43NDdyTitldkx1UFE9PSIsInZhbHVlIjoiZWpzb0hLdk5yTFZ0QVIrRzB5SlZzQT09IiwibWFjIjoiYTFiMWE3ZmIxMzgwNGRlZTg2NjQ1ZDIxZGVkNDU4MzdkNjViMGJlYTFlNzlmMDMzYmZiYjg2NTZhYWY0ODNmOSIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-19 02:22:30	2025-01-19 02:22:30	\N
53	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=RT4e6RCtMlNbKgUhoErD1Bd2UZGdm0LJpWk8aJeO&valid_from=eyJpdiI6ImtoTU1zUzdKeWlFWWFRSzVzQ0RVREE9PSIsInZhbHVlIjoieCtNNHRHaVJGUHl3cGhyZTBwbUtadz09IiwibWFjIjoiNmVlNjBjYWVmM2JmMmM4MWFlMDZmMmY2YjVlOWFkNzU3YjA2ZjQzYmRjYjYxYThhYWQzZjBmNjFlNjk0MDUzNiIsInRhZyI6IiJ9&email=fatma@orient.com&password=******&rememberme=on	2025-01-19 17:17:41	2025-01-19 17:17:41	\N
54	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=RT4e6RCtMlNbKgUhoErD1Bd2UZGdm0LJpWk8aJeO&valid_from=eyJpdiI6IlBCdjFweEt3cDdZSjcrZWRQUUE5b0E9PSIsInZhbHVlIjoiU1F4UjRwZUcrQUlNUGRkMVpRR2Z1Zz09IiwibWFjIjoiOTI3NDQyNDhlZDE1MjYyNTMyYTcwODdhYmQzZGE2NmFjZjIzNWI3ZjM0ZDU2YzE3NzljZDA3YmRlY2Q5OGJhMSIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-19 17:17:57	2025-01-19 17:17:57	\N
55	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=RT4e6RCtMlNbKgUhoErD1Bd2UZGdm0LJpWk8aJeO&valid_from=eyJpdiI6IjQ0UTU5MTlLL0xNZjAvTkR1aHU5U3c9PSIsInZhbHVlIjoiL3ZrNG12TjJqM0hRWXZJdDhPU05odz09IiwibWFjIjoiMzFlYTA4NjNmZDAxNDNkMzBmZGMwNzI1ZDVjYjVmNGM4MDJlNTA5YTc4NDFkMTJkMGYzOTUzMTE0NjI3YWYxMCIsInRhZyI6IiJ9&email=admin@orient.com&password=******&rememberme=on	2025-01-19 17:18:29	2025-01-19 17:18:29	\N
56	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=RT4e6RCtMlNbKgUhoErD1Bd2UZGdm0LJpWk8aJeO&valid_from=eyJpdiI6IlVKMG0zOHh0TE5XNEFYcHhCeGxTbHc9PSIsInZhbHVlIjoiemZraU80b0dpZ2JnS2hTbU02UDVHUT09IiwibWFjIjoiZDlmMTgxMDJiY2Y0ZTViMTA5ZmUzODBjZWZiZGIxZTM0MTllOGJhNTAxMjZhOTZkMTA1MWViNGQyZDIwN2NlZSIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-19 17:18:52	2025-01-19 17:18:52	\N
57	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=RT4e6RCtMlNbKgUhoErD1Bd2UZGdm0LJpWk8aJeO&valid_from=eyJpdiI6InNnTHJ4QWduVkdyMDQxeG5xWUVBeXc9PSIsInZhbHVlIjoibnhSWW5ya2ZrZGsrSURZTTE3bnVidz09IiwibWFjIjoiNzNiYzAyMTcwMjc0ZTBlNjg5ODA1ZDlhMDA0OTU1ZmM4YTVhNWYzMjUwMmZmZTBhZTcyNWI4ZTZjMTA2OTYzYyIsInRhZyI6IiJ9&email=admin@orient.com&password=******&rememberme=on	2025-01-19 17:19:20	2025-01-19 17:19:20	\N
58	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=RT4e6RCtMlNbKgUhoErD1Bd2UZGdm0LJpWk8aJeO&valid_from=eyJpdiI6ImJHbC9CMXA0bUNEU0tGYTdVd2g1VVE9PSIsInZhbHVlIjoiVTlqcVY2U083Nno0ZnZCMVZZUXFxZz09IiwibWFjIjoiYjI3NWRhNmYwNmNlZTRlMmQ2ZTY3MDdhZmE3MjUyOTE1NTZhMWVmMTUxYTY2Yjg0YjM4Y2UzMjNjMTBlZmU1MCIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-19 17:19:42	2025-01-19 17:19:42	\N
59	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=RT4e6RCtMlNbKgUhoErD1Bd2UZGdm0LJpWk8aJeO&valid_from=eyJpdiI6IlF0TzF0UWhVSE83aXp5cG1WNmVmalE9PSIsInZhbHVlIjoiZThkU0pFazRHMmRPcDl0TG1YUHNtUT09IiwibWFjIjoiNGNlNjkwOTliNjc2NmExMTYxY2UzYjIxYzg0ODBlOGIwMzA3NDgyZWQ5ZmE2MTk3NjFlYWYzYWUyN2IyMTBhOSIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-19 17:20:48	2025-01-19 17:20:48	\N
60	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=RT4e6RCtMlNbKgUhoErD1Bd2UZGdm0LJpWk8aJeO&valid_from=eyJpdiI6InVjdUZKVVQrTHl6VHBXSWQzR25ReWc9PSIsInZhbHVlIjoiNUY3R0hxb0FxUGpiRWNQakI0NHk3QT09IiwibWFjIjoiMDI5MzNjYTVkNWI2MDgzNjJiMjYyMTYzNDRmNmFjNmMzZjcwYWE5MmM1NDFmNTM1NzE5ZGZlZjRjMjY0MzZmMyIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-19 17:21:42	2025-01-19 17:21:42	\N
61	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=EEKolwDy8blAOEOs0kS7Re1MscKHPqkhr4VZuvL4&valid_from=eyJpdiI6ImpuYm9BMmVxVjhEYy8xUHhLQUdOc3c9PSIsInZhbHVlIjoiRG8vUjdaRW00SlNSRVIwYU5oU3g0dz09IiwibWFjIjoiMDg4ODI1Y2YyOGVmM2Q1ZjAzMjI2NGYxMGE1OWI3NDUzN2EzYTE2ZmRkOTE2MmU3MjI3NjBhMjA5NzBmYTY1YyIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-19 17:22:35	2025-01-19 17:22:35	\N
62	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=mbzbyNdR3pTeJS9m5AUs2SPQE0oDHnxOcatGShLU&valid_from=eyJpdiI6IjYwR2VjTUZJL241WDBhNW1IcDhBWnc9PSIsInZhbHVlIjoibjhqeXRjVXdLMm15NFFBSkRweldFdz09IiwibWFjIjoiMWY4YzI3YzI2YjU5NWQ4YjYzZjM2NjQyOWIzZDkwNzhiZTZmZWFkN2U5ODNlYmJlZTU0ZDY3MTk3OWI0ODcxZCIsInRhZyI6IiJ9&email=fatma@orient.com&password=******&rememberme=on	2025-01-19 17:37:08	2025-01-19 17:37:08	\N
63	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=SjUkG4dSrQpD4HR2OpVQ07IkGfJa1wbo14qrNzSZ&valid_from=eyJpdiI6IlJOV0hoV0ZRTkNvWDQrQTZBaUYvb0E9PSIsInZhbHVlIjoiRFJrOUI3UjJxUUVpekgyeUdDNlUyUT09IiwibWFjIjoiM2Y5OGViNmI2ZjAzMjJiMzA2MzQ0OWY5M2FhMjFlNzA5YjBiOWVmNWZhMjU2OWY4NzcwMDJhNGYwZGFiZTNhMSIsInRhZyI6IiJ9&email=ramdan@orient.com&password=******	2025-01-22 11:13:06	2025-01-22 11:13:06	\N
64	156.223.150.121	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=3OINNu8DGu92NZU3eopwX5UquwSbUZEpWoSrslog&valid_from=eyJpdiI6IjNXcVEwSXJlbkQ2RkhYMUJZSUtndWc9PSIsInZhbHVlIjoibFFGeFYvbVJRVTFxUE5yUXlDMkc1Zz09IiwibWFjIjoiODM4NzFmYWRmYjljZDJkNjNiODgxMzEzYTVkNzUzZmZkZDU2ZDE5ZGE5NzA4ZTUwOGNmN2QwYWFjYTljNDYzNyIsInRhZyI6IiJ9&email=admin@rabih.com&password=******&rememberme=on	2025-01-23 12:32:17	2025-01-23 12:32:17	\N
65	188.53.126.82	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=9DetTfCRGHGkP922bmPPxeX8gGyEasfvVK9T3uFQ&valid_from=eyJpdiI6IllrTFRkQnZHUTQ2YXhrN0JwQ3UvMXc9PSIsInZhbHVlIjoiZTNSVFg0VmY1a00vSUd1dE5meXdFUT09IiwibWFjIjoiNzIzMjliOGM4NmYzYTFiNTAzMzk5N2Y1YWRjYThmYmE5MTMwZGYxNGY3NjkzNTljNjA5ZjQyOTQ4ODRmNTg3MyIsInRhZyI6IiJ9&email=admin@mamas.com&password=******	2025-01-23 17:43:13	2025-01-23 17:43:13	\N
66	41.40.167.173	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=P5Hx7U9tSSFHAsUdybYIvbuteav4vaSptopGLwDV&valid_from=eyJpdiI6ImhpM05wdE11MjcxNzd5ejZaWXJKblE9PSIsInZhbHVlIjoiUkxGbTlaQ1pGSS84OTdwRFFZdG1NQT09IiwibWFjIjoiMDY4ZGNkNzJkN2YzY2I2MTQzNTFlNzJjMzRlMjljNmE5NTY3NzI4OWY1ODk4NjNlYjczN2QzZTViMGMxODlhYiIsInRhZyI6IiJ9&email=mohamed@orient.com&password=******	2025-01-25 15:35:25	2025-01-25 15:35:25	\N
67	41.40.167.173	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=P5Hx7U9tSSFHAsUdybYIvbuteav4vaSptopGLwDV&valid_from=eyJpdiI6IllZdVVnakpyTVVxNlBDQWE0bWVlYmc9PSIsInZhbHVlIjoiaXZTWEgraWdqbGNHUjFrTUZWMkszdz09IiwibWFjIjoiNDAzMjIxNTNmNDI2OTA3ZTQwNzA4Y2FjZTk5NmVhOTViMDE3NTBiNmVmOWJkMzA3NjZlZTlmY2QyNDdiYjNjYiIsInRhZyI6IiJ9&email=mohamed@rabih.com&password=******	2025-01-25 15:35:47	2025-01-25 15:35:47	\N
68	41.40.167.173	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=P5Hx7U9tSSFHAsUdybYIvbuteav4vaSptopGLwDV&valid_from=eyJpdiI6ImZNQ1hPa2g3NVhIZkhOazdJd2lzVFE9PSIsInZhbHVlIjoiU0w1ZVNjSnhvdjhlWUxxUjVyOG41QT09IiwibWFjIjoiM2JhMTAyNzAyYmU1NjA1ODIxMTNjMzhiYmYwMDUxOTk0OTFkNTQ0NjFmZjVlNGMxZDg2MzI0ZDg1ZWEwZTIwMyIsInRhZyI6IiJ9&email=mohamed@rabih.com&password=******	2025-01-25 15:36:15	2025-01-25 15:36:15	\N
69	41.40.167.173	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=P5Hx7U9tSSFHAsUdybYIvbuteav4vaSptopGLwDV&valid_from=eyJpdiI6IlpRbTUxbWNVcXZpQ2x3NWp4TEgrdmc9PSIsInZhbHVlIjoiMzhaUlR1SUxnTDBvRWEwWnFERGYxQT09IiwibWFjIjoiN2ZjNDczZTMyYjA1YmJlNmEyMmVjYWRmN2E1MzlkNDNjMGQwMTUyNGJiNzUyNGM1Yzk1N2EyNTc1ZWE5MmRiOCIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-25 15:36:38	2025-01-25 15:36:38	\N
70	41.40.167.173	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=rJ1ttzqxJDUUqDcgDtmtr0kGwVbS7co6WGH5Pp9s&valid_from=eyJpdiI6IjJ0SEdOOTFoa2FCd3NMMmd2cGxMa2c9PSIsInZhbHVlIjoiM0lmcFlKQlNHSVF0VlhDTHdQa2Mzdz09IiwibWFjIjoiNjhlN2VkOGViNjA1YTQ3ZGYxNDk2MGUzZmM5YjEyYzBlOTcwMTIxNzhjMWU5OGNiZmQyMGQwNmVjMzM4MGI2NSIsInRhZyI6IiJ9&email=ramdan@orient.com&password=******&rememberme=on	2025-01-25 15:50:26	2025-01-25 15:50:26	\N
71	41.40.167.173	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=P5Hx7U9tSSFHAsUdybYIvbuteav4vaSptopGLwDV&valid_from=eyJpdiI6InFvYmpSVVFMSGxzZkMzczhZSWtMRVE9PSIsInZhbHVlIjoicXFSVlJCMURmM240MXFweDFCRnowdz09IiwibWFjIjoiNzcxYTA2ZDQ0NjQ5MjM1ODZlZmNjN2ZiYTRjMTA3MTAzMjVjM2FmNWNjODAyM2NiYWQ5ZTM0MTQxNzEyY2M5YyIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-01-25 16:15:18	2025-01-25 16:15:18	\N
72	2001:16a2:c090:b325:b591:9625:29da:ddaf	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=TTfdDkSIOHOEMtHBMlTC4SPpABi9P0XHZHl7Z1Pz&valid_from=eyJpdiI6IkQ5Q1lqbm1Xc2RzWExNWVFaWWVIV0E9PSIsInZhbHVlIjoiWmsyUmNCNjV3V05nUUlvRXZtTmg4Zz09IiwibWFjIjoiZDI3NzE0YTYwMDliODRjMDhhMzBiYmIyNDhkN2VkMzEyNmQzMDBkNDFlZWQ1YjcyNTBhMDZlMGY4ZDQ5ZmVhMyIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-01-28 10:29:51	2025-01-28 10:29:51	\N
73	2001:16a2:c090:b325:b591:9625:29da:ddaf	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=TTfdDkSIOHOEMtHBMlTC4SPpABi9P0XHZHl7Z1Pz&valid_from=eyJpdiI6ImN1c0J4c0VRVm5WWkZaTjRDY1pna3c9PSIsInZhbHVlIjoiWGtMZGV1SFNJSGIxSnlHc1JWZWtpQT09IiwibWFjIjoiZjI4YWFiZjdiODRmNjJlNjFjMWU1ODVjMGIxYTYxOWU5MDk4NWEwYzJhZGY1NGM4ZGE4NzNhNTQxNGEyODYyOCIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-01-28 10:29:58	2025-01-28 10:29:58	\N
74	102.45.20.70	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=PBLQpnnNO5GcCGHyk6MawEGAotMD7sYxAFrYO84c&valid_from=eyJpdiI6IjJrcGc2Q0crQnJRUXpzR2dLd1Y0aUE9PSIsInZhbHVlIjoieDR2S1g5VElEekJhTkN2MlQzN1d3QT09IiwibWFjIjoiODhlYmE3YzFiZjc3NDMwNDFjMjAzNjk5ODY3NGRhZGYwODY4YTQ0M2RmYmM3NGE4MTk5YzJkY2VhYmZjNmQxYiIsInRhZyI6IiJ9&email=admin@test.com&password=******	2025-01-29 14:10:00	2025-01-29 14:10:00	\N
75	156.223.166.22	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=lXPF5LlfQYPOzlTheDcxBfZAo26QSyz3G7JgfGpC&valid_from=eyJpdiI6ImV4TFE5N3JLWURYZjh5M3MvNVhwMGc9PSIsInZhbHVlIjoidDR1ajZaRGlpVE5kVGpYSml4ZjhkUT09IiwibWFjIjoiNmI0NGUzNGU0N2FlOTY2NjMxMDcwMWI4YjZhYTE5YzNiMjhhMGRmYjQ1OWQ5NGNmMDE4MTBlNDFkNTI3NDVmYSIsInRhZyI6IiJ9&email=admin@rabih.com&password=******	2025-02-05 11:26:01	2025-02-05 11:26:01	\N
76	156.223.166.22	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=sWIhJQcRH4KGue0Zzd4pvJYbNqow5OMHrFoj6Hk4&valid_from=eyJpdiI6IlNJZ3ptUGxjWlVGblRsOFNOQ09yQVE9PSIsInZhbHVlIjoiUy9HdFZ1dllZMDNyRCsrbk8wUVQyQT09IiwibWFjIjoiMjQzNGJkY2E2ZTIwZTRmNDVmMGNiMzM0YjY1YmI5OWFkZWU2OGU3ZjYwYmI4M2NkN2ZiZTc5MmE4ODk0ZDdiMCIsInRhZyI6IiJ9&email=ramdan@rabih.com&password=******	2025-02-05 12:04:05	2025-02-05 12:04:05	\N
77	102.42.254.200	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=jFKelXlAHmnfO7dSZOzDvNNTxzRGuZPQ0v3H8OGP&valid_from=eyJpdiI6IjF3aXlybHEreXhKdkJYSUkvZ2tUMlE9PSIsInZhbHVlIjoiRFgxbmZHenZjU3VVK0oxdnlRRUlHdz09IiwibWFjIjoiZTdmOTdlY2NjNzdkZDNiNTUwNGI4MTk0MWVjMmFkMWQ2NzZjN2Q3YWU4MmI0MGFlZTJmOGMxMzhlOTkxNTgwNyIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-02-19 18:14:48	2025-02-19 18:14:48	\N
78	102.42.254.200	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=jFKelXlAHmnfO7dSZOzDvNNTxzRGuZPQ0v3H8OGP&valid_from=eyJpdiI6IjlPM0xWbm9FNDRQU1NONDVqanVMaXc9PSIsInZhbHVlIjoicXBKM01RMXpNYTRzTFZ5elc5N0JRZz09IiwibWFjIjoiNTZlYmMxMWQwMjJmNTg3ZjNmNWM1Njg3OTFiY2YyMDY1YTYxZGQ3OTJiZWFjNGU2OTU2ODQ1NjU4MTM5NjEzNyIsInRhZyI6IiJ9&email=fatma@orient.com&password=******	2025-02-19 18:15:17	2025-02-19 18:15:17	\N
79	102.42.254.200	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=jFKelXlAHmnfO7dSZOzDvNNTxzRGuZPQ0v3H8OGP&valid_from=eyJpdiI6IklINUlIdHpQV2RTQmhYdW5SZFo1blE9PSIsInZhbHVlIjoiMmxiMnp0REFRRWZsV2xyMlBkZnRVZz09IiwibWFjIjoiOWE0ZDYzMzUwMzc5OThiNzI4YjcwM2Q0MjZhYzU0MDQ3ZTQwODlkMmExYmZjZGMwZWQ4NTExNDA5ZjM3Mjg3MCIsInRhZyI6IiJ9&email=fatma@orient.com&password=******	2025-02-19 18:15:36	2025-02-19 18:15:36	\N
80	102.42.254.200	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=jFKelXlAHmnfO7dSZOzDvNNTxzRGuZPQ0v3H8OGP&valid_from=eyJpdiI6IktQRVNiRzYwMG52Mk1LOXJNM2pFR0E9PSIsInZhbHVlIjoibjJsYzJQT3dTWUpqZWpQemtabzVPdz09IiwibWFjIjoiMjlmMjk2OGE3M2QwMTMyZTFkZWQxMGY0MTllMDcxYjIxMTU3MDA4OWQ1Y2MyZjQ1OGUzODcyZDRhNzkxY2M3YSIsInRhZyI6IiJ9&email=fatma@orient.com&password=******	2025-02-19 18:16:26	2025-02-19 18:16:26	\N
81	41.42.213.170	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=2AGDbQMplmvAGvj6ihJOAkse5TGEBCjKXL9gBexO&valid_from=eyJpdiI6IjR3TkVyK2l0QkxvQkgvR09KSU53Qmc9PSIsInZhbHVlIjoiUWx3QzJvZ1RNRVoyQTZSaTMwTlVodz09IiwibWFjIjoiYWJlYmJlYmFmZjVjNDMyMzIwMzY3MzA4NGNhODA3MGI5YmNhZWQ3NTVmZTIyOGYyNjlkZTViOTUwMTI0MWU3ZSIsInRhZyI6IiJ9&email=admin@orient.com&password=******&rememberme=on	2025-03-04 00:40:29	2025-03-04 00:40:29	\N
82	41.42.213.170	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=2AGDbQMplmvAGvj6ihJOAkse5TGEBCjKXL9gBexO&valid_from=eyJpdiI6InM0eFdtUlRjc1BGMElqSkd5QW5HWGc9PSIsInZhbHVlIjoiYVY2ZVdvNjVKNjVTaWwxcHZHMzhVZz09IiwibWFjIjoiNjJmMDA1NjEyMDIxMjAxNDE3MDA5MzE0M2RhYTMwYjI5ODRhNDM2NWI5MDU4ODI0N2UxOGMwMjk3MTk2ZTcyYiIsInRhZyI6IiJ9&email=admin@orient.com&password=******	2025-03-04 00:40:53	2025-03-04 00:40:53	\N
83	41.42.213.170	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=ZP867ZVdET1mWEkUqCtatMBtJeotVB4w1BP2lUpV&valid_from=eyJpdiI6IklNODArTVNLTFpHazVOOFR4QUZtYWc9PSIsInZhbHVlIjoieklvT09wazQ2dmxpMGQ5WXdNUVFWUT09IiwibWFjIjoiNWM0MTgyMDc1MzY3NDg1OThkYzA5NmNhYzYxMTcyYTgyNDE3MGI4YTUxNzY0ZTc1NjEyNTEyNzllMGU1NWUwYSIsInRhZyI6IiJ9&email=admin@test.com&password=******	2025-03-04 11:00:45	2025-03-04 11:00:45	\N
84	41.42.213.170	medium	login	0	http://orient.limraerp.com/public/Login	https://orient.limraerp.com/public/AdminLogin	_token=ZP867ZVdET1mWEkUqCtatMBtJeotVB4w1BP2lUpV&valid_from=eyJpdiI6Im1OY1l6NU9VMUY0ejkxMmFQS1h6TXc9PSIsInZhbHVlIjoiVHJLSGsvTG1hNzl1aTgzaFJBQ1ExZz09IiwibWFjIjoiZTE5Nzc1NWRjNmQ4YzRiOTk1YjI0ZmJhNTljNzE1NjVkZThmNWNjOTRiYWQzZWMxMmIyZDMxMjU5YmYyNGVjMSIsInRhZyI6IiJ9&email=admin@test.com&password=******	2025-03-04 11:01:26	2025-03-04 11:01:26	\N
\.


--
-- Data for Name: follow_lists; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.follow_lists (id, "Emp", "Day", "Time", "Client", created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: general_dailies; Type: TABLE DATA; Schema: public; Owner: orientlimraerp_karim
--

COPY public.general_dailies (id, "Code", "Date", "Type", "Debitor", "Creditor", "Statement", "Draw", "Debitor_Coin", "Creditor_Coin", "Account", "Coin", "Cost_Center", created_at, updated_at, userr, "Code_Type", "Branch", "TypeEn", arr) FROM stdin;
1	1	2025-01-16	اصناف بداية فترة	76595.56	0	\N	1	76595.56	0	2500	1	\N	2025-01-16 17:55:28	2025-01-16 17:55:28	1	1	\N	Start Period Products	\N
2	1	2025-01-16	اصناف بداية فترة	0	76595.56	\N	1	0	76595.56	45	1	\N	2025-01-16 17:55:28	2025-01-16 17:55:28	1	1	\N	Start Period Products	\N
3	2	2025-01-17	اصناف بداية فترة	140334.85	0	\N	1	140334.85	0	2500	1	\N	2025-01-17 19:14:50	2025-01-17 19:14:50	59	2	\N	Start Period Products	\N
4	2	2025-01-17	اصناف بداية فترة	0	140334.85	\N	1	0	140334.85	45	1	\N	2025-01-17 19:14:50	2025-01-17 19:14:50	59	2	\N	Start Period Products	\N
5	3	2025-01-17	اصناف بداية فترة	1208.16	0	\N	1	1208.16	0	2500	1	\N	2025-01-17 19:18:06	2025-01-17 19:18:06	59	3	\N	Start Period Products	\N
6	3	2025-01-17	اصناف بداية فترة	0	1208.16	\N	1	0	1208.16	45	1	\N	2025-01-17 19:18:06	2025-01-17 19:18:06	59	3	\N	Start Period Products	\N
7	4	2025-01-17	اصناف بداية فترة	89989.08999999998	0	\N	1	89989.09	0	2500	1	\N	2025-01-17 19:59:28	2025-01-17 19:59:28	59	4	\N	Start Period Products	\N
8	4	2025-01-17	اصناف بداية فترة	0	89989.08999999998	\N	1	0	89989.09	45	1	\N	2025-01-17 19:59:28	2025-01-17 19:59:28	59	4	\N	Start Period Products	\N
9	5	2025-01-17	اصناف بداية فترة	49522.335	0	\N	1	49522.335	0	2500	1	\N	2025-01-17 20:41:40	2025-01-17 20:41:40	59	5	\N	Start Period Products	\N
10	5	2025-01-17	اصناف بداية فترة	0	49522.335	\N	1	0	49522.335	45	1	\N	2025-01-17 20:41:40	2025-01-17 20:41:40	59	5	\N	Start Period Products	\N
11	6	2025-01-18	اصناف بداية فترة	34923.03	0	\N	1	34923.03	0	2500	1	\N	2025-01-18 11:27:53	2025-01-18 11:27:53	59	6	\N	Start Period Products	\N
12	6	2025-01-18	اصناف بداية فترة	0	34923.03	\N	1	0	34923.03	45	1	\N	2025-01-18 11:27:53	2025-01-18 11:27:53	59	6	\N	Start Period Products	\N
13	7	2025-01-18	اصناف بداية فترة	16349.119999999999	0	\N	1	16349.12	0	2500	1	\N	2025-01-18 13:36:51	2025-01-18 13:36:51	59	7	\N	Start Period Products	\N
14	7	2025-01-18	اصناف بداية فترة	0	16349.119999999999	\N	1	0	16349.12	45	1	\N	2025-01-18 13:36:51	2025-01-18 13:36:51	59	7	\N	Start Period Products	\N
15	8	2025-01-18	اصناف بداية فترة	5071.819999999999	0	\N	1	5071.82	0	2500	1	\N	2025-01-18 15:01:25	2025-01-18 15:01:25	59	8	\N	Start Period Products	\N
16	8	2025-01-18	اصناف بداية فترة	0	5071.819999999999	\N	1	0	5071.82	45	1	\N	2025-01-18 15:01:25	2025-01-18 15:01:25	59	8	\N	Start Period Products	\N
95	36	2025-01-19	سند صرف	405	0	\N	1	405	0	2522	1	\N	2025-01-19 14:41:37	2025-01-19 14:41:37	1	1	\N	Payment Voucher	\N
96	36	2025-01-19	سند صرف	0	405	\N	1	0	405	2826	1	\N	2025-01-19 14:41:37	2025-01-19 14:41:37	1	1	3	Payment Voucher	\N
97	37	2025-01-19	اصناف بداية فترة	2840.41	0	\N	1	2840.41	0	2500	1	\N	2025-01-19 15:35:03	2025-01-19 15:35:03	59	9	\N	Start Period Products	\N
98	37	2025-01-19	اصناف بداية فترة	0	2840.41	\N	1	0	2840.41	45	1	\N	2025-01-19 15:35:03	2025-01-19 15:35:03	59	9	\N	Start Period Products	\N
99	38	2025-01-19	اصناف بداية فترة	7308.16	0	\N	1	7308.16	0	2500	1	\N	2025-01-19 16:51:28	2025-01-19 16:51:28	59	10	\N	Start Period Products	\N
100	38	2025-01-19	اصناف بداية فترة	0	7308.16	\N	1	0	7308.16	45	1	\N	2025-01-19 16:51:28	2025-01-19 16:51:28	59	10	\N	Start Period Products	\N
51	20	2025-01-18	سند قبض	0	25	\N	1	0	25	2522	1	\N	2025-01-18 15:54:18	2025-01-18 15:54:18	59	1	\N	Receipt Voucher	\N
52	20	2025-01-18	سند قبض	25	0	\N	1	25	0	2826	1	\N	2025-01-18 15:54:18	2025-01-18 15:54:18	59	1	\N	Receipt Voucher	\N
75	27	2025-01-18	سند قبض	0	10	\N	1	0	10	2522	1	\N	2025-01-18 16:14:26	2025-01-18 16:14:26	59	2	\N	Receipt Voucher	\N
76	27	2025-01-18	سند قبض	10	0	\N	1	10	0	2826	1	\N	2025-01-18 16:14:26	2025-01-18 16:14:26	59	2	\N	Receipt Voucher	\N
87	31	2025-01-18	سند قبض	0	370	\N	1	0	370	2522	1	\N	2025-01-18 16:20:54	2025-01-18 16:20:54	59	3	\N	Receipt Voucher	\N
88	31	2025-01-18	سند قبض	370	0	\N	1	370	0	2826	1	\N	2025-01-18 16:20:54	2025-01-18 16:20:54	59	3	\N	Receipt Voucher	\N
101	39	2025-01-22	القيود اليومية	100000	0	\N	1	100000	0	30	1	\N	2025-01-22 11:20:52	2025-01-22 11:20:52	59	39	3	Journalizing	\N
102	39	2025-01-22	القيود اليومية	0	100000	\N	1	0	100000	45	1	\N	2025-01-22 11:20:52	2025-01-22 11:20:52	59	39	3	Journalizing	\N
103	40	2025-01-22	المشتريات	4335.00	0	\N	1	4335	0	2500	1	\N	2025-01-22 17:12:32	2025-01-22 17:12:32	59	1	\N	Purchases	\N
104	40	2025-01-22	المشتريات	0	4335.00	\N	1	0	4335	2523	1	\N	2025-01-22 17:12:32	2025-01-22 17:12:32	59	1	\N	Purchases	\N
105	40	2025-01-22	المشتريات	4335.00	0	\N	1	4335	0	2523	1	\N	2025-01-22 17:12:32	2025-01-22 17:12:32	59	1	\N	Purchases	\N
106	40	2025-01-22	المشتريات	0	4335.00	\N	1	0	4335	30	1	\N	2025-01-22 17:12:32	2025-01-22 17:12:32	59	1	\N	Purchases	\N
107	41	2025-01-22	المشتريات	16579.99	0	\N	1	16579.99	0	2500	1	\N	2025-01-22 17:19:33	2025-01-22 17:19:33	59	2	\N	Purchases	\N
108	41	2025-01-22	المشتريات	0	16579.99	\N	1	0	16579.99	2523	1	\N	2025-01-22 17:19:33	2025-01-22 17:19:33	59	2	\N	Purchases	\N
109	41	2025-01-22	المشتريات	16579.99	0	\N	1	16579.99	0	2523	1	\N	2025-01-22 17:19:33	2025-01-22 17:19:33	59	2	\N	Purchases	\N
110	41	2025-01-22	المشتريات	0	16579.99	\N	1	0	16579.99	30	1	\N	2025-01-22 17:19:33	2025-01-22 17:19:33	59	2	\N	Purchases	\N
111	42	2025-01-22	المشتريات	2310.00	0	\N	1	2310	0	2500	1	\N	2025-01-22 17:20:31	2025-01-22 17:20:31	59	3	\N	Purchases	\N
112	42	2025-01-22	المشتريات	0	2310.00	\N	1	0	2310	2523	1	\N	2025-01-22 17:20:31	2025-01-22 17:20:31	59	3	\N	Purchases	\N
113	42	2025-01-22	المشتريات	2310.00	0	\N	1	2310	0	2523	1	\N	2025-01-22 17:20:31	2025-01-22 17:20:31	59	3	\N	Purchases	\N
114	42	2025-01-22	المشتريات	0	2310.00	\N	1	0	2310	30	1	\N	2025-01-22 17:20:31	2025-01-22 17:20:31	59	3	\N	Purchases	\N
115	43	2025-01-22	المشتريات	3555	0	\N	1	3555	0	2500	1	\N	2025-01-22 17:22:47	2025-01-22 17:22:47	59	4	\N	Purchases	\N
116	43	2025-01-22	المشتريات	0	3555	\N	1	0	3555	2523	1	\N	2025-01-22 17:22:47	2025-01-22 17:22:47	59	4	\N	Purchases	\N
117	43	2025-01-22	المشتريات	3555	0	\N	1	3555	0	2523	1	\N	2025-01-22 17:22:47	2025-01-22 17:22:47	59	4	\N	Purchases	\N
118	43	2025-01-22	المشتريات	0	3555	\N	1	0	3555	30	1	\N	2025-01-22 17:22:47	2025-01-22 17:22:47	59	4	\N	Purchases	\N
119	44	2025-01-22	المشتريات	17255	0	\N	1	17255	0	2500	1	\N	2025-01-22 17:27:41	2025-01-22 17:27:41	59	5	\N	Purchases	\N
120	44	2025-01-22	المشتريات	0	17255	\N	1	0	17255	2898	1	\N	2025-01-22 17:27:41	2025-01-22 17:27:41	59	5	\N	Purchases	\N
121	45	2025-01-22	المشتريات	12539	0	\N	1	12539	0	2500	1	\N	2025-01-22 17:37:53	2025-01-22 17:37:53	59	6	\N	Purchases	\N
122	45	2025-01-22	المشتريات	0	12539	\N	1	0	12539	2523	1	\N	2025-01-22 17:37:53	2025-01-22 17:37:53	59	6	\N	Purchases	\N
123	45	2025-01-22	المشتريات	12539	0	\N	1	12539	0	2523	1	\N	2025-01-22 17:37:53	2025-01-22 17:37:53	59	6	\N	Purchases	\N
124	45	2025-01-22	المشتريات	0	12539	\N	1	0	12539	30	1	\N	2025-01-22 17:37:53	2025-01-22 17:37:53	59	6	\N	Purchases	\N
125	46	2025-01-22	المشتريات	10882.45	0	\N	1	10882.45	0	2500	1	\N	2025-01-22 17:50:14	2025-01-22 17:50:14	59	7	\N	Purchases	\N
126	46	2025-01-22	المشتريات	0	10882.45	\N	1	0	10882.45	2523	1	\N	2025-01-22 17:50:14	2025-01-22 17:50:14	59	7	\N	Purchases	\N
127	46	2025-01-22	المشتريات	10882.45	0	\N	1	10882.45	0	2523	1	\N	2025-01-22 17:50:14	2025-01-22 17:50:14	59	7	\N	Purchases	\N
128	46	2025-01-22	المشتريات	0	10882.45	\N	1	0	10882.45	30	1	\N	2025-01-22 17:50:14	2025-01-22 17:50:14	59	7	\N	Purchases	\N
129	47	2025-01-22	المشتريات	6118.98	0	\N	1	6118.98	0	2500	1	\N	2025-01-22 17:55:48	2025-01-22 17:55:48	59	8	\N	Purchases	\N
130	47	2025-01-22	المشتريات	0	6118.98	\N	1	0	6118.98	2523	1	\N	2025-01-22 17:55:48	2025-01-22 17:55:48	59	8	\N	Purchases	\N
131	47	2025-01-22	المشتريات	6118.98	0	\N	1	6118.98	0	2523	1	\N	2025-01-22 17:55:48	2025-01-22 17:55:48	59	8	\N	Purchases	\N
132	47	2025-01-22	المشتريات	0	6118.98	\N	1	0	6118.98	30	1	\N	2025-01-22 17:55:48	2025-01-22 17:55:48	59	8	\N	Purchases	\N
133	48	2025-01-22	المشتريات	846.5	0	\N	1	846.5	0	2500	1	\N	2025-01-22 18:02:28	2025-01-22 18:02:28	59	9	\N	Purchases	\N
134	48	2025-01-22	المشتريات	0	846.5	\N	1	0	846.5	2523	1	\N	2025-01-22 18:02:28	2025-01-22 18:02:28	59	9	\N	Purchases	\N
135	48	2025-01-22	المشتريات	846.5	0	\N	1	846.5	0	2523	1	\N	2025-01-22 18:02:28	2025-01-22 18:02:28	59	9	\N	Purchases	\N
136	48	2025-01-22	المشتريات	0	846.5	\N	1	0	846.5	30	1	\N	2025-01-22 18:02:28	2025-01-22 18:02:28	59	9	\N	Purchases	\N
137	49	2025-01-22	المشتريات	25640	0	\N	1	25640	0	2500	1	\N	2025-01-22 18:07:36	2025-01-22 18:07:36	59	10	\N	Purchases	\N
138	49	2025-01-22	المشتريات	0	25640	\N	1	0	25640	2899	1	\N	2025-01-22 18:07:36	2025-01-22 18:07:36	59	10	\N	Purchases	\N
139	49	2025-01-22	المشتريات	25640	0	\N	1	25640	0	2899	1	\N	2025-01-22 18:07:36	2025-01-22 18:07:36	59	10	\N	Purchases	\N
140	49	2025-01-22	المشتريات	0	25640	\N	1	0	25640	30	1	\N	2025-01-22 18:07:36	2025-01-22 18:07:36	59	10	\N	Purchases	\N
141	50	2025-01-22	القيود اليومية	50000	0	\N	1	50000	0	30	1	\N	2025-01-22 18:10:00	2025-01-22 18:10:00	59	50	\N	Journalizing	\N
142	50	2025-01-22	القيود اليومية	0	50000	\N	1	0	50000	45	1	\N	2025-01-22 18:10:00	2025-01-22 18:10:00	59	50	\N	Journalizing	\N
143	51	2025-01-22	المشتريات	11636.2	0	\N	1	11636.2	0	2500	1	\N	2025-01-22 18:22:36	2025-01-22 18:22:36	59	11	\N	Purchases	\N
144	51	2025-01-22	المشتريات	0	11636.2	\N	1	0	11636.2	2523	1	\N	2025-01-22 18:22:36	2025-01-22 18:22:36	59	11	\N	Purchases	\N
145	51	2025-01-22	المشتريات	11636.2	0	\N	1	11636.2	0	2523	1	\N	2025-01-22 18:22:36	2025-01-22 18:22:36	59	11	\N	Purchases	\N
146	51	2025-01-22	المشتريات	0	11636.2	\N	1	0	11636.2	30	1	\N	2025-01-22 18:22:36	2025-01-22 18:22:36	59	11	\N	Purchases	\N
147	52	2025-01-22	المشتريات	20464.03	0	\N	1	20464.03	0	2500	1	\N	2025-01-22 18:48:51	2025-01-22 18:48:51	59	12	\N	Purchases	\N
148	52	2025-01-22	المشتريات	0	20464.03	\N	1	0	20464.03	2523	1	\N	2025-01-22 18:48:51	2025-01-22 18:48:51	59	12	\N	Purchases	\N
149	52	2025-01-22	المشتريات	20464.03	0	\N	1	20464.03	0	2523	1	\N	2025-01-22 18:48:51	2025-01-22 18:48:51	59	12	\N	Purchases	\N
150	52	2025-01-22	المشتريات	0	20464.03	\N	1	0	20464.03	30	1	\N	2025-01-22 18:48:51	2025-01-22 18:48:51	59	12	\N	Purchases	\N
151	53	2025-01-22	سند صرف	305	0	فاتوره كهرباء	1	305	0	57	1	\N	2025-01-22 19:01:16	2025-01-22 19:01:16	59	2	\N	Payment Voucher	\N
152	53	2025-01-22	سند صرف	0	305	\N	1	0	305	30	1	\N	2025-01-22 19:01:16	2025-01-22 19:01:16	59	2	3	Payment Voucher	\N
153	54	2025-01-23	المشتريات	4248.30	0	\N	1	4248.3	0	2500	1	\N	2025-01-23 14:21:25	2025-01-23 14:21:25	59	13	\N	Purchases	\N
154	54	2025-01-23	المشتريات	0	4248.30	\N	1	0	4248.3	2523	1	\N	2025-01-23 14:21:25	2025-01-23 14:21:25	59	13	\N	Purchases	\N
155	54	2025-01-23	المشتريات	4248.30	0	\N	1	4248.3	0	2523	1	\N	2025-01-23 14:21:25	2025-01-23 14:21:25	59	13	\N	Purchases	\N
156	54	2025-01-23	المشتريات	0	4248.30	\N	1	0	4248.3	30	1	\N	2025-01-23 14:21:25	2025-01-23 14:21:25	59	13	\N	Purchases	\N
157	55	2025-01-23	المشتريات	1380.00	0	\N	1	1380	0	2500	1	\N	2025-01-23 14:45:41	2025-01-23 14:45:41	59	14	\N	Purchases	\N
158	55	2025-01-23	المشتريات	0	1380.00	\N	1	0	1380	2523	1	\N	2025-01-23 14:45:41	2025-01-23 14:45:41	59	14	\N	Purchases	\N
159	55	2025-01-23	المشتريات	1380.00	0	\N	1	1380	0	2523	1	\N	2025-01-23 14:45:41	2025-01-23 14:45:41	59	14	\N	Purchases	\N
160	55	2025-01-23	المشتريات	0	1380.00	\N	1	0	1380	30	1	\N	2025-01-23 14:45:41	2025-01-23 14:45:41	59	14	\N	Purchases	\N
161	56	2025-01-23	المبيعات	465.865	0	\N	1	465.865	0	52	1	\N	2025-01-23 14:47:05	2025-01-23 14:47:05	59	9	\N	Sales	\N
162	56	2025-01-23	المبيعات	0	465.865	\N	1	0	465.865	2500	1	\N	2025-01-23 14:47:05	2025-01-23 14:47:05	59	9	\N	Sales	\N
163	56	2025-01-23	المبيعات	630	0	\N	1	630	0	2923	1	\N	2025-01-23 14:47:05	2025-01-23 14:47:05	59	9	\N	Sales	\N
164	56	2025-01-23	المبيعات	0	630.00	\N	1	0	630	48	1	\N	2025-01-23 14:47:05	2025-01-23 14:47:05	59	9	\N	Sales	\N
165	57	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 14:47:05	2025-01-23 14:47:05	59	9	\N	Commission Entitlement	\N
166	57	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 14:47:05	2025-01-23 14:47:05	59	9	\N	Commission Entitlement	\N
167	58	2025-01-23	المشتريات	20740	0	\N	1	20740	0	2500	1	\N	2025-01-23 15:09:53	2025-01-23 15:09:53	59	15	\N	Purchases	\N
168	58	2025-01-23	المشتريات	0	20740	\N	1	0	20740	2931	1	\N	2025-01-23 15:09:53	2025-01-23 15:09:53	59	15	\N	Purchases	\N
169	58	2025-01-23	المشتريات	20740	0	\N	1	20740	0	2931	1	\N	2025-01-23 15:09:53	2025-01-23 15:09:53	59	15	\N	Purchases	\N
170	58	2025-01-23	المشتريات	0	20740	\N	1	0	20740	30	1	\N	2025-01-23 15:09:53	2025-01-23 15:09:53	59	15	\N	Purchases	\N
171	59	2025-01-23	المبيعات	7309.54	0	\N	1	7309.54	0	52	1	\N	2025-01-23 15:26:14	2025-01-23 15:26:14	59	10	\N	Sales	\N
172	59	2025-01-23	المبيعات	0	7309.54	\N	1	0	7309.54	2500	1	\N	2025-01-23 15:26:14	2025-01-23 15:26:14	59	10	\N	Sales	\N
173	59	2025-01-23	المبيعات	10407	0	\N	1	10407	0	2771	1	\N	2025-01-23 15:26:14	2025-01-23 15:26:14	59	10	\N	Sales	\N
174	59	2025-01-23	المبيعات	0	10407.00	\N	1	0	10407	48	1	\N	2025-01-23 15:26:14	2025-01-23 15:26:14	59	10	\N	Sales	\N
175	60	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 15:26:14	2025-01-23 15:26:14	59	10	\N	Commission Entitlement	\N
176	60	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 15:26:14	2025-01-23 15:26:14	59	10	\N	Commission Entitlement	\N
177	61	2025-01-23	المشتريات	300.00	0	\N	1	300	0	2500	1	\N	2025-01-23 15:33:26	2025-01-23 15:33:26	59	16	\N	Purchases	\N
178	61	2025-01-23	المشتريات	0	300.00	\N	1	0	300	2523	1	\N	2025-01-23 15:33:26	2025-01-23 15:33:26	59	16	\N	Purchases	\N
179	61	2025-01-23	المشتريات	300.00	0	\N	1	300	0	2523	1	\N	2025-01-23 15:33:26	2025-01-23 15:33:26	59	16	\N	Purchases	\N
180	61	2025-01-23	المشتريات	0	300.00	\N	1	0	300	30	1	\N	2025-01-23 15:33:26	2025-01-23 15:33:26	59	16	\N	Purchases	\N
189	64	2025-01-23	المبيعات	590	0	\N	1	590	0	52	1	\N	2025-01-23 15:49:10	2025-01-23 15:49:10	59	12	\N	Sales	\N
190	64	2025-01-23	المبيعات	0	590	\N	1	0	590	2500	1	\N	2025-01-23 15:49:10	2025-01-23 15:49:10	59	12	\N	Sales	\N
191	64	2025-01-23	المبيعات	710	0	\N	1	710	0	2922	1	\N	2025-01-23 15:49:10	2025-01-23 15:49:10	59	12	\N	Sales	\N
192	64	2025-01-23	المبيعات	0	710.00	\N	1	0	710	48	1	\N	2025-01-23 15:49:10	2025-01-23 15:49:10	59	12	\N	Sales	\N
193	65	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 15:49:10	2025-01-23 15:49:10	59	12	\N	Commission Entitlement	\N
194	65	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 15:49:10	2025-01-23 15:49:10	59	12	\N	Commission Entitlement	\N
195	66	2025-01-23	المبيعات	46	0	\N	1	46	0	52	1	\N	2025-01-23 15:56:20	2025-01-23 15:56:20	59	13	\N	Sales	\N
196	66	2025-01-23	المبيعات	0	46	\N	1	0	46	2500	1	\N	2025-01-23 15:56:20	2025-01-23 15:56:20	59	13	\N	Sales	\N
197	66	2025-01-23	المبيعات	90	0	\N	1	90	0	2770	1	\N	2025-01-23 15:56:20	2025-01-23 15:56:20	59	13	\N	Sales	\N
198	66	2025-01-23	المبيعات	0	90.00	\N	1	0	90	48	1	\N	2025-01-23 15:56:20	2025-01-23 15:56:20	59	13	\N	Sales	\N
199	67	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 15:56:20	2025-01-23 15:56:20	59	13	\N	Commission Entitlement	\N
200	67	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 15:56:20	2025-01-23 15:56:20	59	13	\N	Commission Entitlement	\N
201	68	2025-01-23	المبيعات	410	0	\N	1	410	0	52	1	\N	2025-01-23 15:58:32	2025-01-23 15:58:32	59	14	\N	Sales	\N
202	68	2025-01-23	المبيعات	0	410	\N	1	0	410	2500	1	\N	2025-01-23 15:58:32	2025-01-23 15:58:32	59	14	\N	Sales	\N
203	68	2025-01-23	المبيعات	520	0	\N	1	520	0	2921	1	\N	2025-01-23 15:58:32	2025-01-23 15:58:32	59	14	\N	Sales	\N
204	68	2025-01-23	المبيعات	0	520.00	\N	1	0	520	48	1	\N	2025-01-23 15:58:32	2025-01-23 15:58:32	59	14	\N	Sales	\N
205	69	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 15:58:32	2025-01-23 15:58:32	59	14	\N	Commission Entitlement	\N
206	69	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 15:58:32	2025-01-23 15:58:32	59	14	\N	Commission Entitlement	\N
207	70	2025-01-23	المبيعات	1792.52	0	\N	1	1792.52	0	52	1	\N	2025-01-23 16:10:31	2025-01-23 16:10:31	59	15	\N	Sales	\N
208	70	2025-01-23	المبيعات	0	1792.52	\N	1	0	1792.52	2500	1	\N	2025-01-23 16:10:31	2025-01-23 16:10:31	59	15	\N	Sales	\N
209	70	2025-01-23	المبيعات	2489	0	\N	1	2489	0	2782	1	\N	2025-01-23 16:10:31	2025-01-23 16:10:31	59	15	\N	Sales	\N
210	70	2025-01-23	المبيعات	0	2489.00	\N	1	0	2489	48	1	\N	2025-01-23 16:10:31	2025-01-23 16:10:31	59	15	\N	Sales	\N
211	71	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 16:10:31	2025-01-23 16:10:31	59	15	\N	Commission Entitlement	\N
212	71	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 16:10:31	2025-01-23 16:10:31	59	15	\N	Commission Entitlement	\N
213	72	2025-01-23	المبيعات	2492.57	0	\N	1	2492.57	0	52	1	\N	2025-01-23 16:47:22	2025-01-23 16:47:22	59	16	\N	Sales	\N
214	72	2025-01-23	المبيعات	0	2492.57	\N	1	0	2492.57	2500	1	\N	2025-01-23 16:47:22	2025-01-23 16:47:22	59	16	\N	Sales	\N
215	72	2025-01-23	المبيعات	3731	0	\N	1	3731	0	2789	1	\N	2025-01-23 16:47:22	2025-01-23 16:47:22	59	16	\N	Sales	\N
216	72	2025-01-23	المبيعات	0	3731.00	\N	1	0	3731	48	1	\N	2025-01-23 16:47:22	2025-01-23 16:47:22	59	16	\N	Sales	\N
217	73	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 16:47:22	2025-01-23 16:47:22	59	16	\N	Commission Entitlement	\N
218	73	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 16:47:22	2025-01-23 16:47:22	59	16	\N	Commission Entitlement	\N
221	75	2025-01-23	القيود اليومية	18000	0	\N	1	18000	0	30	1	\N	2025-01-23 17:49:20	2025-01-23 17:49:20	59	75	\N	Journalizing	\N
222	75	2025-01-23	القيود اليومية	0	18000	\N	1	0	18000	45	1	\N	2025-01-23 17:49:20	2025-01-23 17:49:20	59	75	\N	Journalizing	\N
223	76	2025-01-23	سند صرف	18000	0	تحويل للمهندس للبرنامج	1	18000	0	854	1	\N	2025-01-23 17:50:44	2025-01-23 17:50:44	59	4	\N	Payment Voucher	\N
224	76	2025-01-23	سند صرف	0	18000	\N	1	0	18000	30	1	\N	2025-01-23 17:50:44	2025-01-23 17:50:44	59	4	3	Payment Voucher	\N
225	77	2025-01-23	المبيعات	1094.09	0	\N	1	1094.09	0	52	1	\N	2025-01-23 18:02:00	2025-01-23 18:02:00	59	17	\N	Sales	\N
226	77	2025-01-23	المبيعات	0	1094.09	\N	1	0	1094.09	2500	1	\N	2025-01-23 18:02:00	2025-01-23 18:02:00	59	17	\N	Sales	\N
227	77	2025-01-23	المبيعات	1968	0	\N	1	1968	0	2927	1	\N	2025-01-23 18:02:00	2025-01-23 18:02:00	59	17	\N	Sales	\N
228	77	2025-01-23	المبيعات	0	1968.00	\N	1	0	1968	48	1	\N	2025-01-23 18:02:00	2025-01-23 18:02:00	59	17	\N	Sales	\N
229	78	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 18:02:00	2025-01-23 18:02:00	59	17	\N	Commission Entitlement	\N
230	78	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 18:02:00	2025-01-23 18:02:00	59	17	\N	Commission Entitlement	\N
231	79	2025-01-23	المبيعات	7048.2	0	\N	1	7048.2	0	52	1	\N	2025-01-23 18:12:07	2025-01-23 18:12:07	59	18	\N	Sales	\N
232	79	2025-01-23	المبيعات	0	7048.2	\N	1	0	7048.2	2500	1	\N	2025-01-23 18:12:07	2025-01-23 18:12:07	59	18	\N	Sales	\N
233	79	2025-01-23	المبيعات	9058	0	\N	1	9058	0	2935	1	\N	2025-01-23 18:12:07	2025-01-23 18:12:07	59	18	\N	Sales	\N
234	79	2025-01-23	المبيعات	0	9058.00	\N	1	0	9058	48	1	\N	2025-01-23 18:12:07	2025-01-23 18:12:07	59	18	\N	Sales	\N
235	80	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 18:12:07	2025-01-23 18:12:07	59	18	\N	Commission Entitlement	\N
236	80	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 18:12:07	2025-01-23 18:12:07	59	18	\N	Commission Entitlement	\N
237	81	2025-01-23	المبيعات	1369.16	0	\N	1	1369.16	0	52	1	\N	2025-01-23 18:23:16	2025-01-23 18:23:16	59	19	\N	Sales	\N
238	81	2025-01-23	المبيعات	0	1369.16	\N	1	0	1369.16	2500	1	\N	2025-01-23 18:23:16	2025-01-23 18:23:16	59	19	\N	Sales	\N
239	81	2025-01-23	المبيعات	2140	0	\N	1	2140	0	2784	1	\N	2025-01-23 18:23:16	2025-01-23 18:23:16	59	19	\N	Sales	\N
240	81	2025-01-23	المبيعات	0	2140.00	\N	1	0	2140	48	1	\N	2025-01-23 18:23:16	2025-01-23 18:23:16	59	19	\N	Sales	\N
241	82	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 18:23:16	2025-01-23 18:23:16	59	19	\N	Commission Entitlement	\N
242	82	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 18:23:16	2025-01-23 18:23:16	59	19	\N	Commission Entitlement	\N
243	83	2025-01-23	المبيعات	604.26	0	\N	1	604.26	0	52	1	\N	2025-01-23 18:43:13	2025-01-23 18:43:13	59	20	\N	Sales	\N
244	83	2025-01-23	المبيعات	0	604.26	\N	1	0	604.26	2500	1	\N	2025-01-23 18:43:13	2025-01-23 18:43:13	59	20	\N	Sales	\N
245	83	2025-01-23	المبيعات	1075	0	\N	1	1075	0	2783	1	\N	2025-01-23 18:43:14	2025-01-23 18:43:14	59	20	\N	Sales	\N
246	83	2025-01-23	المبيعات	0	1075.00	\N	1	0	1075	48	1	\N	2025-01-23 18:43:14	2025-01-23 18:43:14	59	20	\N	Sales	\N
247	84	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-23 18:43:14	2025-01-23 18:43:14	59	20	\N	Commission Entitlement	\N
248	84	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-23 18:43:14	2025-01-23 18:43:14	59	20	\N	Commission Entitlement	\N
249	1	2025-01-25	سلفه موظف	500	0	\N	1	500	0	2860	1	\N	2025-01-25 12:41:37	2025-01-25 12:41:37	59	1	\N	Employee Borrow	\N
250	1	2025-01-25	سلفه موظف	0	500	\N	1	0	500	30	1	\N	2025-01-25 12:41:37	2025-01-25 12:41:37	59	1	\N	Employee Borrow	\N
251	1	2025-01-25	سلفه موظف	5000	0	\N	1	5000	0	2836	1	\N	2025-01-25 12:43:35	2025-01-25 12:43:35	59	2	\N	Employee Borrow	\N
252	1	2025-01-25	سلفه موظف	0	5000	\N	1	0	5000	30	1	\N	2025-01-25 12:43:35	2025-01-25 12:43:35	59	2	\N	Employee Borrow	\N
253	87	2025-01-25	القيود اليومية	74701	0	تحصيل فاتوره	1	74701	0	30	1	\N	2025-01-25 12:50:26	2025-01-25 12:50:26	59	87	\N	Journalizing	\N
254	87	2025-01-25	القيود اليومية	0	74701	تحصيل فاتوره	1	0	74701	45	1	\N	2025-01-25 12:50:26	2025-01-25 12:50:26	59	87	\N	Journalizing	\N
257	1	2025-01-25	سلفه موظف	20000	0	\N	1	20000	0	2848	1	\N	2025-01-25 13:18:36	2025-01-25 13:18:36	59	4	\N	Employee Borrow	\N
258	1	2025-01-25	سلفه موظف	0	20000	\N	1	0	20000	30	1	\N	2025-01-25 13:18:36	2025-01-25 13:18:36	59	4	\N	Employee Borrow	\N
259	1	2025-01-25	سلفه موظف	21501	0	\N	1	21501	0	2844	1	\N	2025-01-25 13:22:01	2025-01-25 13:22:01	59	5	\N	Employee Borrow	\N
260	1	2025-01-25	سلفه موظف	0	21501	\N	1	0	21501	30	1	\N	2025-01-25 13:22:01	2025-01-25 13:22:01	59	5	\N	Employee Borrow	\N
261	91	2025-01-23	المبيعات	0	0	\N	1	0	0	52	1	\N	2025-01-25 14:21:47	2025-01-25 14:21:47	59	21	\N	Sales	\N
262	91	2025-01-23	المبيعات	0	0	\N	1	0	0	2500	1	\N	2025-01-25 14:21:47	2025-01-25 14:21:47	59	21	\N	Sales	\N
263	91	2025-01-23	المبيعات	350	0	\N	1	350	0	2722	1	\N	2025-01-25 14:21:47	2025-01-25 14:21:47	59	21	\N	Sales	\N
264	91	2025-01-23	المبيعات	0	350.00	\N	1	0	350	48	1	\N	2025-01-25 14:21:47	2025-01-25 14:21:47	59	21	\N	Sales	\N
265	92	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-25 14:21:47	2025-01-25 14:21:47	59	21	\N	Commission Entitlement	\N
266	92	2025-01-23	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-25 14:21:47	2025-01-25 14:21:47	59	21	\N	Commission Entitlement	\N
269	94	2025-01-25	المبيعات	34257	0	\N	1	34257	0	52	1	\N	2025-01-25 14:49:31	2025-01-25 14:49:31	59	22	\N	Sales	\N
270	94	2025-01-25	المبيعات	0	34257	\N	1	0	34257	2500	1	\N	2025-01-25 14:49:31	2025-01-25 14:49:31	59	22	\N	Sales	\N
271	94	2025-01-25	المبيعات	36060	0	\N	1	36060	0	2690	1	\N	2025-01-25 14:49:31	2025-01-25 14:49:31	59	22	\N	Sales	\N
272	94	2025-01-25	المبيعات	0	36060.00	\N	1	0	36060	48	1	\N	2025-01-25 14:49:31	2025-01-25 14:49:31	59	22	\N	Sales	\N
273	95	2025-01-25	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-25 14:49:31	2025-01-25 14:49:31	59	22	\N	Commission Entitlement	\N
274	95	2025-01-25	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-25 14:49:31	2025-01-25 14:49:31	59	22	\N	Commission Entitlement	\N
275	96	2025-01-25	اصناف بداية فترة	36822	0	\N	1	36822	0	2500	1	\N	2025-01-25 17:49:23	2025-01-25 17:49:23	59	11	\N	Start Period Products	\N
276	96	2025-01-25	اصناف بداية فترة	0	36822	\N	1	0	36822	45	1	\N	2025-01-25 17:49:23	2025-01-25 17:49:23	59	11	\N	Start Period Products	\N
277	97	2025-01-25	المبيعات	34257	0	\N	1	34257	0	52	1	\N	2025-01-25 18:00:02	2025-01-25 18:00:02	59	23	\N	Sales	\N
278	97	2025-01-25	المبيعات	0	34257	\N	1	0	34257	2500	1	\N	2025-01-25 18:00:02	2025-01-25 18:00:02	59	23	\N	Sales	\N
279	97	2025-01-25	المبيعات	36060	0	\N	1	36060	0	2690	1	\N	2025-01-25 18:00:02	2025-01-25 18:00:02	59	23	\N	Sales	\N
280	97	2025-01-25	المبيعات	0	36060.00	\N	1	0	36060	48	1	\N	2025-01-25 18:00:02	2025-01-25 18:00:02	59	23	\N	Sales	\N
281	98	2025-01-25	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-25 18:00:02	2025-01-25 18:00:02	59	23	\N	Commission Entitlement	\N
282	98	2025-01-25	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-25 18:00:02	2025-01-25 18:00:02	59	23	\N	Commission Entitlement	\N
283	99	2025-01-25	سند قبض	0	36060	\N	1	0	36060	2690	1	\N	2025-01-25 18:16:42	2025-01-25 18:16:42	1	4	\N	Receipt Voucher	\N
284	99	2025-01-25	سند قبض	36060	0	\N	1	36060	0	30	1	\N	2025-01-25 18:16:42	2025-01-25 18:16:42	1	4	\N	Receipt Voucher	\N
285	100	2025-01-25	مرتجع بدون فاتورة	36060.00	0	\N	1	36060	0	49	1	\N	2025-01-25 18:23:47	2025-01-25 18:23:47	1	1	\N	Return Without Bill	\N
286	100	2025-01-25	مرتجع بدون فاتورة	0	36060.00	\N	1	0	36060	2690	1	\N	2025-01-25 18:23:47	2025-01-25 18:23:47	1	1	\N	Return Without Bill	\N
287	100	2025-01-25	مرتجع بدون فاتورة	34257	0	\N	1	34257	0	2500	1	\N	2025-01-25 18:23:47	2025-01-25 18:23:47	1	1	\N	Return Without Bill	\N
288	100	2025-01-25	مرتجع بدون فاتورة	0	34257	\N	1	0	34257	52	1	\N	2025-01-25 18:23:47	2025-01-25 18:23:47	1	1	\N	Return Without Bill	\N
289	100	2025-01-25	مرتجع بدون فاتورة	36060.00	0	\N	1	36060	0	2690	1	\N	2025-01-25 18:23:47	2025-01-25 18:23:47	1	1	\N	Return Without Bill	\N
290	100	2025-01-25	مرتجع بدون فاتورة	0	36060.00	\N	1	0	36060	30	1	\N	2025-01-25 18:23:47	2025-01-25 18:23:47	1	1	\N	Return Without Bill	\N
291	101	2025-01-26	المشتريات	4599.94	0	\N	1	4599.94	0	2500	1	\N	2025-01-26 12:24:44	2025-01-26 12:24:44	59	18	\N	Purchases	\N
292	101	2025-01-26	المشتريات	0	4599.94	\N	1	0	4599.94	2898	1	\N	2025-01-26 12:24:44	2025-01-26 12:24:44	59	18	\N	Purchases	\N
293	102	2025-01-26	المبيعات	620	0	\N	1	620	0	52	1	\N	2025-01-26 12:32:46	2025-01-26 12:32:46	59	24	\N	Sales	\N
294	102	2025-01-26	المبيعات	0	620	\N	1	0	620	2500	1	\N	2025-01-26 12:32:46	2025-01-26 12:32:46	59	24	\N	Sales	\N
295	102	2025-01-26	المبيعات	760	0	\N	1	760	0	2780	1	\N	2025-01-26 12:32:46	2025-01-26 12:32:46	59	24	\N	Sales	\N
296	102	2025-01-26	المبيعات	0	760.00	\N	1	0	760	48	1	\N	2025-01-26 12:32:46	2025-01-26 12:32:46	59	24	\N	Sales	\N
297	103	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 12:32:46	2025-01-26 12:32:46	59	24	\N	Commission Entitlement	\N
298	103	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 12:32:46	2025-01-26 12:32:46	59	24	\N	Commission Entitlement	\N
301	105	2025-01-26	سند صرف	800	0	شراء كالون + قلب كالون	1	800	0	2497	1	\N	2025-01-26 15:23:25	2025-01-26 15:23:25	59	6	\N	Payment Voucher	\N
302	105	2025-01-26	سند صرف	0	800	\N	1	0	800	30	1	\N	2025-01-26 15:23:25	2025-01-26 15:23:25	59	6	3	Payment Voucher	\N
303	106	2025-01-26	المشتريات	15.00	0	\N	1	15	0	2500	1	\N	2025-01-26 15:25:28	2025-01-26 15:25:28	59	19	\N	Purchases	\N
304	106	2025-01-26	المشتريات	0	15.00	\N	1	0	15	2523	1	\N	2025-01-26 15:25:28	2025-01-26 15:25:28	59	19	\N	Purchases	\N
305	106	2025-01-26	المشتريات	15.00	0	\N	1	15	0	2523	1	\N	2025-01-26 15:25:28	2025-01-26 15:25:28	59	19	\N	Purchases	\N
306	106	2025-01-26	المشتريات	0	15.00	\N	1	0	15	30	1	\N	2025-01-26 15:25:28	2025-01-26 15:25:28	59	19	\N	Purchases	\N
307	107	2025-01-26	المشتريات	100.00	0	\N	1	100	0	2500	1	\N	2025-01-26 15:33:57	2025-01-26 15:33:57	59	20	\N	Purchases	\N
308	107	2025-01-26	المشتريات	0	100.00	\N	1	0	100	2523	1	\N	2025-01-26 15:33:57	2025-01-26 15:33:57	59	20	\N	Purchases	\N
309	107	2025-01-26	المشتريات	100.00	0	\N	1	100	0	2523	1	\N	2025-01-26 15:33:57	2025-01-26 15:33:57	59	20	\N	Purchases	\N
310	107	2025-01-26	المشتريات	0	100.00	\N	1	0	100	30	1	\N	2025-01-26 15:33:57	2025-01-26 15:33:57	59	20	\N	Purchases	\N
311	108	2025-01-26	المبيعات	781.08	0	\N	1	781.08	0	52	1	\N	2025-01-26 15:34:58	2025-01-26 15:34:58	59	25	\N	Sales	\N
312	108	2025-01-26	المبيعات	0	781.08	\N	1	0	781.08	2500	1	\N	2025-01-26 15:34:58	2025-01-26 15:34:58	59	25	\N	Sales	\N
313	108	2025-01-26	المبيعات	1002	0	\N	1	1002	0	2672	1	\N	2025-01-26 15:34:58	2025-01-26 15:34:58	59	25	\N	Sales	\N
314	108	2025-01-26	المبيعات	0	1002.00	\N	1	0	1002	48	1	\N	2025-01-26 15:34:58	2025-01-26 15:34:58	59	25	\N	Sales	\N
315	109	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 15:34:58	2025-01-26 15:34:58	59	25	\N	Commission Entitlement	\N
316	109	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 15:34:58	2025-01-26 15:34:58	59	25	\N	Commission Entitlement	\N
317	110	2025-01-26	المبيعات	10749.5	0	\N	1	10749.5	0	52	1	\N	2025-01-26 15:42:16	2025-01-26 15:42:16	59	26	\N	Sales	\N
318	110	2025-01-26	المبيعات	0	10749.5	\N	1	0	10749.5	2500	1	\N	2025-01-26 15:42:16	2025-01-26 15:42:16	59	26	\N	Sales	\N
319	110	2025-01-26	المبيعات	12750	0	\N	1	12750	0	2683	1	\N	2025-01-26 15:42:16	2025-01-26 15:42:16	59	26	\N	Sales	\N
320	110	2025-01-26	المبيعات	0	12750.00	\N	1	0	12750	48	1	\N	2025-01-26 15:42:16	2025-01-26 15:42:16	59	26	\N	Sales	\N
321	111	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 15:42:16	2025-01-26 15:42:16	59	26	\N	Commission Entitlement	\N
322	111	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 15:42:16	2025-01-26 15:42:16	59	26	\N	Commission Entitlement	\N
323	112	2025-01-26	المبيعات	4738.07	0	\N	1	4738.07	0	52	1	\N	2025-01-26 16:54:16	2025-01-26 16:54:16	59	27	\N	Sales	\N
324	112	2025-01-26	المبيعات	0	4738.07	\N	1	0	4738.07	2500	1	\N	2025-01-26 16:54:16	2025-01-26 16:54:16	59	27	\N	Sales	\N
325	112	2025-01-26	المبيعات	8560	0	\N	1	8560	0	2606	1	\N	2025-01-26 16:54:16	2025-01-26 16:54:16	59	27	\N	Sales	\N
326	112	2025-01-26	المبيعات	0	8560.00	\N	1	0	8560	48	1	\N	2025-01-26 16:54:16	2025-01-26 16:54:16	59	27	\N	Sales	\N
327	113	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 16:54:16	2025-01-26 16:54:16	59	27	\N	Commission Entitlement	\N
328	113	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 16:54:16	2025-01-26 16:54:16	59	27	\N	Commission Entitlement	\N
329	114	2025-01-26	المشتريات	3500.00	0	\N	1	3500	0	2500	1	\N	2025-01-26 17:23:13	2025-01-26 17:23:13	59	21	\N	Purchases	\N
330	114	2025-01-26	المشتريات	0	3500.00	\N	1	0	3500	2938	1	\N	2025-01-26 17:23:13	2025-01-26 17:23:13	59	21	\N	Purchases	\N
331	114	2025-01-26	المشتريات	3500.00	0	\N	1	3500	0	2938	1	\N	2025-01-26 17:23:13	2025-01-26 17:23:13	59	21	\N	Purchases	\N
332	114	2025-01-26	المشتريات	0	3500.00	\N	1	0	3500	30	1	\N	2025-01-26 17:23:13	2025-01-26 17:23:13	59	21	\N	Purchases	\N
333	115	2025-01-26	المبيعات	7043.36	0	\N	1	7043.36	0	52	1	\N	2025-01-26 17:31:54	2025-01-26 17:31:54	59	28	\N	Sales	\N
334	115	2025-01-26	المبيعات	0	7043.36	\N	1	0	7043.36	2500	1	\N	2025-01-26 17:31:54	2025-01-26 17:31:54	59	28	\N	Sales	\N
335	115	2025-01-26	المبيعات	9320	0	\N	1	9320	0	2635	1	\N	2025-01-26 17:31:54	2025-01-26 17:31:54	59	28	\N	Sales	\N
336	115	2025-01-26	المبيعات	0	9320.00	\N	1	0	9320	48	1	\N	2025-01-26 17:31:54	2025-01-26 17:31:54	59	28	\N	Sales	\N
337	116	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 17:31:54	2025-01-26 17:31:54	59	28	\N	Commission Entitlement	\N
338	116	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 17:31:54	2025-01-26 17:31:54	59	28	\N	Commission Entitlement	\N
339	117	2025-01-26	المبيعات	205	0	\N	1	205	0	52	1	\N	2025-01-26 17:33:08	2025-01-26 17:33:08	59	29	\N	Sales	\N
340	117	2025-01-26	المبيعات	0	205	\N	1	0	205	2500	1	\N	2025-01-26 17:33:08	2025-01-26 17:33:08	59	29	\N	Sales	\N
341	117	2025-01-26	المبيعات	260	0	\N	1	260	0	2647	1	\N	2025-01-26 17:33:08	2025-01-26 17:33:08	59	29	\N	Sales	\N
342	117	2025-01-26	المبيعات	0	260.00	\N	1	0	260	48	1	\N	2025-01-26 17:33:08	2025-01-26 17:33:08	59	29	\N	Sales	\N
343	118	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 17:33:08	2025-01-26 17:33:08	59	29	\N	Commission Entitlement	\N
344	118	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 17:33:08	2025-01-26 17:33:08	59	29	\N	Commission Entitlement	\N
345	119	2025-01-26	المبيعات	1580	0	\N	1	1580	0	52	1	\N	2025-01-26 17:34:18	2025-01-26 17:34:18	59	30	\N	Sales	\N
346	119	2025-01-26	المبيعات	0	1580	\N	1	0	1580	2500	1	\N	2025-01-26 17:34:18	2025-01-26 17:34:18	59	30	\N	Sales	\N
347	119	2025-01-26	المبيعات	1800	0	\N	1	1800	0	2809	1	\N	2025-01-26 17:34:18	2025-01-26 17:34:18	59	30	\N	Sales	\N
348	119	2025-01-26	المبيعات	0	1800.00	\N	1	0	1800	48	1	\N	2025-01-26 17:34:18	2025-01-26 17:34:18	59	30	\N	Sales	\N
349	120	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 17:34:18	2025-01-26 17:34:18	59	30	\N	Commission Entitlement	\N
350	120	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 17:34:18	2025-01-26 17:34:18	59	30	\N	Commission Entitlement	\N
351	121	2025-01-26	المشتريات	205.00	0	\N	1	205	0	2500	1	\N	2025-01-26 17:43:58	2025-01-26 17:43:58	59	22	\N	Purchases	\N
352	121	2025-01-26	المشتريات	0	205.00	\N	1	0	205	2523	1	\N	2025-01-26 17:43:58	2025-01-26 17:43:58	59	22	\N	Purchases	\N
353	121	2025-01-26	المشتريات	205.00	0	\N	1	205	0	2523	1	\N	2025-01-26 17:43:58	2025-01-26 17:43:58	59	22	\N	Purchases	\N
354	121	2025-01-26	المشتريات	0	205.00	\N	1	0	205	30	1	\N	2025-01-26 17:43:58	2025-01-26 17:43:58	59	22	\N	Purchases	\N
363	124	2025-01-26	المبيعات	31427.92	0	\N	1	31427.92	0	52	1	\N	2025-01-26 18:03:58	2025-01-26 18:03:58	59	32	\N	Sales	\N
364	124	2025-01-26	المبيعات	0	31427.92	\N	1	0	31427.92	2500	1	\N	2025-01-26 18:03:58	2025-01-26 18:03:58	59	32	\N	Sales	\N
365	124	2025-01-26	المبيعات	35105	0	\N	1	35105	0	2940	1	\N	2025-01-26 18:03:58	2025-01-26 18:03:58	59	32	\N	Sales	\N
366	124	2025-01-26	المبيعات	0	35105.00	\N	1	0	35105	48	1	\N	2025-01-26 18:03:58	2025-01-26 18:03:58	59	32	\N	Sales	\N
367	125	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 18:03:58	2025-01-26 18:03:58	59	32	\N	Commission Entitlement	\N
368	125	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 18:03:58	2025-01-26 18:03:58	59	32	\N	Commission Entitlement	\N
369	126	2025-01-26	المبيعات	1843.85	0	\N	1	1843.85	0	52	1	\N	2025-01-26 18:08:57	2025-01-26 18:08:57	59	33	\N	Sales	\N
370	126	2025-01-26	المبيعات	0	1843.85	\N	1	0	1843.85	2500	1	\N	2025-01-26 18:08:57	2025-01-26 18:08:57	59	33	\N	Sales	\N
371	126	2025-01-26	المبيعات	2285	0	\N	1	2285	0	2941	1	\N	2025-01-26 18:08:57	2025-01-26 18:08:57	59	33	\N	Sales	\N
372	126	2025-01-26	المبيعات	0	2285.00	\N	1	0	2285	48	1	\N	2025-01-26 18:08:57	2025-01-26 18:08:57	59	33	\N	Sales	\N
373	127	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 18:08:57	2025-01-26 18:08:57	59	33	\N	Commission Entitlement	\N
374	127	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 18:08:57	2025-01-26 18:08:57	59	33	\N	Commission Entitlement	\N
375	128	2025-01-26	المبيعات	3312.32	0	\N	1	3312.32	0	52	1	\N	2025-01-26 18:16:47	2025-01-26 18:16:47	59	34	\N	Sales	\N
376	128	2025-01-26	المبيعات	0	3312.32	\N	1	0	3312.32	2500	1	\N	2025-01-26 18:16:47	2025-01-26 18:16:47	59	34	\N	Sales	\N
377	128	2025-01-26	المبيعات	3860	0	\N	1	3860	0	2814	1	\N	2025-01-26 18:16:47	2025-01-26 18:16:47	59	34	\N	Sales	\N
378	128	2025-01-26	المبيعات	0	3860.00	\N	1	0	3860	48	1	\N	2025-01-26 18:16:47	2025-01-26 18:16:47	59	34	\N	Sales	\N
379	129	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-26 18:16:47	2025-01-26 18:16:47	59	34	\N	Commission Entitlement	\N
380	129	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-26 18:16:47	2025-01-26 18:16:47	59	34	\N	Commission Entitlement	\N
387	132	2025-01-25	المشتريات	20975.04	0	\N	1	20975.04	0	2500	1	\N	2025-01-26 18:52:55	2025-01-26 18:52:55	59	23	\N	Purchases	\N
388	132	2025-01-25	المشتريات	0	20975.04	\N	1	0	20975.04	2898	1	\N	2025-01-26 18:52:55	2025-01-26 18:52:55	59	23	\N	Purchases	\N
389	133	2025-01-27	المشتريات	2440	0	\N	1	2440	0	2500	1	\N	2025-01-27 11:35:59	2025-01-27 11:35:59	59	24	\N	Purchases	\N
390	133	2025-01-27	المشتريات	0	2440	\N	1	0	2440	2523	1	\N	2025-01-27 11:35:59	2025-01-27 11:35:59	59	24	\N	Purchases	\N
391	133	2025-01-27	المشتريات	2440	0	\N	1	2440	0	2523	1	\N	2025-01-27 11:35:59	2025-01-27 11:35:59	59	24	\N	Purchases	\N
392	133	2025-01-27	المشتريات	0	2440	\N	1	0	2440	30	1	\N	2025-01-27 11:35:59	2025-01-27 11:35:59	59	24	\N	Purchases	\N
393	134	2025-01-27	المشتريات	5600.00	0	\N	1	5600	0	2500	1	\N	2025-01-27 11:39:25	2025-01-27 11:39:25	59	25	\N	Purchases	\N
394	134	2025-01-27	المشتريات	0	5600.00	\N	1	0	5600	2899	1	\N	2025-01-27 11:39:25	2025-01-27 11:39:25	59	25	\N	Purchases	\N
395	134	2025-01-27	المشتريات	5600.00	0	\N	1	5600	0	2899	1	\N	2025-01-27 11:39:25	2025-01-27 11:39:25	59	25	\N	Purchases	\N
396	134	2025-01-27	المشتريات	0	5600.00	\N	1	0	5600	30	1	\N	2025-01-27 11:39:25	2025-01-27 11:39:25	59	25	\N	Purchases	\N
397	135	2025-01-27	المشتريات	535	0	\N	1	535	0	2500	1	\N	2025-01-27 11:44:53	2025-01-27 11:44:53	59	26	\N	Purchases	\N
398	135	2025-01-27	المشتريات	0	535	\N	1	0	535	2523	1	\N	2025-01-27 11:44:53	2025-01-27 11:44:53	59	26	\N	Purchases	\N
399	135	2025-01-27	المشتريات	535	0	\N	1	535	0	2523	1	\N	2025-01-27 11:44:53	2025-01-27 11:44:53	59	26	\N	Purchases	\N
400	135	2025-01-27	المشتريات	0	535	\N	1	0	535	30	1	\N	2025-01-27 11:44:53	2025-01-27 11:44:53	59	26	\N	Purchases	\N
401	136	2025-01-27	المبيعات	535	0	\N	1	535	0	52	1	\N	2025-01-27 11:48:15	2025-01-27 11:48:15	59	36	\N	Sales	\N
402	136	2025-01-27	المبيعات	0	535	\N	1	0	535	2500	1	\N	2025-01-27 11:48:15	2025-01-27 11:48:15	59	36	\N	Sales	\N
403	136	2025-01-27	المبيعات	585	0	\N	1	585	0	2607	1	\N	2025-01-27 11:48:15	2025-01-27 11:48:15	59	36	\N	Sales	\N
404	136	2025-01-27	المبيعات	0	585.00	\N	1	0	585	48	1	\N	2025-01-27 11:48:15	2025-01-27 11:48:15	59	36	\N	Sales	\N
405	137	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-27 11:48:15	2025-01-27 11:48:15	59	36	\N	Commission Entitlement	\N
406	137	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-27 11:48:15	2025-01-27 11:48:15	59	36	\N	Commission Entitlement	\N
407	138	2025-01-27	المبيعات	366	0	\N	1	366	0	52	1	\N	2025-01-27 13:50:19	2025-01-27 13:50:19	59	37	\N	Sales	\N
408	138	2025-01-27	المبيعات	0	366	\N	1	0	366	2500	1	\N	2025-01-27 13:50:19	2025-01-27 13:50:19	59	37	\N	Sales	\N
409	138	2025-01-27	المبيعات	420	0	\N	1	420	0	2944	1	\N	2025-01-27 13:50:19	2025-01-27 13:50:19	59	37	\N	Sales	\N
410	138	2025-01-27	المبيعات	0	420.00	\N	1	0	420	48	1	\N	2025-01-27 13:50:19	2025-01-27 13:50:19	59	37	\N	Sales	\N
411	139	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-27 13:50:19	2025-01-27 13:50:19	59	37	\N	Commission Entitlement	\N
412	139	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-27 13:50:19	2025-01-27 13:50:19	59	37	\N	Commission Entitlement	\N
413	140	2025-01-27	المشتريات	110.00	0	\N	1	110	0	2500	1	\N	2025-01-27 13:57:27	2025-01-27 13:57:27	59	27	\N	Purchases	\N
414	140	2025-01-27	المشتريات	0	110.00	\N	1	0	110	2523	1	\N	2025-01-27 13:57:27	2025-01-27 13:57:27	59	27	\N	Purchases	\N
415	140	2025-01-27	المشتريات	110.00	0	\N	1	110	0	2523	1	\N	2025-01-27 13:57:27	2025-01-27 13:57:27	59	27	\N	Purchases	\N
416	140	2025-01-27	المشتريات	0	110.00	\N	1	0	110	30	1	\N	2025-01-27 13:57:27	2025-01-27 13:57:27	59	27	\N	Purchases	\N
417	141	2025-01-27	المبيعات	110	0	\N	1	110	0	52	1	\N	2025-01-27 13:58:07	2025-01-27 13:58:07	59	38	\N	Sales	\N
418	141	2025-01-27	المبيعات	0	110	\N	1	0	110	2500	1	\N	2025-01-27 13:58:07	2025-01-27 13:58:07	59	38	\N	Sales	\N
419	141	2025-01-27	المبيعات	130	0	\N	1	130	0	2771	1	\N	2025-01-27 13:58:07	2025-01-27 13:58:07	59	38	\N	Sales	\N
420	141	2025-01-27	المبيعات	0	130.00	\N	1	0	130	48	1	\N	2025-01-27 13:58:07	2025-01-27 13:58:07	59	38	\N	Sales	\N
421	142	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-27 13:58:07	2025-01-27 13:58:07	59	38	\N	Commission Entitlement	\N
422	142	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-27 13:58:07	2025-01-27 13:58:07	59	38	\N	Commission Entitlement	\N
423	143	2025-01-27	المبيعات	122	0	\N	1	122	0	52	1	\N	2025-01-27 14:02:23	2025-01-27 14:02:23	59	39	\N	Sales	\N
424	143	2025-01-27	المبيعات	0	122	\N	1	0	122	2500	1	\N	2025-01-27 14:02:23	2025-01-27 14:02:23	59	39	\N	Sales	\N
425	143	2025-01-27	المبيعات	140	0	\N	1	140	0	2607	1	\N	2025-01-27 14:02:23	2025-01-27 14:02:23	59	39	\N	Sales	\N
426	143	2025-01-27	المبيعات	0	140.00	\N	1	0	140	48	1	\N	2025-01-27 14:02:23	2025-01-27 14:02:23	59	39	\N	Sales	\N
427	144	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-27 14:02:23	2025-01-27 14:02:23	59	39	\N	Commission Entitlement	\N
428	144	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-27 14:02:23	2025-01-27 14:02:23	59	39	\N	Commission Entitlement	\N
429	145	2025-01-27	المبيعات	200	0	\N	1	200	0	52	1	\N	2025-01-27 15:05:07	2025-01-27 15:05:07	63	40	\N	Sales	\N
430	145	2025-01-27	المبيعات	0	200	\N	1	0	200	2500	1	\N	2025-01-27 15:05:07	2025-01-27 15:05:07	63	40	\N	Sales	\N
431	145	2025-01-27	المبيعات	220	0	\N	1	220	0	2950	1	\N	2025-01-27 15:05:07	2025-01-27 15:05:07	63	40	\N	Sales	\N
432	145	2025-01-27	المبيعات	0	220.00	\N	1	0	220	48	1	\N	2025-01-27 15:05:07	2025-01-27 15:05:07	63	40	\N	Sales	\N
433	146	2025-01-27	المشتريات	909.36	0	\N	1	909.36	0	2500	1	\N	2025-01-27 15:34:55	2025-01-27 15:34:55	59	28	\N	Purchases	\N
434	146	2025-01-27	المشتريات	0	909.36	\N	1	0	909.36	2523	1	\N	2025-01-27 15:34:55	2025-01-27 15:34:55	59	28	\N	Purchases	\N
435	146	2025-01-27	المشتريات	909.36	0	\N	1	909.36	0	2523	1	\N	2025-01-27 15:34:55	2025-01-27 15:34:55	59	28	\N	Purchases	\N
436	146	2025-01-27	المشتريات	0	909.36	\N	1	0	909.36	30	1	\N	2025-01-27 15:34:55	2025-01-27 15:34:55	59	28	\N	Purchases	\N
437	147	2025-01-26	المبيعات	1447.55	0	\N	1	1447.55	0	52	1	\N	2025-01-27 15:40:26	2025-01-27 15:40:26	59	41	\N	Sales	\N
438	147	2025-01-26	المبيعات	0	1447.55	\N	1	0	1447.55	2500	1	\N	2025-01-27 15:40:26	2025-01-27 15:40:26	59	41	\N	Sales	\N
439	147	2025-01-26	المبيعات	2703	0	\N	1	2703	0	2791	1	\N	2025-01-27 15:40:26	2025-01-27 15:40:26	59	41	\N	Sales	\N
440	147	2025-01-26	المبيعات	0	2703.00	\N	1	0	2703	48	1	\N	2025-01-27 15:40:26	2025-01-27 15:40:26	59	41	\N	Sales	\N
441	148	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-27 15:40:26	2025-01-27 15:40:26	59	41	\N	Commission Entitlement	\N
442	148	2025-01-26	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-27 15:40:26	2025-01-27 15:40:26	59	41	\N	Commission Entitlement	\N
443	149	2025-01-27	المبيعات	447.63	0	\N	1	447.63	0	52	1	\N	2025-01-27 15:45:19	2025-01-27 15:45:19	59	42	\N	Sales	\N
444	149	2025-01-27	المبيعات	0	447.63	\N	1	0	447.63	2500	1	\N	2025-01-27 15:45:19	2025-01-27 15:45:19	59	42	\N	Sales	\N
445	149	2025-01-27	المبيعات	780	0	\N	1	780	0	2607	1	\N	2025-01-27 15:45:19	2025-01-27 15:45:19	59	42	\N	Sales	\N
446	149	2025-01-27	المبيعات	0	780.00	\N	1	0	780	48	1	\N	2025-01-27 15:45:19	2025-01-27 15:45:19	59	42	\N	Sales	\N
447	150	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-27 15:45:19	2025-01-27 15:45:19	59	42	\N	Commission Entitlement	\N
448	150	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-27 15:45:19	2025-01-27 15:45:19	59	42	\N	Commission Entitlement	\N
449	151	2025-01-27	المبيعات	400	0	\N	1	400	0	52	1	\N	2025-01-27 15:46:52	2025-01-27 15:46:52	59	43	\N	Sales	\N
450	151	2025-01-27	المبيعات	0	400	\N	1	0	400	2500	1	\N	2025-01-27 15:46:52	2025-01-27 15:46:52	59	43	\N	Sales	\N
451	151	2025-01-27	المبيعات	800	0	\N	1	800	0	2758	1	\N	2025-01-27 15:46:52	2025-01-27 15:46:52	59	43	\N	Sales	\N
452	151	2025-01-27	المبيعات	0	800.00	\N	1	0	800	48	1	\N	2025-01-27 15:46:52	2025-01-27 15:46:52	59	43	\N	Sales	\N
453	152	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-27 15:46:52	2025-01-27 15:46:52	59	43	\N	Commission Entitlement	\N
454	152	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-27 15:46:52	2025-01-27 15:46:52	59	43	\N	Commission Entitlement	\N
455	153	2025-01-27	المبيعات	1243.95	0	\N	1	1243.95	0	52	1	\N	2025-01-27 15:51:19	2025-01-27 15:51:19	59	44	\N	Sales	\N
456	153	2025-01-27	المبيعات	0	1243.95	\N	1	0	1243.95	2500	1	\N	2025-01-27 15:51:19	2025-01-27 15:51:19	59	44	\N	Sales	\N
457	153	2025-01-27	المبيعات	1300	0	\N	1	1300	0	2565	1	\N	2025-01-27 15:51:19	2025-01-27 15:51:19	59	44	\N	Sales	\N
458	153	2025-01-27	المبيعات	0	1300.00	\N	1	0	1300	48	1	\N	2025-01-27 15:51:19	2025-01-27 15:51:19	59	44	\N	Sales	\N
459	154	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-27 15:51:19	2025-01-27 15:51:19	59	44	\N	Commission Entitlement	\N
460	154	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-27 15:51:19	2025-01-27 15:51:19	59	44	\N	Commission Entitlement	\N
461	155	2025-01-27	المبيعات	1540	0	\N	1	1540	0	52	1	\N	2025-01-27 15:54:38	2025-01-27 15:54:38	59	45	\N	Sales	\N
462	155	2025-01-27	المبيعات	0	1540	\N	1	0	1540	2500	1	\N	2025-01-27 15:54:38	2025-01-27 15:54:38	59	45	\N	Sales	\N
463	155	2025-01-27	المبيعات	1800	0	\N	1	1800	0	2774	1	\N	2025-01-27 15:54:38	2025-01-27 15:54:38	59	45	\N	Sales	\N
464	155	2025-01-27	المبيعات	0	1800.00	\N	1	0	1800	48	1	\N	2025-01-27 15:54:38	2025-01-27 15:54:38	59	45	\N	Sales	\N
465	156	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-27 15:54:38	2025-01-27 15:54:38	59	45	\N	Commission Entitlement	\N
466	156	2025-01-27	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-27 15:54:38	2025-01-27 15:54:38	59	45	\N	Commission Entitlement	\N
467	157	2025-01-27	سند قبض	0	220	\N	1	0	220	2950	1	\N	2025-01-27 15:55:51	2025-01-27 15:55:51	59	5	\N	Receipt Voucher	\N
468	157	2025-01-27	سند قبض	220	0	\N	1	220	0	30	1	\N	2025-01-27 15:55:51	2025-01-27 15:55:51	59	5	\N	Receipt Voucher	\N
469	158	2025-01-28	المشتريات	602.91	0	\N	1	602.91	0	2500	1	\N	2025-01-28 14:28:44	2025-01-28 14:28:44	59	29	\N	Purchases	\N
470	158	2025-01-28	المشتريات	0	602.91	\N	1	0	602.91	2523	1	\N	2025-01-28 14:28:44	2025-01-28 14:28:44	59	29	\N	Purchases	\N
471	158	2025-01-28	المشتريات	602.91	0	\N	1	602.91	0	2523	1	\N	2025-01-28 14:28:44	2025-01-28 14:28:44	59	29	\N	Purchases	\N
472	158	2025-01-28	المشتريات	0	602.91	\N	1	0	602.91	30	1	\N	2025-01-28 14:28:44	2025-01-28 14:28:44	59	29	\N	Purchases	\N
473	159	2025-01-28	المبيعات	3626.12	0	\N	1	3626.12	0	52	1	\N	2025-01-28 14:34:07	2025-01-28 14:34:07	59	46	\N	Sales	\N
474	159	2025-01-28	المبيعات	0	3626.12	\N	1	0	3626.12	2500	1	\N	2025-01-28 14:34:07	2025-01-28 14:34:07	59	46	\N	Sales	\N
475	159	2025-01-28	المبيعات	0	2379.00	\N	1	0	2379	48	1	\N	2025-01-28 14:34:07	2025-01-28 14:34:07	59	46	\N	Sales	\N
476	159	2025-01-28	المبيعات	0	14.00	\N	1	0	14	112	1	\N	2025-01-28 14:34:07	2025-01-28 14:34:07	59	46	\N	Sales	\N
477	159	2025-01-28	المبيعات	2393	0	\N	1	2393	0	2606	1	\N	2025-01-28 14:34:07	2025-01-28 14:34:07	59	46	\N	Sales	\N
478	160	2025-01-28	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-28 14:34:07	2025-01-28 14:34:07	59	46	\N	Commission Entitlement	\N
479	160	2025-01-28	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-28 14:34:07	2025-01-28 14:34:07	59	46	\N	Commission Entitlement	\N
480	161	2025-01-28	المشتريات	2795.9	0	\N	1	2795.9	0	2500	1	\N	2025-01-28 14:40:48	2025-01-28 14:40:48	59	30	\N	Purchases	\N
481	161	2025-01-28	المشتريات	0	2795.9	\N	1	0	2795.9	2523	1	\N	2025-01-28 14:40:48	2025-01-28 14:40:48	59	30	\N	Purchases	\N
482	161	2025-01-28	المشتريات	2795.9	0	\N	1	2795.9	0	2523	1	\N	2025-01-28 14:40:48	2025-01-28 14:40:48	59	30	\N	Purchases	\N
483	161	2025-01-28	المشتريات	0	2795.9	\N	1	0	2795.9	30	1	\N	2025-01-28 14:40:48	2025-01-28 14:40:48	59	30	\N	Purchases	\N
484	162	2025-01-28	المبيعات	9775.52	0	\N	1	9775.52	0	52	1	\N	2025-01-28 14:46:13	2025-01-28 14:46:13	59	47	\N	Sales	\N
485	162	2025-01-28	المبيعات	0	9775.52	\N	1	0	9775.52	2500	1	\N	2025-01-28 14:46:13	2025-01-28 14:46:13	59	47	\N	Sales	\N
486	162	2025-01-28	المبيعات	9565	0	\N	1	9565	0	2686	1	\N	2025-01-28 14:46:13	2025-01-28 14:46:13	59	47	\N	Sales	\N
487	162	2025-01-28	المبيعات	0	9565.00	\N	1	0	9565	48	1	\N	2025-01-28 14:46:13	2025-01-28 14:46:13	59	47	\N	Sales	\N
488	163	2025-01-28	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-28 14:46:13	2025-01-28 14:46:13	59	47	\N	Commission Entitlement	\N
489	163	2025-01-28	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-28 14:46:13	2025-01-28 14:46:13	59	47	\N	Commission Entitlement	\N
490	164	2025-01-28	المبيعات	1610	0	\N	1	1610	0	52	1	\N	2025-01-28 14:52:21	2025-01-28 14:52:21	59	48	\N	Sales	\N
491	164	2025-01-28	المبيعات	0	1610	\N	1	0	1610	2500	1	\N	2025-01-28 14:52:21	2025-01-28 14:52:21	59	48	\N	Sales	\N
492	164	2025-01-28	المبيعات	1850	0	\N	1	1850	0	2952	1	\N	2025-01-28 14:52:21	2025-01-28 14:52:21	59	48	\N	Sales	\N
493	164	2025-01-28	المبيعات	0	1850.00	\N	1	0	1850	48	1	\N	2025-01-28 14:52:21	2025-01-28 14:52:21	59	48	\N	Sales	\N
494	165	2025-01-28	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-28 14:52:21	2025-01-28 14:52:21	59	48	\N	Commission Entitlement	\N
495	165	2025-01-28	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-28 14:52:21	2025-01-28 14:52:21	59	48	\N	Commission Entitlement	\N
496	166	2025-01-26	سند صرف	745	0	بنزين ابراهيم يوم 26 يناير	1	745	0	854	1	\N	2025-01-28 15:03:30	2025-01-28 15:03:30	59	7	\N	Payment Voucher	\N
497	166	2025-01-26	سند صرف	20	0	كارته طريق	1	20	0	854	1	\N	2025-01-28 15:03:30	2025-01-28 15:03:30	59	7	\N	Payment Voucher	\N
498	166	2025-01-26	سند صرف	0	765	ابراهيم	1	0	765	30	1	\N	2025-01-28 15:03:30	2025-01-28 15:03:30	59	7	3	Payment Voucher	\N
499	167	2025-01-28	سند صرف	710	0	فاتوره التليفون +النت	1	710	0	854	1	\N	2025-01-28 15:15:01	2025-01-28 15:15:01	59	8	\N	Payment Voucher	\N
500	167	2025-01-28	سند صرف	0	710	\N	1	0	710	30	1	\N	2025-01-28 15:15:01	2025-01-28 15:15:01	59	8	3	Payment Voucher	\N
501	168	2025-01-28	المبيعات	1455	0	\N	1	1455	0	52	1	\N	2025-01-28 16:25:48	2025-01-28 16:25:48	59	49	\N	Sales	\N
502	168	2025-01-28	المبيعات	0	1455	\N	1	0	1455	2500	1	\N	2025-01-28 16:25:48	2025-01-28 16:25:48	59	49	\N	Sales	\N
503	168	2025-01-28	المبيعات	135	0	\N	1	135	0	2607	1	\N	2025-01-28 16:25:48	2025-01-28 16:25:48	59	49	\N	Sales	\N
504	168	2025-01-28	المبيعات	0	135.00	\N	1	0	135	48	1	\N	2025-01-28 16:25:48	2025-01-28 16:25:48	59	49	\N	Sales	\N
505	169	2025-01-28	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-28 16:25:48	2025-01-28 16:25:48	59	49	\N	Commission Entitlement	\N
506	169	2025-01-28	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-28 16:25:48	2025-01-28 16:25:48	59	49	\N	Commission Entitlement	\N
507	170	2025-01-29	المبيعات	4205	0	\N	1	4205	0	52	1	\N	2025-01-29 18:47:38	2025-01-29 18:47:38	59	50	\N	Sales	\N
508	170	2025-01-29	المبيعات	0	4205	\N	1	0	4205	2500	1	\N	2025-01-29 18:47:38	2025-01-29 18:47:38	59	50	\N	Sales	\N
509	170	2025-01-29	المبيعات	6525	0	\N	1	6525	0	2683	1	\N	2025-01-29 18:47:38	2025-01-29 18:47:38	59	50	\N	Sales	\N
510	170	2025-01-29	المبيعات	0	6525.00	\N	1	0	6525	48	1	\N	2025-01-29 18:47:38	2025-01-29 18:47:38	59	50	\N	Sales	\N
511	171	2025-01-29	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-29 18:47:38	2025-01-29 18:47:38	59	50	\N	Commission Entitlement	\N
512	171	2025-01-29	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-29 18:47:38	2025-01-29 18:47:38	59	50	\N	Commission Entitlement	\N
513	172	2025-01-30	المشتريات	3960	0	\N	1	3960	0	2500	1	\N	2025-01-30 15:11:00	2025-01-30 15:11:00	59	31	\N	Purchases	\N
514	172	2025-01-30	المشتريات	273.70	0	\N	1	273.7	0	112	1	\N	2025-01-30 15:11:00	2025-01-30 15:11:00	59	31	\N	Purchases	\N
515	172	2025-01-30	المشتريات	0	4233.7	\N	1	0	4233.7	2523	1	\N	2025-01-30 15:11:00	2025-01-30 15:11:00	59	31	\N	Purchases	\N
516	172	2025-01-30	المشتريات	4233.7	0	\N	1	4233.7	0	2523	1	\N	2025-01-30 15:11:00	2025-01-30 15:11:00	59	31	\N	Purchases	\N
517	172	2025-01-30	المشتريات	0	4233.7	\N	1	0	4233.7	30	1	\N	2025-01-30 15:11:00	2025-01-30 15:11:00	59	31	\N	Purchases	\N
518	173	2025-01-30	المبيعات	30807.35	0	\N	1	30807.35	0	52	1	\N	2025-01-30 15:16:31	2025-01-30 15:16:31	59	51	\N	Sales	\N
519	173	2025-01-30	المبيعات	0	30807.35	\N	1	0	30807.35	2500	1	\N	2025-01-30 15:16:31	2025-01-30 15:16:31	59	51	\N	Sales	\N
520	173	2025-01-30	المبيعات	8801.00	0	\N	1	8801	0	30	1	\N	2025-01-30 15:16:31	2025-01-30 15:16:31	59	51	\N	Sales	\N
521	173	2025-01-30	المبيعات	0	8801.00	\N	1	0	8801	2522	1	\N	2025-01-30 15:16:31	2025-01-30 15:16:31	59	51	\N	Sales	\N
522	173	2025-01-30	المبيعات	8801.00	0	\N	1	8801	0	2522	1	\N	2025-01-30 15:16:31	2025-01-30 15:16:31	59	51	\N	Sales	\N
523	173	2025-01-30	المبيعات	0	8801.00	\N	1	0	8801	48	1	\N	2025-01-30 15:16:31	2025-01-30 15:16:31	59	51	\N	Sales	\N
524	174	2025-01-30	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-30 15:16:31	2025-01-30 15:16:31	59	51	\N	Commission Entitlement	\N
525	174	2025-01-30	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-30 15:16:31	2025-01-30 15:16:31	59	51	\N	Commission Entitlement	\N
526	175	2025-01-30	المبيعات	2280.98	0	\N	1	2280.98	0	52	1	\N	2025-01-30 15:22:05	2025-01-30 15:22:05	59	52	\N	Sales	\N
527	175	2025-01-30	المبيعات	0	2280.98	\N	1	0	2280.98	2500	1	\N	2025-01-30 15:22:05	2025-01-30 15:22:05	59	52	\N	Sales	\N
528	175	2025-01-30	المبيعات	800	0	\N	1	800	0	2758	1	\N	2025-01-30 15:22:05	2025-01-30 15:22:05	59	52	\N	Sales	\N
529	175	2025-01-30	المبيعات	0	800.00	\N	1	0	800	48	1	\N	2025-01-30 15:22:05	2025-01-30 15:22:05	59	52	\N	Sales	\N
530	176	2025-01-30	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-01-30 15:22:05	2025-01-30 15:22:05	59	52	\N	Commission Entitlement	\N
531	176	2025-01-30	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-01-30 15:22:05	2025-01-30 15:22:05	59	52	\N	Commission Entitlement	\N
532	177	2025-02-01	المشتريات	3850.00	0	\N	1	3850	0	2500	1	\N	2025-02-01 13:59:00	2025-02-01 13:59:00	59	32	\N	Purchases	\N
533	177	2025-02-01	المشتريات	0	3850.00	\N	1	0	3850	2523	1	\N	2025-02-01 13:59:00	2025-02-01 13:59:00	59	32	\N	Purchases	\N
534	177	2025-02-01	المشتريات	3850.00	0	\N	1	3850	0	2523	1	\N	2025-02-01 13:59:00	2025-02-01 13:59:00	59	32	\N	Purchases	\N
535	177	2025-02-01	المشتريات	0	3850.00	\N	1	0	3850	30	1	\N	2025-02-01 13:59:00	2025-02-01 13:59:00	59	32	\N	Purchases	\N
536	178	2025-02-01	المبيعات	3850	0	\N	1	3850	0	52	1	\N	2025-02-01 14:00:25	2025-02-01 14:00:25	59	53	\N	Sales	\N
537	178	2025-02-01	المبيعات	0	3850	\N	1	0	3850	2500	1	\N	2025-02-01 14:00:25	2025-02-01 14:00:25	59	53	\N	Sales	\N
538	178	2025-02-01	المبيعات	4500	0	\N	1	4500	0	2686	1	\N	2025-02-01 14:00:25	2025-02-01 14:00:25	59	53	\N	Sales	\N
539	178	2025-02-01	المبيعات	0	4500.00	\N	1	0	4500	48	1	\N	2025-02-01 14:00:25	2025-02-01 14:00:25	59	53	\N	Sales	\N
540	179	2025-02-01	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-01 14:00:25	2025-02-01 14:00:25	59	53	\N	Commission Entitlement	\N
541	179	2025-02-01	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-01 14:00:25	2025-02-01 14:00:25	59	53	\N	Commission Entitlement	\N
542	180	2025-02-02	المشتريات	150.00	0	\N	1	150	0	2500	1	\N	2025-02-02 17:20:58	2025-02-02 17:20:58	59	33	\N	Purchases	\N
543	180	2025-02-02	المشتريات	0	150.00	\N	1	0	150	2523	1	\N	2025-02-02 17:20:58	2025-02-02 17:20:58	59	33	\N	Purchases	\N
544	180	2025-02-02	المشتريات	150.00	0	\N	1	150	0	2523	1	\N	2025-02-02 17:20:58	2025-02-02 17:20:58	59	33	\N	Purchases	\N
545	180	2025-02-02	المشتريات	0	150.00	\N	1	0	150	30	1	\N	2025-02-02 17:20:58	2025-02-02 17:20:58	59	33	\N	Purchases	\N
557	184	2025-02-03	المشتريات	13154.05	0	\N	1	13154.05	0	2500	1	\N	2025-02-03 19:29:54	2025-02-03 19:29:54	59	35	\N	Purchases	\N
558	184	2025-02-03	المشتريات	0	13150	\N	1	0	13150	2523	1	\N	2025-02-03 19:29:54	2025-02-03 19:29:54	59	35	\N	Purchases	\N
559	184	2025-02-03	المشتريات	0	4.05	\N	1	0	4.05	206	1	\N	2025-02-03 19:29:54	2025-02-03 19:29:54	59	35	\N	Purchases	\N
560	184	2025-02-03	المشتريات	13150	0	\N	1	13150	0	2523	1	\N	2025-02-03 19:29:54	2025-02-03 19:29:54	59	35	\N	Purchases	\N
561	184	2025-02-03	المشتريات	0	13150	\N	1	0	13150	30	1	\N	2025-02-03 19:29:54	2025-02-03 19:29:54	59	35	\N	Purchases	\N
562	185	2025-02-04	المشتريات	1310	0	\N	1	1310	0	2500	1	\N	2025-02-04 11:36:00	2025-02-04 11:36:00	59	36	\N	Purchases	\N
563	185	2025-02-04	المشتريات	0	1310	\N	1	0	1310	2523	1	\N	2025-02-04 11:36:00	2025-02-04 11:36:00	59	36	\N	Purchases	\N
564	185	2025-02-04	المشتريات	1310	0	\N	1	1310	0	2523	1	\N	2025-02-04 11:36:00	2025-02-04 11:36:00	59	36	\N	Purchases	\N
565	185	2025-02-04	المشتريات	0	1310	\N	1	0	1310	30	1	\N	2025-02-04 11:36:00	2025-02-04 11:36:00	59	36	\N	Purchases	\N
572	188	2025-02-02	المبيعات	7959.48	0	\N	1	7959.48	0	52	1	\N	2025-02-04 11:40:41	2025-02-04 11:40:41	59	56	\N	Sales	\N
573	188	2025-02-02	المبيعات	0	7959.48	\N	1	0	7959.48	2500	1	\N	2025-02-04 11:40:41	2025-02-04 11:40:41	59	56	\N	Sales	\N
574	188	2025-02-02	المبيعات	8851	0	\N	1	8851	0	2821	1	\N	2025-02-04 11:40:41	2025-02-04 11:40:41	59	56	\N	Sales	\N
575	188	2025-02-02	المبيعات	0	8851.00	\N	1	0	8851	48	1	\N	2025-02-04 11:40:41	2025-02-04 11:40:41	59	56	\N	Sales	\N
576	189	2025-02-02	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-04 11:40:41	2025-02-04 11:40:41	59	56	\N	Commission Entitlement	\N
577	189	2025-02-02	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-04 11:40:41	2025-02-04 11:40:41	59	56	\N	Commission Entitlement	\N
588	193	2025-02-04	المبيعات	32049.26	0	\N	1	32049.26	0	52	1	\N	2025-02-04 12:07:30	2025-02-04 12:07:30	59	58	\N	Sales	\N
589	193	2025-02-04	المبيعات	0	32049.26	\N	1	0	32049.26	2500	1	\N	2025-02-04 12:07:30	2025-02-04 12:07:30	59	58	\N	Sales	\N
590	193	2025-02-04	المبيعات	0	9520.00	\N	1	0	9520	48	1	\N	2025-02-04 12:07:30	2025-02-04 12:07:30	59	58	\N	Sales	\N
591	193	2025-02-04	المبيعات	0	352.80	\N	1	0	352.8	112	1	\N	2025-02-04 12:07:30	2025-02-04 12:07:30	59	58	\N	Sales	\N
592	193	2025-02-04	المبيعات	9872.8	0	\N	1	9872.8	0	2606	1	\N	2025-02-04 12:07:30	2025-02-04 12:07:30	59	58	\N	Sales	\N
593	194	2025-02-04	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-04 12:07:30	2025-02-04 12:07:30	59	58	\N	Commission Entitlement	\N
594	194	2025-02-04	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-04 12:07:30	2025-02-04 12:07:30	59	58	\N	Commission Entitlement	\N
595	195	2025-02-04	المبيعات	85565.57	0	\N	1	85565.57	0	52	1	\N	2025-02-04 15:50:30	2025-02-04 15:50:30	59	59	\N	Sales	\N
596	195	2025-02-04	المبيعات	0	85565.57	\N	1	0	85565.57	2500	1	\N	2025-02-04 15:50:30	2025-02-04 15:50:30	59	59	\N	Sales	\N
597	195	2025-02-04	المبيعات	0	9945.00	\N	1	0	9945	48	1	\N	2025-02-04 15:50:30	2025-02-04 15:50:30	59	59	\N	Sales	\N
598	195	2025-02-04	المبيعات	0	966.00	\N	1	0	966	40	1	\N	2025-02-04 15:50:30	2025-02-04 15:50:30	59	59	\N	Sales	\N
599	195	2025-02-04	المبيعات	10911	0	\N	1	10911	0	2686	1	\N	2025-02-04 15:50:30	2025-02-04 15:50:30	59	59	\N	Sales	\N
600	196	2025-02-04	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-04 15:50:30	2025-02-04 15:50:30	59	59	\N	Commission Entitlement	\N
601	196	2025-02-04	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-04 15:50:30	2025-02-04 15:50:30	59	59	\N	Commission Entitlement	\N
608	199	2025-02-04	القيود اليومية	10000	0	\N	1	10000	0	30	1	\N	2025-02-04 16:27:28	2025-02-04 16:27:28	59	199	3	Journalizing	\N
609	199	2025-02-04	القيود اليومية	0	10000	\N	1	0	10000	45	1	\N	2025-02-04 16:27:28	2025-02-04 16:27:28	59	199	3	Journalizing	\N
610	200	2025-02-04	سند صرف	3500	0	مرتب ابوعلاء	1	3500	0	2852	1	\N	2025-02-04 16:29:02	2025-02-04 16:29:02	59	9	\N	Payment Voucher	\N
611	200	2025-02-04	سند صرف	0	3500	\N	1	0	3500	30	1	\N	2025-02-04 16:29:02	2025-02-04 16:29:02	59	9	3	Payment Voucher	\N
612	201	2025-02-04	سند صرف	900	0	تغير زيت يوم 4 فبراير	1	900	0	854	1	\N	2025-02-04 16:30:32	2025-02-04 16:30:32	59	10	\N	Payment Voucher	\N
613	201	2025-02-04	سند صرف	0	900	\N	1	0	900	30	1	\N	2025-02-04 16:30:32	2025-02-04 16:30:32	59	10	3	Payment Voucher	\N
614	202	2025-02-04	المشتريات	2342.44	0	\N	1	2342.44	0	2500	1	\N	2025-02-04 19:04:40	2025-02-04 19:04:40	59	38	\N	Purchases	\N
615	202	2025-02-04	المشتريات	0	2342.44	\N	1	0	2342.44	2523	1	\N	2025-02-04 19:04:40	2025-02-04 19:04:40	59	38	\N	Purchases	\N
616	202	2025-02-04	المشتريات	2342.44	0	\N	1	2342.44	0	2523	1	\N	2025-02-04 19:04:40	2025-02-04 19:04:40	59	38	\N	Purchases	\N
617	202	2025-02-04	المشتريات	0	2342.44	\N	1	0	2342.44	30	1	\N	2025-02-04 19:04:40	2025-02-04 19:04:40	59	38	\N	Purchases	\N
618	203	2025-02-04	المشتريات	77.00	0	\N	1	77	0	2500	1	\N	2025-02-04 19:31:51	2025-02-04 19:31:51	59	39	\N	Purchases	\N
619	203	2025-02-04	المشتريات	0	77.00	\N	1	0	77	2523	1	\N	2025-02-04 19:31:51	2025-02-04 19:31:51	59	39	\N	Purchases	\N
620	203	2025-02-04	المشتريات	77.00	0	\N	1	77	0	2523	1	\N	2025-02-04 19:31:51	2025-02-04 19:31:51	59	39	\N	Purchases	\N
621	203	2025-02-04	المشتريات	0	77.00	\N	1	0	77	30	1	\N	2025-02-04 19:31:51	2025-02-04 19:31:51	59	39	\N	Purchases	\N
630	206	2025-02-05	المشتريات	1090.00	0	\N	1	1090	0	2500	1	\N	2025-02-05 12:32:56	2025-02-05 12:32:56	59	40	\N	Purchases	\N
631	206	2025-02-05	المشتريات	0	1090.00	\N	1	0	1090	2959	1	\N	2025-02-05 12:32:56	2025-02-05 12:32:56	59	40	\N	Purchases	\N
632	206	2025-02-05	المشتريات	1090.00	0	\N	1	1090	0	2959	1	\N	2025-02-05 12:32:56	2025-02-05 12:32:56	59	40	\N	Purchases	\N
633	206	2025-02-05	المشتريات	0	1090.00	\N	1	0	1090	30	1	\N	2025-02-05 12:32:56	2025-02-05 12:32:56	59	40	\N	Purchases	\N
634	207	2025-02-04	المبيعات	1478.75	0	\N	1	1478.75	0	52	1	\N	2025-02-05 13:32:55	2025-02-05 13:32:55	59	62	\N	Sales	\N
635	207	2025-02-04	المبيعات	0	1478.75	\N	1	0	1478.75	2500	1	\N	2025-02-05 13:32:55	2025-02-05 13:32:55	59	62	\N	Sales	\N
636	207	2025-02-04	المبيعات	2628	0	\N	1	2628	0	2912	1	\N	2025-02-05 13:32:55	2025-02-05 13:32:55	59	62	\N	Sales	\N
637	207	2025-02-04	المبيعات	0	2628.00	\N	1	0	2628	48	1	\N	2025-02-05 13:32:55	2025-02-05 13:32:55	59	62	\N	Sales	\N
638	208	2025-02-04	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-05 13:32:55	2025-02-05 13:32:55	59	62	\N	Commission Entitlement	\N
639	208	2025-02-04	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-05 13:32:55	2025-02-05 13:32:55	59	62	\N	Commission Entitlement	\N
640	209	2025-02-05	القيود اليومية	23000	0	\N	1	23000	0	30	1	\N	2025-02-05 17:08:13	2025-02-05 17:08:13	1	209	\N	Journalizing	\N
641	209	2025-02-05	القيود اليومية	0	23000	\N	1	0	23000	45	1	\N	2025-02-05 17:08:13	2025-02-05 17:08:13	1	209	\N	Journalizing	\N
646	211	2025-02-05	المبيعات	1090	0	\N	1	1090	0	52	1	\N	2025-02-05 18:33:07	2025-02-05 18:33:07	1	63	\N	Sales	\N
647	211	2025-02-05	المبيعات	0	1090	\N	1	0	1090	2500	1	\N	2025-02-05 18:33:07	2025-02-05 18:33:07	1	63	\N	Sales	\N
648	211	2025-02-05	المبيعات	1800	0	\N	1	1800	0	2944	1	\N	2025-02-05 18:33:07	2025-02-05 18:33:07	1	63	\N	Sales	\N
649	211	2025-02-05	المبيعات	0	1800.00	\N	1	0	1800	48	1	\N	2025-02-05 18:33:07	2025-02-05 18:33:07	1	63	\N	Sales	\N
650	212	2025-02-05	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-05 18:33:07	2025-02-05 18:33:07	1	63	\N	Commission Entitlement	\N
651	212	2025-02-05	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-05 18:33:07	2025-02-05 18:33:07	1	63	\N	Commission Entitlement	\N
652	213	2025-02-05	سند صرف	2000	0	مرتب ام خالد	1	2000	0	2800	1	\N	2025-02-05 18:40:42	2025-02-05 18:40:42	1	12	\N	Payment Voucher	\N
653	213	2025-02-05	سند صرف	0	2000	\N	1	0	2000	30	1	\N	2025-02-05 18:40:42	2025-02-05 18:40:42	1	12	3	Payment Voucher	\N
654	214	2025-02-05	سند صرف	15000	0	ايجار شهر فبراير 2025	1	15000	0	854	1	\N	2025-02-05 18:45:38	2025-02-05 18:45:38	1	13	\N	Payment Voucher	\N
655	214	2025-02-05	سند صرف	2000	0	مرتب ام كريمه	1	2000	0	2860	1	\N	2025-02-05 18:45:38	2025-02-05 18:45:38	1	13	\N	Payment Voucher	\N
656	214	2025-02-05	سند صرف	6000	0	مرتب مصطفى	1	6000	0	2795	1	\N	2025-02-05 18:45:38	2025-02-05 18:45:38	1	13	\N	Payment Voucher	\N
657	214	2025-02-05	سند صرف	0	23000	\N	1	0	23000	30	1	\N	2025-02-05 18:45:38	2025-02-05 18:45:38	1	13	3	Payment Voucher	\N
664	217	2025-02-10	القيود اليومية	10000	0	\N	1	10000	0	30	1	\N	2025-02-10 13:33:41	2025-02-10 13:33:41	59	217	\N	Journalizing	\N
665	217	2025-02-10	القيود اليومية	0	10000	\N	1	0	10000	45	1	\N	2025-02-10 13:33:41	2025-02-10 13:33:41	59	217	\N	Journalizing	\N
666	218	2025-02-10	سند صرف	1000	0	مرتب ام كريمه	1	1000	0	2860	1	\N	2025-02-10 13:35:20	2025-02-10 13:35:20	59	14	\N	Payment Voucher	\N
667	218	2025-02-10	سند صرف	10000	0	سداد فواتير	1	10000	0	2541	1	\N	2025-02-10 13:35:20	2025-02-10 13:35:20	59	14	\N	Payment Voucher	\N
668	218	2025-02-10	سند صرف	0	11000	\N	1	0	11000	30	1	\N	2025-02-10 13:35:20	2025-02-10 13:35:20	59	14	3	Payment Voucher	\N
669	219	2025-02-10	القيود اليومية	10000	0	\N	1	10000	0	30	1	\N	2025-02-10 18:44:33	2025-02-10 18:44:33	59	219	\N	Journalizing	\N
670	219	2025-02-10	القيود اليومية	0	10000	\N	1	0	10000	45	1	\N	2025-02-10 18:44:33	2025-02-10 18:44:33	59	219	\N	Journalizing	\N
671	220	2025-02-10	المشتريات	8928.50	0	\N	1	8928.5	0	2500	1	\N	2025-02-10 18:45:40	2025-02-10 18:45:40	59	41	\N	Purchases	\N
672	220	2025-02-10	المشتريات	0	8928.50	\N	1	0	8928.5	2523	1	\N	2025-02-10 18:45:40	2025-02-10 18:45:40	59	41	\N	Purchases	\N
673	220	2025-02-10	المشتريات	8928.50	0	\N	1	8928.5	0	2523	1	\N	2025-02-10 18:45:40	2025-02-10 18:45:40	59	41	\N	Purchases	\N
674	220	2025-02-10	المشتريات	0	8928.50	\N	1	0	8928.5	30	1	\N	2025-02-10 18:45:40	2025-02-10 18:45:40	59	41	\N	Purchases	\N
675	221	2025-02-11	المشتريات	1141	0	\N	1	1141	0	2500	1	\N	2025-02-11 14:20:11	2025-02-11 14:20:11	59	42	\N	Purchases	\N
676	221	2025-02-11	المشتريات	0	1141	\N	1	0	1141	2523	1	\N	2025-02-11 14:20:11	2025-02-11 14:20:11	59	42	\N	Purchases	\N
677	221	2025-02-11	المشتريات	1141	0	\N	1	1141	0	2523	1	\N	2025-02-11 14:20:11	2025-02-11 14:20:11	59	42	\N	Purchases	\N
678	221	2025-02-11	المشتريات	0	1141	\N	1	0	1141	30	1	\N	2025-02-11 14:20:11	2025-02-11 14:20:11	59	42	\N	Purchases	\N
679	222	2025-02-11	القيود اليومية	10000	0	\N	1	10000	0	30	1	\N	2025-02-11 14:20:58	2025-02-11 14:20:58	59	222	\N	Journalizing	\N
680	222	2025-02-11	القيود اليومية	0	10000	\N	1	0	10000	45	1	\N	2025-02-11 14:20:58	2025-02-11 14:20:58	59	222	\N	Journalizing	\N
681	223	2025-02-11	المشتريات	6021.8	0	\N	1	6021.8	0	2500	1	\N	2025-02-11 14:23:05	2025-02-11 14:23:05	59	43	\N	Purchases	\N
682	223	2025-02-11	المشتريات	0	6021.8	\N	1	0	6021.8	2523	1	\N	2025-02-11 14:23:05	2025-02-11 14:23:05	59	43	\N	Purchases	\N
683	223	2025-02-11	المشتريات	6021.8	0	\N	1	6021.8	0	2523	1	\N	2025-02-11 14:23:05	2025-02-11 14:23:05	59	43	\N	Purchases	\N
684	223	2025-02-11	المشتريات	0	6021.8	\N	1	0	6021.8	30	1	\N	2025-02-11 14:23:05	2025-02-11 14:23:05	59	43	\N	Purchases	\N
685	224	2025-02-11	المشتريات	840.00	0	\N	1	840	0	2500	1	\N	2025-02-11 19:15:28	2025-02-11 19:15:28	59	44	\N	Purchases	\N
686	224	2025-02-11	المشتريات	0	840.00	\N	1	0	840	2523	1	\N	2025-02-11 19:15:28	2025-02-11 19:15:28	59	44	\N	Purchases	\N
687	224	2025-02-11	المشتريات	840.00	0	\N	1	840	0	2523	1	\N	2025-02-11 19:15:28	2025-02-11 19:15:28	59	44	\N	Purchases	\N
688	224	2025-02-11	المشتريات	0	840.00	\N	1	0	840	30	1	\N	2025-02-11 19:15:28	2025-02-11 19:15:28	59	44	\N	Purchases	\N
689	225	2025-02-13	القيود اليومية	10000	0	\N	1	10000	0	30	1	\N	2025-02-13 12:08:18	2025-02-13 12:08:18	59	225	\N	Journalizing	\N
690	225	2025-02-13	القيود اليومية	0	10000	\N	1	0	10000	45	1	\N	2025-02-13 12:08:18	2025-02-13 12:08:18	59	225	\N	Journalizing	\N
691	226	2025-02-13	المشتريات	10800.00	0	\N	1	10800	0	2500	1	\N	2025-02-13 12:12:25	2025-02-13 12:12:25	59	45	\N	Purchases	\N
692	226	2025-02-13	المشتريات	0	10800.00	\N	1	0	10800	2523	1	\N	2025-02-13 12:12:25	2025-02-13 12:12:25	59	45	\N	Purchases	\N
693	226	2025-02-13	المشتريات	10800.00	0	\N	1	10800	0	2523	1	\N	2025-02-13 12:12:25	2025-02-13 12:12:25	59	45	\N	Purchases	\N
694	226	2025-02-13	المشتريات	0	10800.00	\N	1	0	10800	30	1	\N	2025-02-13 12:12:25	2025-02-13 12:12:25	59	45	\N	Purchases	\N
695	227	2025-02-13	المبيعات	10800	0	\N	1	10800	0	52	1	\N	2025-02-13 12:14:30	2025-02-13 12:14:30	59	65	\N	Sales	\N
696	227	2025-02-13	المبيعات	0	10800	\N	1	0	10800	2500	1	\N	2025-02-13 12:14:30	2025-02-13 12:14:30	59	65	\N	Sales	\N
697	227	2025-02-13	المبيعات	11520.00	0	\N	1	11520	0	30	1	\N	2025-02-13 12:14:30	2025-02-13 12:14:30	59	65	\N	Sales	\N
698	227	2025-02-13	المبيعات	0	11520.00	\N	1	0	11520	2764	1	\N	2025-02-13 12:14:31	2025-02-13 12:14:31	59	65	\N	Sales	\N
699	227	2025-02-13	المبيعات	11520.00	0	\N	1	11520	0	2764	1	\N	2025-02-13 12:14:31	2025-02-13 12:14:31	59	65	\N	Sales	\N
700	227	2025-02-13	المبيعات	0	11520.00	\N	1	0	11520	48	1	\N	2025-02-13 12:14:31	2025-02-13 12:14:31	59	65	\N	Sales	\N
701	228	2025-02-13	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-13 12:14:31	2025-02-13 12:14:31	59	65	\N	Commission Entitlement	\N
702	228	2025-02-13	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-13 12:14:31	2025-02-13 12:14:31	59	65	\N	Commission Entitlement	\N
703	229	2025-02-13	سند صرف	800	0	بنزين يوم 12 فبراير	1	800	0	854	1	\N	2025-02-13 12:18:21	2025-02-13 12:18:21	59	15	\N	Payment Voucher	\N
704	229	2025-02-13	سند صرف	0	800	\N	1	0	800	30	1	\N	2025-02-13 12:18:21	2025-02-13 12:18:21	59	15	3	Payment Voucher	\N
705	230	2025-02-04	المبيعات	53.33	0	\N	1	53.33	0	52	1	\N	2025-02-19 15:39:10	2025-02-19 15:39:10	59	66	\N	Sales	\N
706	230	2025-02-04	المبيعات	0	53.33	\N	1	0	53.33	2500	1	\N	2025-02-19 15:39:10	2025-02-19 15:39:10	59	66	\N	Sales	\N
707	230	2025-02-04	المبيعات	110	0	\N	1	110	0	2607	1	\N	2025-02-19 15:39:10	2025-02-19 15:39:10	59	66	\N	Sales	\N
708	230	2025-02-04	المبيعات	0	110.00	\N	1	0	110	48	1	\N	2025-02-19 15:39:10	2025-02-19 15:39:10	59	66	\N	Sales	\N
709	231	2025-02-04	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-19 15:39:10	2025-02-19 15:39:10	59	66	\N	Commission Entitlement	\N
710	231	2025-02-04	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-19 15:39:10	2025-02-19 15:39:10	59	66	\N	Commission Entitlement	\N
711	232	2025-02-19	المبيعات	1938.79	0	\N	1	1938.79	0	52	1	\N	2025-02-19 16:20:42	2025-02-19 16:20:42	59	67	\N	Sales	\N
712	232	2025-02-19	المبيعات	0	1938.79	\N	1	0	1938.79	2500	1	\N	2025-02-19 16:20:42	2025-02-19 16:20:42	59	67	\N	Sales	\N
713	232	2025-02-19	المبيعات	0	1990.00	\N	1	0	1990	48	1	\N	2025-02-19 16:20:42	2025-02-19 16:20:42	59	67	\N	Sales	\N
714	232	2025-02-19	المبيعات	0	12.60	\N	1	0	12.6	112	1	\N	2025-02-19 16:20:42	2025-02-19 16:20:42	59	67	\N	Sales	\N
715	232	2025-02-19	المبيعات	2002.6	0	\N	1	2002.6	0	2607	1	\N	2025-02-19 16:20:42	2025-02-19 16:20:42	59	67	\N	Sales	\N
716	233	2025-02-19	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-19 16:20:42	2025-02-19 16:20:42	59	67	\N	Commission Entitlement	\N
717	233	2025-02-19	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-19 16:20:42	2025-02-19 16:20:42	59	67	\N	Commission Entitlement	\N
718	234	2025-02-19	المشتريات	1540.00	0	\N	1	1540	0	2500	1	\N	2025-02-19 16:33:18	2025-02-19 16:33:18	59	46	\N	Purchases	\N
719	234	2025-02-19	المشتريات	0	1540.00	\N	1	0	1540	2523	1	\N	2025-02-19 16:33:18	2025-02-19 16:33:18	59	46	\N	Purchases	\N
720	234	2025-02-19	المشتريات	1540.00	0	\N	1	1540	0	2523	1	\N	2025-02-19 16:33:18	2025-02-19 16:33:18	59	46	\N	Purchases	\N
721	234	2025-02-19	المشتريات	0	1540.00	\N	1	0	1540	30	1	\N	2025-02-19 16:33:18	2025-02-19 16:33:18	59	46	\N	Purchases	\N
722	235	2025-02-19	المبيعات	9308.06	0	\N	1	9308.06	0	52	1	\N	2025-02-19 17:00:46	2025-02-19 17:00:46	59	68	\N	Sales	\N
723	235	2025-02-19	المبيعات	0	9308.06	\N	1	0	9308.06	2500	1	\N	2025-02-19 17:00:46	2025-02-19 17:00:46	59	68	\N	Sales	\N
724	235	2025-02-19	المبيعات	3083	0	\N	1	3083	0	30	1	\N	2025-02-19 17:00:46	2025-02-19 17:00:46	59	68	\N	Sales	\N
725	235	2025-02-19	المبيعات	0	3083	\N	1	0	3083	2522	1	\N	2025-02-19 17:00:46	2025-02-19 17:00:46	59	68	\N	Sales	\N
726	235	2025-02-19	المبيعات	3083	0	\N	1	3083	0	2522	1	\N	2025-02-19 17:00:46	2025-02-19 17:00:46	59	68	\N	Sales	\N
727	235	2025-02-19	المبيعات	0	2950.00	\N	1	0	2950	48	1	\N	2025-02-19 17:00:46	2025-02-19 17:00:46	59	68	\N	Sales	\N
728	235	2025-02-19	المبيعات	0	133.00	\N	1	0	133	112	1	\N	2025-02-19 17:00:46	2025-02-19 17:00:46	59	68	\N	Sales	\N
729	236	2025-02-19	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-19 17:00:46	2025-02-19 17:00:46	59	68	\N	Commission Entitlement	\N
730	236	2025-02-19	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-19 17:00:46	2025-02-19 17:00:46	59	68	\N	Commission Entitlement	\N
731	237	2025-02-19	المشتريات	8014	0	\N	1	8014	0	2500	1	\N	2025-02-19 17:10:09	2025-02-19 17:10:09	59	47	\N	Purchases	\N
732	237	2025-02-19	المشتريات	0	8014	\N	1	0	8014	2523	1	\N	2025-02-19 17:10:09	2025-02-19 17:10:09	59	47	\N	Purchases	\N
733	237	2025-02-19	المشتريات	8014	0	\N	1	8014	0	2523	1	\N	2025-02-19 17:10:09	2025-02-19 17:10:09	59	47	\N	Purchases	\N
734	237	2025-02-19	المشتريات	0	8014	\N	1	0	8014	30	1	\N	2025-02-19 17:10:09	2025-02-19 17:10:09	59	47	\N	Purchases	\N
735	238	2025-02-19	القيود اليومية	30000	0	\N	1	30000	0	30	1	\N	2025-02-19 17:12:28	2025-02-19 17:12:28	59	238	\N	Journalizing	\N
736	238	2025-02-19	القيود اليومية	0	30000	\N	1	0	30000	45	1	\N	2025-02-19 17:12:28	2025-02-19 17:12:28	59	238	\N	Journalizing	\N
737	239	2025-02-19	المبيعات	368.58	0	\N	1	368.58	0	52	1	\N	2025-02-19 17:27:29	2025-02-19 17:27:29	59	69	\N	Sales	\N
738	239	2025-02-19	المبيعات	0	368.58	\N	1	0	368.58	2500	1	\N	2025-02-19 17:27:29	2025-02-19 17:27:29	59	69	\N	Sales	\N
739	239	2025-02-19	المبيعات	406.00	0	\N	1	406	0	30	1	\N	2025-02-19 17:27:29	2025-02-19 17:27:29	59	69	\N	Sales	\N
740	239	2025-02-19	المبيعات	0	406.00	\N	1	0	406	2522	1	\N	2025-02-19 17:27:29	2025-02-19 17:27:29	59	69	\N	Sales	\N
741	239	2025-02-19	المبيعات	406.00	0	\N	1	406	0	2522	1	\N	2025-02-19 17:27:29	2025-02-19 17:27:29	59	69	\N	Sales	\N
742	239	2025-02-19	المبيعات	0	406.00	\N	1	0	406	48	1	\N	2025-02-19 17:27:29	2025-02-19 17:27:29	59	69	\N	Sales	\N
743	240	2025-02-19	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-19 17:27:29	2025-02-19 17:27:29	59	69	\N	Commission Entitlement	\N
744	240	2025-02-19	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-19 17:27:29	2025-02-19 17:27:29	59	69	\N	Commission Entitlement	\N
745	241	2025-02-19	المبيعات	12180	0	\N	1	12180	0	52	1	\N	2025-02-19 17:58:25	2025-02-19 17:58:25	59	70	\N	Sales	\N
746	241	2025-02-19	المبيعات	0	12180	\N	1	0	12180	2500	1	\N	2025-02-19 17:58:25	2025-02-19 17:58:25	59	70	\N	Sales	\N
747	241	2025-02-19	المبيعات	12180	0	\N	1	12180	0	2966	1	\N	2025-02-19 17:58:25	2025-02-19 17:58:25	59	70	\N	Sales	\N
748	241	2025-02-19	المبيعات	0	12180.00	\N	1	0	12180	48	1	\N	2025-02-19 17:58:25	2025-02-19 17:58:25	59	70	\N	Sales	\N
749	242	2025-02-19	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-19 17:58:25	2025-02-19 17:58:25	59	70	\N	Commission Entitlement	\N
750	242	2025-02-19	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-19 17:58:25	2025-02-19 17:58:25	59	70	\N	Commission Entitlement	\N
751	243	2025-02-19	تحويلات الخزائن	10000	0	\N	1	10000	0	2827	1	\N	2025-02-19 18:25:19	2025-02-19 18:25:19	1	1	\N	Safes Transfer	\N
752	243	2025-02-19	تحويلات الخزائن	0	10000	\N	1	0	10000	30	1	\N	2025-02-19 18:25:19	2025-02-19 18:25:19	1	1	\N	Safes Transfer	\N
753	244	2025-02-20	المشتريات	1300	0	\N	1	1300	0	2500	1	\N	2025-02-20 14:29:22	2025-02-20 14:29:22	59	48	\N	Purchases	\N
754	244	2025-02-20	المشتريات	0	1300	\N	1	0	1300	2967	1	\N	2025-02-20 14:29:22	2025-02-20 14:29:22	59	48	\N	Purchases	\N
755	245	2025-02-20	المبيعات	15328.65	0	\N	1	15328.65	0	52	1	\N	2025-02-20 14:38:27	2025-02-20 14:38:27	59	71	\N	Sales	\N
756	245	2025-02-20	المبيعات	0	15328.65	\N	1	0	15328.65	2500	1	\N	2025-02-20 14:38:27	2025-02-20 14:38:27	59	71	\N	Sales	\N
757	245	2025-02-20	المبيعات	0	4115.00	\N	1	0	4115	48	1	\N	2025-02-20 14:38:27	2025-02-20 14:38:27	59	71	\N	Sales	\N
758	245	2025-02-20	المبيعات	0	21.00	\N	1	0	21	112	1	\N	2025-02-20 14:38:27	2025-02-20 14:38:27	59	71	\N	Sales	\N
759	245	2025-02-20	المبيعات	4136	0	\N	1	4136	0	2606	1	\N	2025-02-20 14:38:27	2025-02-20 14:38:27	59	71	\N	Sales	\N
760	246	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-20 14:38:27	2025-02-20 14:38:27	59	71	\N	Commission Entitlement	\N
761	246	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-20 14:38:27	2025-02-20 14:38:27	59	71	\N	Commission Entitlement	\N
762	247	2025-02-20	المشتريات	500	0	\N	1	500	0	2500	1	\N	2025-02-20 14:53:49	2025-02-20 14:53:49	59	49	\N	Purchases	\N
763	247	2025-02-20	المشتريات	0	500	\N	1	0	500	2967	1	\N	2025-02-20 14:53:49	2025-02-20 14:53:49	59	49	\N	Purchases	\N
764	248	2025-02-20	المبيعات	13330.52	0	\N	1	13330.52	0	52	1	\N	2025-02-20 14:57:19	2025-02-20 14:57:19	59	72	\N	Sales	\N
765	248	2025-02-20	المبيعات	0	13330.52	\N	1	0	13330.52	2500	1	\N	2025-02-20 14:57:19	2025-02-20 14:57:19	59	72	\N	Sales	\N
766	248	2025-02-20	المبيعات	0	6824.00	\N	1	0	6824	48	1	\N	2025-02-20 14:57:19	2025-02-20 14:57:19	59	72	\N	Sales	\N
767	248	2025-02-20	المبيعات	0	340.48	\N	1	0	340.48	112	1	\N	2025-02-20 14:57:19	2025-02-20 14:57:19	59	72	\N	Sales	\N
768	248	2025-02-20	المبيعات	7164.48	0	\N	1	7164.48	0	2804	1	\N	2025-02-20 14:57:19	2025-02-20 14:57:19	59	72	\N	Sales	\N
769	249	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-20 14:57:19	2025-02-20 14:57:19	59	72	\N	Commission Entitlement	\N
770	249	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-20 14:57:19	2025-02-20 14:57:19	59	72	\N	Commission Entitlement	\N
771	250	2025-02-20	المشتريات	2310.00	0	\N	1	2310	0	2500	1	\N	2025-02-20 15:05:14	2025-02-20 15:05:14	59	50	\N	Purchases	\N
772	250	2025-02-20	المشتريات	0	2310.00	\N	1	0	2310	2523	1	\N	2025-02-20 15:05:14	2025-02-20 15:05:14	59	50	\N	Purchases	\N
773	250	2025-02-20	المشتريات	2310.00	0	\N	1	2310	0	2523	1	\N	2025-02-20 15:05:14	2025-02-20 15:05:14	59	50	\N	Purchases	\N
774	250	2025-02-20	المشتريات	0	2310.00	\N	1	0	2310	30	1	\N	2025-02-20 15:05:14	2025-02-20 15:05:14	59	50	\N	Purchases	\N
779	252	2025-02-20	المشتريات	4095	0	\N	1	4095	0	2500	1	\N	2025-02-20 15:16:42	2025-02-20 15:16:42	59	52	\N	Purchases	\N
780	252	2025-02-20	المشتريات	0	4095	\N	1	0	4095	2523	1	\N	2025-02-20 15:16:42	2025-02-20 15:16:42	59	52	\N	Purchases	\N
781	252	2025-02-20	المشتريات	4095	0	\N	1	4095	0	2523	1	\N	2025-02-20 15:16:42	2025-02-20 15:16:42	59	52	\N	Purchases	\N
782	252	2025-02-20	المشتريات	0	4095	\N	1	0	4095	30	1	\N	2025-02-20 15:16:42	2025-02-20 15:16:42	59	52	\N	Purchases	\N
783	253	2025-02-20	المبيعات	33917.37	0	\N	1	33917.37	0	52	1	\N	2025-02-20 15:18:05	2025-02-20 15:18:05	59	73	\N	Sales	\N
784	253	2025-02-20	المبيعات	0	33917.37	\N	1	0	33917.37	2500	1	\N	2025-02-20 15:18:05	2025-02-20 15:18:05	59	73	\N	Sales	\N
785	253	2025-02-20	المبيعات	0	11265.00	\N	1	0	11265	48	1	\N	2025-02-20 15:18:05	2025-02-20 15:18:05	59	73	\N	Sales	\N
786	253	2025-02-20	المبيعات	0	1092.00	\N	1	0	1092	112	1	\N	2025-02-20 15:18:05	2025-02-20 15:18:05	59	73	\N	Sales	\N
787	253	2025-02-20	المبيعات	12357	0	\N	1	12357	0	2686	1	\N	2025-02-20 15:18:05	2025-02-20 15:18:05	59	73	\N	Sales	\N
788	254	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-20 15:18:05	2025-02-20 15:18:05	59	73	\N	Commission Entitlement	\N
789	254	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-20 15:18:05	2025-02-20 15:18:05	59	73	\N	Commission Entitlement	\N
790	255	2025-02-20	المشتريات	999.64	0	\N	1	999.64	0	2500	1	\N	2025-02-20 15:29:24	2025-02-20 15:29:24	59	53	\N	Purchases	\N
791	255	2025-02-20	المشتريات	0	999.64	\N	1	0	999.64	2523	1	\N	2025-02-20 15:29:24	2025-02-20 15:29:24	59	53	\N	Purchases	\N
792	255	2025-02-20	المشتريات	999.64	0	\N	1	999.64	0	2523	1	\N	2025-02-20 15:29:24	2025-02-20 15:29:24	59	53	\N	Purchases	\N
793	255	2025-02-20	المشتريات	0	999.64	\N	1	0	999.64	30	1	\N	2025-02-20 15:29:24	2025-02-20 15:29:24	59	53	\N	Purchases	\N
794	256	2025-02-20	المبيعات	1460.75	0	\N	1	1460.75	0	52	1	\N	2025-02-20 15:32:56	2025-02-20 15:32:56	59	74	\N	Sales	\N
795	256	2025-02-20	المبيعات	0	1460.75	\N	1	0	1460.75	2500	1	\N	2025-02-20 15:32:56	2025-02-20 15:32:56	59	74	\N	Sales	\N
796	256	2025-02-20	المبيعات	2605.5	0	\N	1	2605.5	0	2791	1	\N	2025-02-20 15:32:56	2025-02-20 15:32:56	59	74	\N	Sales	\N
797	256	2025-02-20	المبيعات	0	2605.50	\N	1	0	2605.5	48	1	\N	2025-02-20 15:32:56	2025-02-20 15:32:56	59	74	\N	Sales	\N
798	257	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-20 15:32:56	2025-02-20 15:32:56	59	74	\N	Commission Entitlement	\N
799	257	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-20 15:32:56	2025-02-20 15:32:56	59	74	\N	Commission Entitlement	\N
800	258	2025-02-20	المبيعات	582.73	0	\N	1	582.73	0	52	1	\N	2025-02-20 15:45:52	2025-02-20 15:45:52	59	75	\N	Sales	\N
801	258	2025-02-20	المبيعات	0	582.73	\N	1	0	582.73	2500	1	\N	2025-02-20 15:45:52	2025-02-20 15:45:52	59	75	\N	Sales	\N
802	258	2025-02-20	المبيعات	2465	0	\N	1	2465	0	2944	1	\N	2025-02-20 15:45:52	2025-02-20 15:45:52	59	75	\N	Sales	\N
803	258	2025-02-20	المبيعات	0	2465.00	\N	1	0	2465	48	1	\N	2025-02-20 15:45:52	2025-02-20 15:45:52	59	75	\N	Sales	\N
804	259	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-20 15:45:52	2025-02-20 15:45:52	59	75	\N	Commission Entitlement	\N
805	259	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-20 15:45:52	2025-02-20 15:45:52	59	75	\N	Commission Entitlement	\N
806	260	2025-02-20	المبيعات	4482.78	0	\N	1	4482.78	0	52	1	\N	2025-02-20 15:56:35	2025-02-20 15:56:35	59	76	\N	Sales	\N
807	260	2025-02-20	المبيعات	0	4482.78	\N	1	0	4482.78	2500	1	\N	2025-02-20 15:56:35	2025-02-20 15:56:35	59	76	\N	Sales	\N
808	260	2025-02-20	المبيعات	0	2882.00	\N	1	0	2882	48	1	\N	2025-02-20 15:56:35	2025-02-20 15:56:35	59	76	\N	Sales	\N
809	260	2025-02-20	المبيعات	0	47.60	\N	1	0	47.6	112	1	\N	2025-02-20 15:56:35	2025-02-20 15:56:35	59	76	\N	Sales	\N
810	260	2025-02-20	المبيعات	2929.6	0	\N	1	2929.6	0	2969	1	\N	2025-02-20 15:56:35	2025-02-20 15:56:35	59	76	\N	Sales	\N
811	261	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-20 15:56:35	2025-02-20 15:56:35	59	76	\N	Commission Entitlement	\N
812	261	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-20 15:56:35	2025-02-20 15:56:35	59	76	\N	Commission Entitlement	\N
813	262	2025-02-20	المشتريات	27497.61	0	\N	1	27497.61	0	2500	1	\N	2025-02-20 16:02:24	2025-02-20 16:02:24	59	54	\N	Purchases	\N
814	262	2025-02-20	المشتريات	0	27497.61	\N	1	0	27497.61	2931	1	\N	2025-02-20 16:02:24	2025-02-20 16:02:24	59	54	\N	Purchases	\N
815	262	2025-02-20	المشتريات	18000	0	\N	1	18000	0	2931	1	\N	2025-02-20 16:02:24	2025-02-20 16:02:24	59	54	\N	Purchases	\N
816	262	2025-02-20	المشتريات	0	18000	\N	1	0	18000	30	1	\N	2025-02-20 16:02:24	2025-02-20 16:02:24	59	54	\N	Purchases	\N
817	263	2025-02-20	القيود اليومية	20000	0	\N	1	20000	0	30	1	\N	2025-02-20 16:07:47	2025-02-20 16:07:47	59	263	\N	Journalizing	\N
818	263	2025-02-20	القيود اليومية	0	20000	\N	1	0	20000	45	1	\N	2025-02-20 16:07:47	2025-02-20 16:07:47	59	263	\N	Journalizing	\N
819	264	2025-02-20	سند صرف	18000	0	سداد فواتير	1	18000	0	2931	1	\N	2025-02-20 16:08:45	2025-02-20 16:08:45	59	16	\N	Payment Voucher	\N
820	264	2025-02-20	سند صرف	0	18000	\N	1	0	18000	30	1	\N	2025-02-20 16:08:45	2025-02-20 16:08:45	59	16	3	Payment Voucher	\N
821	265	2025-02-20	القيود اليومية	10000	0	\N	1	10000	0	30	1	\N	2025-02-20 16:17:40	2025-02-20 16:17:40	59	265	\N	Journalizing	\N
822	265	2025-02-20	القيود اليومية	0	10000	\N	1	0	10000	45	1	\N	2025-02-20 16:17:40	2025-02-20 16:17:40	59	265	\N	Journalizing	\N
827	267	2025-02-20	المشتريات	1680.00	0	\N	1	1680	0	2500	1	\N	2025-02-20 16:25:02	2025-02-20 16:25:02	59	56	\N	Purchases	\N
828	267	2025-02-20	المشتريات	0	1680.00	\N	1	0	1680	2523	1	\N	2025-02-20 16:25:02	2025-02-20 16:25:02	59	56	\N	Purchases	\N
829	267	2025-02-20	المشتريات	1680.00	0	\N	1	1680	0	2523	1	\N	2025-02-20 16:25:02	2025-02-20 16:25:02	59	56	\N	Purchases	\N
830	267	2025-02-20	المشتريات	0	1680.00	\N	1	0	1680	30	1	\N	2025-02-20 16:25:02	2025-02-20 16:25:02	59	56	\N	Purchases	\N
831	268	2025-02-20	المشتريات	65.00	0	\N	1	65	0	2500	1	\N	2025-02-20 16:28:14	2025-02-20 16:28:14	59	57	\N	Purchases	\N
832	268	2025-02-20	المشتريات	0	65.00	\N	1	0	65	2523	1	\N	2025-02-20 16:28:14	2025-02-20 16:28:14	59	57	\N	Purchases	\N
833	268	2025-02-20	المشتريات	65.00	0	\N	1	65	0	2523	1	\N	2025-02-20 16:28:14	2025-02-20 16:28:14	59	57	\N	Purchases	\N
834	268	2025-02-20	المشتريات	0	65.00	\N	1	0	65	30	1	\N	2025-02-20 16:28:14	2025-02-20 16:28:14	59	57	\N	Purchases	\N
835	269	2025-02-20	المبيعات	3054.81	0	\N	1	3054.81	0	52	1	\N	2025-02-20 17:01:12	2025-02-20 17:01:12	59	77	\N	Sales	\N
836	269	2025-02-20	المبيعات	0	3054.81	\N	1	0	3054.81	2500	1	\N	2025-02-20 17:01:12	2025-02-20 17:01:12	59	77	\N	Sales	\N
837	269	2025-02-20	المبيعات	6054	0	\N	1	6054	0	2969	1	\N	2025-02-20 17:01:12	2025-02-20 17:01:12	59	77	\N	Sales	\N
838	269	2025-02-20	المبيعات	0	6054.00	\N	1	0	6054	48	1	\N	2025-02-20 17:01:12	2025-02-20 17:01:12	59	77	\N	Sales	\N
839	270	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-20 17:01:12	2025-02-20 17:01:12	59	77	\N	Commission Entitlement	\N
840	270	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-20 17:01:12	2025-02-20 17:01:12	59	77	\N	Commission Entitlement	\N
841	271	2025-02-20	المبيعات	439.38	0	\N	1	439.38	0	52	1	\N	2025-02-20 17:09:10	2025-02-20 17:09:10	59	78	\N	Sales	\N
842	271	2025-02-20	المبيعات	0	439.38	\N	1	0	439.38	2500	1	\N	2025-02-20 17:09:10	2025-02-20 17:09:10	59	78	\N	Sales	\N
843	271	2025-02-20	المبيعات	735	0	\N	1	735	0	2607	1	\N	2025-02-20 17:09:10	2025-02-20 17:09:10	59	78	\N	Sales	\N
844	271	2025-02-20	المبيعات	0	735.00	\N	1	0	735	48	1	\N	2025-02-20 17:09:10	2025-02-20 17:09:10	59	78	\N	Sales	\N
845	272	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-20 17:09:10	2025-02-20 17:09:10	59	78	\N	Commission Entitlement	\N
846	272	2025-02-20	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-20 17:09:10	2025-02-20 17:09:10	59	78	\N	Commission Entitlement	\N
853	275	2025-02-25	المبيعات	1141.74	0	\N	1	1141.74	0	52	1	\N	2025-02-25 12:45:13	2025-02-25 12:45:13	59	80	\N	Sales	\N
854	275	2025-02-25	المبيعات	0	1141.74	\N	1	0	1141.74	2500	1	\N	2025-02-25 12:45:13	2025-02-25 12:45:13	59	80	\N	Sales	\N
855	275	2025-02-25	المبيعات	0	405.00	\N	1	0	405	48	1	\N	2025-02-25 12:45:13	2025-02-25 12:45:13	59	80	\N	Sales	\N
856	275	2025-02-25	المبيعات	0	28.00	\N	1	0	28	112	1	\N	2025-02-25 12:45:13	2025-02-25 12:45:13	59	80	\N	Sales	\N
857	275	2025-02-25	المبيعات	433	0	\N	1	433	0	2607	1	\N	2025-02-25 12:45:13	2025-02-25 12:45:13	59	80	\N	Sales	\N
858	276	2025-02-25	استحقاق عمولة	0	0	\N	1	0	0	2503	1	\N	2025-02-25 12:45:13	2025-02-25 12:45:13	59	80	\N	Commission Entitlement	\N
859	276	2025-02-25	استحقاق عمولة	0	0	\N	1	0	0	2505	1	\N	2025-02-25 12:45:13	2025-02-25 12:45:13	59	80	\N	Commission Entitlement	\N
860	277	2025-02-25	المشتريات	58.00	0	\N	1	58	0	2500	1	\N	2025-02-25 12:49:59	2025-02-25 12:49:59	59	58	\N	Purchases	\N
861	277	20